-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Secondary_Flight_Controls.Flaps_Controller;
with Jpats_Secondary_Flight_Controls.Container;
with Aircraft_Flaps;

procedure Jpats_Secondary_Flight_Controls.Flaps_Controller_Ctd is
   package Ctnr renames Container;
   The_Flaps : Aircraft_Flaps.Instance renames Ctnr.This_Subsystem.The_Flaps;
begin
Test_1 : declare
   Test_Case_1 : Boolean;
begin
   Flaps_Controller.Initialize;
   Test_Case_1 := (Aircraft_Flaps.Deflection (The_Flaps) = 0.0 and
                   Aircraft_Flaps.Load (The_Flaps) = 0.0 and
                   Aircraft_Flaps.Hydraulic_Load (The_Flaps) = 0.0);
   Class_Test_Result_File.Report_Case_Status (Success => Test_Case_1, Number => 1);
end Test_1;

Test_2 : declare
   Test_Case_2 : array (1..3) of Boolean;
   Flag : Integer := 0;
   Iconst : constant Float := 0.066667;
   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
begin
   Flaps_Controller.Initialize;
   Io.Flap_Cont_To_Sw   := False;
   Io.Flap_Cont_Land_Sw := True;
   Io.Flap_Cont_Up_Sw   := False;
   Flaps_Controller.Update(Iconst);
   Test_Case_2(1) := Aircraft_Flaps.Deflection (The_Flaps) > 0.0;
   Test_Case_2(2) := Aircraft_Flaps.Load (The_Flaps) = 0.0;
   Test_Case_2(3) := Aircraft_Flaps.Hydraulic_Load (The_Flaps) > 0.0;
   for I in 1..3
   loop
      exit when not Test_Case_2(I);
      Flag := I;
   end loop;
   Class_Test_Result_File.Report_Case_Status (Success => Flag = 3, Number => 2);

end Test_2;


end Jpats_Secondary_Flight_Controls.Flaps_Controller_Ctd;
