-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Secondary_Flight_Controls.Aileron_Trim_Controller;
with Jpats_Secondary_Flight_Controls.Container;
with Aileron_Trim;

procedure Jpats_Secondary_Flight_Controls.Aileron_Trim_Controller_Ctd is
begin

Test_1 : declare
   The_Ail_Trim : Aileron_Trim.Instance renames Container.This_Subsystem.The_Aileron_Trim;
   Test_Case_1 : Boolean;
begin
   Aileron_Trim_Controller.Initialize;
   Test_Case_1 := Aileron_Trim.Position (The_Ail_Trim) = 0.0 and Aileron_Trim.Load (The_Ail_Trim) = 0.0;
   Class_Test_Result_File.Report_Case_Status (Success => Test_Case_1, Number => 1);
end Test_1;

Test_2 : declare

   package Ctnr renames Container;
   The_Ail_Trim : Aileron_Trim.Instance renames Container.This_Subsystem.The_Aileron_Trim;
   Test_Case_2 : array (1..2) of Boolean;
   Flag : Integer := 0;
   Iconst : constant Float := 0.06666667;
   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;


begin

   Aileron_Trim_Controller.Initialize;

   Io.Aileron_Elev_Trim_Left_Sw := True;
   Io.Aileron_Elev_Trim_Right_Sw := False;

   Aileron_Trim_Controller.Update(Iconst);
   Test_Case_2(1):= Aileron_Trim.Position (The_Ail_Trim) > 0.0;
   Test_Case_2(2):= Aileron_Trim.Load (The_Ail_Trim) /= 0.0;


   for I in 1..2
   loop
      exit when not Test_Case_2(I);
      Flag := I;
   end loop;
   Class_Test_Result_File.Report_Case_Status (Success => Flag = 2, Number => 2);
end Test_2;


end Jpats_Secondary_Flight_Controls.Aileron_Trim_Controller_Ctd;
