-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Landing_Gear.Container;

package body Jpats_Landing_Gear is

-- relays
   function Is_Open
     (Name : in Jpats_Landing_Gear_Types.Relay_Name_Type)
      return Boolean is
   begin
      return False;
   end Is_Open;

   function Is_Closed
     (Name : in Jpats_Landing_Gear_Types.Relay_Name_Type)
      return Boolean is
   begin
      return False;
   end Is_Closed;

--switches
   function Is_Open
     (Name : in Jpats_Landing_Gear_Types.Switch_Name_Type)
      return Boolean is
   begin
      return False;
   end Is_Open;

   function Is_Closed
     (Name : in Jpats_Landing_Gear_Types.Switch_Name_Type)
      return Boolean is
   begin
      return False;
   end Is_Closed;

   function Left_Landing_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type is
   begin
      return Jpats_Landing_Gear_Types.Gear_Position_Type'First;
   end Left_Landing_Gear_Position;

   function Right_Landing_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type is
   begin
      return Jpats_Landing_Gear_Types.Gear_Position_Type'First;
   end Right_Landing_Gear_Position;

   function Nose_Landing_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type is
   begin
      return Jpats_Landing_Gear_Types.Gear_Position_Type'First;
   end Nose_Landing_Gear_Position;

   function Mean_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type is
   begin
      return Jpats_Landing_Gear_Types.Gear_Position_Type'First;
   end Mean_Gear_Position;

   function All_Gear_Up return Boolean is
   begin
      return False;
   end All_Gear_Up;

   function Gear_Aero_Factor return Jpats_Landing_Gear_Types.Gear_Aero_Factor_Type is
   begin
      return Jpats_Landing_Gear_Types.Gear_Aero_Factor_Type'First;
   end Gear_Aero_Factor;

   function Gear_Hyd_Load return Length_Types.Gpm is
   begin
      return (Container.Main_Gear.Hydraulic_Load (Container.This_Subsystem.The_Left_Main_Landing_Gear) *
              Container.Main_Gear.Hydraulic_Load (Container.This_Subsystem.The_Right_Main_Landing_Gear) *
              Container.Nose_Gear.Hydraulic_Load (Container.This_Subsystem.The_Nose_Landing_Gear));
   end Gear_Hyd_Load;

   function Gear_Doors_Hyd_Load return Length_Types.Gpm is
   begin
      return (Container.Gear_Door.Hydraulic_Load(Container.This_Subsystem.The_Left_Main_Gear_Door) *
              Container.Gear_Door.Hydraulic_Load(Container.This_Subsystem.The_Right_Main_Gear_Door));
   end Gear_Doors_Hyd_Load;

   function Left_Landing_Gear_A1_WOW_Relay_Load return Electrical_Units_Types.Amps is
   begin
      return Electrical_Units_Types.Amps'First;
   end Left_Landing_Gear_A1_WOW_Relay_Load;

   function Right_Landing_Gear_A1_WOW_Relay_Load return Electrical_Units_Types.Amps is
   begin
      return Electrical_Units_Types.Amps'First;
   end Right_Landing_Gear_A1_WOW_Relay_Load;

   function Left_Landing_Gear_A2_WOW_Relay_Load return Electrical_Units_Types.Amps is
   begin
      return Electrical_Units_Types.Amps'First;
   end Left_Landing_Gear_A2_WOW_Relay_Load;

   function Right_Landing_Gear_A2_WOW_Relay_Load return Electrical_Units_Types.Amps is
   begin
      return Electrical_Units_Types.Amps'First;
   end Right_Landing_Gear_A2_WOW_Relay_Load;

   function Q_Switch_Control_Relay_Load return Electrical_Units_Types.Amps is
   begin
      return Electrical_Units_Types.Amps'First;
   end Q_Switch_Control_Relay_Load;

   function Landing_Gear_Down_And_Locked_Rly_Load return Electrical_Units_Types.Amps is
   begin
      return Electrical_Units_Types.Amps'First;
   end Landing_Gear_Down_And_Locked_Rly_Load;

   function Landing_Gear_Control_Assembly_Load return Electrical_Units_Types.Amps is
   begin
      return Electrical_Units_Types.Amps'First;
   end Landing_Gear_Control_Assembly_Load;

   -- hardware

   function Emergency_Gear_Handle_Extended return Boolean is
   begin
      return False;
   end Emergency_Gear_Handle_Extended;


   function Gear_Handle_Is_Up return Boolean is
   begin
      return not Container.This_Io_Interface.Landing_Gear_Down_Sw;
   end Gear_Handle_Is_Up;

end Jpats_Landing_Gear;
