-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Altitude_Hold;
with Attitude_Latency;
with Auto_Throttle_Hold;
with Demand_x_Acceleration;
with Error_Coefficients;
with Primary_Control_Surface;
with Flylevel;
with Indicated_Velocity_Hold;
with Lateral_Trim;
with Longitudinal_Trim;
with Pitch_Hold;
with PLA_Trim;
with Rate_of_Climb_Hold;
with Roll_Hold;
with Side_Slip_Hold;
with Special_Autopilot_Pitch;
with Special_Autopilot_Roll;
with Special_Autopilot_Yaw;
with Status;
with Torque_Trim;
with Trim;
with Yaw_Hold;

with Limit_G;
with JPATS_Auto_Test.Container;
with JPATS_Auto_Test.Flight_Characteristics_Container;


package body JPATS_Auto_Test is

function Angle_Limit             is new Limit_G(Value_Type => Float, Limit_Type => Angle_Types.Radians);
function Aileron_Limit           is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Aircraft_Body_Types.A_Position);
function Elevator_Limit          is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Aircraft_Body_Types.E_Position);
function Rudder_Limit            is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Aircraft_Body_Types.R_Position);
function Aileron_Tab_Trim_Limit  is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Secondary_Flight_Controls_Types.Aileron_Trim_Position_Type);
function Elevator_Tab_Trim_Limit is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Secondary_Flight_Controls_Types.Elevator_Trim_Position_Type);
function Rudder_Tab_Trim_Limit   is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Secondary_Flight_Controls_Types.Rudder_Trim_Position_Type);
function Flap_Limit              is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Secondary_Flight_Controls_Types.Flap_Position_Type);
function Landing_Gear_Limit      is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Landing_Gear_Types.Gear_Position_Type);
function Thrust_Limit            is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Auto_Test_Types.Thrust_Type);

--| Altitude_Hold
    function Get_Altitude_Hold_Rate_of_Climb_Demand return Length_Types.Feet_per_Sec is
    begin
       return Altitude_Hold.Get_Rate_of_Climb_Demand(Container.This_Subsystem.The_Altitude_Hold);
    end Get_Altitude_Hold_Rate_of_Climb_Demand;

    function Get_Altitude_Hold_Rate_of_Climb_Hold return Boolean is
    begin
       return Altitude_Hold.Get_Rate_of_Climb_Hold(Container.This_Subsystem.The_Altitude_Hold);
    end Get_Altitude_Hold_Rate_of_Climb_Hold;

--| Auto_Throttle_Hold
    function Get_Auto_Throttle_Hold_Engine_Thrust_Demand return JPATS_Auto_Test_Types.Thrust_Type is
    begin
       return Thrust_Limit(Auto_Throttle_Hold.Get_Engine_Thrust_Demand(Container.This_Subsystem.The_Auto_Throttle_Hold));
    end Get_Auto_Throttle_Hold_Engine_Thrust_Demand;

    function Get_Auto_Throttle_Engine_Thrust return Boolean is
    begin
       return Auto_Throttle_Hold.Get_Engine_Thrust(Container.This_Subsystem.The_Auto_Throttle_Hold);
    end Get_Auto_Throttle_Engine_Thrust;

    function Get_Auto_Throttle_Hold_PLA_Trim return Boolean is
    begin
       return Auto_Throttle_Hold.Get_PLA_Trim(Container.This_Subsystem.The_Auto_Throttle_Hold);
    end Get_Auto_Throttle_Hold_PLA_Trim;

--| Demand_x_Acceleration
    function Get_Demand_x_Acceleration return Float is
    begin
       return Demand_x_Acceleration.Get_Demand_x_Acceleration(Container.This_Subsystem.The_Demand_x_Acceleration);
    end Get_Demand_x_Acceleration;

--| Error_Coefficients
    function Get_Left_Aileron_Delta_Deflection return Angle_Types.Degrees is
    begin
        return Error_Coefficients.Get_Delta_Deflection(Container.This_Subsystem.The_Left_Aileron_Error_Coefficients);
    end Get_Left_Aileron_Delta_Deflection;

    function Get_Right_Aileron_Delta_Deflection return Angle_Types.Degrees is
    begin
        return Error_Coefficients.Get_Delta_Deflection(Container.This_Subsystem.The_Right_Aileron_Error_Coefficients);
    end Get_Right_Aileron_Delta_Deflection;

    function Get_Elevator_Delta_Deflection return Angle_Types.Degrees is
    begin
        return Error_Coefficients.Get_Delta_Deflection(Container.This_Subsystem.The_Elevator_Error_Coefficients);
    end Get_Elevator_Delta_Deflection;   --| For elevator and rudder This_Subsystem.The_Error_Coefficients_Right_Aileron_Effect
                                         --| does not matter.

    function Get_Rudder_Delta_Deflection return Angle_Types.Degrees is
    begin
        return Error_Coefficients.Get_Delta_Deflection(Container.This_Subsystem.The_Rudder_Error_Coefficients);
    end Get_Rudder_Delta_Deflection;     --| For elevator and rudder This_Subsystem.The_Error_Coefficients_Right_Aileron_Effect
                                         --| does not matter.

--| Flylevel
    function Get_Flylevel_Longitudinal_Trim return Boolean is
    begin
       return Flylevel.Get_Longitudinal_Trim(Container.This_Subsystem.The_Flylevel);
    end Get_Flylevel_Longitudinal_Trim;

    function Get_Flylevel_Lateral_Trim return Boolean is
    begin
       return Flylevel.Get_Lateral_Trim(Container.This_Subsystem.The_Flylevel);
    end Get_Flylevel_Lateral_Trim;

--| Indicated_Velocity_Hold
    function Get_Indicated_Velocity_Hold_Pitch_Angle_Demand return Angle_Types.Radians is
    begin
       return Indicated_Velocity_Hold.Get_Pitch_Angle_Demand(Container.This_Subsystem.The_Indicated_Velocity_Hold);
    end Get_Indicated_Velocity_Hold_Pitch_Angle_Demand;

    function Get_Indicated_Velocity_Pitch_Hold return Boolean is
    begin
       return Indicated_Velocity_Hold.Get_Pitch_Hold(Container.This_Subsystem.The_Indicated_Velocity_Hold);
    end Get_Indicated_Velocity_Pitch_Hold;

--| Lateral_Trim
    function Get_Lateral_Trim_Roll_Angle_Hold return Boolean is
    begin
       return Lateral_Trim.Get_Roll_Hold(Container.This_Subsystem.The_Lateral_Trim);
    end Get_Lateral_Trim_Roll_Angle_Hold;

    function Get_Lateral_Trim_Yaw_Hold return Boolean is
    begin
       return Lateral_Trim.Get_Yaw_Hold(Container.This_Subsystem.The_Lateral_Trim);
    end Get_Lateral_Trim_Yaw_Hold;

    function Get_Lateral_Trim_Aileron_Tab_Trim return Boolean is
    begin
       return Lateral_Trim.Get_Aileron_Tab_Trim(Container.This_Subsystem.The_Lateral_Trim);
    end Get_Lateral_Trim_Aileron_Tab_Trim;

    function Get_Lateral_Trim_Rudder_Tab_Trim return Boolean is
    begin
       return Lateral_Trim.Get_Rudder_Tab_Trim(Container.This_Subsystem.The_Lateral_Trim);
    end Get_Lateral_Trim_Rudder_Tab_Trim;

--| Longitudinal_Trim
    function Get_Longitudinal_Trim_Rate_of_Climb_Hold return Boolean is
    begin
       return Longitudinal_Trim.Get_Rate_of_Climb_Hold(Container.This_Subsystem.The_Longitudinal_Trim);
    end Get_Longitudinal_Trim_Rate_of_Climb_Hold;

    function Get_Longitudinal_Trim_Elevator_Tab_Trim return Boolean is
    begin
       return Longitudinal_Trim.Get_Elevator_Tab_Trim(Container.This_Subsystem.The_Longitudinal_Trim);
    end Get_Longitudinal_Trim_Elevator_Tab_Trim;

    function Get_Longitudinal_Trim_Auto_Throttle return Boolean is
    begin
       return Longitudinal_Trim.Get_Auto_Throttle(Container.This_Subsystem.The_Longitudinal_Trim);
    end Get_Longitudinal_Trim_Auto_Throttle;

    function Get_Longitudinal_Trim_PLA_Trim return Boolean is
    begin
       return Longitudinal_Trim.Get_PLA_Trim(Container.This_Subsystem.The_Longitudinal_Trim);
    end Get_Longitudinal_Trim_PLA_Trim;

--| Pitch_Hold
    function Get_Pitch_Rate_Demand return Angle_Types.Radians_per_Sec is
    begin
       return Pitch_Hold.Get_Pitch_Rate_Demand(Container.This_Subsystem.The_Pitch_Hold);
    end Get_Pitch_Rate_Demand;

    function Get_Pitch_Rate_Valid return Boolean is
    begin
       return Pitch_Hold.Get_Pitch_Rate_Valid(Container.This_Subsystem.The_Pitch_Hold);
    end Get_Pitch_Rate_Valid;

--| PLA_Trim
    function Get_PLA_Trim_Demand return Angle_Types.Degrees is
    begin
       return PLA_Trim.Get_PLA_Trim_Demand(Container.This_Subsystem.The_PLA_Trim);
    end Get_PLA_Trim_Demand;

    function Get_PLA_Trim_Valid return Boolean is
    begin
       return PLA_Trim.Get_PLA_Trim_Valid(Container.This_Subsystem.The_PLA_Trim);
    end Get_PLA_Trim_Valid;

--| Primary_Control_Surface_Trim
    --| Left_Aileron
    function Get_Left_Aileron_Valid return Boolean is
    begin
       return Primary_Control_Surface.Get_Position_Valid(Container.This_Subsystem.The_Left_Aileron);
    end Get_Left_Aileron_Valid;

    function Get_Left_Aileron_Value return JPATS_Aircraft_Body_Types.A_Position is
    begin
       return Aileron_Limit(Primary_Control_Surface.Get_Position_Value(Container.This_Subsystem.The_Left_Aileron));
    end Get_Left_Aileron_Value;

    --| Right_Aileron
    function Get_Right_Aileron_Valid return Boolean is
    begin
       return Primary_Control_Surface.Get_Position_Valid(Container.This_Subsystem.The_Right_Aileron);
    end Get_Right_Aileron_Valid;

    function Get_Right_Aileron_Value return JPATS_Aircraft_Body_Types.A_Position is
    begin
       return Aileron_Limit(Primary_Control_Surface.Get_Position_Value(Container.This_Subsystem.The_Right_Aileron));
    end Get_Right_Aileron_Value;

    --| Elevator
    function Get_Elevator_Valid return Boolean is
    begin
       return Primary_Control_Surface.Get_Position_Valid(Container.This_Subsystem.The_Elevator);
    end Get_Elevator_Valid;

    function Get_Elevator_Value return JPATS_Aircraft_Body_Types.E_Position is
    begin
       return Elevator_Limit(Primary_Control_Surface.Get_Position_Value(Container.This_Subsystem.The_Elevator));
    end Get_Elevator_Value;

    --| Rudder
    function Get_Rudder_Valid return Boolean is
    begin
       return Primary_Control_Surface.Get_Position_Valid(Container.This_Subsystem.The_Rudder);
    end Get_Rudder_Valid;

    function Get_Rudder_Value return JPATS_Aircraft_Body_Types.R_Position is
    begin
       return Rudder_Limit(Primary_Control_Surface.Get_Position_Value(Container.This_Subsystem.The_Rudder));
    end Get_Rudder_Value;

--| Rate_of_Climb_Hold
    function Get_Rate_of_Climb_Hold_Pitch_Angle_Demand return Angle_Types.Radians is
    begin
       return Rate_of_Climb_Hold.Get_Pitch_Angle_Demand(Container.This_Subsystem.The_Rate_of_Climb_Hold);
    end Get_Rate_of_Climb_Hold_Pitch_Angle_Demand;

    function Get_Rate_of_Climb_Hold_Pitch_Hold return Boolean is
    begin
       return Rate_of_Climb_Hold.Get_Pitch_Hold(Container.This_Subsystem.The_Rate_of_Climb_Hold);
    end Get_Rate_of_Climb_Hold_Pitch_Hold;

--| Roll_Hold

    function Get_Roll_Rate_Demand return Angle_Types.Radians_per_Sec is
    begin
       return Roll_Hold.Get_Roll_Rate_Demand(Container.This_Subsystem.The_Roll_Hold);
    end Get_Roll_Rate_Demand;

    function Get_Roll_Rate_Valid return Boolean is
    begin
       return Roll_Hold.Get_Roll_Rate_Valid(Container.This_Subsystem.The_Roll_Hold);
    end Get_Roll_Rate_Valid;

--| Secondary_Controls
    --| Aileron
    function Get_Secondary_Controls_Aileron return Boolean is
    begin
       return False;--Trim.Get_Position_Valid(Container.This_Subsystem.The_Aileron_Tab_Trim);
    end Get_Secondary_Controls_Aileron;

    function Get_Secondary_Controls_Value_Aileron return JPATS_Secondary_Flight_Controls_Types.Aileron_Trim_Position_Type is
    begin
       return 0.0; --Aileron_Tab_Trim_Limit(Trim.Get_Position_Value(Container.This_Subsystem.The_Aileron_Tab_Trim));
    end Get_Secondary_Controls_Value_Aileron;

    --| Elevator
    function Get_Secondary_Controls_Elevator return Boolean is
    begin
       return False;--Trim.Get_Position_Valid(Container.This_Subsystem.The_Elevator_Tab_Trim);
    end Get_Secondary_Controls_Elevator;

    function Get_Secondary_Controls_Value_Elevator return JPATS_Secondary_Flight_Controls_Types.Elevator_Trim_Position_Type is
    begin
       return 0.0;--Elevator_Tab_Trim_Limit(Trim.Get_Position_Value(Container.This_Subsystem.The_Elevator_Tab_Trim));
    end Get_Secondary_Controls_Value_Elevator;

    --| Rudder
    function Get_Secondary_Controls_Rudder return Boolean is
    begin
       return False; --Trim.Get_Position_Valid(Container.This_Subsystem.The_Rudder_Tab_Trim);
    end Get_Secondary_Controls_Rudder;

    function Get_Secondary_Controls_Value_Rudder return JPATS_Secondary_Flight_Controls_Types.Rudder_Trim_Position_Type is
    begin
       return 0.0; --Rudder_Tab_Trim_Limit(Trim.Get_Position_Value(Container.This_Subsystem.The_Rudder_Tab_Trim));
    end Get_Secondary_Controls_Value_Rudder;

    --| Flap_Position
    function Get_Secondary_Controls_Flap_Position return Boolean is
    begin
       return False; --Container.Secondary_Controls.Get_Attribute_Valid(Container.This_Subsystem.The_Flap_Position);
    end Get_Secondary_Controls_Flap_Position;

    function Get_Secondary_Controls_Value_Flap_Position return JPATS_Secondary_Flight_Controls_Types.Flap_Position_Type is
    begin
       return 0.0; --Flap_Limit(Container.Secondary_Controls.Get_Attribute(Container.This_Subsystem.The_Flap_Position));
    end Get_Secondary_Controls_Value_Flap_Position;

    --| Speedbrake_Position
    function Get_Secondary_Controls_Speedbrake_Position return Boolean is
    begin
       return False;--Container.Secondary_Controls.Get_Attribute_Valid(Container.This_Subsystem.The_Speedbrake_Position);
    end Get_Secondary_Controls_Speedbrake_Position;

    function Get_Secondary_Controls_Value_Speedbrake_Position return JPATS_Secondary_Flight_Controls_Types.Speedbrake_Position_Type is
    begin
       return 0.0; --Flap_Limit(Container.Secondary_Controls.Get_Attribute(Container.This_Subsystem.The_Speedbrake_Position));
    end Get_Secondary_Controls_Value_Speedbrake_Position;

    --| Landing_Gear_Position
    function Get_Secondary_Controls_Landing_Gear_Position return Boolean is
    begin
       return False; --Container.Secondary_Controls.Get_Attribute_Valid(Container.This_Subsystem.The_Landing_Gear_Position);
    end Get_Secondary_Controls_Landing_Gear_Position;

    function Get_Secondary_Controls_Value_Landing_Gear_Position return JPATS_Landing_Gear_Types.Gear_Position_Type is
    begin
       return 0.0; --Landing_Gear_Limit(Container.Secondary_Controls.Get_Attribute(Container.This_Subsystem.The_Landing_Gear_Position));
    end Get_Secondary_Controls_Value_Landing_Gear_Position;

    function Get_Secondary_Controls_Parking_Brakes_ON return Boolean is
    begin
       return Container.Secondary_Controls.Get_Attribute_Valid(Container.This_Subsystem.The_Parking_Brake);
    end Get_Secondary_Controls_Parking_Brakes_ON;

--| Side_Slip_Hold
    function Get_Side_Slip_Hold_Roll_Hold return Boolean is
    begin
       return Side_Slip_Hold.Get_Roll_Hold(Container.This_Subsystem.The_Side_Slip_Hold);
    end Get_Side_Slip_Hold_Roll_Hold;

    function Get_Side_Slip_Hold_Roll_Angle_Demand return Angle_Types.Radians is
    begin
       return Side_Slip_Hold.Get_Roll_Angle_Demand(Container.This_Subsystem.The_Side_Slip_Hold);
    end Get_Side_Slip_Hold_Roll_Angle_Demand;

    function Get_Side_Slip_Hold_Yaw_Hold return Boolean is
    begin
       return Side_Slip_Hold.Get_Yaw_Hold(Container.This_Subsystem.The_Side_Slip_Hold);
    end Get_Side_Slip_Hold_Yaw_Hold;

--| Special_Autopilot_Pitch
    function Get_Special_Autopilot_Pitch_Elevator_Demand return JPATS_Aircraft_Body_Types.E_Position is
    begin
       return Elevator_Limit(Special_Autopilot_Pitch.Get_Position_Demand(Container.This_Subsystem.The_Special_Autopilot_Pitch_for_Elevator));
    end Get_Special_Autopilot_Pitch_Elevator_Demand;

    function Get_Special_Autopilot_Pitch_Elevator_Valid return Boolean is
    begin
       return Special_Autopilot_Pitch.Get_Position_Valid(Container.This_Subsystem.The_Special_Autopilot_Pitch_for_Elevator);
    end Get_Special_Autopilot_Pitch_Elevator_Valid;

--| Special_Autopilot_Roll
    --| Left Aileron
    function Get_Special_Autopilot_Roll_Left_Aileron_Demand return JPATS_Aircraft_Body_Types.A_Position is
    begin
       return Aileron_Limit(Special_Autopilot_Roll.Get_Position_Demand(Container.This_Subsystem.The_Special_Autopilot_Roll_for_Left_Aileron));
    end Get_Special_Autopilot_Roll_Left_Aileron_Demand;

    function Get_Special_Autopilot_Roll_Left_Aileron_Valid return Boolean is
    begin
       return Special_Autopilot_Roll.Get_Position_Valid(Container.This_Subsystem.The_Special_Autopilot_Roll_for_Left_Aileron);
    end Get_Special_Autopilot_Roll_Left_Aileron_Valid;

--| Special_Autopilot_Roll
    --| Right Aileron
    function Get_Special_Autopilot_Roll_Right_Aileron_Demand return JPATS_Aircraft_Body_Types.A_Position is
    begin
       return Aileron_Limit(Special_Autopilot_Roll.Get_Position_Demand(Container.This_Subsystem.The_Special_Autopilot_Roll_for_Right_Aileron));
    end Get_Special_Autopilot_Roll_Right_Aileron_Demand;

    function Get_Special_Autopilot_Roll_Right_Aileron_Valid return Boolean is
    begin
       return Special_Autopilot_Roll.Get_Position_Valid(Container.This_Subsystem.The_Special_Autopilot_Roll_for_Right_Aileron);
    end Get_Special_Autopilot_Roll_Right_Aileron_Valid;

--| Special_Autopilot_Yaw
    function Get_Special_Autopilot_Yaw_Rudder_Demand return JPATS_Aircraft_Body_Types.R_Position is
    begin
       return Rudder_Limit(Special_Autopilot_Yaw.Get_Position_Demand(Container.This_Subsystem.The_Special_Autopilot_Yaw_for_Rudder));
    end Get_Special_Autopilot_Yaw_Rudder_Demand;

    function Get_Special_Autopilot_Yaw_Rudder_Valid return Boolean is
    begin
       return Special_Autopilot_Yaw.Get_Position_Valid(Container.This_Subsystem.The_Special_Autopilot_Yaw_for_Rudder);
    end Get_Special_Autopilot_Yaw_Rudder_Valid;

--| Yaw_Hold
    function Get_Yaw_Rate_Demand return Angle_Types.Radians_per_Sec is
    begin
       return Yaw_Hold.Get_Yaw_Rate_Demand(Container.This_Subsystem.The_Yaw_Hold);
    end Get_Yaw_Rate_Demand;

    function Get_Yaw_Rate_Valid return Boolean is
    begin
       return Yaw_Hold.Get_Yaw_Rate_Valid(Container.This_Subsystem.The_Yaw_Hold);
    end Get_Yaw_Rate_Valid;

--| Torque_Trim
    function Get_Torque_Trim_PLA_Trim_Demand return Angle_Types.Degrees is
    begin
       return Torque_Trim.Get_PLA_Trim_Demand(Container.This_Subsystem.The_Torque_Trim);
    end Get_Torque_Trim_PLA_Trim_Demand;

    function Get_Torque_Trim_PLA_Trim_Valid return Boolean is
    begin
       return Torque_Trim.Get_PLA_Trim_Valid(Container.This_Subsystem.The_Torque_Trim);
    end Get_Torque_Trim_PLA_Trim_Valid;

--| Flight_Characteristics
    function Get_Angle_of_Attack return Angle_Types.Radians is
    begin
       return Flight_Characteristics_Container.Angle_of_Attack_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Angle_of_Attack);
    end Get_Angle_of_Attack;

    function Get_Side_Slip_Angle return Angle_Types.Radians is
    begin
       return Flight_Characteristics_Container.Side_Slip_Angle_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Side_Slip_Angle);
    end Get_Side_Slip_Angle;

    function Get_Calibrated_Airspeed return Length_Types.Knots is
    begin
       return Flight_Characteristics_Container.Calibrated_Airspeed_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Calibrated_Airspeed);
    end Get_Calibrated_Airspeed;

    function Get_North return Lat_Long_Types.Latitude_Degrees is
    begin
        return Flight_Characteristics_Container.North_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_North);
    end Get_North;

    function Get_East return Lat_Long_Types.Longitude_Degrees is
    begin
        return Flight_Characteristics_Container.East_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_East);
    end Get_East;

    function Get_Field_Geometric_Altitude return Length_Types.Feet is
    begin
       return Flight_Characteristics_Container.Field_Geometric_Altitude_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Field_Geometric_Altitude);
    end Get_Field_Geometric_Altitude;

    function Get_Field_Pressure_Altitude return Length_Types.Feet is
    begin
       return Flight_Characteristics_Container.Field_Pressure_Altitude_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Field_Pressure_Altitude);
    end Get_Field_Pressure_Altitude;

    function Get_Pressure_Altitude return Length_Types.Feet is
    begin
       return Flight_Characteristics_Container.Pressure_Altitude_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Pressure_Altitude);
    end Get_Pressure_Altitude;

    function Get_Reference_Coordinates_of_Current_Center_of_Gravity return Coordinate_Types.Reference_System is
    begin
       return Flight_Characteristics_Container.Aircraft_Center_of_Gravity_Flight_Characteristics.Get_Attribute
                                                    (Flight_Characteristics_Container.This_Subsystem.The_Reference_Coordinates_of_Current_Center_of_Gravity);
    end Get_Reference_Coordinates_of_Current_Center_of_Gravity;

    function Get_Reference_Coordinates_of_Current_Center_of_Gravity_Valid return Boolean is
    begin
       return Flight_Characteristics_Container.Aircraft_Center_of_Gravity_Flight_Characteristics.Get_Attribute_Valid
                                                    (Flight_Characteristics_Container.This_Subsystem.The_Reference_Coordinates_of_Current_Center_of_Gravity);
    end Get_Reference_Coordinates_of_Current_Center_of_Gravity_Valid;

    function Get_Gross_Weight return Mass_Types.Lbm is
    begin
       return Flight_Characteristics_Container.Gross_Weight_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Gross_Weight);
    end Get_Gross_Weight;

    function Get_Gross_Weight_Valid return Boolean is
    begin
       return Flight_Characteristics_Container.Gross_Weight_Flight_Characteristics.Get_Attribute_Valid(Flight_Characteristics_Container.This_Subsystem.The_Gross_Weight);
    end Get_Gross_Weight_Valid;

    function Get_Outside_Air_Temperature return Temperature_Types.Rankine is
    begin
       return Flight_Characteristics_Container.Outside_Air_Temperature_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Outside_Air_Temperature);
    end Get_Outside_Air_Temperature;

    function Get_Winds_Direction return Angle_Types.Radians is
    begin
       return Angle_Limit(Flight_Characteristics_Container.Winds_Direction_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Winds_Direction));
    end Get_Winds_Direction;

    function Get_Winds_Velocity return Length_Types.Knots is
    begin
       return Flight_Characteristics_Container.Winds_Velocity_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Winds_Velocity);
    end Get_Winds_Velocity;

    function Get_Winds_Direction_Valid return Boolean is
    begin
       return Flight_Characteristics_Container.Winds_Direction_Flight_Characteristics.Get_Attribute_Valid(Flight_Characteristics_Container.This_Subsystem.The_Winds_Direction);
    end Get_Winds_Direction_Valid;

    function Get_Winds_Velocity_Valid return Boolean is
    begin
       return Flight_Characteristics_Container.Winds_Velocity_Flight_Characteristics.Get_Attribute_Valid(Flight_Characteristics_Container.This_Subsystem.The_Winds_Velocity);
    end Get_Winds_Velocity_Valid;

    function Get_Moment_of_Inertia return Coordinate_Types.Inertia_Axis is
    begin
       return Flight_Characteristics_Container.Moment_of_Inertia_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Moment_of_Inertia);
    end Get_Moment_of_Inertia;

    function Get_Moment_of_Inertia_Valid return Boolean is
    begin
       return Flight_Characteristics_Container.Moment_of_Inertia_Flight_Characteristics.Get_Attribute_Valid(Flight_Characteristics_Container.This_Subsystem.The_Moment_of_Inertia);
    end Get_Moment_of_Inertia_Valid;


    function Get_Steady_State_Wind return Coordinate_Types.Cartesian is
    begin
       return Flight_Characteristics_Container.Steady_State_Wind_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Steady_State_Wind);
    end Get_Steady_State_Wind;

    function Get_Steady_State_Wind_Valid return Boolean is
    begin
       return Flight_Characteristics_Container.Steady_State_Wind_Flight_Characteristics.Get_Attribute_Valid(Flight_Characteristics_Container.This_Subsystem.The_Steady_State_Wind);
    end Get_Steady_State_Wind_Valid;


--| Status gives if initializing, stabilizing and running of the test
    function Get_Initializing_Test_Status return Boolean is
    begin
       return Status.Get_Test_Operating_State(Container.This_Subsystem.The_Initializing_State);
    end Get_Initializing_Test_Status;

    function Get_Stabilizing_Test_Status return Boolean is
    begin
       return Status.Get_Test_Operating_State(Container.This_Subsystem.The_Stabilizing_State);
    end Get_Stabilizing_Test_Status;

    function Get_Running_Test_Status return Boolean is
    begin
       return Status.Get_Test_Operating_State(Container.This_Subsystem.The_Run_Test_State);
    end Get_Running_Test_Status;

    function Get_Manual_Test_Status return Boolean is
    begin
       return Status.Get_Test_Operating_State(Container.This_Subsystem.The_Manual_Test_State);
    end Get_Manual_Test_Status;

--| Roll_Angle_Demand, Pitch_Angle_Demand, Yaw_Angle_Demand, used such that
--| the latest update of Roll_Angle_Demand, Pitch_Angle_Demand, Yaw_Angle_Demand respectively
--| is made available.
    function Get_Roll_Angle_Demand return Angle_Types.Radians is
    begin
       return Container.Attitude_Angle_Demand.Get_Attribute(Container.This_Subsystem.The_Roll_Angle_Demand);
    end Get_Roll_Angle_Demand;

    function Get_Pitch_Angle_Demand return Angle_Types.Radians is
    begin
       return Container.Attitude_Angle_Demand.Get_Attribute(Container.This_Subsystem.The_Pitch_Angle_Demand);
    end Get_Pitch_Angle_Demand;

    function Get_Yaw_Angle_Demand return Angle_Types.Radians is
    begin
       return Container.Attitude_Angle_Demand.Get_Attribute(Container.This_Subsystem.The_Yaw_Angle_Demand);
    end Get_Yaw_Angle_Demand;

--| Cockpit_Primary_Controls drives the column in the lateral and longitudinal direction and move
--| the left pedals in a open loop.
    function Get_Lateral_Column_Position_Valid return Boolean is
    begin
       return Container.Cockpit_Primary_Position.Get_Attribute_Valid(Container.This_Subsystem.The_Lateral_Position);
    end Get_Lateral_Column_Position_Valid;

    function Get_Lateral_Column_Position_Value return Angle_Types.Degrees is
    begin
       return Container.Cockpit_Primary_Position.Get_Attribute(Container.This_Subsystem.The_Lateral_Position);
    end Get_Lateral_Column_Position_Value;

    function Get_Longitudinal_Column_Position_Valid return Boolean is
    begin
       return Container.Cockpit_Primary_Position.Get_Attribute_Valid(Container.This_Subsystem.The_Longitudinal_Position);
    end Get_Longitudinal_Column_Position_Valid;

    function Get_Longitudinal_Column_Position_Value return Angle_Types.Degrees is
    begin
       return Container.Cockpit_Primary_Position.Get_Attribute(Container.This_Subsystem.The_Longitudinal_Position);
    end Get_Longitudinal_Column_Position_Value;

    function Get_Left_Pedal_Position_Valid return Boolean is
    begin
       return Container.Cockpit_Primary_Position.Get_Attribute_Valid(Container.This_Subsystem.The_Pedal_Position);
    end Get_Left_Pedal_Position_Valid;

    function Get_Left_Pedal_Position_Value return Angle_Types.Degrees is
    begin
       return Container.Cockpit_Primary_Position.Get_Attribute(Container.This_Subsystem.The_Pedal_Position);
    end Get_Left_Pedal_Position_Value;

--| Cockpit_Primary_Controls applies force on the column in the lateral and longitudinal direction
--| and move the left pedals in a open loop.
    function Get_Lateral_Column_Force_Valid return Boolean is
    begin
       return Container.Cockpit_Primary_Force.Get_Attribute_Valid(Container.This_Subsystem.The_Lateral_Force);
    end Get_Lateral_Column_Force_Valid;

    function Get_Lateral_Column_Force_Value return Angle_Types.Degrees is
    begin
       return Container.Cockpit_Primary_Force.Get_Attribute(Container.This_Subsystem.The_Lateral_Force);
    end Get_Lateral_Column_Force_Value;

    function Get_Longitudinal_Column_Force_Valid return Boolean is
    begin
       return Container.Cockpit_Primary_Force.Get_Attribute_Valid(Container.This_Subsystem.The_Longitudinal_Force);
    end Get_Longitudinal_Column_Force_Valid;

    function Get_Longitudinal_Column_Force_Value return Angle_Types.Degrees is
    begin
       return Container.Cockpit_Primary_Force.Get_Attribute(Container.This_Subsystem.The_Longitudinal_Force);
    end Get_Longitudinal_Column_Force_Value;

    function Get_Pedal_Force_Valid return Boolean is
    begin
       return Container.Cockpit_Primary_Force.Get_Attribute_Valid(Container.This_Subsystem.The_Pedal_Force);
    end Get_Pedal_Force_Valid;

    function Get_Pedal_Force_Value return Angle_Types.Degrees is
    begin
       return Container.Cockpit_Primary_Force.Get_Attribute(Container.This_Subsystem.The_Pedal_Force);
    end Get_Pedal_Force_Value;

--| Attitude Latency driver is to be used while testing the control loading system.
    function Get_Latency_Step_Input_Pitch_Angle return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Attitude_Angle(Container.This_Subsystem.The_Pitch_Latency);
    end Get_Latency_Step_Input_Pitch_Angle;

    function Get_Pitch_Latency_Step_Input_Valid return Boolean is
    begin
       return Attitude_Latency.Get_Latency_Valid(Container.This_Subsystem.The_Pitch_Latency);
    end Get_Pitch_Latency_Step_Input_Valid;

    function Get_Pitch_Latency_Step_Input return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Latency_Step_Input(Container.This_Subsystem.The_Pitch_Latency);
    end Get_Pitch_Latency_Step_Input;

    function Get_Latency_Step_Input_Roll_Angle return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Attitude_Angle(Container.This_Subsystem.The_Roll_Latency);
    end Get_Latency_Step_Input_Roll_Angle;

    function Get_Roll_Latency_Step_Input_Valid return Boolean is
    begin
       return Attitude_Latency.Get_Latency_Valid(Container.This_Subsystem.The_Roll_Latency);
    end Get_Roll_Latency_Step_Input_Valid;

    function Get_Roll_Latency_Step_Input return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Latency_Step_Input(Container.This_Subsystem.The_Roll_Latency);
    end Get_Roll_Latency_Step_Input;

    function Get_Latency_Step_Input_Yaw_Angle return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Attitude_Angle(Container.This_Subsystem.The_Yaw_Latency);
    end Get_Latency_Step_Input_Yaw_Angle;

    function Get_Yaw_Latency_Step_Input_Valid return Boolean is
    begin
       return Attitude_Latency.Get_Latency_Valid(Container.This_Subsystem.The_Yaw_Latency);
    end Get_Yaw_Latency_Step_Input_Valid;

    function Get_Yaw_Latency_Step_Input return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Latency_Step_Input(Container.This_Subsystem.The_Yaw_Latency);
    end Get_Yaw_Latency_Step_Input;



    function Get_Bleed_Load return Float is
    begin
       return Flight_Characteristics_Container.Engine_Load_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Bleed_Load);
    end Get_Bleed_Load;

    function Get_Bleed_Load_Valid return Boolean is
    begin
       return Flight_Characteristics_Container.Engine_Load_Flight_Characteristics.Get_Attribute_Valid(Flight_Characteristics_Container.This_Subsystem.The_Bleed_Load);
    end Get_Bleed_Load_Valid;

    function Get_Accessory_Load return Float is
    begin
       return Flight_Characteristics_Container.Engine_Load_Flight_Characteristics.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Accessory_Load);
    end Get_Accessory_Load;

    function Get_Accessory_Load_Valid return Boolean is
    begin
       return Flight_Characteristics_Container.Engine_Load_Flight_Characteristics.Get_Attribute_Valid(Flight_Characteristics_Container.This_Subsystem.The_Accessory_Load);
    end Get_Accessory_Load_Valid;



end JPATS_Auto_Test;
