-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Float_Text_Io; use Ada.Float_Text_Io;
with Ada.Text_Io; use Ada.Text_Io;
with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Aircraft_Flaps;

procedure Aircraft_Flaps_Ctd is


begin


   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      In_First_Quarter_Timer  : Float := 0.0;
      In_Second_Quarter_Timer : float := 0.0;
      In_Third_Quarter_Timer  : float := 0.0;
      In_Fourth_Quarter_Timer : float := 0.0;

      In_First_Quarter_Latch  : Boolean := true;
      In_Second_Quarter_Latch : Boolean := true;
      In_Third_Quarter_Latch  : Boolean := true;
      In_Fourth_Quarter_Latch : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      The_Flaps : Aircraft_Flaps.Instance;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;

   begin

      Aircraft_Flaps.Initialize (The_Flaps);
      Test_1 := Aircraft_Flaps.Deflection (The_Flaps) = 0.0;
      Test_2 := Aircraft_Flaps.Load (The_Flaps) = 0.0;
      Test_3 := Aircraft_Flaps.Hydraulic_Load (The_Flaps) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Aircraft_Flaps.Update
              (An_Instance              => The_Flaps, -- in out Instance;
               Iconst                   => Iconst,    -- in     Float;
               Emerg_Gear_Handle_Extend => False,     -- in     Boolean;
               Primary_Hyd_Fcn          => 1.0,       -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Emerg_Hyd_Fcn            => 1.0,       -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Flap_Selector_Up         => True,      -- in     Boolean;
               Flap_Selector_Take_Off   => False,     -- in     Boolean;
               Flap_Selector_Land       => False,     -- in     Boolean;
               Flap_Cont_Cb             => True,      -- in     Boolean;
               Mean_Gear_Position       => 1.0,       -- in     Jpats_Landing_Gear_Types.Gear_Position_Type;
               Dynamic_Pressure         => 0.0,       -- in     Force_Types.Pounds_Per_Sq_Feet;
               Fail_Left_Outboard_Flap  => False,     -- in     Boolean;
               Fail_Right_Outboard_Flap => False,     -- in     Boolean;
               Fail_Left_Wing_Flaps     => False,     -- in     Boolean;
               Fail_Right_Wing_Flaps    => False);    -- in     Boolean);




            if In_First_Quarter_Latch and In_First_Quarter_Timer > 40.0 then
               Test_4 := Aircraft_Flaps.Deflection (The_Flaps) = 0.0;
               Test_5 := Aircraft_Flaps.Load (The_Flaps) = 0.0;
               Test_6 := Aircraft_Flaps.Hydraulic_Load (The_Flaps) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
               Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
               In_First_Quarter_Latch := False;
            end if;
            In_First_Quarter_Timer := In_First_Quarter_Timer + Iconst;
         elsif Now < Two_Quarter_Time then


            Aircraft_Flaps.Update
              (An_Instance              => The_Flaps, -- in out Instance;
               Iconst                   => Iconst,    -- in     Float;
               Emerg_Gear_Handle_Extend => False,     -- in     Boolean;
               Primary_Hyd_Fcn          => 1.0,       -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Emerg_Hyd_Fcn            => 1.0,       -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Flap_Selector_Up         => False,      -- in     Boolean;
               Flap_Selector_Take_Off   => True,     -- in     Boolean;
               Flap_Selector_Land       => False,     -- in     Boolean;
               Flap_Cont_Cb             => True,      -- in     Boolean;
               Mean_Gear_Position       => 1.0,       -- in     Jpats_Landing_Gear_Types.Gear_Position_Type;
               Dynamic_Pressure         => 0.0,       -- in     Force_Types.Pounds_Per_Sq_Feet;
               Fail_Left_Outboard_Flap  => False,     -- in     Boolean;
               Fail_Right_Outboard_Flap => False,     -- in     Boolean;
               Fail_Left_Wing_Flaps     => False,     -- in     Boolean;
               Fail_Right_Wing_Flaps    => False);    -- in     Boolean);


            if In_Second_Quarter_Latch and In_Second_Quarter_Timer > 50.0 then
               Test_7 := Aircraft_Flaps.Deflection (The_Flaps) = 23.0;
               Test_8 := Aircraft_Flaps.Load (The_Flaps) = 0.0;
               Test_9 := Aircraft_Flaps.Hydraulic_Load (The_Flaps) >= 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
               Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
               Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);
               In_Second_Quarter_Latch := False;
            end if;
            In_Second_Quarter_Timer := In_Second_Quarter_Timer + Iconst;
         elsif Now < Three_Quarter_Time then

            Aircraft_Flaps.Update
              (An_Instance              => The_Flaps, -- in out Instance;
               Iconst                   => Iconst,    -- in     Float;
               Emerg_Gear_Handle_Extend => False,     -- in     Boolean;
               Primary_Hyd_Fcn          => 1.0,       -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Emerg_Hyd_Fcn            => 1.0,       -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Flap_Selector_Up         => False,      -- in     Boolean;
               Flap_Selector_Take_Off   => False,     -- in     Boolean;
               Flap_Selector_Land       => True,     -- in     Boolean;
               Flap_Cont_Cb             => True,      -- in     Boolean;
               Mean_Gear_Position       => 1.0,       -- in     Jpats_Landing_Gear_Types.Gear_Position_Type;
               Dynamic_Pressure         => 0.0,       -- in     Force_Types.Pounds_Per_Sq_Feet;
               Fail_Left_Outboard_Flap  => False,     -- in     Boolean;
               Fail_Right_Outboard_Flap => False,     -- in     Boolean;
               Fail_Left_Wing_Flaps     => False,     -- in     Boolean;
               Fail_Right_Wing_Flaps    => False);    -- in     Boolean);


            if In_Third_Quarter_Latch and In_Third_Quarter_Timer > 50.0 then
               Test_10 := Aircraft_Flaps.Deflection (The_Flaps) = 50.0;
               Test_11 := Aircraft_Flaps.Load (The_Flaps) = 0.0;
               Test_12 := Aircraft_Flaps.Hydraulic_Load (The_Flaps) >= 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
               In_Third_Quarter_Latch := False;
            end if;
            In_Third_Quarter_Timer := In_Third_Quarter_Timer + Iconst;
         else

            Aircraft_Flaps.Update
              (An_Instance              => The_Flaps, -- in out Instance;
               Iconst                   => Iconst,    -- in     Float;
               Emerg_Gear_Handle_Extend => False,     -- in     Boolean;
               Primary_Hyd_Fcn          => 1.0,       -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Emerg_Hyd_Fcn            => 1.0,       -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Flap_Selector_Up         => True,      -- in     Boolean;
               Flap_Selector_Take_Off   => False,     -- in     Boolean;
               Flap_Selector_Land       => False,     -- in     Boolean;
               Flap_Cont_Cb             => True,      -- in     Boolean;
               Mean_Gear_Position       => 1.0,       -- in     Jpats_Landing_Gear_Types.Gear_Position_Type;
               Dynamic_Pressure         => 0.0,       -- in     Force_Types.Pounds_Per_Sq_Feet;
               Fail_Left_Outboard_Flap  => False,     -- in     Boolean;
               Fail_Right_Outboard_Flap => False,     -- in     Boolean;
               Fail_Left_Wing_Flaps     => False,     -- in     Boolean;
               Fail_Right_Wing_Flaps    => False);    -- in     Boolean);


            if In_Fourth_Quarter_Latch and In_Fourth_Quarter_Timer > 80.0 then
               Test_13 := Aircraft_Flaps.Deflection (The_Flaps) = 0.0;
               Test_14 := Aircraft_Flaps.Load (The_Flaps) = 0.0;
               Test_15 := Aircraft_Flaps.Hydraulic_Load (The_Flaps) >= 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               In_Fourth_Quarter_Latch := False;
            end if;
            In_Fourth_Quarter_Timer := In_Fourth_Quarter_Timer + Iconst;
--            Put (Float(Aircraft_Flaps.Deflection (The_Flaps))); New_Line;
         end if;

      end loop;

   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;


end Aircraft_Flaps_Ctd;
