-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Text_IO;

--------------------------------------------------------------------------------
--
-- A class for class test result files. This is intended for use by class test
-- drivers to report their results. Only one file is created each run.
--
--------------------------------------------------------------------------------

package Class_Test_Result_File is

   -- Value indicating the default test case number
   Default_Test_Case : constant Integer;

   -----------------------------------------------------------------------------
   -- Report the next test case' success. Either "PASSED" or "FAILED" will be
   -- reported.
   -----------------------------------------------------------------------------
   procedure Report_Case_Status (Success : in Boolean;
     Number : in Integer := Default_Test_Case);

private

   Default_Test_Case : constant Integer := -1;

   -- The directory in which the file will be placed.
   File_Path : constant String := "";

end Class_Test_Result_File;


