-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Reposition;
with  Jpats_Reposition_Types;
with Ada.Text_Io;
with Radio_Types;
with Ada.Text_Io;
with Ada.Exceptions;
with Class_Test_Result_File;

use Ada.Text_Io;

procedure Reposition_Ct is

   package Jrt renames Jpats_Reposition_Types;

   Ref_Lat : Jrt.Lat_Type;
   Ref_Lon : Jrt.Lon_Type;
   Ref_Lgd : Float;
   Ref_Hdg : Jrt.Bearing_Type;
   Ref_Gsa : Float;
   Ref_Alt : Float;
   Command : Jrt.Reposition_Command_Type;
   Pass : Boolean;

   type Ils_Results_Array is array
     (Jrt.Ils_8nm .. Jrt.Vfr_0p5nm) of Jrt.Reposition_Command_Type;

   --file for runway heading -90.0(270.0):
   Results_1 : constant Ils_Results_Array :=
     ((True,(4.50000E+01,-4.47725E+01,3.54911E+03),-90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.48669E+01,2.27456E+03),-90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.48904E+01,1.95592E+03),-90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49140E+01,1.63728E+03),-90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49140E+01,1.63728E+03),-90.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49494E+01,1.15932E+03),-90.0,110.0,0.0,0.0,False));

   --file for runway heading 90.0:
   Results_2 : constant Ils_Results_Array :=
     ((True,(4.50000E+01,-4.52275E+01,3.54911E+03),90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.51331E+01,2.27456E+03),90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.51095E+01,1.95592E+03),90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50860E+01,1.63728E+03),90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50860E+01,1.63728E+03),90.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50506E+01,1.15932E+03),90.0,110.0,0.0,0.0,False));

   type Rwy_Results_Array is array
     (Jrt.Ils_8nm .. Jrt.L_Inside_Downwind) of Jrt.Reposition_Command_Type;

   --file for runway heading 90.0:
   Results_3 : constant Rwy_Results_Array :=
     ((True,(4.50000E+01,-4.51858E+01,3.00000E+03), 90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50914E+01,2.50000E+03), 90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50678E+01,1.50000E+03), 90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50443E+01,1.50000E+03), 90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50443E+01,2.00000E+03), 90.0,200.0,0.0,0.0,False),
      (True,(4.50000e+01,-4.50089E+01,1.30000E+03), 90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49998E+01,1.00000E+03), 90.0,  0.0,0.0,1.0,False),
      (True,(4.50334E+01,-4.52289E+01,3.50000E+03),135.0,150.0,0.0,0.0,False),
      (True,(4.49666E+01,-4.52289E+01,3.50000E+03), 45.0,150.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49882E+01,4.00000E+03), 90.0,125.0,0.0,0.0,False),
      (True,(4.49669E+01,-4.49882E+01,2.00000E+03),-90.0,200.0,0.0,0.0,False),
      (True,(4.49917E+01,-4.49882E+01,1.80000E+03),-90.0,100.0,0.0,0.0,False),
      (True,(4.49944E+01,-4.49882E+01,2.00000E+03),-90.0,150.0,0.0,0.0,False),
      (True,(4.50331E+01,-4.49882E+01,2.00000E+03),-90.0,200.0,0.0,0.0,False),
      (True,(4.50083E+01,-4.49882E+01,1.80000E+03),-90.0,100.0,0.0,0.0,False),
      (True,(4.50055E+01,-4.49882E+01,2.00000E+03),-90.0,150.0,0.0,0.0,False));

   --file for runway heading -90.0:
   Results_4 : constant Rwy_Results_Array :=
     ((True,(4.50000E+01,-4.48142E+01,3.00000E+03),- 90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49086E+01,2.50000E+03),- 90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49322E+01,1.50000E+03),- 90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49557E+01,1.50000E+03),- 90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49557E+01,2.00000E+03),- 90.0,200.0,0.0,0.0,False),
      (True,(4.50000e+01,-4.49911E+01,1.30000E+03),- 90.0,110.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50002E+01,1.00000E+03),- 90.0,  0.0,0.0,1.0,False),
      (True,(4.49666E+01,-4.47711E+01,3.50000E+03),- 45.0,150.0,0.0,0.0,False),
      (True,(4.50334E+01,-4.47711E+01,3.50000E+03),-135.0,150.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50118E+01,4.00000E+03),- 90.0,125.0,0.0,0.0,False),
      (True,(4.50331E+01,-4.50118E+01,2.00000E+03),  90.0,200.0,0.0,0.0,False),
      (True,(4.50083E+01,-4.50118E+01,1.80000E+03),  90.0,100.0,0.0,0.0,False),
      (True,(4.50056E+01,-4.50118E+01,2.00000E+03),  90.0,150.0,0.0,0.0,False),
      (True,(4.49669E+01,-4.50118E+01,2.00000E+03),  90.0,200.0,0.0,0.0,False),
      (True,(4.49917E+01,-4.50118E+01,1.80000E+03),  90.0,100.0,0.0,0.0,False),
      (True,(4.49944E+01,-4.50118E+01,2.00000E+03), 90.0,150.0,0.0,0.0,False));

   --file for ramp test:
   Results_Ramp : constant Jrt.Reposition_Command_Type :=
     (True,(37.618164062,-122.38171386,11.0),125.0,0.0,0.0,1.0,False);


   type Formation_Cases is array (1 .. 18) of Integer;

   type Formation_Test is
      record
         Hdg         : Float;
         Fore_Aft    : Float;
         Left_Right  : Float;
         Above_Below : Float;
      end record;

   type Formation_Array is array (Formation_Cases'Range) of Formation_Test;

   Form_Test : constant Formation_Array :=
     ((-90.0,-1_000.0,    0.0,    0.0),
      (-90.0, 1_000.0,    0.0,    0.0),
      (-90.0,     0.0,-1000.0,    0.0),
      (-90.0,     0.0, 1000.0,    0.0),
      (-90.0,     0.0,    0.0,-1000.0),
      (-90.0,     0.0,    0.0, 1000.0),
      (  0.0,-1_000.0,    0.0,    0.0),
      (  0.0, 1_000.0,    0.0,    0.0),
      (  0.0,     0.0,-1000.0,    0.0),
      (  0.0,     0.0, 1000.0,    0.0),
      (  0.0,     0.0,    0.0,-1000.0),
      (  0.0,     0.0,    0.0, 1000.0),
      ( 90.0,-1_000.0,    0.0,    0.0),
      ( 90.0, 1_000.0,    0.0,    0.0),
      ( 90.0,     0.0,-1000.0,    0.0),
      ( 90.0,     0.0, 1000.0,    0.0),
      ( 90.0,     0.0,    0.0,-1000.0),
      ( 90.0,     0.0,    0.0, 1000.0));

   type Formation_Results_Array is array
     (Formation_Cases'Range) of Jrt.Reposition_Command_Type;


   Results_Form : constant Formation_Results_Array :=
     ((True,(4.50000E+01,-4.49961E+01,1.00000E+04),- 90.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50039E+01,1.00000E+04),- 90.0,200.0,0.0,0.0,False),
      (True,(4.49973E+01,-4.50000E+01,1.00000E+04),- 90.0,200.0,0.0,0.0,False),
      (True,(4.50027E+01,-4.50000E+01,1.00000E+04),- 90.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50000E+01,9.00000E+03),- 90.0,200.0,0.0,0.0,False),
      (True,(4.50000e+01,-4.50000E+01,1.10000E+04),- 90.0,200.0,0.0,0.0,False),
      (True,(4.49973E+01,-4.50000E+01,1.00000E+04),   0.0,200.0,0.0,1.0,False),
      (True,(4.50027E+01,-4.50000E+01,1.00000E+04),   0.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50039E+01,1.00000E+04),   0.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49961E+01,1.00000E+04),   0.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50000E+01,9.00000E+03),   0.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50000E+01,1.10000E+04),   0.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50039E+01,1.00000E+04),  90.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.49961E+01,1.00000E+04),  90.0,200.0,0.0,0.0,False),
      (True,(4.50027E+01,-4.50000E+01,1.00000E+04),  90.0,200.0,0.0,0.0,False),
      (True,(4.49973E+01,-4.50000E+01,1.00000E+04),  90.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50000E+01,9.00000E+03),  90.0,200.0,0.0,0.0,False),
      (True,(4.50000E+01,-4.50000E+01,1.10000E+04), 90.0,200.0,0.0,0.0,False));

begin

   ---------------------------------------------------------------------------
   --this loop for ils reposition with station heading: -90.0(270.0)

   Put_Line("ILS Reposition with station heading -90.0(270.0):");

   for I in Jrt.Ils_8nm .. Jrt.Vfr_0p5nm loop

      Ref_Lat := 45.0;
      Ref_Lon := -45.0;
      Ref_Lgd := 10_000.0;
      Ref_Hdg := -90.0;
      Ref_Gsa := 3.0;
      Ref_Alt := 1_000.0;

      Reposition.Relative
        (Ref_Lat => Ref_Lat,
         Ref_Lon => Ref_Lon,
         Ref_Lgd => Ref_Lgd,
         Ref_Hdg => Ref_Hdg,
         Ref_Gsa => Ref_Gsa,
         Ref_Alt => Ref_Alt,
         Ref_Sel => i,
         Command => Command);

      Pass :=
        Command.Active = Results_1(I).Active and
    abs(Command.Position.Latitude - Results_1(I).Position.Latitude) <0.01 and
    abs(Command.Position.Longitude - Results_1(I).Position.Longitude) <0.01 and
    abs(Command.Position.Altitude - Results_1(I).Position.Altitude) < 10.0 and
        abs(Command.Heading - Results_1(I).Heading) < 1.0 and
        abs(Command.Airspeed - Results_1(I).Airspeed) < 2.0 and
        abs(Command.Gear_Position - Results_1(I).Gear_Position) < 2.0;

      Class_Test_Result_File.Report_Case_Status (Pass);

      if Pass then
         Put_Line("pass");
      else
         Put_Line("fail");
      end if;
   end loop;

   --------------------------------------------------------------------------
   --this loop for ils reposition, runway heading 90.0.

   Put_Line("ILS Reposition with runway heading 90.0");

   for I in Jrt.Ils_8nm .. Jrt.Vfr_0p5nm loop

      Ref_Lat := 45.0;
      Ref_Lon := -45.0;
      Ref_Lgd := 10_000.0;
      Ref_Hdg := 90.0;
      Ref_Gsa := 3.0;
      Ref_Alt := 1_000.0;

      Reposition.Relative
        (Ref_Lat => Ref_Lat,
         Ref_Lon => Ref_Lon,
         Ref_Lgd => Ref_Lgd,
         Ref_Hdg => Ref_Hdg,
         Ref_Gsa => Ref_Gsa,
         Ref_Alt => Ref_Alt,
         Ref_Sel => i,
         Command => Command);

      Pass :=
        Command.Active = Results_2(I).Active and
    abs(Command.Position.Latitude - Results_2(I).Position.Latitude) <0.01 and
    abs(Command.Position.Longitude - Results_2(I).Position.Longitude) <0.01 and
    abs(Command.Position.Altitude - Results_2(I).Position.Altitude) < 10.0 and
        abs(Command.Heading - Results_2(I).Heading) < 1.0 and
        abs(Command.Airspeed - Results_2(I).Airspeed) < 2.0 and
        abs(Command.Gear_Position - Results_2(I).Gear_Position) < 2.0;

      Class_Test_Result_File.Report_Case_Status (Pass);

      if Pass then
         Put_Line("pass");
      else
         Put_Line("fail");
      end if;
   end loop;

   ----------------------------------------------------------------------------
   -- runway relative repositions with runway heading 90.0:

   Put_Line("Runway Relative Repositions with runway heading 90.0:");

   for I in Jrt.Ils_8nm .. Jrt.L_Inside_Downwind loop

      Ref_Lat := 45.0;
      Ref_Lon := -45.0;
      Ref_Hdg := 90.0;
      Ref_Alt := 1_000.0;

      Reposition.Relative
        (Ref_Lat => Ref_Lat,
         Ref_Lon => Ref_Lon,
         Ref_Hdg => Ref_Hdg,
         Ref_Alt => Ref_Alt,
         Ref_Sel => i,
         Command => Command);

      Pass :=
        Command.Active = Results_3(I).Active and
    abs(Command.Position.Latitude - Results_3(I).Position.Latitude) <0.01 and
    abs(Command.Position.Longitude - Results_3(I).Position.Longitude) <0.01 and
    abs(Command.Position.Altitude - Results_3(I).Position.Altitude) < 10.0 and
        abs(Command.Heading - Results_3(I).Heading) < 1.0 and
        abs(Command.Airspeed - Results_3(I).Airspeed) < 2.0 and
        abs(Command.Gear_Position - Results_3(I).Gear_Position) < 2.0;

      Class_Test_Result_File.Report_Case_Status (Pass);

      if Pass then
         Put_Line("pass");
      else
         Put_Line("fail");
      end if;

   end loop;

   ----------------------------------------------------------------------------
   -- runway relative repositions with runway heading -90.0:
   Put_Line("Runway Relative Repositions with Runway Heading -90.0:");

   for I in Jrt.Ils_8nm .. Jrt.L_Inside_Downwind loop

      Ref_Lat := 45.0;
      Ref_Lon := -45.0;
      Ref_Hdg := -90.0;
      Ref_Alt := 1_000.0;

      Reposition.Relative
        (Ref_Lat => Ref_Lat,
         Ref_Lon => Ref_Lon,
         Ref_Hdg => Ref_Hdg,
         Ref_Alt => Ref_Alt,
         Ref_Sel => i,
         Command => Command);

      Pass :=
        Command.Active = Results_4(I).Active and
    abs(Command.Position.Latitude - Results_4(I).Position.Latitude) <0.01 and
    abs(Command.Position.Longitude - Results_4(I).Position.Longitude) <0.01 and
    abs(Command.Position.Altitude - Results_4(I).Position.Altitude) < 10.0 and
        abs(Command.Heading - Results_4(I).Heading) < 1.0 and
        abs(Command.Airspeed - Results_4(I).Airspeed) < 2.0 and
        abs(Command.Gear_Position - Results_4(I).Gear_Position) < 2.0;

      Class_Test_Result_File.Report_Case_Status (Pass);

      if Pass then
         Put_Line("pass");
      else
         Put_Line("fail");
      end if;

   end loop;

   --RAMP Reposition test-----------------------------------------------
   --
   Put_Line("Ramp Reposition Test:");

   Reposition.Ramp(Ref_Apt => "KSFO",
                   Command => Command);

   Pass :=
     Command.Active = Results_Ramp.Active and
    abs(Command.Position.Latitude - Results_Ramp.Position.Latitude) <0.01 and
    abs(Command.Position.Longitude - Results_Ramp.Position.Longitude) <0.01 and
    abs(Command.Position.Altitude - Results_Ramp.Position.Altitude) < 10.0 and
    abs(Command.Heading - Results_Ramp.Heading) < 1.0 and
    abs(Command.Airspeed - Results_Ramp.Airspeed) < 2.0 and
    abs(Command.Gear_Position - Results_Ramp.Gear_Position) < 2.0;

   Class_Test_Result_File.Report_Case_Status (Pass);

   if Pass then
      Put_Line("pass");
   else
      Put_Line("fail");
   end if;

   --Formation repostion test:
   --
   Put_Line("Formation Reposition Test:");

   for I in Formation_Cases'range loop

      --
      Reposition.Formation
        (Ref_Lat     =>  45.0,
         Ref_Lon     => -45.0,
         Ref_Alt     => 10_000.0,
         Ref_Hdg     => Form_Test(I).Hdg,
         Ref_Ias     => 200.0,
         Fore_Aft    => Form_Test(I).Fore_Aft,
         Left_Right  => Form_Test(I).Left_Right,
         Above_Below => Form_Test(I).Above_Below,
         Command     => Command);

   Pass :=
     Command.Active = Results_Ramp.Active and
 abs(Command.Position.Latitude - Results_Form(I).Position.Latitude) <0.01 and
 abs(Command.Position.Longitude - Results_Form(I).Position.Longitude) <0.01 and
 abs(Command.Position.Altitude - Results_Form(I).Position.Altitude) < 10.0 and
 abs(Command.Heading - Results_Form(I).Heading) < 1.0 and
 abs(Command.Airspeed - Results_Form(I).Airspeed) < 2.0;

   Class_Test_Result_File.Report_Case_Status (Pass);

   if Pass then
      Put_Line("pass");
   else
      Put_Line("fail");
   end if;

   end loop;

end;
