-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Radio_Db_If.Container;
with Jpats_Radio_Db_If.Controller;
with Jpats_Radio_Db_If;
with Class_Test_Result_File;
with Jpats_Radio_Db_If.Ios_If;
with Jpats_Radio_Db_If_Types;
with Interfaces.C;

with Ada.Text_Io;
use Ada.Text_Io;

procedure Jpats_Radio_Db_If.Ctd is

   package Jrt renames Jpats_Radio_Db_If_Types;

   Time : Float := 0.0;
   Iconst : Float := 1.0/10.0;
   Pass : Boolean := False;


begin

   -------------------------------------------------------
   -- Test Case 1-- VOR Station Search
   --
   -- Inputs:
   --  station : Tulsa VOR (TUL) -- 114.4
   --
   -- Expected Results:
   --   ident : TUL
   --   latitude :36.1963
   --   longitude : -95.7881
   --
   -- Purpose:
   --   to test nav station search for vhf nav station
   --

   JPATS_Radio_Db_If.Controller.Initialize;
   JPATS_Radio_Db_If.Controller.Update(Iconst);

   Pass :=
     Container.This_Subsystem.The_Nav_Station.Idnt = "TUL " and
     abs(Container.This_Subsystem.The_Nav_Station.Lat - 36.1963) < 0.1 and
     abs(Container.This_Subsystem.The_Nav_Station.Lon + 95.7881) < 0.1;

   if Pass then
      Put_Line("VHF Nav Tuning OK");
   else
      Put_Line("VHF Nav Tuning Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);

   -------------------------------------------------------
   -- Test Case 2-- DME Station Search
   --
   -- Inputs:
   --  station : OSW -- 117.6
   --
   -- Expected Results:
   --   ident : OSW
   --   latitude  : 36.1963
   --   longitude : -95.7881
   --
   -- Purpose:
   --   to test dme station search for dme station
   --
   Pass :=
     Container.This_Subsystem.The_Dme_Station.Idnt = "OSW " and
     abs(Container.This_Subsystem.The_Dme_Station.Lat - 37.1575) < 0.1 and
     abs(Container.This_Subsystem.The_Dme_Station.Lon + 95.2036) < 0.1;

   if Pass then
      Put_Line("DME Tuning OK");
   else
      Put_Line("DME Tuning Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);

   -------------------------------------------------------
   -- Test Case 3-- VHF Comm Station Search
   --
   -- Inputs:
   --  station : TUL -- 121.2
   --
   -- Expected Results:
   --   ident : OSW
   --   latitude  : 36.1963
   --   longitude : -95.7881
   --
   -- Purpose:
   --   to test dme station search for dme station
   --
   Pass :=
     Container.This_Subsystem.The_Vhf_Comm_Station.Idnt = "KTUL" and
     abs(Container.This_Subsystem.The_Vhf_Comm_Station.Lat - 36.1984) < 0.1 and
     abs(Container.This_Subsystem.The_Vhf_Comm_Station.Lon + 95.8882) < 0.1;

   if Pass then
      Put_Line("VHF Comm Tuning OK");
   else
      Put_Line("VHF Comm Tuning Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);

   -------------------------------------------------------
   -- Test Case 4-- Magnetic Variation Search
   --
   -- Inputs:
   --  position: 36.1963N, 95.7881W
   --
   -- Expected
   -- variation : 4.75
   --
   -- Purpose:
   --   to test magnetic variation search
   --
   Pass :=
     abs(Container.This_Subsystem.The_Magnetic_Variation - 4.75) < 0.1;

   if Pass then
      Put_Line("Magnetic Variation OK");
   else
      Put_Line("Magnetic Variation Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);

   -------------------------------------------------------
   -- Test Case 5-- Station Kill Test
   --
   -- Inputs:
   -- station     : TUL
   -- kill option : 10000040 hex
   -- kill mode   : kill
   -- marker mode : 0
   --
   -- Expected
   -- TUL VOR killed
   --
   -- Purpose:
   --   to test station kill process
   --


   JPATS_Radio_Db_If.Ios_If.Set_Station_Kill
     (A_Kill => (Stn_Idnt  => "TUL      ",   --Kill Ident/ASCII Option
                 Kill_Optn => 16#00000040#, --Bitwise mask for partial kill
                 Kill_Mode => Jrt.Kill,     --Kill Mode:
                                            --0=NULL,1=Kill,2=Reset,3=Reset All
                 Mkr_Kill  => 0));           --Marker Kill Option w/ ILS Kills

   JPATS_Radio_Db_If.Controller.Update(Iconst);

   Pass :=
     Container.This_Subsystem.The_Nav_Station.Idnt(1..3) /= "TUL";

   if Pass then
      Put_Line("Station Kill OK");
   else
      Put_Line("Station Kill Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);

   -------------------------------------------------------
   -- Test Case 6 -- Station Reset Test
   --
   -- Inputs:
   -- station     : TUL
   -- kill option : 10000040 hex
   -- kill mode   : reset
   -- marker mode : 0
   --
   -- Expected
   -- TUL VOR enabled
   --
   -- Purpose:
   --   to test station reset process
   --

   JPATS_Radio_Db_If.Ios_If.Set_Station_Kill
     (A_Kill => (Stn_Idnt  => "TUL      ",  --Kill Ident/ASCII Option
                 Kill_Optn => 16#10000040#, --Bitwise mask for partial kill
                 Kill_Mode => Jrt.Reset,    --Kill Mode:
                                            --0=NULL,1=Kill,2=Reset,3=Reset All
                 Mkr_Kill  => 0));          --Marker Kill Option w/ ILS Kills

   JPATS_Radio_Db_If.Controller.Update(Iconst);

   Pass :=
     Container.This_Subsystem.The_Nav_Station.Idnt(1..3) = "TUL";

   if Pass then
      Put_Line("Station Reset OK");
   else
      Put_Line("Station Reset Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);

end;
