-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Vor;
with  Jpats_Radio_Db_If_Types;
with Ada.Text_Io;
with Radio_Types;
with Ada.Text_IO;
with Ada.Exceptions;
with Class_Test_Result_File;

use Ada.Text_Io;

procedure Vor_Ct is

   Power : Boolean;
   Mode_On : Boolean;
--   Position : Radio_Types.Position_Type;
   Aircraft_True_Hdg   : Radio_Types.Heading_Type;
   Magnetic_Variation : Radio_Types.Bearing_Type;
   Course_Selected            : Radio_Types.Bearing_Type;
   Ground_Elevation           : Radio_Types.Altitude_Type;
   Station                    : Jpats_Radio_Db_If_Types.Stn_Struct_Type;
   Frequency_Changed          : Boolean;
   Pass                       : Boolean;
   Bearing_Stable             : Boolean;
   Bearing_N1                 : Float;
   Time : Float := 0.0;
   Iconst : Float := 1.0/7.5;
   The_Vor : Vor.Instance;

   type Cases is array (1 .. 8) of Integer;

   type Position_Array is array (Cases'range) of Radio_Types.Position_Type;

   Position : constant Position_Array :=
     ((46.0,-45.0,20_000.0),
      (46.0,-44.0,20_000.0),
      (45.0,-44.0,20_000.0),
      (44.0,-44.0,20_000.0),
      (44.0,-45.0,20_000.0),
      (44.0,-46.0,20_000.0),
      (45.0,-46.0,20_000.0),
      (46.0,-46.0,20_000.0));

   type Bearing_Array is array (Cases'range) of Float;

   Bearing : constant Bearing_Array :=
     (180.0,-145.2,-90.0,-35.7,0.0,35.7,90.0,145.2);


begin

   for I in Cases'Range loop

      Time := 0.0;
      Vor.Init(The_Vor);

      Power := True;
      Mode_On := True;
      Aircraft_True_Hdg := 90.0;
      Magnetic_Variation := 0.0;
      Course_Selected := 150.0;
      Ground_Elevation := 1000.0;
      Station.Lat := 45.0;
      Station.Lon := -45.0;
      Station.Elv := 1000.0;
      Station.Typ2(22) := False;
      Station.Var := 0.0;
      Station.Rng := 300.0;
      Frequency_Changed := False;

      while Time < 4.0 loop
         Time := Time + Iconst;

         VOR.Set_VOR_Inputs
           (An_Instance        => The_VOR,
            Power              => Power,
            Mode_On            => Mode_On,
            Aircraft_True_Hdg  => Aircraft_True_Hdg,
            Aircraft_Position  => Position(I),
            Magnetic_Variation => Magnetic_Variation,
            Course_Selected    => Course_Selected,
            Ground_Elevation   => Ground_Elevation,
            Station            => Station,
            Frequency_Changed  => Frequency_Changed);


         vor.Update(Integration_Constant => Iconst,
                    An_Instance          => The_Vor);

         Bearing_Stable := abs(VOR.Mag_Brg_Deg(The_VOR) - Bearing_N1) < 0.1 and
           Time > 1.0;

         Bearing_N1 := VOR.Mag_Brg_Deg(The_VOR);

         if Bearing_Stable then
            Pass := abs(VOR.Mag_Brg_Deg(The_VOR) - Bearing(I)) < 0.5;

            Class_Test_Result_File.Report_Case_Status (Pass);

            if Pass then
               Put_Line("pass");
            else
               Put_Line("fail");
            end if;

            exit;

         end if;

      end loop;

   end loop;

end;

