-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Radio.Audio.Communication.VHF_Comm;
use Radio.Audio.Communication.VHF_Comm;
with  Jpats_Radio_Db_If_Types;
with Ada.Text_Io;
with Radio_Types;
with Class_Test_Result_File;
use Ada.Text_Io;

procedure Vhf_Comm_Ct is

   package Vhf_Comm renames Radio.Audio.Communication.VHF_Comm;

   Power : Boolean;
   Mode_On : Boolean;
   Magnetic_Variation : Radio_Types.Bearing_Type;
   Ground_Elevation           : Radio_Types.Altitude_Type;
   Station                    : Jpats_Radio_Db_If_Types.Stn_Struct_Type;
   Transmitting : Boolean;
   Frequency : Integer;
   Elt_Transmit : Boolean;
   Stable : Boolean;
   Vca_N1 : Float;
   Time : Float := 0.0;
   Iconst : Float := 1.0/7.5;
   The_Vhf_Comm : Vhf_Comm.Instance;

   type Cases is array (1 .. 8) of Integer;

   type Position_Array is array (Cases'range) of Radio_Types.Position_Type;

   Position : constant Position_Array :=
     ((46.0,-45.0,20_000.0),
      (46.0,-44.0,20_000.0),
      (45.0,-44.0,20_000.0),
      (44.0,-44.0,20_000.0),
      (44.0,-45.0,20_000.0),
      (44.0,-46.0,20_000.0),
      (45.0,-46.0,20_000.0),
      (46.0,-46.0,20_000.0));

begin

   for I in Cases'Range loop

      Time := 0.0;
      Init(The_Vhf_Comm);


      Power := True;
      Mode_On := True;
      Magnetic_Variation := 0.0;
      Ground_Elevation := 1000.0;
      Station.Lat := 45.0;
      Station.Lon := -45.0;
      Station.Elv := 1000.0;
      Station.Typ2(25) := False;
      Station.Var := 0.0;
      Station.Rng := 300.0;
      Transmitting := False;
      Frequency := 0;
      Elt_Transmit := False;

      while Time < 5.0 loop
         Time := Time + Iconst;

         Set_Power(The_Vhf_Comm,Power);
         Set_Aircraft_Position(The_Vhf_Comm,Position(I));
         Set_Ground_Elevation(The_Vhf_Comm,Ground_Elevation);
         Set_Magnetic_Variation(The_Vhf_Comm,Magnetic_Variation);
         Set_Station(The_Vhf_Comm,Station);
         Set_Transmitting(The_Vhf_Comm,Transmitting);
         Set_Frequency(The_Vhf_Comm,Frequency);
         Set_Elt_Transmit(The_Vhf_Comm,Elt_Transmit);

         Update(Integration_Constant => Iconst,
                An_Instance          => The_Vhf_Comm);

         Stable := abs(Vca(The_Vhf_Comm) - Vca_N1) < 0.01 and
           Time > 0.5;
         Vca_N1 := Vca(The_Vhf_Comm);

         if Stable then

            Class_Test_Result_File.Report_Case_Status(receiving(The_Vhf_Comm));

            if receiving(The_Vhf_Comm) then
               Put_Line("Pass");
            else
               Put_Line("Fail");
            end if;

            exit;

         end if;

      end loop;

   end loop;

end;

