-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Radio.Audio.Dme;
with  Jpats_Radio_Db_If_Types;
with Ada.Text_Io;
with Radio_Types;
with Class_Test_Result_File;

use Ada.Text_Io;
use Radio.Audio.Dme;

procedure Radio.Audio.Dme_Ct is

   Power : Boolean;
   Mode_On : Boolean;
   Ils_Freq_Tuned : Boolean;
   Frequency_Hold_Selected : Boolean;
   Aircraft_True_Hdg   : Radio_Types.Heading_Type;
   Magnetic_Variation : Radio_Types.Bearing_Type;
   Ground_Elevation           : Radio_Types.Altitude_Type;
   Station                    : Jpats_Radio_Db_If_Types.Stn_Struct_Type;
   Stable : Boolean;
   Range_N1 : Float;
   Pass : Boolean;
   Time : Float := 0.0;
   Iconst : Float := 1.0/7.5;
   The_Dme : Radio.Audio.Dme.Instance;

   type Cases is array (1 .. 16) of Integer;

   type Position_Array is array (Cases'range) of Radio_Types.Position_Type;

   Position : constant Position_Array :=
     ((46.0,-45.0,10_000.0),
      (46.0,-44.0,10_000.0),
      (45.0,-44.0,10_000.0),
      (44.0,-44.0,10_000.0),
      (44.0,-45.0,10_000.0),
      (44.0,-46.0,10_000.0),
      (45.0,-46.0,10_000.0),
      (46.0,-46.0,10_000.0),
      (46.0,-45.0,50_000.0),
      (46.0,-44.0,50_000.0),
      (45.0,-44.0,50_000.0),
      (44.0,-44.0,50_000.0),
      (44.0,-45.0,50_000.0),
      (44.0,-46.0,50_000.0),
      (45.0,-46.0,50_000.0),
      (46.0,-46.0,50_000.0));

   type Distance_Array is array (Cases'range) of Float;

   Distance : constant Distance_Array :=
     (60.01,73.07,42.45,73.93,60.02,73.93,42.45,73.07,
      60.54,73.50,43.19,74.35,60.54,74.35,43.19,73.50);


begin

   for I in Cases'Range loop

      Time := 0.0;
      Init(The_dme);

      Power := True;
      Mode_On := True;
      Ils_Freq_Tuned := False;
      Frequency_Hold_Selected := False;
      Aircraft_True_Hdg := 90.0;
      Magnetic_Variation := 0.0;
      Ground_Elevation := 1000.0;
      Station.Lat := 45.0;
      Station.Lon := -45.0;
      Station.Elv := 1000.0;
      Station.Typ2(22) := False;
      Station.Var := 0.0;
      Station.Rng := 300.0;

      while Time < 4.0 loop
         Time := Time + Iconst;

         Set_Power(The_Dme,Power);
         Set_Aircraft_Position(The_Dme,Position(I));
         Set_Ground_Elevation(The_Dme,Ground_Elevation);
         Set_Magnetic_Variation(The_Dme,Magnetic_Variation);
         Set_Station(The_Dme,Station);
         Set_ILS_Freq_Tuned(The_Dme,ILS_Freq_Tuned);
         Set_Frequency_Hold_Selected(The_Dme,Frequency_Hold_Selected);


         Radio.Audio.Dme.Update(Integration_Constant => Iconst,
                                An_Instance          => The_Dme);

         Stable := abs(Range_To_station(The_Dme) - Range_N1) < 0.01 and
           Time > 1.5;

         Range_N1 := Range_To_station(The_Dme);

         if Stable then
            Pass := abs(Range_To_station(The_Dme) - Distance(I)) < 0.5;

            Class_Test_Result_File.Report_Case_Status (Pass);

            if Pass then
               Put_Line("pass");
            else
               Put_Line("fail");
            end if;

            exit;

         end if;

      end loop;

   end loop;

end;

