-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Marker_Beacon;
with  Jpats_Radio_Db_If_Types;
with Ada.Text_Io;
with Radio_Types;
with Class_Test_Result_File;

use Ada.Text_Io,
  Marker_Beacon,
  Jpats_Radio_Db_If_Types;

procedure Marker_Beacon_Ct is

   package Mkr renames Marker_Beacon;

   Power : Boolean;
   High_Sense : Boolean;
   Aircraft_True_Hdg   : Radio_Types.Heading_Type;
   Magnetic_Variation : Radio_Types.Bearing_Type;
   Ground_Elevation           : Radio_Types.Altitude_Type;
   Station                    : Jpats_Radio_Db_If_Types.Mrkr_Stn_Struct;
   Stable : Boolean;
   Vca_n1 : Float;
   Time : Float := 0.0;
   Iconst : Float := 1.0/7.5;
   The_Mkr : Marker_Beacon.Instance;

   type Cases is array (1 .. 3) of Integer;

   type Position_Array is array (Cases'range) of Radio_Types.Position_Type;

   Position : constant Position_Array :=
     ((45.00000000,-44.95383333,20000.0),
      (45.00000000,-44.94643889,20000.0),
      (45.00000000,-44.84340000,20000.0));

begin

   for I in Cases'Range loop

      Time := 0.0;
      Init(The_Mkr);


      Power := True;
      High_Sense := False;
      Aircraft_True_Hdg := 90.0;
      Magnetic_Variation := 0.0;
      Ground_Elevation := 1000.0;
      Station(Inner).Lat := 45.0;
      Station(Inner).Lon := -44.95383333;
      Station(Inner).Elv := 1000.0;
      Station(Inner).Hdg := 270.0;
      Station(Inner).Typ2(24) := False; --bone marker
      Station(Inner).Typ2(23) := false; --z marker
      Station(Inner).Typ2(22) := false; --fan marker
      Station(Inner).Typ2(21) := False; --bc marker
      Station(Inner).Typ2(29) := True; --inner marker
      Station(Inner).Var := 0.0;
      Station(middle).Lat := 45.0;
      Station(middle).Lon := -44.94643889;
      Station(middle).Elv := 1000.0;
      Station(Middle).Hdg := 270.0;
      Station(middle).Var := 0.0;
      Station(outer).Lat := 45.0;
      Station(outer).Lon := -44.84340000;
      Station(outer).Elv := 1000.0;
      Station(Outer).Hdg := 270.0;
      Station(outer).Var := 0.0;

      while Time < 2.0 loop
         Time := Time + Iconst;

         Set_Power(The_Mkr,Power);
         Set_High_Sense(The_Mkr,High_Sense);
         Set_Aircraft_Position(The_Mkr,Position(I));
         Set_Aircraft_True_Hdg(The_Mkr,Aircraft_True_Hdg);
         Set_Magnetic_Variation(The_Mkr,Magnetic_Variation);
         Set_Ground_Elevation(The_Mkr,Ground_Elevation);
         Set_Station(The_Mkr,Station);

         Update(Integration_Constant => Iconst,
                An_Instance          => The_Mkr);

         if I = 1 then
            Stable := abs(Inner_VCA(The_mkr) - Vca_N1) < 0.01 and
              Time > 0.25;
            Vca_N1 := Inner_VCA(The_mkr);

            if Stable then
               Class_Test_Result_File.Report_Case_Status
                 (Inner_Receiving(The_mkr));

               if Inner_Receiving(The_mkr) then
                  Put_Line("pass");
               else
                  Put_Line("fail");
               end if;

               exit;

            end if;


         elsif I = 2 then
            Stable := abs(Middle_VCA(The_mkr) - Vca_N1) < 0.01 and
              Time > 0.25;
            Vca_N1 := Middle_VCA(The_mkr);

            if Stable then
               Class_Test_Result_File.Report_Case_Status
                 (Middle_Receiving(The_mkr));

               if Middle_Receiving(The_mkr) then
                  Put_Line("pass");
               else
                  Put_Line("fail");
               end if;

               exit;

            end if;

         elsif I = 3 then
            Stable := abs(Outer_VCA(The_mkr) - Vca_N1) < 0.01 and
              Time > 0.25;
            Vca_N1 := Outer_VCA(The_mkr);

            if Stable then
               Class_Test_Result_File.Report_Case_Status
                 (Outer_Receiving(The_mkr));

               if Outer_Receiving(The_mkr) then
                  Put_Line("pass");
               else
                  Put_Line("fail");
               end if;

               exit;

            end if;
         end if;


      end loop;

   end loop;

end;





