-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Localizer;
with  Jpats_Radio_Db_If_Types;
with Ada.Text_Io;
with Radio_Types;
with Class_Test_Result_File;

use Ada.Text_Io;

procedure Localizer_Ct is

   Power : Boolean;
   Mode_On : Boolean;
   Aircraft_True_Hdg   : Radio_Types.Heading_Type;
   Magnetic_Variation : Radio_Types.Bearing_Type;
   Ground_Elevation           : Radio_Types.Altitude_Type;
   Station                    : Jpats_Radio_Db_If_Types.Stn_Struct_Type;
   Frequency_Changed          : Boolean;
   Center_Of_Gravity_X        : Float;
   Reference_Airfield         : Jpats_Radio_Db_If_Types.Apt_Struct_Type;
   Reference_Runway           : Jpats_Radio_Db_If_Types.Rwy_Struct_Type;
   Stable                     : Boolean;
   Dots_N1                    : Float;
   Pass                       : Boolean;
   Time : Float := 0.0;
   Iconst : Float := 1.0/7.5;
   The_Localizer : Localizer.Instance;

   type Cases is array (1 .. 15) of Integer;

   type Position_Array is array (Cases'range) of Radio_Types.Position_Type;

   Position : constant Position_Array :=
     ((45.00483611,-44.84339722,6_000.0),
      (45.00241667,-44.84339722,6_000.0),
      (45.00000000,-44.84339722,6_000.0),
      (44.99758333,-44.84339722,6_000.0),
      (44.99516389,-44.84339722,6_000.0),
      (45.00823333,-44.73333333,6_000.0),
      (45.00411389,-44.73333333,6_000.0),
      (45.00000000,-44.73333333,6_000.0),
      (44.99588611,-44.73333333,6_000.0),
      (44.99176667,-44.73333333,6_000.0),
      (45.01543611,-44.50000000,6_000.0),
      (45.00771667,-44.50000000,6_000.0),
      (45.00000000,-44.50000000,6_000.0),
      (44.99228611,-44.50000000,6_000.0),
      (44.98456389,-44.50000000,6_000.0));

   type Dots_Array is array (Cases'range) of Float;

   Dots : constant Dots_Array := (2.0,1.0,0.0,-1.0,-2.0,
                                  2.0,1.0,0.0,-1.0,-2.0,
                                  2.0,1.0,0.0,-1.0,-2.0);
begin

   for I in Cases'Range loop

      Time := 0.0;
      Localizer.Init_Localizer(The_Localizer);

      Power := True;
      Mode_On := True;
      Aircraft_True_Hdg := 270.0;
      Magnetic_Variation := 0.0;
      Ground_Elevation := 1000.0;
      Station.Lat := 45.0;
      Station.Lon := -45.0;
      Station.Elv := 1000.0;
      Station.Var := 0.0;
      Station.Rng := 300.0;
      Station.Hdg := 270.0;
      Station.Lgd := 10000.0;
      Station.Lbw := 5.0;
      Station.Typ1(30) := True;
      Station.Typ2(20) := True;
      Station.Typ2(29) := False;
      Center_Of_Gravity_X := 0.0;
      Reference_Airfield.Idnt := "XXXX";
      Reference_Runway.Len := 10000.0;
      Reference_Runway.Dtr := 0.0;
      Frequency_Changed := False;


      while Time < 4.0 loop
         Time := Time + Iconst;

         -- Provide inputs for Localizer processing
         Localizer.Set_Localizer_Inputs
           (An_Instance         => The_Localizer,
            Power               => Power,
            Mode_On             => Mode_On,
            Aircraft_Position   => Position(I),
            Aircraft_True_Hdg   => Aircraft_True_Hdg,
            Magnetic_Variation  => Magnetic_Variation,
            Ground_Elevation    => Ground_Elevation,
            Station             => Station,
            Frequency_Changed   => Frequency_Changed,
            Center_Of_Gravity_X => Center_Of_Gravity_X,
            Reference_Airfield  => Reference_Airfield,
            Reference_Runway    => Reference_Runway);

         --Call Localizer
         Localizer.Update_Localizer(Iconst,The_Localizer);

         Stable := abs(Localizer.Dev_Dots(The_Localizer) - Dots_N1) < 0.1 and
           Time > 1.0;
         Dots_N1 := Localizer.Dev_Dots(The_Localizer);

         if Stable then
            Pass := abs(Localizer.Dev_Dots(The_Localizer) - Dots(I)) < 0.1;

            Class_Test_Result_File.Report_Case_Status (Pass);

            if Pass then
               Put_Line("pass");
            else
               Put_Line("fail");
            end if;

            exit;
         end if;

      end loop;

   end loop;

end;

