-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Radio.Container;
with Jpats_Radio.Controller;
with Jpats_Radio;
with Class_Test_Result_File;
with Jpats_Reposition,
  Jpats_Electrical,
  Jpats_Simulated_Aircraft,
  Jpats_Atmosphere,
  Jpats_Radio_Db_If,
  Jpats_avionics;

with Ada.Text_Io;
use Ada.Text_Io;

procedure Jpats_Radio.Ctd is

   Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;

   Time : Float := 0.0;
   Iconst : Float := 1.0/10.0;
   Pass : Boolean := False;

begin


   -------------------------------------------------------
   -- Test Case 1--VHF Nav
   --
   -- Inputs:
   --   station data:  ils station @ 45.0N, 45.0W,2993.0 ft elev
   --   cb power: available
   --   aircraft position: 45.0024N, 44.8434W, 2993.0 ft elev
   --   magnetic variation : 0.0
   --   ils frequency tuned
   --   true heading : 270.0
   --   course selected : 0.0
   --   marker stations : all located @ aircraft position
   --
   -- Expected Results:
   --   localizer deviation : 1.0 dot
   --   glideslope deviation : 2.0 dots
   --   marker beacons :  all receiving
   --
   --
   -- Purpose:
   --   test the function of the vhf nav receiver
   --
   JPATS_Radio.Controller.Initialize;

   JPATS_Radio.Controller.Update(Iconst);

   --localizer:
   Pass := abs(Io.The_Nav_Tx2.Localizer_Deviation - 1.0) < 0.1;
   if Pass then
      Put_Line("Localizer OK");
   else
      Put_Line("localizer Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);

   --glideslope:
   Pass := abs(Io.The_Nav_Tx2.Glideslope_Deviation - 2.0) < 0.1;
   if Pass then
      Put_Line("Glideslope OK");
   else
      Put_Line("Glideslope Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);

   --marker beacons
   Pass := Io.The_Nav_Tx2.Outer_Marker_Beacon;
   if Pass then
      Put_Line("Outer Marker OK");
   else
      Put_Line("Outer Marker Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := Io.The_Nav_Tx2.Middle_Marker_Beacon;
   if Pass then
      Put_Line("Middle Marker OK");
   else
      Put_Line("Middle Marker Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := Io.The_Nav_Tx2.Inner_Marker_Beacon;
   if Pass then
      Put_Line("Inner Marker OK");
   else
      Put_Line("Inner Marker Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);


   -------------------------------------------------------
   -- Test Case 2--DME Receiver
   --
   -- Inputs:
   --   power : available
   --   aircraft position : 45.0024N, 44.843397W,2993.0 ft. elev
   --   station : dme station @ 46.0N, 46.0W, 1000 ft elev.
   --
   --
   -- Expected Results:
   --   distance : 77.4 nautical miles
   --
   -- Purpose:
   --   To test the DME receiver
   --
   JPATS_Radio.Controller.Initialize;

   Time := 0.0;

   loop

      Time := Time + Iconst;

      JPATS_Radio.Controller.Update(Iconst);

      if Time > 1.5 then
         Pass := abs(Io.The_Dme_Tx2.Distance - 77.4) < 0.5;

         if Pass then
            Put_Line("DME OK");
         else
            Put_Line("DME Fail");
         end if;
         Class_Test_Result_File.Report_Case_Status(Pass);
         exit;
      end if;
   end loop;
   -------------------------------------------------------
   -- Test Case 3-- ELT
   --
   -- Inputs:
   --   arm switch - on
   --   crash -- on
   --
   -- Expected Results:
   --   ELT transmit light - on
   --
   -- Purpose:
   --   To test the ELT transmitter
   --
   JPATS_Radio.Controller.Initialize;
   Io.The_Elt_Arm_Sw := True;

   JPATS_Radio.Controller.Update(Iconst);
   Pass := Io.The_Elt_Xmt_Lt;

   if Pass then
      Put_Line("ELT OK");
   else
      Put_Line("ELT Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);


   -------------------------------------------------------
   -- Test Case 4-- VHF Comm
   --
   -- Inputs:
   --   power : available
   --   aircraft position : 45.0024N, 44.843397W,2993.0 ft. elev
   --   station : vhf comm station @ 45.5N, 45.5W, 1000 ft. elev.
   --
   --
   -- Expected Results:
   --   receiving, with VCA close to 1.0
   --
   -- Purpose:
   --   Test the VHF Comm radio
   --
   JPATS_Radio.Controller.Initialize;

   JPATS_Radio.Controller.Update(Iconst);

   Pass := abs(Io.Vhf_Signal_To_Noise_Ratio - 1.0) < 0.1;

   if Pass then
      Put_Line("VHF Comm OK");
   else
      Put_Line("VHF Comm Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);


   -------------------------------------------------------
   -- Test Case 5-- UHF Comm
   --
   -- Inputs:
   --   power : available
   --   aircraft position : 45.0024N, 44.843397W,2993.0 ft. elev
   --   station : uhf comm station @ 45.5N, 45.5W, 1000 ft. elev.
   --
   --
   -- Expected Results:
   --   receiving, with VCA close to 1.0
   --
   -- Purpose:
   --   Test the UHF Comm radio
   --
   JPATS_Radio.Controller.Initialize;

   JPATS_Radio.Controller.Update(Iconst);

   Pass := abs(Io.Uhf_Signal_To_Noise_Ratio - 1.0) < 0.1;

   if Pass then
      Put_Line("UHF Comm OK");
   else
      Put_Line("UHF Comm Fail");
   end if;
   Class_Test_Result_File.Report_Case_Status(Pass);


end;














