-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Glideslope;
with  Jpats_Radio_Db_If_Types;
with Ada.Text_Io;
with Radio_Types;
with Class_Test_Result_File;

use Ada.Text_Io,
  Jpats_Radio_Db_If_Types,
  glideslope;

procedure glideslope_Ct is

   Power : Boolean;
   Mode_On : Boolean;
   Aircraft_True_Hdg   : Radio_Types.Heading_Type;
   Magnetic_Variation : Radio_Types.Bearing_Type;
   Ground_Elevation           : Radio_Types.Altitude_Type;
   Station                    : Jpats_Radio_Db_If_Types.Stn_Struct_Type;
   Frequency_Changed          : Boolean;
   Center_Of_Gravity_X        : Float;
   Center_Of_Gravity_Z        : Float;
   Aircraft_Pitch             : Float;
   Stable                     : Boolean;
   Pass                       : Boolean;
   Dots_N1                    : Float;
   Time : Float := 0.0;
   Iconst : Float := 1.0/7.5;
   The_gs : glideslope.Instance;

   type Cases is array (1 .. 13) of Integer;

   type Position_Array is array (Cases'range) of Radio_Types.Position_Type;

   Position : constant Position_Array :=
     ((45.00000000,-44.84339722,2194.0),
      (45.00000000,-44.84339722,2593.0),
      (45.00000000,-44.84339722,2993.0),
      (45.00000000,-44.73333333,3310.0),
      (45.00000000,-44.73333333,3695.0),
      (45.00000000,-44.73333333,4080.0),
      (45.00000000,-44.73333333,4467.0),
      (45.00000000,-44.73333333,4853.0),
      (45.00000000,-44.50000000,5675.0),
      (45.00000000,-44.50000000,6455.0),
      (45.00000000,-44.50000000,7235.0),
      (45.00000000,-44.50000000,8016.0),
      (45.00000000,-44.50000000,8798.0));

   type Dots_Array is array (Cases'range) of Float;

   Dots : constant Dots_Array := (-2.0,0.0,2.0,
                                  -2.0,-1.0,0.0,1.0,2.0,
                                  -2.0,-1.0,0.0,1.0,2.0);




begin

   for I in Cases'Range loop

      Time := 0.0;
      Init(The_Gs);


      Power := True;
      Mode_On := True;
      Aircraft_True_Hdg := 270.0;
      Magnetic_Variation := 0.0;
      Ground_Elevation := 1000.0;
      Station.Lat := 45.0;
      Station.Lon := -45.0;
      Station.Elv := 1000.0;
      Station.Hdg := 270.0;
      Station.Lgd := 10000.0;
      Station.Gsa := 3.0;
      Station.Gsw := 1.5;
      Station.Typ1(30) := true;
      Station.Typ2(21) := true;
      Station.Var := 0.0;
      Station.Rng := 300.0;
      Frequency_Changed := False;
      Center_Of_Gravity_X := 0.0;
      Center_Of_Gravity_Z := 0.0;
      Aircraft_Pitch      := 0.0;

      while Time < 2.0 loop
         Time := Time + Iconst;

         Set_glideslope_Inputs
           (An_Instance         => The_gs,
            Power               => Power,
            Mode_On             => Mode_On,
            Aircraft_Position   => Position(I),
            Aircraft_True_Hdg   => Aircraft_True_Hdg,
            Magnetic_Variation  => Magnetic_Variation,
            Ground_Elevation    => Ground_Elevation,
            Station             => Station,
            Frequency_Changed   => Frequency_Changed,
            Center_Of_Gravity_X => Center_Of_Gravity_X,
            Center_Of_Gravity_Z => Center_Of_Gravity_Z,
            Aircraft_Pitch      => Aircraft_Pitch);


         Update(Integration_Constant => Iconst,
                An_Instance          => The_Gs);

         Stable := abs(Glideslope.Dev_Dots(The_Gs) - Dots_N1) < 0.1 and
           Time > 1.0;
         Dots_N1 := Glideslope.Dev_Dots(The_Gs);

         if Stable then
            Pass := abs(Glideslope.Dev_Dots(The_Gs) - Dots(I)) < 0.1;

            Class_Test_Result_File.Report_Case_Status (Pass);

            if Pass then
               Put_Line("pass");
            else
               Put_Line("fail");
            end if;

            exit;

         end if;

      end loop;

   end loop;

end;

