-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
--with Saved_Data_Header;
--with Save_Stream_Notifier;

package body Subsystem_Scheduler is

   -- This tries to account for the overhead in both saved data headers and
   -- buffer_stream headers.
--   Overhead_Per_Entry : constant Natural := Saved_Data_Header.Bytes + 16;

   procedure Initialize
     ( An_Instance : in out Instance ) is
   begin
      null;
   end Initialize;

   procedure Update
     ( An_Instance          : in out Instance;
       Integration_Constant : in     Float ) is
   begin
      null;
   end Update;

   procedure Update_In_Freeze
     ( An_Instance : in out Instance ) is
   begin
      null;
   end Update_In_Freeze;

   procedure Save
     ( An_Instance : in out Instance;
       To_Stream   : in out Ada.Streams.Root_Stream_Type'Class
     ) is
   begin
      null;
   end Save;

   -------------------------------------------------------------------------------
   -- Routine to retrieve a snapshot of the instance from the given stream.
   --
   -- Note that the predefined attributes 'Read and 'Input can be used on any
   -- object to retrieve its value in the given stream. This routine should be
   -- written so that data is read from the stream in the same order it was placed
   -- into the stream.
   -------------------------------------------------------------------------------
   procedure Restore
     ( An_Instance : in out Instance;
       From_Stream : in out Ada.Streams.Root_Stream_Type'Class
     ) is
   begin
      null;
   end Restore;

   -------------------------------------------------------------------------------
   -- Create the save and restore streams for the given scheduler, using the given
   -- amount of bytes per instance stored.
   -------------------------------------------------------------------------------
   procedure Create_Streams
     ( An_Instance : in out Instance'Class;
       Save_Size   : in     Natural
     ) is
   begin
--      An_Instance.Save_Stream    := new Buffer_Stream.Save.Instance;
--      An_Instance.Restore_Stream := new Buffer_Stream.Restore.Instance;

--      Buffer_Stream.Save.Create
--        (Stream   => An_Instance.Save_Stream.all,
--         Max_Size => (Save_Size + Overhead_Per_Entry)
--         );

--      Buffer_Stream.Restore.Create
--        (Stream   => An_Instance.Restore_Stream.all,
--         Max_Size => (Save_Size + Overhead_Per_Entry) * 2
--         );
null;
   end Create_Streams;

   -------------------------------------------------------------------------------
   -- Create the save/restore notifier for the given scheduler.
   -------------------------------------------------------------------------------
   procedure Create_Notifier (An_Instance : in Handle) is
--      Forget_About_It : Save_Stream_Notifier.Handle;
   begin
      -- Create the notifier for the save stream
--      Forget_About_It := new Save_Stream_Notifier.Instance(An_Instance);
   null;
   end Create_Notifier;

   -------------------------------------------------------------------------------
   -- Return a pointer to the save stream associated with the given scheduler.
   -------------------------------------------------------------------------------
   function Save_Stream (An_Instance : in Instance'Class) return
     Buffer_Stream.Save.Handle is
   begin
      return An_Instance.Save_Stream;
   end Save_Stream;

   -------------------------------------------------------------------------------
   -- Return a pointer to the restore stream associated with the given scheduler.
   -------------------------------------------------------------------------------
   function Restore_Stream (An_Instance : in Instance'Class) return
     Buffer_Stream.Restore.Handle is
   begin
      return An_Instance.Restore_Stream;
   end Restore_Stream;

end Subsystem_Scheduler;




