-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Thomas N. Haley
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

----------------------------------------------------------------------------
-- Process the command line arguements.
----------------------------------------------------------------------------
--with Ada.Dynamic_Priorities;
--with Ada.Strings.Fixed;
--with Ada.Strings.Maps.Constants;
--with Ada.Tags;
--with Ada.Text_IO;
--with Ada.Real_Time;
-- with JPATS_IOS_Interface;
-- with Interfaces.C;
-- with OS_Interface;
-- with Record_Playback;
-- with Stethoscope_Bindings;
-- with System;

-- Allow builtin operators for the following types
--use type Ada.Real_Time.Time;
--use type Ada.Real_Time.Time_Span;

package body Scheduler_Collection is

--    --
--    -- Package body constants.
--    --
     Body_File_Name : constant string := "Scheduler_Collection.adb";
--
--   COMMENT_CHAR                     : constant CHARACTER := '#';
--    -- Comment character used for the SIM.CFG file.
--
--    CR_CHAR                          : constant CHARACTER := CHARACTER'VAL(13);
--    -- Carriage return used for the SIM.CFG file.
--
--    END_OF_FILE_CHAR                 : constant CHARACTER := CHARACTER'VAL(26);
--    -- End of File character for the SIM.CFG file;
--
--    END_OF_LINE_CHAR                 : constant CHARACTER := CHARACTER'VAL(10);
--    -- End of Line character for the SIM.CFG file.
--
--    Max_Number_Module_Type_Chars     : constant INTEGER := 80;
--
--    MAX_NUMBER_OF_PARAMS             : constant POSITIVE := 10;
--    -- Maximum number of parameters for a SIM.CFG entry.
--
    Max_Name_Length                  : constant POSITIVE := 50;
--    -- Maximum length of a file name.
--
--    Max_Number_Of_Background_Threads    : constant INTEGER := 10;
--    --% Defines the maximum number of background threads.
--
--    Max_Number_Of_Background_Modules    : constant INTEGER := 10;
--    --% Defines the maximum number of background threads.
--
--    Max_Number_Of_Non_Real_Time_Modules : constant := 240;
--    --% Defines the maximum number of nonreal-time modules that can be
--    --% scheduled by the scheduler.
--
--    Max_Number_Of_Real_Time_Modules     : constant := 240;
--    --% Defines the maximum number of real-time modules that can be scheduled
--    --%  by the scheduler.
--
--    Max_Number_Of_Module_Name_Chars     : constant := 80;
--    --% Defines the maximum allowable length for a module name.
--
--    Max_Number_Of_Threads               : constant := 24;
--    --% Defines the maximum number of threads that may be created.
--
--    Max_Number_Of_Thread_Name_Chars     : constant := 20;
--    --% Defines the maximum allowable length for a thread name.
--
--    MAX_STRING_LENGTH                : constant POSITIVE := 255;
--
--    MIN_NUM_PARAMS_FOR_NRT_MODULE    : constant INTEGER := 6;
--    -- Minimum number of parameters for a Non Real Time module in SIM.CFG.
--
--    MIN_NUM_PARAMS_FOR_RT_MODULE     : constant INTEGER := 5;
--    -- Minimum number of parameters for a Real Time module in SIM.CFG.
--
--    MIN_NUM_PARAMS_FOR_SIMCLOCK      : constant INTEGER := 2;
--    -- Minimum number of parameters for a Sim Clock module in SIM.CFG.
--
--    MIN_NUM_PARAMS_FOR_THREAD        : constant INTEGER := 8;
--    -- Minimum number of parameters for a Thread module in SIM.CFG.
--
--    subtype Real_Time_Module_ID_type is NATURAL range 0..Max_Number_Of_Real_Time_Modules-1;
--    --% Defines range of valid real-time module IDs.
--
--    subtype Thread_ID_Type is NATURAL range 0 .. Max_Number_Of_Threads-1;
--    --% Defines range of valid thread IDs.
--
--    --
--    -- Thread task type spec.  The most common usage is for periodic activation of real time processing e.g. there
--    -- usually are 60 HZ, 30 HZ, 15 HZ, etc. tasks.  There will be a thread type allocated for each task.
--    --
--    task type Thread_Type is
--
--       --
--       -- Rendezvous for initializing the thread task.
--       --
--       entry Initialize( Id         : in  Thread_ID_Type;
--                         Priority   : in  Integer;
--                         CPU        : in  Integer );
--
--       entry Update;
--       --% Called to tell the thread to call its modules.
--
--       entry Cancel;
--       --% Called to cancel the thread.
--
--    end Thread_Type;
--
--    type THREAD_PTR_TYPE is access Thread_Type;
--    -- Defines a pointer type to Thread_Type tasks.
--
--    --
--    -- Package body types.
--    --
--    type Abort_Id_Type is ( Task_Cant_Resume, Unsuccessful_Processing_Of_Config_Data );
--
--    type List_Proc_Ptr_Type is access function ( Param_String : in STRING ) return BOOLEAN;
--    -- For Processing Module types in the SIM.CFG file.
--
--    type Non_Real_Time_Module_Data is record
--
--       Name_Len       : NATURAL                                        := 0;
--
--       Name           : STRING( 1 .. Max_Number_Of_Module_Name_Chars ) := ( others => Ada.Characters.Latin_1.Nul );
--
--       Module_Handle  : Subsystem_Scheduler.Handle                     := null;
--
--       Execution_Mask : INTEGER                                        := 0;
--
--       Active         : BOOLEAN                                        := FALSE;
--
--       Cycles_Called  : NATURAL                                        := 0;
--
--    end record;
--    --% Defines a type to hold module data in the real-time module table.
--
--    type Module_Node_Type;
--
--    type Module_Node_PTR_Type is access all Module_Node_Type;
--
--    type Module_Node_Type is record
--
--       Module_Id : Natural := 0;
--       -- Index into table of information that is kept by the scheduler for each module.
--
--       Next      : Module_Node_PTR_Type := NULL;
--       -- Pointer to the next node in the linked list.
--
--    end record;
--
--    type Non_Real_Time_Module_Data_Ptr_Type is access all Non_Real_Time_Module_Data;
--
--    type Real_Time_Module_Data is record
--
--       Name_Len       : NATURAL                                        := 0;
--       Name           : STRING( 1 .. Max_Number_Of_Module_Name_Chars ) := ( others => Ada.Characters.Latin_1.Nul );
--       Thread         : THREAD_ID_TYPE                                 := THREAD_ID_TYPE'first;
--       Module_Handle  : Subsystem_Scheduler.Handle                     := NULL;
--       Execution_Mask : integer                                        := 0;
--       Active         : BOOLEAN                                        := FALSE;
--       Snap_Requested : Boolean                                        := False;
--       Cycles_Called  : NATURAL                                        := 0;
--       Min_Time       : FLOAT                                          := 0.0;
--       Max_Time       : FLOAT                                          := 0.0;
--       Ave_Time       : FLOAT                                          := 0.0;
--       Percent_Frame  : FLOAT                                          := 0.0;
--       Stopped        : Boolean                                        := TRUE;
--       Frozen         : Boolean                                        := False;
--
--    end record;
--
--    type Real_Time_Module_Data_Ptr_Type is access all Real_Time_Module_Data;
--
--    type Start_End_Pos_Type is record
--
--       Start_Pos : Positive := 1;
--
--       End_Pos   : Positive := 1;
--
--    end record;
--
--    type Parameter_Position_Type is array ( Positive range 1..Max_Number_OF_Params ) of Start_End_Pos_Type;
--
--    type Line_Record_Type is record
--
--       Current_Buffer_Position   : Positive := 1;
--
--       Number_Of_Entries_In_Line : Positive := 1;
--
--       Parameter_Positions       : Parameter_Position_Type := ( others => ( Start_Pos => 1,
--                                                                            End_Pos   => 1 ) );
--
--    end record;
--
--    type Thread_Data_Type is record
--
--       Name_Len             : NATURAL                                        := 0;
--
--       Name                 : STRING( 1 .. Max_Number_Of_Thread_Name_Chars ) := ( others => Ada.Characters.Latin_1.Nul );
--
--       Priority             : INTEGER                                        := 0;
--
--       Start_Cycle          : NATURAL                                        := 0;
--
--       Scheduling_Period    : POSITIVE                                       := 1;
--
--       Execution_Period     : POSITIVE                                       := 1;
--
--       Delta_Time           : FLOAT                                          := 0.0;
--
--       Iterations_Completed : NATURAL                                        := 0;
--
--       Scheduling_Overruns  : NATURAL                                        := 0;
--
--       Execution_Overruns   : NATURAL                                        := 0;
--
--       Cycle_Last_Started   : NATURAL                                        := 0;
--
--       Cycle_Last_Finished  : NATURAL                                        := 0;
--
--       Max_Overruns         : NATURAL                                        := 0;
--
--       User_Time            : FLOAT                                          := 0.0;
--
--       Sys_Time             : FLOAT                                          := 0.0;
--
--       Percent_CPU          : FLOAT                                          := 0.0;
--
--       Current_Module       : NATURAL                                        := 0;
--
--    end record;
--    --% Defines a type to hold thread data.
--
--    type Thread_Data_Ptr_Type is access all Thread_Data_Type;
--
--    --
--    -- Link list node that comprises the list which contains the modules to process.
--    --
--    type Thread_List_Node_Type;
--
--    type Thread_List_Node_Ptr_Type is access all Thread_List_Node_Type;
--    -- Defines a pointer type to NODE_TYPE.
--
--    type Thread_List_Node_Type is record
--
--       Thread_Ptr : Thread_Ptr_Type := null;
--       -- Pointer to the thread task.
--
--       Id         : Natural := 0;
--       -- ID of the thread.
--
--       Prev : Thread_List_Node_Ptr_Type := null;
--       -- Pointer to the previous element of the linked list.
--
--       Next       : Thread_List_Node_Ptr_Type := null;
--       -- Pointer to next node in the linked list.
--
--       Task_OS_ID : Integer := 0;
--       -- Task ID for the RTOS.
--
--    end record;
--
--    type Controller_Class_List_Node_Type;
--
--    type Controller_Class_List_Node_Ptr_Type is access Controller_Class_List_Node_Type;
--
--    type Controller_Class_List_Node_Type is record
--
--       NAME          : STRING( 1 .. MAX_NAME_LENGTH ) := ( others => Ada.Characters.Latin_1.Nul );
--
--       MODULE_Handle : Subsystem_Scheduler.Handle := NULL;
--
--       NEXT          : Controller_Class_List_Node_Ptr_Type := NULL;
--
--    end record;
--
--    Controller_Class_List      : Controller_Class_List_Node_Ptr_Type := NULL;
--    -- List of registered controller classes.
--
--    Controller_Class_List_Last : Controller_Class_List_Node_Ptr_Type := NULL;
--    -- Pointer to last node of registered controller classes.
--
--    Controller_Class_List_Not_Initialized : BOOLEAN := true;
--    -- True when the controller class list is not initialized.
--
--    Current_Frame : NATURAL := 0;
--    --% Contains the current frame number.
--
--    Current_Snapshot_Module_Idx : Natural := 0;
--    -- For enumerating all of the snap shot requests for real-time modules.
--
--    Current_Timer_Cycle : NATURAL := 0;
--    --% Contains the current cycle number within the current frame.
--
--    Cycle_Length     : FLOAT := 1.0 / 240.0;
--    --% Defines the length of one cycle.
--
--    Cycles_Per_Frame : POSITIVE := 40;
--    --% Defines the number of cycles (ticks) per frame.
--
--    Frame_Length : FLOAT := 1.0;
--    --% Defines the length of one frame.
--
--    List_Of_Threads : Thread_List_Node_Ptr_Type := NULL;
--    -- Points to the head of a linked list of real-time thread tasks.
--
--    List_Of_Threads_Tail  : Thread_List_Node_Ptr_Type := null;
--    -- Used for marking the end of the linked lists.
--
--    Non_Real_Time_Module_Array : array ( NATURAL range 0 .. Max_Number_Of_Non_Real_Time_Modules - 1 ) of Non_Real_Time_Module_Data;
--    --% Table containing one RT_MODULE_ENTRY_TYPE record for each module
--    --% scheduled by the scheduler.
--
--    Number_of_Non_Real_Time_Modules : NATURAL := 0;
--    --% Contains the number of nonreal-time modules contained in the module
--    --% table.
--
--    Number_of_Real_Time_Modules : NATURAL := 0;
--    --% Contains the number of real-time modules contained in the module
--    --% table.
--
--    Number_Of_Sim_Threads : NATURAL := 0;
--    --% Contains the number of threads created by the application.
--
--    Real_Time_Module_Array : array ( NATURAL range 0..Max_Number_Of_Real_Time_Modules-1 ) of Real_Time_Module_Data;
--    --% Defines an array type to hold data about real-time modules.
--
--    Simulation_Is_Aborted : BOOLEAN := false;
--    -- True when the simulation is aborted.
--
--    Start_Simulation : Boolean := false;
--    -- True when the real-time sim has been commanded to start.
--
--    Thread_Associated_Module_List : array ( Thread_ID_Type ) of MODULE_NODE_PTR_TYPE      := (others => NULL);
--    -- Array of lists for each thread.  The list contains real-time modules to be called at a certain rate.
--
--    Thread_Associated_Module_List_TAIL : array ( Thread_ID_Type ) of MODULE_NODE_PTR_TYPE := (others => NULL);
--    -- End of the lists for each thread.
--
--    Thread_Data_Array : array (NATURAL range 0 .. Max_Number_Of_Threads - 1 ) of Thread_Data_Type;
--    --% Defines an array type to hold data about threads.
--
--    TOTAL_CYCLES : NATURAL := 0;
--    --% Contains the total number of cycles that have elapsed since the
--    --% simulation was started.
--
--    Total_Number_Of_Cycles : NATURAL := 0;
--    --% Contains the total number of cycles that have elapsed since the
--    --% simulation was started.
--
--    package Natural_IO is new Ada.Text_IO.Integer_IO( NATURAL );
--    -- For Reading the Simulation Config File.
--
--    package Positive_IO is new Ada.Text_IO.Integer_IO( POSITIVE );
--    -- For Reading the Simulation Config File.
--
--    package Int_IO is new Ada.Text_IO.Integer_IO( Integer );
--
--    procedure hostAdd(  Host_Name       : Interfaces.C.Char_Array;
--                     Host_IP_Address : Interfaces.C.Char_Array );
--    pragma import( c, hostAdd, "hostAdd" );
--
--
--    ----------------------------------------------------------------------------
--    -- Internal Prototyes.
--    ----------------------------------------------------------------------------
--    function Process_Non_Real_Time_Module_Entry( Param_String : in STRING ) return BOOLEAN;
--
--    function Process_Real_Time_Module_Entry( Param_String : in STRING ) return BOOLEAN;
--
--    function Process_Simclock_Entry( Param_String : in STRING ) return BOOLEAN;
--
--    function Process_Thread_Entry( Param_String : in STRING ) return BOOLEAN;
--
--    procedure Abort_Simulation( Abort_Id : in Abort_Id_type );
--
--    procedure Decode_Module_Line_Info( Parameter_String      : in     STRING;
--                                       Min_Number_Params     : in     INTEGER;
--                                       Line_Record_Info      : in out Line_Record_Type;
--                                       Not_Enough_Parameters : out    BOOLEAN );
--
--    procedure Read_Non_Real_Time_Module_Data( Module_Name         : in  STRING;
--                                              Module_Record_Ptr   : in  Non_Real_Time_Module_Data_Ptr_Type;
--                                              Module_Record_Found : out BOOLEAN );
--
--    procedure Read_Real_Time_Module_Data( Module_Name         : in  STRING;
--                                          Module_Record_Ptr   : in  Real_Time_Module_Data_Ptr_Type;
--                                          Module_Record_Found : out BOOLEAN );
--
--    procedure Read_Thread_Data( Thread_Name         : in  STRING;
--                                Thread_Record_Ptr   : in  Thread_Data_Ptr_Type;
--                                Thread_Record_Found : out BOOLEAN );
--
--    procedure Retrieve_Module_Handle( The_Name         : in     String;
--                                      Module_Handle    : out    Subsystem_Scheduler.Handle;
--                                      Handle_Not_Found : out    BOOLEAN );
--
--    procedure Set_Start_Simulation( pData : System.Address );
--
--    procedure Do_Non_Real_Time_Processing;
--
--    procedure Process_Timer_Event;
--
--    function Process_Config_Data return boolean is separate;
--
--    procedure Decode_Module_Line_Info( Parameter_String      : in     STRING;
--                                       Min_Number_Params     : in     INTEGER;
--                                       Line_Record_Info      : in out Line_Record_Type;
--                                       Not_Enough_Parameters : out    BOOLEAN ) is separate;
--
--
--    function Process_Non_Real_Time_Module_Entry( Param_String : in STRING ) return BOOLEAN is separate;
--
--    function Process_Real_Time_Module_Entry( Param_String : in STRING ) return BOOLEAN is separate;
--
--    function Process_Simclock_Entry( Param_String : in STRING ) return BOOLEAN is separate;
--
--    function Process_Thread_Entry( Param_String : in STRING ) return BOOLEAN is separate;
--
--    procedure Abort_Simulation( Abort_Id : in Abort_Id_Type ) is
--
--    begin
--
--       case Abort_Id is
--
--          when Task_Cant_Resume =>
--
--            Ada.Text_IO.Put_Line( "Can't Resume Task - Aborting" );
--
--          when Unsuccessful_Processing_Of_Config_Data =>
--
--            Ada.Text_IO.Put_Line( "Config Data or File Error - Aborting" );
--
--       end case;
--
--       Simulation_Is_Aborted := true;
--
--    exception
--       when others =>
--          Post_Error(Body_File_Name & ": Abort_Simulation");
--       raise;
--
--    end Abort_Simulation;
--
--
--    --
--    -- Called to do non real-time processing for the simulation.
--    --
--    procedure Do_Non_Real_Time_Processing  is
--
--    begin
--
--       for I in 0 .. Number_Of_Non_Real_Time_Modules - 1 loop
--
--          Subsystem_Scheduler.Initialize( An_Instance => Non_Real_Time_Module_Array( I ).Module_Handle.all );
--
--          Subsystem_Scheduler.Create_Streams( An_Instance => Real_Time_Module_Array( I ).Module_Handle.all,
--                                              Save_Size   => 0 );
--
--          Non_Real_Time_Module_Array(I).CYCLES_CALLED := Non_Real_Time_Module_Array(I).CYCLES_CALLED + 1;
--
--       end loop;
--
--    exception
--       when others =>
--          Post_Error(Body_File_Name & ": Do_Non_Real_Time_Processing");
--       raise;
--
--    end Do_Non_Real_Time_Processing;
--
--    --
--    -- Called when ever the simulation terminates.
--    --
--    procedure End_Simulation_Run is
--
--    begin
--
--       null;
--
--    exception
--       when others =>
--          Post_Error(Body_File_Name & ": End_Simulation_Run");
--       raise;
--
--    end End_Simulation_Run;
--
--    --
--    -- Process an event at the system clock interval.
--    --
--    procedure Process_Timer_Event is
--
--       Thread_List_Node_Ptr : Thread_List_Node_Ptr_Type := List_Of_Threads;
--
--       ID                   : Thread_ID_Type := 0;
--
--    begin
--
--       --
--       -- Keep track of the frames by counting the current cycle within the frame.
--       --
--       if ( Current_Timer_Cycle >= Cycles_Per_Frame - 1 ) then
--
--          Current_Timer_Cycle := 0;
--
--          Current_Frame := Current_Frame + 1;
--
--       else
--
--          Current_Timer_Cycle := Current_Timer_Cycle + 1;
--
--       end if;
--
--       --
--       -- Keep an accumulator for the total number of cycles that the sim has executed.
--       --
--       Total_Number_Of_Cycles := Total_Number_Of_Cycles + 1;
--
--       -- Check to see if its time to snapshot all the models yet. If so, they will all be
--       -- marked as in need of snapshot.
--       Record_Playback.Check_Model_Snapshot_Time;
--
--       Stethoscope_Bindings.ScopeCollectSignals( Scope_Index => 0 );
--       --
--       -- While there are threads to process
--       --
--       loop
--
--          exit when Thread_List_Node_Ptr = null;
--
--          --
--          -- Index into the Thread Data Array.
--          --
--          ID := Thread_List_Node_Ptr.ID;
--
--          --
--          -- If time to execute thread within the frame.
--          --
--          if ( ( Current_Timer_Cycle - Thread_Data_Array(ID).START_CYCLE ) rem Thread_Data_Array(ID).SCHEDULING_PERIOD ) = 0 then
--
--             --
--             -- Resume the thread task
--             --
--             select
--
--                Thread_List_Node_Ptr.Thread_Ptr.Update;
--
--                Thread_Data_Array( Thread_List_Node_Ptr.ID ).Cycle_Last_Started := Total_Number_Of_Cycles;
--
--              else
--
--                Thread_Data_Array( ID ).SCHEDULING_OVERRUNS := Thread_Data_Array( ID ).SCHEDULING_OVERRUNS + 1;
--
--                --if ( (TBL.TOTAL_CYCLES-TTBL(NODE_PTR.ID).CYCLE_LAST_STARTED) / TTBL(NODE_PTR.ID).SCHEDULING_PERIOD) >=
--                --TTBL(NODE_PTR.ID).MAX_OVERRUNS then
--                --abort NODE_PTR.Thread_Ptr.all;
--                --if NODE_PTR = THREAD_LIST then
--                --THREAD_LIST := THREAD_LIST.NEXT;
--                --else
--                --NODE_PTR.PREV.NEXT := NODE_PTR.NEXT;
--                --end if;
--             end select;
--
--
--          end if;
--
--          Thread_List_Node_Ptr := Thread_List_Node_Ptr.next;
--
--       end loop;
--
--
--       Thread_Data_Array(0).Iterations_Completed :=Thread_Data_Array(0).Iterations_Completed + 1;
--
--    exception
--       when others =>
--          Post_Error(Body_File_Name & ": Process_Event_Timer");
--       raise;
--
--    end Process_Timer_Event;
--
--    procedure Read_Non_Real_Time_Module_Data( Module_Name         : in  STRING;
--                                              Module_Record_Ptr   : in  Non_Real_Time_Module_Data_Ptr_Type;
--                                              Module_Record_Found : out BOOLEAN ) is
--
--       End_Marker      : constant STRING( 1 .. 1 ) := ( others => Ada.Characters.Latin_1.Nul );
--
--       End_Pos         : POSITIVE := 1;
--
--       Index_Of_Null   : integer := 0;
--
--
--    begin
--
--       Module_Record_Found := false;
--
--       if ( Number_of_Non_Real_Time_Modules = 0 ) then
--
--          return;
--
--       end if;
--
--       Index_Of_Null := Ada.Strings.Fixed.Index( Source  => Module_Name,
--                                                 Pattern => End_Marker );
--
--       if ( Index_Of_Null > 1 ) then
--
--          End_Pos := POSITIVE( Index_Of_Null - 1 );
--
--          for i in 0 .. ( Number_of_Non_Real_Time_Modules - 1 ) loop
--
--              if ( Module_Name( 1 .. End_Pos )
--                     = Ada.Strings.Fixed.Translate ( Non_Real_Time_Module_Array( i ).Name( 1 .. Non_Real_Time_Module_Array( i ).Name_Len ),
--                                                                 Ada.Strings.Maps.Constants.Lower_Case_Map ) ) then
--
--                Module_Record_Ptr.all := Non_Real_Time_Module_Array( i );
--
--                Module_Record_Found := true;
--
--                exit;
--
--             end if;
--
--          end loop;
--
--       end if;
--
--    end Read_Non_Real_Time_Module_Data;
--
--    procedure Read_Real_Time_Module_Data( Module_Name         : in  STRING;
--                                          Module_Record_Ptr   : in  Real_Time_Module_Data_Ptr_Type;
--                                          Module_Record_Found : out BOOLEAN ) is
--
--       End_Marker    : constant STRING( 1 .. 1 ) := ( others => Ada.Characters.Latin_1.Nul );
--
--       End_Pos       : POSITIVE := 1;
--
--       Index_Of_Null : integer := 0;
--
--
--    begin
--
--       Module_Record_Found := false;
--
--       if ( Number_of_Real_Time_Modules = 0 ) then
--
--          return;
--
--       end if;
--
--       Index_Of_Null := Ada.Strings.Fixed.Index( Source  => Module_Name,
--                                                 Pattern => End_Marker );
--
--       if ( Index_Of_Null > 1 ) then
--
--          End_Pos := POSITIVE( Index_Of_Null - 1 );
--
--          for i in 0 .. ( Number_of_Real_Time_Modules - 1 ) loop
--
--
--              if ( Module_Name( 1 .. End_Pos )
--                     = Ada.Strings.Fixed.Translate ( Real_Time_Module_Array( i ).Name( 1 .. Real_Time_Module_Array( i ).Name_Len ),
--                                                                 Ada.Strings.Maps.Constants.Lower_Case_Map ) ) then
--
--                Module_Record_Ptr.all := Real_Time_Module_Array( i );
--
--                Module_Record_Found   := true;
--
--                exit;
--
--             end if;
--
--          end loop;
--
--       end if;
--
--    end Read_Real_Time_Module_Data;
--
--    procedure Read_Thread_Data( Thread_Name         : in  STRING;
--                                Thread_Record_Ptr   : in  Thread_Data_Ptr_Type;
--                                Thread_Record_Found : out BOOLEAN ) is
--
--       End_Marker      : constant STRING( 1 .. 1 ) := ( others => Ada.Characters.Latin_1.Nul );
--
--       End_Pos         : POSITIVE := 1;
--
--       Index_Of_Null   : integer := 0;
--
--
--    begin
--
--       Thread_Record_Found := false;
--
--       if ( Number_of_Sim_Threads = 0 ) then
--
--          return;
--
--       end if;
--
--       Index_Of_Null := Ada.Strings.Fixed.Index( Source  => Thread_Name,
--                                                 Pattern => End_Marker );
--
--       if ( Index_Of_Null > 1 ) then
--
--          End_Pos := POSITIVE( Index_Of_Null - 1 );
--
--          for i in 0 .. ( Number_of_Sim_Threads - 1 ) loop
--
--              if ( Thread_Name( 1 .. End_Pos )
--                     = Ada.Strings.Fixed.Translate ( Thread_Data_Array( i ).Name( 1 .. Thread_Data_Array( i ).Name_Len ),
--                                                     Ada.Strings.Maps.Constants.Lower_Case_Map ) ) then
--
--                Thread_Record_Ptr.all := Thread_Data_Array( i );
--
--                Thread_Record_Found := true;
--
--                exit;
--
--             end if;
--
--          end loop;
--
--       end if;
--
--    end Read_Thread_Data;
--
--    --
--    -- Retrieve handle corresponding to the input name.
--    --
--    procedure Retrieve_Module_Handle( The_Name         : in     String;
--                                      Module_Handle    : out    Subsystem_Scheduler.Handle;
--                                      Handle_Not_Found : out    BOOLEAN ) is
--
--       End_Pos       : POSITIVE := 1;
--
--       Index_Of_Null : NATURAL := 0;
--
--       NODE          : Controller_Class_List_Node_Ptr_Type := Controller_Class_List;
--       --% Points to the current entry on the linked list.
--
--       TEMP_NODE     : Controller_Class_List_Node_Type := ( NAME          => ( others => Ada.Characters.Latin_1.Nul ),
--                                                            Module_Handle => NULL,
--                                                            NEXT          => NULL );
--
--       End_Marker    : constant STRING( 1 .. 1 ) := ( others => Ada.Characters.Latin_1.Nul );
--
--    begin
--
--       Handle_Not_Found := true;
--
--       while ( NODE /= NULL ) loop
--
--          TEMP_NODE := NODE.ALL;
--
--          Index_Of_Null := Ada.Strings.Fixed.Index( Source  => The_Name,
--                                                    Pattern => End_Marker );
--
--          if ( Index_Of_Null > 0 ) then
--
--             End_Pos := POSITIVE( Index_Of_Null );
--
--             if TEMP_NODE.NAME( 1 .. End_Pos ) = Ada.Strings.Fixed.Translate( The_Name( 1 .. End_Pos ),
--                                                                                    Ada.Strings.Maps.Constants.Lower_Case_Map) then
--
--                Module_Handle := Temp_NODE.Module_Handle;
--
--                Handle_Not_Found := false;
--
--                exit;
--
--             end if;
--
--          end if;
--
--          NODE := NODE.NEXT;
--
--       end loop;
--
--    exception
--       when others =>
--          Post_Error(Body_File_Name & ": Retrieve_Module_Handle");
--       raise;
--
--    end Retrieve_Module_Handle;
--
--
--    procedure Set_Start_Simulation( pData : System.Address ) is
--
--    begin
--
--       Start_Simulation := JPATS_IOS_Interface.Convert_To_Bool( pData => pData );
--
--    end Set_Start_Simulation;
--
    function Begin_Enumerating_Real_Time_Module_Snapshot_Request_Data return Boolean is

--       More_Data_To_Enumerate : Boolean := TRUE;

    begin

--       Current_Snapshot_Module_Idx := Real_Time_Module_Array'first;

--       if ( Number_Of_Real_Time_Modules = 0 ) then

--          More_Data_To_Enumerate := false;

--       end if;

--       return More_Data_To_Enumerate;

        return False;
    end Begin_Enumerating_Real_Time_Module_Snapshot_Request_Data;

    --
    -- Method to determine if the simulation has been aborted.  Returns true when the simulation
    -- has been aborted.
    --
    function Is_Simulation_Aborted return BOOLEAN is

    begin
     return True;
--       return Simulation_Is_Aborted;

    end Is_Simulation_Aborted;

    function Is_Simulation_Started return boolean is

--       Simulation_Is_Started : boolean;

    begin

--       Simulation_Is_Started := Start_Simulation;
--       return Start_Simulation;
      return False;
    end Is_Simulation_Started;

    function Set_Real_Time_Module_Snapshot_Request return Boolean is

--       More_Data_To_Enumerate : Boolean := TRUE;

    begin

--       Real_Time_Module_Array( Current_Snapshot_Module_Idx ).Snap_Requested := True;
--
--       if ( Current_Snapshot_Module_Idx = ( Number_Of_Real_Time_Modules - 1 ) ) then
--
--          More_Data_To_Enumerate := false;
--
--       else
--
--          Current_Snapshot_Module_Idx := Current_Snapshot_Module_Idx + 1;
--
--       end if;
--
--       return More_Data_To_Enumerate;
         return False;
    end Set_Real_Time_Module_Snapshot_Request;
--
    procedure Connect_To_IOS is

    begin

--       hostAdd( Host_Name       => Interfaces.C.To_C( "jpats-tgt2" ),
--                Host_IP_Address => Interfaces.C.To_C( "10.43.1.4" ) );

--
--       JPATS_IOS_Interface.Register_JPATS_IOS_Variable( Annotation_String     => "Start_Simulation",
--                                                        Units_String          => "",
--                                                        Variable_Address      => Start_Simulation'address,
--                                                        Set_Variable_Proc_Ptr => Set_Start_Simulation'access,
--                                                        Type_Of_IOS_Variable  => JPATS_IOS_Interface.BOOL_TYPE ,
--                                                        Minimum_Value_of_Var  => -100.0,
--                                                        Maximum_Value_of_Var  => 100.0 );
--
    null;
    end Connect_To_IOS;

    --
    -- Called to post an error message to the console.
    --
    procedure Post_Error( Mesg : in STRING ) is

    begin

--       Ada.Text_IO.Put_Line( "Error: " & Mesg );
       null;
    end Post_Error;
--
--
--    --
--    -- Called to post message to the console.
--    --
    procedure Post_Mesg( Mesg : in STRING ) is

    begin

--       Ada.Text_IO.Put_Line( "Info: " & Mesg );
      null;
    end Post_Mesg;

    --
    -- Called to post a warning message to the console.
    --
    procedure Post_Warning( MESG    : in STRING ) is

    begin

--      Ada.Text_IO.Put_Line( "Warning: " & Mesg );
      null;
    end Post_Warning;

    --
    -- Process an event at the system clock interval.
    --
    --
    -- Method to determine to register controller class with the simulation.
    --
  procedure Register ( The_Handle : in Subsystem_Scheduler.Handle ) is

  --       End_Marker        : constant STRING := ".instance";

--         End_Pos           : POSITIVE := 1;

  --       Index_Of_Instance : integer := 0;

    --     Name_String       : STRING( 1 .. MAX_NAME_LENGTH ) := ( others => Ada.Characters.Latin_1.Nul );

--         Tag_String        : STRING( 1 .. MAX_NAME_LENGTH ) := ( others => Ada.Characters.Latin_1.Nul );

   begin

--         Ada.Strings.Fixed.Move( Source  => Ada.Tags.External_Tag( The_Handle'Tag ),
--                                 Target  => Tag_String,
--                                 Drop    => Ada.Strings.Right,
--                                 Justify => Ada.Strings.Left,
--                                 Pad     => Ada.Characters.Latin_1.Nul );
--
--         Index_Of_Instance := Ada.Strings.Fixed.Index( Source  => Tag_String,
--                                                  Pattern => End_Marker );
--
--         if ( Index_Of_Instance > 1 ) then
--
--            End_Pos := POSITIVE( Index_Of_Instance - 1 );
--
--            Ada.Strings.Fixed.Move( Source  => Tag_String( 1 .. End_Pos ),
--                                    Target  => Name_String,
--                                    Drop    => Ada.Strings.Right,
--                                    Justify => Ada.Strings.Left,
--                                    Pad     => Ada.Characters.Latin_1.Nul );
--
--            Ada.Text_IO.Put_Line( Name_String );
--
--            if ( Controller_Class_List_Not_Initialized ) then
--
--               Controller_Class_List      := new Controller_Class_List_Node_Type;
--
--               Controller_Class_List.Name := Name_String;
--
--               Controller_Class_List.Module_Handle := The_Handle;
--
--               Controller_Class_List.Next := null;
--
--               Controller_Class_List_Not_InitializeD := false;
--
--               Controller_Class_List_Last := Controller_Class_List;
--
--            else
--
--               Controller_Class_List_Last.Next := New Controller_Class_List_Node_Type;
--
--               Controller_Class_List_Last := Controller_Class_List_Last.Next;
--
--               Controller_Class_List_Last.Name := Name_String;
--
--               Controller_Class_List_Last.Module_Handle := The_Handle;
--
--               Controller_Class_List_Last.Next := null;
--
--            end if;
--
--        end if;
     null;
   exception
         when others =>
            Post_Error(Body_File_Name & ": Register");
         raise;

   end Register;


    procedure Retrieve_Scheduler_Handle( The_Name          : in  String;
                                         Handle            : out Subsystem_Scheduler.Handle;
                                         Handle_Found      : out Boolean ) is

 --      Handle_Not_Found : boolean;
       -- True when the handle was not found.

    begin

--       Retrieve_Module_Handle( The_Name         => The_Name,
--                               Module_Handle    => Handle,
--                               Handle_Not_Found => Handle_Not_Found );
--
--       Handle_Found := not( Handle_Not_Found );
      null;

    end Retrieve_Scheduler_Handle;

     procedure Retrieve_Scheduler_Name
      ( Handle     : in     Subsystem_Scheduler.Handle;
        The_Name   :    out Ada.Strings.Unbounded.Unbounded_String;
        Name_Found :    out Boolean ) is


--       use type Subsystem_Scheduler.Handle;
--
--       NODE          : Controller_Class_List_Node_Ptr_Type := Controller_Class_List;
--       --% Points to the current entry on the linked list.
--
--       TEMP_NODE     : Controller_Class_List_Node_Type := ( NAME          => ( others => Ada.Characters.Latin_1.Nul ),
--                                                            Module_Handle => NULL,
--                                                            NEXT          => NULL );
--
--       Handles_Are_Equal : boolean := false;
--
    begin

--       Name_Found := false;
--
--       while ( NODE /= NULL ) loop
--
--          TEMP_NODE := NODE.ALL;
--
--          Handles_Are_Equal := Temp_Node.Module_Handle = Handle;
--
--          if ( Handles_Are_Equal ) then
--
--             The_Name := Ada.Strings.Unbounded.To_Unbounded_String( TEMP_NODE.NAME );
--
--             Name_Found := true;
--
--             exit;
--
--          end if;
--
--          NODE := NODE.NEXT;
--
--       end loop;
--
--    exception
--       when others =>
--          Post_Error(Body_File_Name & ": Retrieve_Module_Handle");
--       raise;
      null;
    end Retrieve_Scheduler_Name;

    --
    -- Called to run the simulation.
    --
    procedure RUN_SIMULATION  is

--       Successful_Processing_Of_Config_Data : BOOLEAN := false;
       -- True when the configuration data has all been processed successfully.

--       Temp_Name_Unbounded : Ada.Strings.Unbounded.Unbounded_String;

    begin

--       Successful_Processing_Of_Config_Data := Process_Config_Data;

--       if ( Successful_Processing_Of_Config_Data ) then
--
--          Do_Non_Real_Time_Processing;
--
--          OS_Interface.Start_Simclock;
--
--       else
--
--          Abort_Simulation( Abort_Id => Unsuccessful_Processing_Of_Config_Data );
--
--       end if;
--
--    exception
--       when others =>
--          Post_Error(Body_File_Name & ": RUN_SIMULATION");
--       raise;
      null;
    end RUN_SIMULATION;
--
--   --
--    -- Thread task type body.  The most common usage is for periodic activation of real time processing e.g. there
--    -- usually are 60 HZ, 30 HZ, 15 HZ, etc. tasks.  There will be a thread type allocated for each task.
--    --
--    task body Thread_Type is
--
--       Task_ID : Thread_ID_Type := 0;
--       --% Thread ID of this thread.
--
--       I : Real_Time_Module_ID_type := 0;
--       --% Holds an index into the module table.
--
--       DT : FLOAT := 0.0;
--       --% Delta time to be passed to the modules.  Durring normal operation,
--       --% the value of DT will be the same as the value of DELTA_TIME stored
--       --% in the thread table.  However, after an overrun has occured, the
--       --% value of DT will be adjusted to compensate for the overrun.  This
--       --% allows all of the modules to see a consistent view of time even
--       --% though an overrun has occurred.
--
--       Scheduling_Overruns_Number : NATURAL := 0;
--       --% Temporary that holds the number of scheduling overruns that have occured
--       --% since the simulation was started.
--
--       LAST_SCHED_OVERRUNS : NATURAL := 0;
--       --% Holds the number of scheduling overruns that had occurred as of
--       --% the previous execution of the task.
--
--       SCHED_OVERRUN_COUNT : NATURAL := 0;
--       --% Holds the difference in Scheduling_Overruns_Number and LAST_SCHED_OVERRUNS.
--
--       LAST_EXECUTION_OVERRUNS : NATURAL := 0;
--       --% Holds the number of execution overruns that had occurred as of the
--       --% last iteration of the task.
--
--       UNCORRECTED_OVERRUNS : NATURAL := 0;
--       --% Contains the total number of overruns that have not been "corrected"
--       --% with regards to time.
--
--       MODULE_NODE : MODULE_NODE_PTR_TYPE := NULL;
--       --% Used to iterate through the module list for this thread.
--
--    begin
--
--       accept Initialize( ID         : in  Thread_ID_Type;
--                          PRIORITY   : in  INTEGER;
--                          CPU        : in  INTEGER ) do
--
--          Task_ID    := ID;
--
--          --Ada.Dynamic_Priorities.Set_Priority( System.Any_Priority( Priority ) );
--
--       end Initialize;
--
--       loop
--
--          select
--
--             accept UPDATE;
--
--                Scheduling_Overruns_Number := Thread_Data_Array( TASK_ID ).SCHEDULING_OVERRUNS;
--
--                SCHED_OVERRUN_COUNT        := Scheduling_Overruns_Number - LAST_SCHED_OVERRUNS;
--
--                UNCORRECTED_OVERRUNS       := UNCORRECTED_OVERRUNS + SCHED_OVERRUN_COUNT;
--
--                LAST_SCHED_OVERRUNS        := Scheduling_Overruns_Number;
--
--                LAST_EXECUTION_OVERRUNS := Thread_Data_Array( TASK_ID ).EXECUTION_OVERRUNS;
--
--             ----------------------------------------------------------------------------
--             -- Now set the value of DT to be passed to the modules.  If there are
--             -- no scheduling overruns that we need to "correct" then we just set
--             -- DT to be the same as the value of DELTA_TIME stored in the thread table
--             -- for this thread.  However, if there are scheduling overruns to be
--             -- corrected, then we set DT to be twice the value of DELTA_TIME and we
--             -- decrement the uncorrected overrun count.  Doing this has the effect
--             -- of slowly correcting the modules view of time after an overrun has
--             -- occured.
--             ----------------------------------------------------------------------------
--
--                if ( UNCORRECTED_OVERRUNS > 0 ) then
--
--                   DT                   := Thread_Data_Array( TASK_ID ).DELTA_TIME * 2.0;
--
--                   UNCORRECTED_OVERRUNS := UNCORRECTED_OVERRUNS - 1;
--
--                else
--
--                   DT := Thread_Data_Array( TASK_ID ).DELTA_TIME;
--
--                end if;
--
--             ----------------------------------------------------------------------------
--             -- Now cycle through the modules in the module list and call any that should
--             -- be called.
--             ----------------------------------------------------------------------------
--
--             MODULE_NODE := Thread_Associated_Module_List( TASK_ID );
--
--             loop
--
--                exit when MODULE_NODE = NULL;
--
--                I := MODULE_NODE.MODULE_ID;
--
--                Thread_Data_Array( TASK_ID ).CURRENT_MODULE := I;
--
--                if ( Real_Time_Module_Array( I ).Active ) then
--
--                   Record_Playback.Record_Playback_Processing( Snap_Is_Requested => Real_Time_Module_Array( i ).Snap_Requested,
--                                                               Module_Handle     => Real_Time_Module_Array( i ).Module_Handle );
--
--                   Subsystem_Scheduler.Update( An_Instance          => Real_Time_Module_Array( I ).Module_Handle.all,
--                                               Integration_Constant => DT );
--
--                   Real_Time_Module_Array( I ).CYCLES_CALLED := Real_Time_Module_Array( I ).CYCLES_CALLED + 1;
--
--
--                end if;
--
--                MODULE_NODE := MODULE_NODE.NEXT;
--
--             end loop;
--
--             Thread_Data_Array( Task_ID ).ITERATIONS_COMPLETED  := Thread_Data_Array( Task_ID ).ITERATIONS_COMPLETED + 1;
--
--             Thread_Data_Array( Task_ID ).CYCLE_LAST_FINISHED   := TOTAL_CYCLES;
--
--             or accept CANCEL;
--
--                exit;
--
--             or terminate;
--
--          end select;
--
--       end loop;
--
--    exception
--       when others =>
--          Post_Error(Body_File_Name & ": Thread_Type" & Integer'Image(Task_Id));
--          Post_Error( "Module_Name is " & Real_Time_Module_Array( I ).Name( 1 .. Real_Time_Module_Array( I ).Name_Len ) );
--       raise;
--
--    end Thread_Type;
--
--    --
--    --  Task spec for main execution
--    --
--    task Main_Execution_Thread is
--
--       entry Run_The_Simulation;
--
--       entry Abort_The_Simulation;
--
--       entry Suspend_The_Simulation;
--
--    end Main_Execution_Thread;
--
--    task body Main_Execution_Thread is
--
--    begin
--
--       accept Run_The_Simulation do
--
--          Run_Simulation;
--
--       end Run_The_Simulation;
--
--       loop
--
--          select
--
--             accept Suspend_The_Simulation;
--
--                POST_MESG( "Stopping simulation.");
--
--                exit;
--
--             or accept Abort_The_Simulation;
--
-- --               raise Abort_Simulation;
--
--                exit;
--
--             or terminate;
--
--          end select;
--
--       end loop;
--
--       End_Simulation_Run;
--
--    exception
--
--       when others =>
--          Post_Error(Body_File_Name & ": Main_Execution_Thread");
--          Post_Error("Aborting simulation");
--          End_Simulation_Run;
--       raise;
--
--    end Main_Execution_Thread;
   -------------------------------------------------------------------------------
   -- Request a snapshot for all real-time modules. This should cause
   -- Record_Playback.Snapshot to be called for each module before its next
   -- update.
   -------------------------------------------------------------------------------
   procedure Set_Real_Time_Module_Snapshot_Requests is
   begin

      -- Set all the Snap_Requested flags on all active real-time modules
--      for Module_Index in Real_Time_Module_Array'First .. Real_Time_Module_Array'First +
--        Number_Of_Real_Time_Modules - 1
--      loop
--         Real_Time_Module_Array (Module_Index).Snap_Requested := True;
--      end loop;
     null;
   end Set_Real_Time_Module_Snapshot_Requests;

end Scheduler_Collection;
