-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer: Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Ada.Text_Io;
with Class_Test_Result_File;
with Propeller_Interface_Unit;

with Angle_Types;
with Jpats_Propeller_Types;
with Vector_Types;
use  Vector_Types;
with Force_Types;
with Electrical_Units_Types;

procedure Propeller_Interface_Unit_Ctd is


begin

  Ada.Text_Io.Put_Line ("Propeller_Interface_Unit_Ctd.exe is executing.");

Test_1:
    -------------------------------------------
    -- Test Case 1
    -- Test the Initialize function
    -- Inputs           : A Valid Propeller_Interface_Unit  Class
    -- Expected Results : A query of all accessor functions should
    --                    show that all of the initialized instance
    --                    variables are set to the correct values
    --                    thus, testing the initialize and accessor
    --                    functions.
    -- Purpose          : Test the initialize and accessor functions.
    -- Interface Tested : Propeller_Interface_Unit.Initialize
    --                    Propeller_Interface_Unit.Prop_Rpm_Cmd
    --                    Propeller_Interface_Unit.Delta_Blade_Angle
    --
    declare
      Test_Number                          : Integer := 1;
      Test_Result                          : Boolean;
      Test_Init                            : Boolean;
      The_PIU                              : Propeller_Interface_Unit.Instance;
      Test_Angle_1                         : Angle_Types.Degrees;
    begin

      -- Test the initialize function

      Propeller_Interface_Unit.Initialize
        (An_Instance => The_PIU);

      -- Use the accessor function to check the initialize function and the accessor functions


      -- Access Delta_Blade_Angle
      Test_Number := 1;
      Test_Angle_1 := Propeller_Interface_Unit.Delta_Blade_Angle
        (An_Instance => The_PIU);
      Test_Result := Test_Angle_1 = Angle_Types.Degrees(0.0);
      Test_Init := Test_Result;
      Class_Test_Result_File.Report_Case_Status (Success => Test_Init, Number => Test_Number);

    end Test_1;

Test_2:
    -------------------------------------------
    -- Test Case 2
    -- Test the Set and Accessor functions
    -- Inputs           : A Valid Propeller_Interface_Unit  Class
    -- Expected Results : A set and query of all accessor functions should
    --                    show that all of the initialized instance
    --                    variables are set to the correct values.
    -- Purpose          : Test the set and accessor functions.
    -- Interface Tested : Propeller_Interface_Unit.Initialize
    --                    Propeller_Interface_Unit.Set_Prop_Rpm_Cmd
    --                    Propeller_Interface_Unit.Set_Delta_Blade_Angle
    --                    Propeller_Interface_Unit.Prop_Rpm_Cmd
    --                    Propeller_Interface_Unit.Delta_Blade_Angle
    --
    declare
      Test_Number                          : Integer := 2;
      Test_Result                          : Boolean;
      Test_Init                            : Boolean;
      The_PIU                              : Propeller_Interface_Unit.Instance;
      Test_Angle_1                         : Angle_Types.Degrees;
      Test_Angle_2                         : Angle_Types.Degrees;
    begin
      -- Test the public set functions.
      -- Set_Delta_Blade_Angle
      Test_Number := 4;
      Test_Angle_1 := Angle_Types.Rpm(42.34);
      Propeller_Interface_Unit.Set_Delta_Blade_Angle
        (An_Instance       => The_PIU,
         Delta_Blade_Angle => Test_Angle_1);
      Test_Angle_2 := Propeller_Interface_Unit.Delta_Blade_Angle
        (An_Instance => The_PIU);
      Test_Result :=  Test_Angle_2 = Angle_Types.Rpm(42.34);
      Test_Init := Test_Result;
      Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
    end Test_2;

Test_3:
    -------------------------------------------
    -- Test Case 3
    -- Test the Set and Accessor functions
    -- Inputs           : A Valid Propeller_Interface_Unit Class
    -- Expected Results : This test places the Piu under the
    --                    conditions of a demanded blade rpm
    --                    of 1900 rpm and 0.025 rpm_per_sec
    --                    with a supplied engine oil pressure
    --                    of 15 psig.  With an initial delta_blade_angle
    --                    of 25.0 degrees, the delta_blade_angle
    --                    should decrease to bring the propeller
    --                    speed up to the required 2000.0 rpm.
    --                    show that all of the initialized instance
    --                    variables are set to the correct values.
    -- Purpose          : Test the update procedure.
    -- Interface Tested : Propeller_Interface_Unit.Initialize
    --                    Propeller_Interface_Unit.Set_Prop_Rpm_Cmd
    --                    Propeller_Interface_Unit.Set_Delta_Blade_Angle
    --                    Propeller_Interface_Unit.Prop_Rpm_Cmd
    --                    Propeller_Interface_Unit.Delta_Blade_Angle
    --                    Propeller_Interface_Unit.Update
    --
      declare
        Test_Number                          : Integer := 3;
        Test_Result                          : Boolean;
        Next_PIU                             : Propeller_Interface_Unit.Instance;
        This_PIU                             : Propeller_Interface_Unit.Instance;
        Test_Angle_1                         : Angle_Types.Degrees;
        Test_Angle_2                         : Angle_Types.Degrees;
        Test_Prop_Rpm                        : Jpats_Propeller_Types.Propeller_Angular_Rate_Vector_Type.Instance;
        Iconst                               : Float;
      begin
        Iconst := 1.0/15.0;
        Test_Angle_1 := Angle_Types.Rpm(25.0);
        Propeller_Interface_Unit.Set_Delta_Blade_Angle
          (An_Instance       => Next_PIU,
           Delta_Blade_Angle => Test_Angle_1);
        Propeller_Interface_Unit.Set_Delta_Blade_Angle
          (An_Instance       => This_PIU,
           Delta_Blade_Angle => Test_Angle_1);

        Test_Prop_Rpm := (1900.0,0.0,0.0);

        Propeller_Interface_Unit.Update
          (Next_Instance                     => Next_PIU,
           This_Instance                     => This_PIU,
           Iconst                            => Iconst,
           Overspeed_Governor_Reset_Solenoid => False,
           Propeller_Feather_Solenoid        => False,
           PMU_Blade_Angle_Rate              => Angle_Types.Degrees_Per_Sec(0.0),
           Prop_Rpm                          => Test_Prop_Rpm,
           Engine_Oil_Pressure               => Force_Types.Psi(15.0),
           Malf_Np_Lo                        => False,
           Feather_Malfunction               => False);

        Test_Angle_2 := Propeller_Interface_Unit.Delta_Blade_Angle
          (An_Instance => Next_PIU);
        Test_Result :=  ((Test_Angle_2 - Angle_Types.Degrees_Per_Sec(-67.0))/(-67.0) < 0.0001);
        Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);

      end Test_3;

      Ada.Text_Io.Put_Line ("Propeller_Interface_Unit_Ctd.exe is finished.");

end Propeller_Interface_Unit_Ctd;







