-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0

with Jpats_Powerplant.Container;
with Jpats_Powerplant.Controller;
with Jpats_Powerplant.Io_Interface;
with Power_Management_Unit;
with Pratt_Whitney_Pt6a_68_Gas_Generator;
with Fuel_Metering_Unit;

package body JPATS_Powerplant is

   Null_Message : Arinc_429_Types.Message_Type;
-- Outside of Powerplant_Cat, Propeller_Cat, and Engine_Data_Manager_Cat

  -- Access Power_Control_Lever_Angle
  function Power_Control_Lever_Angle return Angle_Types.Degrees is
  begin
    return Jpats_Powerplant.Io_Interface.This_Io_Interface.Pcl_Position;
  end Power_Control_Lever_Angle;

  -- Accessor PMU_Status_Annunciator_Request
  function PMU_Status_Annunciator_Request return Boolean is
  begin
    return Power_Management_Unit.Pmu_Status
      (An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Power_Management_Unit);
  end PMU_Status_Annunciator_Request;

  -- Accessor IGN_Select_Annunciator_Request
  function IGN_Select_Annunciator_Request return Boolean is
  begin
    return Jpats_Powerplant.Controller.Ignition_Select;
  end IGN_Select_Annunciator_Request;

  -- Accessor Start_Ready_Annunciator_Request
  function Start_Ready_Annunciator_Request return Boolean is
  begin
    return Power_Management_Unit.Pla_At_20_Degrees
      (An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Power_Management_Unit);
  end Start_Ready_Annunciator_Request;

  -- Accessor Ignition_Exciter_Load
  function Ignition_Exciter_Load return Electrical_Units_Types.Amps is
  begin
    return Pratt_Whitney_Pt6a_68_Gas_generator.Ignition_Exciter_Load
      ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Gas_Generator);
  end Ignition_Exciter_Load;

  -- Accessor Auto_Ignition_Relay_Load
  function Auto_Ignition_Relay_Load return Electrical_Units_Types.Amps is
  begin
    return Jpats_Powerplant.Container.Auto_Return_Relay.Load
      ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Auto_Ignition_Relay);
  end Auto_Ignition_Relay_Load;

  -- Access Engine_Oil_Pressure
  function Engine_Oil_Pressure return Force_Types.Psi is
  begin
    return Pratt_Whitney_Pt6a_68_Gas_Generator.Engine_Oil_Pressure
      ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Gas_Generator);
  end Engine_Oil_Pressure;

  -- Access Engine_Oil_Temperature
  function Engine_Oil_Temperature return Temperature_Types.Celsius is
  begin
    return Pratt_Whitney_Pt6a_68_Gas_Generator.Engine_Oil_Temperature
      ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Gas_Generator);
  end Engine_Oil_Temperature;

  -- Oil_Pressure_Annunciator_Request is moved to the Engine_Data_Manager_Category

  -- Accessor PMU_Fail_Relay_Load
  function PMU_Fail_Relay_Load return Electrical_Units_Types.Amps is
  begin
    return Jpats_Powerplant.Container.Auto_Return_Relay.Load
      ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_PMU_Fail_Relay);
  end PMU_Fail_Relay_Load;

  -- Accessor Chip_Annunciator_Request
  function Chip_Annunciator_Request return Boolean is
  begin
    return Pratt_Whitney_Pt6a_68_Gas_Generator.Chip_Sensor
      ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Gas_Generator);
  end Chip_Annunciator_Request;

  -- Accessor PMU_Load
  function PMU_Load return Electrical_Units_Types.Amps is
  begin
    return Power_Management_Unit.Pmu_Electrical_Load
      (An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Power_Management_Unit);
  end PMU_Load;

  -- Method Bleed_Temperature
  function Bleed_Temperature return Temperature_Types.Kelvin is
  begin
    return (Pratt_Whitney_Pt6a_68_Gas_Generator.Bleed_Temperature
      ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Gas_Generator) + 273.15);
  end Bleed_Temperature;

  -- Method Bleed_Pressure
  function Bleed_Pressure return Force_Types.Psi is
  begin
    return Pratt_Whitney_Pt6a_68_Gas_Generator.Bleed_Pressure
      ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Gas_Generator);
  end Bleed_Pressure;

  -- Access Reduction_Gear_Box_RPM
  function Reduction_Gear_Box_RPM
    return Jpats_Propeller_Types.Propeller_Angular_Rate_Vector_Type.Instance
  is
  begin
    return (Pratt_Whitney_Pt6a_68_Gas_Generator.Power_Turbine_Rpm
      ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Gas_Generator), Angle_Types.Rpm(0.0),Angle_Types.Rpm(0.0));
  end Reduction_Gear_Box_RPM;

  -- Access Overspeed_Governor_Reset_Solenoid
  function Overspeed_Governor_Reset_Solenoid return Boolean is
  begin
--    return Power_Management_Unit.
--      (An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Power_Management_Unit);
    return false;
  end Overspeed_Governor_Reset_Solenoid;

  -- Access Propeller_Feather_Signal
  function Manual_Feather_Signal
    return Boolean is
  begin
    return False;
  end Manual_Feather_Signal;

   -- Access PMU_Blade_Angle_Rate
  function PMU_Blade_Angle_Rate
    return Angle_Types.Degrees_Per_Sec is
  begin
    return Power_Management_Unit.PMU_Blade_Angle_Rate
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
  end PMU_Blade_Angle_Rate;


  -- Access Start_Relay
  function Start_Relay return Boolean is
  begin
    return Container.Auto_Return_Relay.Is_Energized
      ( An_Instance => Container.This_Subsystem.The_Start_Relay);
  end Start_Relay;

  -- Access Starter_On_Relay
  function Starter_On_Relay return Boolean is
  begin
    return Container.Auto_Return_Relay.Is_Energized
      ( An_Instance => Container.This_Subsystem.The_Starter_On_Relay);
  end Starter_On_Relay;

  -- Access PMU_Fail_Annunciator_Request
  function Pmu_Fail_Annunciator_Request return Boolean is
  begin
    return Container.Auto_Return_Relay.Is_Energized
     ( An_Instance => Container.This_Subsystem.The_Pmu_Fail_Relay);
  end Pmu_Fail_Annunciator_Request;

  -- Access Generator_Shaft_Rpm
  function Generator_Shaft_Rpm return Angle_Types.Rpm is
  begin
    return Pratt_Whitney_Pt6a_68_Gas_Generator.Generator_Shaft_Rpm
      ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Gas_Generator);
  end Generator_Shaft_Rpm;

  function Internal_Turbine_Temperature
    return Temperature_Types.Celsius is
  begin
    return Pratt_Whitney_Pt6a_68_Gas_Generator.Internal_Turbine_Temperature_Sensor
      (An_Instance => Container.This_Subsystem.The_Gas_Generator);
  end Internal_Turbine_Temperature;

  -- Accessor Intermediate_Fuel_Pump_Pressure
  function Intermediate_Fuel_Pump_Pressure return Force_Types.Psi is
  begin
    return Jpats_Powerplant.Container.Intermediate_Pressure_Pump.Outlet_Pressure
      (An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Intermediate_Pressure_Pump);
  end Intermediate_Fuel_Pump_Pressure;

  -- Accessor Fuel_Flow
  function Fuel_Flow return Mass_Types.Pph is
  begin
    return Fuel_Metering_Unit.Fuel_Flow_Rate
      (An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Fuel_Metering_Unit);
  end Fuel_Flow;

  -- Method Engine_Torque_Pct
  function Engine_Torque_Pct return Normalized_Types.Normalize is
  begin
    return Pratt_Whitney_Pt6a_68_Gas_Generator.Torque_Sensor
      (An_Instance => Container.This_Subsystem.The_Gas_Generator);
  end Engine_Torque_Pct;

  -- Accessor Gas_Generator_Speed in Percent;  -- Ng
  function Gas_Generator_Speed_Pct return Normalized_Types.Normalize is
  begin
    return 0.0;
  end Gas_Generator_Speed_Pct;

  -- Accessor Gas_Generator_Speed_Sensor in Rpm;
  function Gas_Generator_Speed_Sensor return Angle_Types.Rpm is
  begin
    return Pratt_Whitney_Pt6a_68_Gas_Generator.Gas_Generator_Rpm_Sensor
      (An_Instance => Container.This_Subsystem.The_Gas_Generator);
  end Gas_Generator_Speed_Sensor;

  -- Access A429_TX_PMU_A_336_Torque
   function  A429_TX_PMU_A_336_Torque
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_A_336_Torque
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_A_336_Torque;

-- Access A429_TX_PMU_A_344_N1
   function  A429_TX_PMU_A_344_N1
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_A_344_N1
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_A_344_N1;

-- Access A429_TX_PMU_A_345_Itt
   function  A429_TX_PMU_A_345_Itt
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_A_345_Itt
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_A_345_Itt;

-- Access A429_TX_PMU_A_346_Np
   function  A429_TX_PMU_A_346_Np
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_A_346_Np
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_A_346_Np;

-- Access A429_TX_PMU_A_134_Pla
   function  A429_TX_PMU_A_134_Pla
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_A_134_Pla
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_A_134_Pla;

-- Access A429_TX_PMU_A_130_Outside_Air_Temperature
   function  A429_TX_PMU_A_130_Outside_Air_Temperature
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_A_130_Outside_Air_Temperature
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_A_130_Outside_Air_Temperature;

-- Access A429_TX_PMU_B_336_Torque
   function  A429_TX_PMU_B_336_Torque
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_B_336_Torque
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_B_336_Torque;

-- Access A429_TX_PMU_B_344_N1
   function  A429_TX_PMU_B_344_N1
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_B_344_N1
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_B_344_N1;

-- Access A429_TX_PMU_B_345_Itt
   function  A429_TX_PMU_B_345_Itt
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_B_345_Itt
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_B_345_Itt;

-- Access A429_TX_PMU_B_346_Np
   function  A429_TX_PMU_B_346_Np
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_B_346_Np
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_B_346_Np;

-- Access A429_TX_PMU_B_134_Pla
   function  A429_TX_PMU_B_134_Pla
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_B_134_Pla
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_B_134_Pla;

-- Access A429_TX_PMU_B_130_Outside_Air_Temperature
   function  A429_TX_PMU_B_130_Outside_Air_Temperature
      return Arinc_429_Types.Message_Type is
   begin
      return Power_Management_Unit.A429_TX_PMU_B_130_Outside_Air_Temperature
      (An_Instance => Container.This_Subsystem.The_Power_Management_Unit);
   end A429_TX_PMU_B_130_Outside_Air_Temperature;

  -- Access Exhaust_Thrust
   function  Exhaust_Thrust
     return Force_Types.Lbf is
   begin
     return Pratt_Whitney_Pt6a_68_Gas_Generator.Exhaust_Thrust
       ( An_Instance => Jpats_Powerplant.Container.This_Subsystem.The_Gas_Generator);
   end Exhaust_Thrust;

end JPATS_Powerplant;






