-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

 with Jpats_Electrical.Container;
-- with Power_Supply.Generator;

package body Jpats_Electrical is


   -- circuit breakers
   function Is_Powered
     (Name : in Jpats_Electrical_Types.Circuit_Breaker_Name_Type)
     return Boolean
   is
--      package Ctnr renames Container;
--      package Cbs renames Ctnr.Circuit_Breaker_Collection;
   begin
--    return Cbs.Is_Powered (Ctnr.This_Subsystem.The_Circuit_Breakers, Name);
     return True;
   end Is_Powered;

   procedure Trip
     (Name : in Jpats_Electrical_Types.Circuit_Breaker_Name_Type)
   is
--      Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;
--      package Ele renames Jpats_Electrical_Types;
   begin
--      case Name is
--         when Ele.Ail_El_Trim_Cb                  => Io.Ail_El_Trim_Do     := True;
--         when Ele.Rud_Trim_Cb                     => Io.Rud_Trim_Do        := True;
--         when Ele.Ldg_Gr_Cont_Cb                  => Io.Ldg_Gr_Cont_Do     := True;
--         when Ele.Flap_Cont_Cb                    => Io.Flap_Cont_Do       := True;
--         when Ele.Util_Lt_Cb                      => Io.Util_Do            := True;
--         when Ele.Coll_Lts_Cb                     => Io.Coll_Do            := True;
--         when Ele.Inst_Lts_Cb                     => Io.Inst_Do            := True;
--         when Ele.Ldg_Lts_Cb                      => Io.Ldg_Do             := True;
--         when Ele.Cws_Cb_Fwd_Batt_Bus             => Io.Cws_Batt_Do        := True;
--         when Ele.Fuel_Qty_Lo_Cb                  => Io.Fuel_Qty_Lo_Do     := True;
--         when Ele.Pmu_Cb                          => Io.Pmu_Do             := True;
--         when Ele.Boost_Pump_Cb                   => Io.Boost_Pump_Do      := True;
--         when Ele.Ign_Cb                          => Io.Ign_Do             := True;
--         when Ele.Start_Cb                        => Io.Start_Do           := True;
--         when Ele.Oil_Trx_Cb                      => Io.Oil_Trx_Do         := True;
--         when Ele.Batt_Sw_Cb                      => Io.Bat_Sw_Do          := True;
--         when Ele.Avi_Mstr_Cb                     => Io.Avi_Mstr_Do        := True;
--         when Ele.Fld_Lts_Cb                      => Io.Fldt_Do            := True;
--         when Ele.Alt_Eng_Dis_Cb                  => Io.Alt_Eng_Dis_Do     := True;
--         when Ele.Edm_Cb_Fwd_Batt_Bus             => Io.Edm_Batt_Do        := True;
--         when Ele.Prop_Sys_Cb                     => Io.Prop_Sys_Do        := True;
--         when Ele.Fdr_Cb                          => Io.Fdr_Do             := True;
--         when Ele.Aoa_Cb                          => Io.Aoa_Do             := True;
--         when Ele.Inflow_Sys_Cb                   => Io.Inflow_Sys_Do      := True;
--         when Ele.Hyd_Sys_Cb                      => Io.Hyd_Sys_Do         := True;
--         when Ele.Audio_Cb                        => Io.Audio_Do           := True;
--         when Ele.Aft_Battery_Cb                  => Io.Aft_Bat_Do         := True;
--         when Ele.Aux_Battery_Cb                  => Io.Aux_Bat_Do         := True;
--         when Ele.Fwd_Avi_Cb_Fwd_Batt_Bus         => Io.Fwd_Avi_Batt_Do    := True;
--
--         when Ele.Eadi_Cb                         => Io.Eadi_Do            := True;
--         when Ele.Gps_Cb                          => Io.Gps_Do             := True;
--         when Ele.Ahrs_Cb                         => Io.Ahrs_Do            := True;
--         when Ele.Aft_Avi_Cb_Fwd_Avi_Batt_Bus     => Io.Aft_Avi_Batt_Do    := True;
--
--         when Ele.Gyro_Cb                         => Io.Gyro_Do            := True;
--         when Ele.Altm_Cb_Fwd_Aux_Batt_Bus        => Io.Altm_Batt_Do       := True;
--         when Ele.Trn_Rt_Cb                       => Io.Turn_Rt_Do         := True;
--         when Ele.Uhf_Comm_Cb                     => Io.Uhf_Comm_Do        := True;
--         when Ele.Radio_Rlys_Cb_Fwd_Aux_Batt_Bus  => Io.Radio_Rlys_Batt_Do := True;
--         when Ele.Fire_Detect_Cb_Fwd_Aux_Batt_Bus => Io.Fire_1_Do          := True;
--         when Ele.Stby_Lts_Cb                     => Io.Stby_Do            := True;
--         when Ele.Aft_Stby_Cb                     => Io.Aft_Inst_Do        := True;
--
--
--
--         when Ele.Air_Cond_Cb                     => Io.Air_Cond_Do        := True;
--         when Ele.Ckpt_Temp_Cb                    => Io.Ckpt_Temp_Do       := True;
--         when Ele.Aural_Warn_Cb                   => Io.Aural_Warn_Do      := True;
--         when Ele.Evap_Blower_Cb                  => Io.Evap_Blower_Do     := True;
--         when Ele.Aoa_Ht_Cb                       => Io.Aoa_Ht_Do          := True;
--         when Ele.Pitot_Ht_Cb                     => Io.Pitot_Ht_Do        := True;
--         when Ele.Fuel_Bal_Cb                     => Io.Fuel_Bal_Do        := True;
--         when Ele.Side_Lts_Cb                     => Io.Side_Do            := True;
--         when Ele.Nav_Lts_Cb                      => Io.Nav_Do             := True;
--         when Ele.Taxi_Lts_Cb                     => Io.Taxi_Do            := True;
--         when Ele.Speedbrake_Cb                   => Io.Speed_Brake_Do     := True;
--         when Ele.Nws_Cb                          => Io.Nws_Do             := True;
--         when Ele.Test_Lts_Cb                     => Io.Test_Do            := True;
--         when Ele.Trim_Ind_Cb                     => Io.Trim_Ind_Do        := True;
--         when Ele.Edm_Cb_Fwd_Gen_Bus              => Io.Edm_Gen_Do         := True;
--         when Ele.Gen_Sw_Cb                       => Io.Gen_Sw_Do          := True;
--         when Ele.Fwd_Avi_Cb_Fwd_Gen_Bus          => Io.Fwd_Avi_Gen_Do     := True;
--         when Ele.Fire_Detect_Cb_Fwd_Gen_Bus      => Io.Fire_2_Do          := True;
--         when Ele.Eng_Sys_Dis_Cb                  => Io.Eng_Sys_Dis_Do     := True;
--         when Ele.Pri_Eng_Dis_Cb                  => Io.Pri_Eng_Dis_Do     := True;
--         when Ele.Tad_Cb                          => Io.Tad_Do             := True;
--         when Ele.Seat_Adj_Cb                     => Io.Seat_Adj_Do        := True;
--         when Ele.Cws_Cb_Fwd_Gen_Bus              => Io.Cws_Gen_Do         := True;
--         when Ele.Aft_Gen_Cb                      => Io.Aft_Gen_Do         := True;
--
--         when Ele.Adc_Cb                          => Io.Adc_Do             := True;
--         when Ele.Ehsi_Cb                         => Io.Ehsi_Do            := True;
--         when Ele.Xpdr_Cb                         => Io.Xpdr_Do            := True;
--         when Ele.Nacws_Cb                        => Io.Nacws_Do           := True;
--         when Ele.Vhf_Comm_Cb                     => Io.Vhf_Comm_Do        := True;
--         when Ele.Asi_Cb                          => Io.Asi_Do             := True;
--         when Ele.Altm_Cb_Fwd_Avi_Gen_Bus         => Io.Altm_Gen_Do        := True;
--         when Ele.Vhf_Nav_Cb                      => Io.Vhf_Nav_Do         := True;
--         when Ele.Dme_Cb                          => Io.Dme_Do             := True;
--         when Ele.Radio_Rlys_Cb_Fwd_Avi_Gen_Bus   => Io.Radio_Rlys_Do      := True;
--         when Ele.Vvi_Cb                          => Io.Vvi_Do             := True;
--         when Ele.Rmu_Cb                          => Io.Rmu_Gen_Do         := True;
--         when Ele.Aft_Avi_Cb_Fwd_Avi_Gen_Bus      => Io.Aft_Avi_Gen_Do     := True;
--
--         when others => null;
--
--      end case;
  null;
end Trip;

   procedure Clear_Trip
     (Name : in Jpats_Electrical_Types.Circuit_Breaker_Name_Type)
   is
--      Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;
--      package Ele renames Jpats_Electrical_Types;
   begin
--      case Name is
--         when Ele.Ail_El_Trim_Cb                  => Io.Ail_El_Trim_Do     := False;
--         when Ele.Rud_Trim_Cb                     => Io.Rud_Trim_Do        := False;
--         when Ele.Ldg_Gr_Cont_Cb                  => Io.Ldg_Gr_Cont_Do     := False;
--         when Ele.Flap_Cont_Cb                    => Io.Flap_Cont_Do       := False;
--         when Ele.Util_Lt_Cb                      => Io.Util_Do            := False;
--         when Ele.Coll_Lts_Cb                     => Io.Coll_Do            := False;
--         when Ele.Inst_Lts_Cb                     => Io.Inst_Do            := False;
--         when Ele.Ldg_Lts_Cb                      => Io.Ldg_Do             := False;
--         when Ele.Cws_Cb_Fwd_Batt_Bus             => Io.Cws_Batt_Do        := False;
--         when Ele.Fuel_Qty_Lo_Cb                  => Io.Fuel_Qty_Lo_Do     := False;
--         when Ele.Pmu_Cb                          => Io.Pmu_Do             := False;
--         when Ele.Boost_Pump_Cb                   => Io.Boost_Pump_Do      := False;
--         when Ele.Ign_Cb                          => Io.Ign_Do             := False;
--         when Ele.Start_Cb                        => Io.Start_Do           := False;
--         when Ele.Oil_Trx_Cb                      => Io.Oil_Trx_Do         := False;
--         when Ele.Batt_Sw_Cb                      => Io.Bat_Sw_Do          := False;
--         when Ele.Avi_Mstr_Cb                     => Io.Avi_Mstr_Do        := False;
--         when Ele.Fld_Lts_Cb                      => Io.Fldt_Do            := False;
--         when Ele.Alt_Eng_Dis_Cb                  => Io.Alt_Eng_Dis_Do     := False;
--         when Ele.Edm_Cb_Fwd_Batt_Bus             => Io.Edm_Batt_Do        := False;
--         when Ele.Prop_Sys_Cb                     => Io.Prop_Sys_Do        := False;
--         when Ele.Fdr_Cb                          => Io.Fdr_Do             := False;
--         when Ele.Aoa_Cb                          => Io.Aoa_Do             := False;
--         when Ele.Inflow_Sys_Cb                   => Io.Inflow_Sys_Do      := False;
--         when Ele.Hyd_Sys_Cb                      => Io.Hyd_Sys_Do         := False;
--         when Ele.Audio_Cb                        => Io.Audio_Do           := False;
--         when Ele.Aft_Battery_Cb                  => Io.Aft_Bat_Do         := False;
--         when Ele.Aux_Battery_Cb                  => Io.Aux_Bat_Do         := False;
--         when Ele.Fwd_Avi_Cb_Fwd_Batt_Bus         => Io.Fwd_Avi_Batt_Do    := False;
--
--         when Ele.Eadi_Cb                         => Io.Eadi_Do            := False;
--         when Ele.Gps_Cb                          => Io.Gps_Do             := False;
--         when Ele.Ahrs_Cb                         => Io.Ahrs_Do            := False;
--         when Ele.Aft_Avi_Cb_Fwd_Avi_Batt_Bus     => Io.Aft_Avi_Batt_Do    := False;
--
--         when Ele.Gyro_Cb                         => Io.Gyro_Do            := False;
--         when Ele.Altm_Cb_Fwd_Aux_Batt_Bus        => Io.Altm_Batt_Do       := False;
--         when Ele.Trn_Rt_Cb                       => Io.Turn_Rt_Do         := False;
--         when Ele.Uhf_Comm_Cb                     => Io.Uhf_Comm_Do        := False;
--         when Ele.Radio_Rlys_Cb_Fwd_Aux_Batt_Bus  => Io.Radio_Rlys_Batt_Do := False;
--         when Ele.Fire_Detect_Cb_Fwd_Aux_Batt_Bus => Io.Fire_1_Do          := False;
--         when Ele.Stby_Lts_Cb                     => Io.Stby_Do            := False;
--         when Ele.Aft_Stby_Cb                     => Io.Aft_Inst_Do        := False;
--
--
--
--         when Ele.Air_Cond_Cb                     => Io.Air_Cond_Do        := False;
--         when Ele.Ckpt_Temp_Cb                    => Io.Ckpt_Temp_Do       := False;
--         when Ele.Aural_Warn_Cb                   => Io.Aural_Warn_Do      := False;
--         when Ele.Evap_Blower_Cb                  => Io.Evap_Blower_Do     := False;
--         when Ele.Aoa_Ht_Cb                       => Io.Aoa_Ht_Do          := False;
--         when Ele.Pitot_Ht_Cb                     => Io.Pitot_Ht_Do        := False;
--         when Ele.Fuel_Bal_Cb                     => Io.Fuel_Bal_Do        := False;
--         when Ele.Side_Lts_Cb                     => Io.Side_Do            := False;
--         when Ele.Nav_Lts_Cb                      => Io.Nav_Do             := False;
--         when Ele.Taxi_Lts_Cb                     => Io.Taxi_Do            := False;
--         when Ele.Speedbrake_Cb                   => Io.Speed_Brake_Do     := False;
--         when Ele.Nws_Cb                          => Io.Nws_Do             := False;
--         when Ele.Test_Lts_Cb                     => Io.Test_Do            := False;
--         when Ele.Trim_Ind_Cb                     => Io.Trim_Ind_Do        := False;
--         when Ele.Edm_Cb_Fwd_Gen_Bus              => Io.Edm_Gen_Do         := False;
--         when Ele.Gen_Sw_Cb                       => Io.Gen_Sw_Do          := False;
--         when Ele.Fwd_Avi_Cb_Fwd_Gen_Bus          => Io.Fwd_Avi_Gen_Do     := False;
--         when Ele.Fire_Detect_Cb_Fwd_Gen_Bus      => Io.Fire_2_Do          := False;
--         when Ele.Eng_Sys_Dis_Cb                  => Io.Eng_Sys_Dis_Do     := False;
--         when Ele.Pri_Eng_Dis_Cb                  => Io.Pri_Eng_Dis_Do     := False;
--         when Ele.Tad_Cb                          => Io.Tad_Do             := False;
--         when Ele.Seat_Adj_Cb                     => Io.Seat_Adj_Do        := False;
--         when Ele.Cws_Cb_Fwd_Gen_Bus              => Io.Cws_Gen_Do         := False;
--         when Ele.Aft_Gen_Cb                      => Io.Aft_Gen_Do         := False;
--
--         when Ele.Adc_Cb                          => Io.Adc_Do             := False;
--         when Ele.Ehsi_Cb                         => Io.Ehsi_Do            := False;
--         when Ele.Xpdr_Cb                         => Io.Xpdr_Do            := False;
--         when Ele.Nacws_Cb                        => Io.Nacws_Do           := False;
--         when Ele.Vhf_Comm_Cb                     => Io.Vhf_Comm_Do        := False;
--         when Ele.Asi_Cb                          => Io.Asi_Do             := False;
--         when Ele.Altm_Cb_Fwd_Avi_Gen_Bus         => Io.Altm_Gen_Do        := False;
--         when Ele.Vhf_Nav_Cb                      => Io.Vhf_Nav_Do         := False;
--         when Ele.Dme_Cb                          => Io.Dme_Do             := False;
--         when Ele.Radio_Rlys_Cb_Fwd_Avi_Gen_Bus   => Io.Radio_Rlys_Do      := False;
--         when Ele.Vvi_Cb                          => Io.Vvi_Do             := False;
--         when Ele.Rmu_Cb                          => Io.Rmu_Gen_Do         := False;
--         when Ele.Aft_Avi_Cb_Fwd_Avi_Gen_Bus      => Io.Aft_Avi_Gen_Do     := False;
--
--         when others => null;
--
--      end case;
     null;

   end Clear_Trip;

   procedure Clear_All_Trip
   is
--      Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;
   begin
--      Io.Ail_El_Trim_Do     := False;
--      Io.Rud_Trim_Do        := False;
--      Io.Ldg_Gr_Cont_Do     := False;
--      Io.Flap_Cont_Do       := False;
--      Io.Util_Do            := False;
--      Io.Coll_Do            := False;
--      Io.Inst_Do            := False;
--      Io.Ldg_Do             := False;
--      Io.Cws_Batt_Do        := False;
--      Io.Fuel_Qty_Lo_Do     := False;
--      Io.Pmu_Do             := False;
--      Io.Boost_Pump_Do      := False;
--      Io.Ign_Do             := False;
--      Io.Start_Do           := False;
--      Io.Oil_Trx_Do         := False;
--      Io.Bat_Sw_Do          := False;
--      Io.Avi_Mstr_Do        := False;
--      Io.Fldt_Do            := False;
--      Io.Alt_Eng_Dis_Do     := False;
--      Io.Edm_Batt_Do        := False;
--      Io.Prop_Sys_Do        := False;
--      Io.Fdr_Do             := False;
--      Io.Aoa_Do             := False;
--      Io.Inflow_Sys_Do      := False;
--      Io.Hyd_Sys_Do         := False;
--      Io.Audio_Do           := False;
--      Io.Aft_Bat_Do         := False;
--      Io.Aux_Bat_Do         := False;
--      Io.Fwd_Avi_Batt_Do    := False;
--
--      Io.Eadi_Do            := False;
--      Io.Gps_Do             := False;
--      Io.Ahrs_Do            := False;
--      Io.Aft_Avi_Batt_Do    := False;
--
--      Io.Gyro_Do            := False;
--      Io.Altm_Batt_Do       := False;
--      Io.Turn_Rt_Do         := False;
--      Io.Uhf_Comm_Do        := False;
--      Io.Radio_Rlys_Batt_Do := False;
--      Io.Fire_1_Do          := False;
--      Io.Stby_Do            := False;
--      Io.Aft_Inst_Do        := False;
--
--
--
--      Io.Air_Cond_Do        := False;
--      Io.Ckpt_Temp_Do       := False;
--      Io.Aural_Warn_Do      := False;
--      Io.Evap_Blower_Do     := False;
--      Io.Aoa_Ht_Do          := False;
--      Io.Pitot_Ht_Do        := False;
--      Io.Fuel_Bal_Do        := False;
--      Io.Side_Do            := False;
--      Io.Nav_Do             := False;
--      Io.Taxi_Do            := False;
--      Io.Speed_Brake_Do     := False;
--      Io.Nws_Do             := False;
--      Io.Test_Do            := False;
--      Io.Trim_Ind_Do        := False;
--      Io.Edm_Gen_Do         := False;
--      Io.Gen_Sw_Do          := False;
--      Io.Fwd_Avi_Gen_Do     := False;
--      Io.Fire_2_Do          := False;
--      Io.Eng_Sys_Dis_Do     := False;
--      Io.Pri_Eng_Dis_Do     := False;
--      Io.Tad_Do             := False;
--      Io.Seat_Adj_Do        := False;
--      Io.Cws_Gen_Do         := False;
--      Io.Aft_Gen_Do         := False;
--
--      Io.Adc_Do             := False;
--      Io.Ehsi_Do            := False;
--      Io.Xpdr_Do            := False;
--      Io.Nacws_Do           := False;
--      Io.Vhf_Comm_Do        := False;
--      Io.Asi_Do             := False;
--      Io.Altm_Gen_Do        := False;
--      Io.Vhf_Nav_Do         := False;
--      Io.Dme_Do             := False;
--      Io.Radio_Rlys_Do      := False;
--      Io.Vvi_Do             := False;
--      Io.Rmu_Gen_Do         := False;
--      Io.Aft_Avi_Gen_Do     := False;
     null;
   end Clear_All_Trip;


   -- relays
   function Is_Closed
     (Name : in Jpats_Electrical_Types.Relay_Name_Type)
     return Boolean
   is
--      package Ctnr renames Container;
--      package Relays renames Ctnr.Coil_Relay_Collection;
   begin
--      return Relays.Is_Closed (Ctnr.This_Subsystem.The_Relays, Name);
     return True;
   end Is_Closed;

   -- master caution panel light requests
   function Bat_Bus_Annunciator_Request return Boolean
   is
--      package Ele renames Jpats_Electrical_Types;
   begin
--      return not Is_Powered (Ele.Cws_Cb_Fwd_Batt_Bus);
     return False;
   end Bat_Bus_Annunciator_Request;

   function Gen_Bus_Annunciator_Request return Boolean
   is
--      package Ele renames Jpats_Electrical_Types;
   begin
--      return not Is_Powered (Ele.Cws_Cb_Fwd_Gen_Bus);
     return False;
   end Gen_Bus_Annunciator_Request;

   function Gen_Annunciator_Request return Boolean
   is
--      package Ctnr renames Container;
--      package Gcu  renames Ctnr.Generator_Control_Unit;
   begin
 --     return not Gcu.Line_Control (Ctnr.This_Subsystem.The_Generator_Control_Unit);
     return False;
   end Gen_Annunciator_Request;

   function Bus_Tie_Annunciator_Request return Boolean
   is
--      package Ele    renames Jpats_Electrical_Types;
--      package Ctnr   renames Container;
--      package Relays renames Ctnr.Coil_Relay_Collection;
   begin
--      return Relays.Is_Open (Ctnr.This_Subsystem.The_Relays, Ele.Bus_Tie_Relay) and Is_Powered (Ele.Bus_Tie_Control_Cb);
     return False;
   end Bus_Tie_Annunciator_Request;

   function Starter_Torque return Float
   is
--      package Ctnr renames Container;
   begin
--      return Power_Supply.Generator.Torque (Ctnr.This_Subsystem.The_Generator);
     return 0.0;
   end Starter_Torque;

   function Emergency_Lights return Boolean
   is
   begin
--      return Container.Auxiliary_Battery_Mount.Lights_Out (Container.This_Subsystem.The_Auxiliary_Battery_Mount);
     return False;
   end Emergency_Lights;

   function Display_Voltage return Electrical_Units_Types.Volts_Dc
   is
      package Ctnr renames Container;
      package Vm renames Ctnr.Voltmeter;
      The_Vm : Vm.Instance renames Ctnr.This_Subsystem.The_Voltmeter;
   begin
      return Vm.Displayed_Voltage(The_Vm);
   end Display_Voltage;

   function Display_Load return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      package Vm renames Ctnr.Voltmeter;
      The_Vm : Vm.Instance renames Ctnr.This_Subsystem.The_Voltmeter;
   begin
      return Vm.Displayed_Load(The_Vm);
   end Display_Load;

end Jpats_electrical;



