-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Altitude_Hold;
with Attitude_Latency;
with Auto_Throttle_Hold;
with Demand_x_Acceleration;
with Error_Coefficients;
with Primary_Control_Surface;
with Flylevel;
with Indicated_Velocity_Hold;
with Lateral_Trim;
with Longitudinal_Trim;
with Pitch_Hold;
with PLA_Trim;
with Rate_of_Climb_Hold;
with Roll_Hold;
with Side_Slip_Hold;
with Special_Autopilot_Pitch;
with Special_Autopilot_Roll;
with Special_Autopilot_Yaw;
with Status;
with Torque_Trim;
with Trim;
with Yaw_Hold;
with JPATS_Auto_Test.Container;
with JPATS_Auto_Test.Flight_Characteristics_Container;


package body JPATS_Auto_Test is
   package Fcc renames Flight_Characteristics_Container;

    function Get_Altitude_Hold_Rate_of_Climb_Demand return Length_Types.Feet_per_Sec is
    begin
       return Altitude_Hold.Get_Rate_of_Climb_Demand(Container.This_Subsystem.The_Altitude_Hold);
    end Get_Altitude_Hold_Rate_of_Climb_Demand;

    function Get_Altitude_Hold_Rate_of_Climb_Hold return Boolean is
    begin
       return Altitude_Hold.Get_Rate_of_Climb_Hold(Container.This_Subsystem.The_Altitude_Hold);
    end Get_Altitude_Hold_Rate_of_Climb_Hold;

    function Get_Auto_Throttle_Hold_Engine_Thrust_Demand return JPATS_Auto_Test_Types.Thrust_Type is
    begin
       return Auto_Throttle_Hold.Get_Engine_Thrust_Demand(Container.This_Subsystem.The_Auto_Throttle_Hold);
    end Get_Auto_Throttle_Hold_Engine_Thrust_Demand;

    function Get_Demand_x_Acceleration return Float is
    begin
       return Demand_x_Acceleration.Get_Demand_x_Acceleration(Container.This_Subsystem.The_Demand_x_Acceleration);
    end Get_Demand_x_Acceleration;

    function Get_Left_Aileron_Delta_Deflection return Angle_Types.Degrees is
    begin
        return Error_Coefficients.Get_Delta_Deflection(Container.This_Subsystem.The_Left_Aileron_Error_Coefficients);
    end Get_Left_Aileron_Delta_Deflection;

    function Get_Right_Aileron_Delta_Deflection return Angle_Types.Degrees is
    begin
        return Error_Coefficients.Get_Delta_Deflection(Container.This_Subsystem.The_Right_Aileron_Error_Coefficients);
    end Get_Right_Aileron_Delta_Deflection;

    function Get_Elevator_Delta_Deflection return Angle_Types.Degrees is
    begin
        return Error_Coefficients.Get_Delta_Deflection(Container.This_Subsystem.The_Elevator_Error_Coefficients);
    end Get_Elevator_Delta_Deflection;   --| For elevator and rudder This_Subsystem.The_Error_Coefficients_Right_Aileron_Effect
                                         --| does not matter.

    function Get_Rudder_Delta_Deflection return Angle_Types.Degrees is
    begin
        return Error_Coefficients.Get_Delta_Deflection(Container.This_Subsystem.The_Rudder_Error_Coefficients);
    end Get_Rudder_Delta_Deflection;     --| For elevator and rudder This_Subsystem.The_Error_Coefficients_Right_Aileron_Effect
                                         --| does not matter.

--| Flylevel
    function Get_Flylevel_Longitudinal_Trim return Boolean is
    begin
       return Flylevel.Get_Longitudinal_Trim(Container.This_Subsystem.The_Flylevel);
    end Get_Flylevel_Longitudinal_Trim;

    function Get_Flylevel_Lateral_Trim return Boolean is
    begin
       return Flylevel.Get_Lateral_Trim(Container.This_Subsystem.The_Flylevel);
    end Get_Flylevel_Lateral_Trim;

--| Indicated_Velocity_Hold
    function Get_Indicated_Velocity_Hold_Pitch_Angle_Demand return Angle_Types.Radians is
    begin
       return Indicated_Velocity_Hold.Get_Pitch_Angle_Demand(Container.This_Subsystem.The_Indicated_Velocity_Hold);
    end Get_Indicated_Velocity_Hold_Pitch_Angle_Demand;

--| Lateral_Trim
    function Get_Lateral_Trim_Roll_Angle_Hold return Boolean is
    begin
       return Lateral_Trim.Get_Roll_Hold(Container.This_Subsystem.The_Lateral_Trim);
    end Get_Lateral_Trim_Roll_Angle_Hold;

    function Get_Lateral_Trim_Yaw_Hold return Boolean is
    begin
       return Lateral_Trim.Get_Yaw_Hold(Container.This_Subsystem.The_Lateral_Trim);
    end Get_Lateral_Trim_Yaw_Hold;

--| Longitudinal_Trim
    function Get_Longitudinal_Trim_Rate_of_Climb_Hold return Boolean is
    begin
       return Longitudinal_Trim.Get_Rate_of_Climb_Hold(Container.This_Subsystem.The_Longitudinal_Trim);
    end Get_Longitudinal_Trim_Rate_of_Climb_Hold;


    function Get_Longitudinal_Trim_Auto_Throttle return Boolean is
    begin
       return Longitudinal_Trim.Get_Auto_Throttle(Container.This_Subsystem.The_Longitudinal_Trim);
    end Get_Longitudinal_Trim_Auto_Throttle;

    function Get_Longitudinal_Trim_PLA_Trim return Boolean is
    begin
       return Longitudinal_Trim.Get_PLA_Trim(Container.This_Subsystem.The_Longitudinal_Trim);
    end Get_Longitudinal_Trim_PLA_Trim;

--| Pitch_Hold
    function Pitch_Rate return Angle_Types.Radians_per_Sec is
    begin
       return Pitch_Hold.Pitch_Rate(Container.This_Subsystem.The_Pitch_Hold);
    end Pitch_Rate;

--| PLA_Trim
    function Get_PLA_Trim_Demand return Angle_Types.Degrees is
    begin
       return PLA_Trim.Get_PLA_Trim_Demand(Container.This_Subsystem.The_PLA_Trim);
    end Get_PLA_Trim_Demand;

    function L_Ail_pos return Angle_Types.degrees is
    begin
       return Primary_Control_Surface.Get_Position_Value(Container.This_Subsystem.The_Left_Aileron);
    end L_Ail_pos;

    function R_Ail_pos return Angle_types.degrees is
    begin
       return Primary_Control_Surface.Get_Position_Value(Container.This_Subsystem.The_Right_Aileron);
    end R_Ail_pos;

    function Elev_pos return Angle_Types.degrees is
    begin
       return Primary_Control_Surface.Get_Position_Value(Container.This_Subsystem.The_Elevator);
    end Elev_pos;

    function Rud_pos return Angle_Types.degrees is
    begin
       return Primary_Control_Surface.Get_Position_Value(Container.This_Subsystem.The_Rudder);
    end Rud_pos;

--| Rate_of_Climb_Hold
    function Get_Rate_of_Climb_Hold_Pitch_Angle_Demand return Angle_Types.Radians is
    begin
       return Rate_of_Climb_Hold.Get_Pitch_Angle_Demand(Container.This_Subsystem.The_Rate_of_Climb_Hold);
    end Get_Rate_of_Climb_Hold_Pitch_Angle_Demand;

--| Roll_Hold

    function Roll_Rate return Angle_Types.Radians_per_Sec is
    begin
       return Roll_Hold.Roll_Rate(Container.This_Subsystem.The_Roll_Hold);
    end Roll_Rate;



--| Side_Slip_Hold
    function Get_Side_Slip_Hold_Roll_Hold return Boolean is
    begin
       return Side_Slip_Hold.Get_Roll_Hold(Container.This_Subsystem.The_Side_Slip_Hold);
    end Get_Side_Slip_Hold_Roll_Hold;

    function Get_Side_Slip_Hold_Roll_Angle_Demand return Angle_Types.Radians is
    begin
       return Side_Slip_Hold.Get_Roll_Angle_Demand(Container.This_Subsystem.The_Side_Slip_Hold);
    end Get_Side_Slip_Hold_Roll_Angle_Demand;

    function Get_Side_Slip_Hold_Yaw_Hold return Boolean is
    begin
       return Side_Slip_Hold.Get_Yaw_Hold(Container.This_Subsystem.The_Side_Slip_Hold);
    end Get_Side_Slip_Hold_Yaw_Hold;

--| Special_Autopilot_Pitch
    function Get_Special_Autopilot_Pitch_Elevator_Demand return Angle_Types.degrees is
    begin
       return Special_Autopilot_Pitch.Get_Position_Demand(Container.This_Subsystem.The_Special_Autopilot_Pitch_for_Elevator);
    end Get_Special_Autopilot_Pitch_Elevator_Demand;

    function Get_Special_Autopilot_Pitch_Elevator_Valid return Boolean is
    begin
       return Special_Autopilot_Pitch.Get_Position_Valid(Container.This_Subsystem.The_Special_Autopilot_Pitch_for_Elevator);
    end Get_Special_Autopilot_Pitch_Elevator_Valid;

--| Special_Autopilot_Roll
    function Get_Special_Autopilot_Roll return Angle_Types.Degrees is
    begin
       return Special_Autopilot_Roll.Get_Aileron_cmd(Container.This_Subsystem.The_Special_Autopilot_Roll);
    end Get_Special_Autopilot_Roll;

--| Special_Autopilot_Yaw
    function Get_Special_Autopilot_Yaw_Rudder_Demand return Angle_Types.Degrees is
    begin
       return Special_Autopilot_Yaw.Get_Position_Demand(Container.This_Subsystem.The_Special_Autopilot_Yaw_for_Rudder);
    end Get_Special_Autopilot_Yaw_Rudder_Demand;

    function Get_Special_Autopilot_Yaw_Rudder_Valid return Boolean is
    begin
       return Special_Autopilot_Yaw.Get_Position_Valid(Container.This_Subsystem.The_Special_Autopilot_Yaw_for_Rudder);
    end Get_Special_Autopilot_Yaw_Rudder_Valid;

--| Yaw_Hold
    function Yaw_Rate return Angle_Types.Radians_per_Sec is
    begin
       return Yaw_Hold.Yaw_Rate(Container.This_Subsystem.The_Yaw_Hold);
    end Yaw_Rate;

--| Torque_Trim
    function Get_Torque_Trim_PLA_Trim_Demand return Angle_Types.Degrees is
    begin
       return Torque_Trim.Get_PLA_Trim_Demand(Container.This_Subsystem.The_Torque_Trim);
    end Get_Torque_Trim_PLA_Trim_Demand;

    function Get_Torque_Trim_PLA_Trim_Valid return Boolean is
    begin
       return Torque_Trim.Get_PLA_Trim_Valid(Container.This_Subsystem.The_Torque_Trim);
    end Get_Torque_Trim_PLA_Trim_Valid;

--| Flight_Characteristics
    function Get_Angle_of_Attack return Angle_Types.Radians is
    begin
       return Flight_Characteristics_Container.Aoa_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Angle_of_Attack);
    end Get_Angle_of_Attack;

    function Get_Side_Slip_Angle return Angle_Types.Radians is
    begin
       return Flight_Characteristics_Container.Side_Slip_Angle_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Side_Slip_Angle);
    end Get_Side_Slip_Angle;

    function Get_Calibrated_Airspeed return Length_Types.Knots is
    begin
       return Flight_Characteristics_Container.CAS_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_CAS);
    end Get_Calibrated_Airspeed;

    function Get_North return Lat_Long_Types.Latitude_Degrees is
    begin
        return Flight_Characteristics_Container.Latitude.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_North);
    end Get_North;

    function Get_East return Lat_Long_Types.Longitude_Degrees is
    begin
        return Flight_Characteristics_Container.longitude.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_East);
    end Get_East;

    function Get_Field_Geometric_Altitude return Length_Types.Feet is
    begin
       return Flight_Characteristics_Container.Field_Geometric_Altitude_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Field_Geometric_Altitude);
    end Get_Field_Geometric_Altitude;

    function Cg_Loc return Coordinate_Types.Reference_System is
    begin
       return Flight_Characteristics_Container.Cg_Fc.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Cg_loc);
    end Cg_Loc;

    function Get_Outside_Air_Temperature return Temperature_Types.Rankine is
    begin
       return Flight_Characteristics_Container.Outside_Air_Temperature_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Outside_Air_Temperature);
    end Get_Outside_Air_Temperature;

    function Get_Winds_Direction return Angle_Types.Radians is
    begin
       return Flight_Characteristics_Container.Winds_Direction_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Winds_Direction);
    end Get_Winds_Direction;

    function Get_Winds_Velocity return Length_Types.Knots is
    begin
       return Flight_Characteristics_Container.Winds_Velocity_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Winds_Velocity);
    end Get_Winds_Velocity;

    function Get_GW return float is
    begin
           return Flight_Characteristics_Container.Misc.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Gw);
   --         return Container.This_Subsystem.The_Gw
    end Get_GW;

      function Get_Altitude return Float is
    begin
       return Flight_Characteristics_Container.misc.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Altitude);
    end Get_Altitude;

    function Get_Moment_of_Inertia return Coordinate_Types.Inertia_Axis is
    begin
           return Flight_Characteristics_Container.Inertia_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Inertia);
    end Get_Moment_of_Inertia;

    function Get_Steady_State_Wind return Coordinate_Types.Cartesian is
    begin
       return Flight_Characteristics_Container.Steady_State_Wind_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Steady_State_Wind);
    end Get_Steady_State_Wind;

    function Get_Initializing_Test_Status return Boolean is
    begin
       return Status.Get_Test_Operating_State(Container.This_Subsystem.The_Initializing_State);
    end Get_Initializing_Test_Status;

    function Get_Stabilizing_Test_Status return Boolean is
    begin
       return Status.Get_Test_Operating_State(Container.This_Subsystem.The_Stabilizing_State);
    end Get_Stabilizing_Test_Status;

    function Get_Running_Test_Status return Boolean is
    begin
       return Status.Get_Test_Operating_State(Container.This_Subsystem.The_Run_Test_State);
    end Get_Running_Test_Status;

    function Get_Manual_Test_Status return Boolean is
    begin
       return Status.Get_Test_Operating_State(Container.This_Subsystem.The_Manual_Test_State);
    end Get_Manual_Test_Status;

    function Roll_Angle return Angle_Types.Radians is
    begin
       return Container.Attitude_Angle_Demand.Get_Attribute(Container.This_Subsystem.The_Roll_Angle_Demand);
    end Roll_Angle;

    function Pitch_Angle return Angle_Types.Radians is
    begin
       return Container.Attitude_Angle_Demand.Get_Attribute(Container.This_Subsystem.The_Pitch_Angle_Demand);
    end Pitch_Angle;

    function Yaw_Angle return Angle_Types.Radians is
    begin
       return Container.Attitude_Angle_Demand.Get_Attribute(Container.This_Subsystem.The_Yaw_Angle_Demand);
    end Yaw_Angle;

    function Get_Lateral_Column_Position_Value return Angle_Types.Degrees is
    begin
       return Container.Cockpit_Primary_Position.Get_Attribute(Container.This_Subsystem.The_Lateral_Position);
    end Get_Lateral_Column_Position_Value;

     function Get_Longitudinal_Column_Position_Value return Angle_Types.Degrees is
    begin
       return Container.Cockpit_Primary_Position.Get_Attribute(Container.This_Subsystem.The_Longitudinal_Position);
    end Get_Longitudinal_Column_Position_Value;

    function Get_Left_Pedal_Position_Value return Angle_Types.Degrees is
    begin
       return Container.Cockpit_Primary_Position.Get_Attribute(Container.This_Subsystem.The_Pedal_Position);
    end Get_Left_Pedal_Position_Value;


    function Get_Lateral_Column_Force_Value return Angle_Types.Degrees is
    begin
       return Flight_Characteristics_Container.Force_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Lateral_Force);
    end Get_Lateral_Column_Force_Value;

    function Get_Longitudinal_Column_Force_Value return Angle_Types.Degrees is
    begin
       return Flight_Characteristics_Container.Force_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Longitudinal_Force);
    end Get_Longitudinal_Column_Force_Value;

    function Get_Pedal_Force_Value return Angle_Types.Degrees is
    begin
       return Flight_Characteristics_Container.Force_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Pedal_Force);
    end Get_Pedal_Force_Value;

    function Get_Latency_Step_Input_Pitch_Angle return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Attitude_Angle(Container.This_Subsystem.The_Pitch_Latency);
    end Get_Latency_Step_Input_Pitch_Angle;


    function Get_Pitch_Latency_Step_Input return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Latency_Step_Input(Container.This_Subsystem.The_Pitch_Latency);
    end Get_Pitch_Latency_Step_Input;

    function Get_Latency_Step_Input_Roll_Angle return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Attitude_Angle(Container.This_Subsystem.The_Roll_Latency);
    end Get_Latency_Step_Input_Roll_Angle;


    function Get_Roll_Latency_Step_Input return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Latency_Step_Input(Container.This_Subsystem.The_Roll_Latency);
    end Get_Roll_Latency_Step_Input;

    function Get_Latency_Step_Input_Yaw_Angle return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Attitude_Angle(Container.This_Subsystem.The_Yaw_Latency);
    end Get_Latency_Step_Input_Yaw_Angle;


    function Get_Yaw_Latency_Step_Input return Angle_Types.Radians is
    begin
       return Attitude_Latency.Get_Latency_Step_Input(Container.This_Subsystem.The_Yaw_Latency);
    end Get_Yaw_Latency_Step_Input;

    function Get_Bleed_Load return Float is
    begin
       return Flight_Characteristics_Container.Engine_Load_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Bleed_Load);
    end Get_Bleed_Load;

     function Get_Accessory_Load return Float is
    begin
       return Flight_Characteristics_Container.Engine_Load_FC.Get_Attribute(Flight_Characteristics_Container.This_Subsystem.The_Accessory_Load);
    end Get_Accessory_Load;

    function On return Boolean is
    begin
       return
         Container.This_Subsystem.On;
    end On;

    function Roll_mode return Integer is
    begin
       return
         Container.This_Subsystem.The_At_Roll_mode;
    end Roll_mode;

    function trimming return Boolean is
    begin
       return
         Container.This_Subsystem.trimming;
    end trimming;


    function Get_Longitudinal_Trim_Elevator_Tab_Trim return Boolean is
    begin
       return Longitudinal_Trim.Get_Elevator_Tab_Trim(Container.This_Subsystem.The_Longitudinal_Trim);
    end Get_Longitudinal_Trim_Elevator_Tab_Trim;


    function Get_Lateral_Trim_Aileron_Tab_Trim return Boolean is
    begin
       return Lateral_Trim.Get_Aileron_Tab_Trim(Container.This_Subsystem.The_Lateral_Trim);
    end Get_Lateral_Trim_Aileron_Tab_Trim;

    function Get_Lateral_Trim_Rudder_Tab_Trim return Boolean is
    begin
       return Lateral_Trim.Get_Rudder_Tab_Trim(Container.This_Subsystem.The_Lateral_Trim);
    end Get_Lateral_Trim_Rudder_Tab_Trim;

    function Ail_trim return integer is
    begin
       return Container.This_Subsystem.The_Ail_Trim;
    end Ail_trim;

    function ele_Tab_pos return float is
    begin
       return Container.This_Subsystem.The_ele_Tab_pos;
    end ele_Tab_pos;

    function ele_Tab_mode return integer is
    begin
       return Container.This_Subsystem.The_ele_Tab_mode;
    end ele_Tab_mode;

    function Rud_Tab_pos return float is
    begin
       return Container.This_Subsystem.The_Rud_Tab_pos;
    end Rud_Tab_pos;

    function rud_Tab_mode return integer is
    begin
       return Container.This_Subsystem.The_rud_Tab_mode;
    end Rud_tab_mode;

    function Flap_Pos return float is
    begin
       return Container.This_Subsystem.The_Flap_Pos;
    end Flap_Pos;

   function SB_Pos return boolean is
    begin
       return Container.This_Subsystem.The_SB_Pos;
    end SB_Pos;

    function LG_Pos return boolean is
    begin
       return Container.This_Subsystem.The_LG_Pos;
    end LG_Pos;
end JPATS_Auto_Test;
