-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with JPATS_Atmosphere.Container;

with DFW_Microburst;
with Free_Air;
with Microburst;
with NASA_Microburst;
with Steady_State_Wind;
with Turbulence;
with Wind_Gust;
with Wind_Shear;
with Winds;
with Aircraft_Ice;

package body JPATS_Atmosphere is
   Cnt_mb : Microburst.Instance renames Container.This_Subsystem.The_Microburst;
   Cnt_Dfw : Dfw_Microburst.instance renames Container.This_Subsystem.The_DFW_Microburst;
   --| DFW Microburst
   function Get_DFW_Microburst_Radial_Distance_to_Aircraft return Length_Types.Feet is
   begin
      return DFW_Microburst.Get_Radial_Distance_to_Aircraft(cnt_dfw);
   end Get_DFW_Microburst_Radial_Distance_to_Aircraft;

   function Get_DFW_Microburst_Aircraft_x_Distance_Through_Model return Length_Types.Feet is
   begin
      return DFW_Microburst.Get_Aircraft_x_Distance_Through_Model(cnt_dfw);
   end Get_DFW_Microburst_Aircraft_x_Distance_Through_Model;

   function Get_x_Distance_Between_Aircraft_and_DFW_Microburst_Center return Length_Types.Feet is
   begin
      return DFW_Microburst.Get_x_to_MB_cntr(cnt_dfw);
   end Get_x_Distance_Between_Aircraft_and_DFW_Microburst_Center;

   function Get_y_Distance_Between_Aircraft_and_DFW_Microburst_Center return Length_Types.Feet is
   begin
      return DFW_Microburst.Get_y_to_MB_cntr(cnt_dfw);
   end Get_y_Distance_Between_Aircraft_and_DFW_Microburst_Center;

   function Get_DFW_Microburst_Aircraft_Angle_wrt_Microburst_Center return Angle_Types.Radians is
   begin
      return DFW_Microburst.Get_Aircraft_Angle_wrt_Microburst_Center(cnt_dfw);
   end Get_DFW_Microburst_Aircraft_Angle_wrt_Microburst_Center;

   function Get_DFW_Microburst_Local_Velocity return Coordinate_Types.Cartesian is
   begin
      return DFW_Microburst.Get_Local_Velocity(cnt_dfw);
   end Get_DFW_Microburst_Local_Velocity;

   function Get_DFW_Microburst_Local_Pressure return Force_Types.Pounds_per_Sq_Feet is
   begin
      return DFW_Microburst.Get_Local_Pressure(cnt_dfw);
   end Get_DFW_Microburst_Local_Pressure;

   function Get_DFW_Microburst_Local_Temperature return Temperature_Types.Rankine is
   begin
      return DFW_Microburst.Get_Local_Temperature(cnt_dfw);
   end Get_DFW_Microburst_Local_Temperature;

   function Get_DFW_Microburst_Roll_Moment_due_to_Microburst return Float is
   begin
      return DFW_Microburst.Get_Mb_Roll_Mom(cnt_dfw);
   end Get_DFW_Microburst_Roll_Moment_due_to_Microburst;

   --| Microburst
   function Get_Microburst_Intensity return Float is
   begin
      return Microburst.Get_Intensity(cnt_mb);
   end Get_Microburst_Intensity;

   function Get_Microburst_Trigger return Boolean is
   begin
      return Microburst.Trigger(cnt_mb);
   end Get_Microburst_Trigger;

   function Get_Microburst_Magnitude return Float is
   begin
      return Microburst.Get_Magnitude(cnt_mb);
   end Get_Microburst_Magnitude;

   function Get_x_To_Td return Length_Types.Feet is
   begin
      return Microburst.Get_x_To_Td(cnt_mb);
   end Get_x_To_td;

   function Get_y_to_td return Length_Types.Feet is
   begin
      return Microburst.Get_y_To_td(cnt_mb);
   end Get_y_to_td;

   function Get_Microburst_Vel_Ea return Coordinate_Types.Cartesian is
   begin
      return Microburst.Get_Vel_Ea(cnt_mb);
   end Get_Microburst_Vel_Ea;

   function Get_Microburst_Lagged_Wind_Velocity return Coordinate_Types.Cartesian is
   begin
      return Microburst.Get_Lagged_Wind_Velocity(cnt_mb);
   end Get_Microburst_Lagged_Wind_Velocity;

   function Get_Delta_T return Temperature_Types.Rankine is
   begin
      return Microburst.Get_Delta_T(cnt_mb);
   end Get_Delta_T;

   function Get_Delta_P return Force_Types.Pounds_per_Sq_Feet is
   begin
      return Microburst.Get_Delta_P(cnt_mb);
   end Get_Delta_P;

   function Get_Mb_Rad return Length_Types.Feet is
   begin
      return Microburst.Get_Mb_Rad(cnt_mb);
   end Get_Mb_Rad;

   function Get_Mb_Top return Length_Types.Feet is
   begin
      return Microburst.Get_Mb_Top(cnt_mb);
   end Get_Mb_Top;

   --| NASA Microburst
   function Get_NASA_Local_Velocity return Coordinate_Types.Cartesian is
   begin
      return NASA_Microburst.Get_Local_Velocity(Container.This_Subsystem.The_NASA_Microburst);
   end Get_NASA_Local_Velocity;

   --| Steady State Winds
   function Get_Steady_State_Wind_Vel_Ea return Coordinate_Types.Cartesian is
   begin
      return Steady_State_Wind.Get_Vel_Ea(Container.This_Subsystem.The_Steady_State_Wind);
   end Get_Steady_State_Wind_Vel_Ea;

   function Get_Steady_State_Wind_Increment_in_Vel_Ea return Coordinate_Types.Cartesian is
   begin
      return Steady_State_Wind.Get_Increment_in_Vel_Ea(Container.This_Subsystem.The_Steady_State_Wind);
   end Get_Steady_State_Wind_Increment_in_Vel_Ea;

   --| Turbulence
   function Get_Turbulence_Rough_Air_Intensity return Float is
   begin
      return Turbulence.Get_Rough_Air_Intensity(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_Rough_Air_Intensity;

   function Get_Total_Turbulence_Intensity return Float is
   begin
      return Turbulence.Get_Total_Turbulence_Intensity(Container.This_Subsystem.The_Turbulence);
   end Get_Total_Turbulence_Intensity;

   function Get_Turbulence_Scale_Length return Float is
   begin
      return Turbulence.Get_Turbulence_Scale_Length(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_Scale_Length;

   function Get_Turbulence_RMS_Intensity return Coordinate_Types.Cartesian is
   begin
      return Turbulence.Get_RMS_Intensity(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_RMS_Intensity;

   function Get_Turbulence_Mean_Forward_Speed return Length_Types.Feet_per_Sec is
   begin
      return Turbulence.Get_Mean_Forward_Speed(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_Mean_Forward_Speed;

   function Get_Turbulence_State_Vector return Coordinate_Types.Array_Type is
   begin
      return Turbulence.Get_Turbulence_State_Vector(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_State_Vector;

   function Get_Turbulence_V_B return Coordinate_Types.Cartesian is
   begin
      return Turbulence.Get_Turbulence_V_B(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_V_B;

   function Get_Turbulence_Angular_Rate_Body_Axis return Coordinate_Types.Attitude is
   begin
      return Turbulence.Get_Turbulence_Angular_Rate_Body_Axis(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_Angular_Rate_Body_Axis;

   function Get_Turbulence_XNP return Float is
   begin
      return Turbulence.Get_XNP(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_XNP;

   function Get_Turbulence_XINTQ return Float is
   begin
      return Turbulence.Get_XINTQ(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_XINTQ;

   function Get_Turbulence_XNQ return Float is
   begin
      return Turbulence.Get_XNQ(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_XNQ;

   function Get_Turbulence_XINTR return Float is
   begin
      return Turbulence.Get_XINTR(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_XINTR;

   function Get_Turbulence_XNR return Float is
   begin
      return Turbulence.Get_XNR(Container.This_Subsystem.The_Turbulence);
   end Get_Turbulence_XNR;

   --| Wind Gust
   function Get_Wind_Gust_Valid return Boolean is
   begin
      return Wind_Gust.Get_Wind_Gust_Valid(Container.This_Subsystem.The_Wind_Gust);
   end Get_Wind_Gust_Valid;

   function Get_Wind_Gust_Counter return Float is
   begin
      return Wind_Gust.Get_Wind_Gust_Counter(Container.This_Subsystem.The_Wind_Gust);
   end Get_Wind_Gust_Counter;

   function Get_Wind_Gust_Random_Counter return Float is
   begin
      return Wind_Gust.Get_Wind_Gust_Random_Counter(Container.This_Subsystem.The_Wind_Gust);
   end Get_Wind_Gust_Random_Counter;

   function Get_Wind_Gust_New_Output return Float is
   begin
      return Wind_Gust.Get_New_Wind_Gust_Output(Container.This_Subsystem.The_Wind_Gust);
   end Get_Wind_Gust_New_Output;

   function Get_Wind_Gust_Output return Float is
   begin
      return Wind_Gust.Get_Wind_Gust_Output(Container.This_Subsystem.The_Wind_Gust);
   end Get_Wind_Gust_Output;

   function Get_Desired_Wind_Gust_Velocity return Length_Types.Feet_per_Sec is
   begin
      return Wind_Gust.Get_New_Wind_Gust_Output(Container.This_Subsystem.The_Wind_Gust);
   end Get_Desired_Wind_Gust_Velocity;

   function Get_Wind_Gust_Velocity return Length_Types.Feet_per_Sec is
   begin
      return Wind_Gust.Get_Wind_Gust_Velocity(Container.This_Subsystem.The_Wind_Gust);
   end Get_Wind_Gust_Velocity;

   function Get_Wind_Gust_Vel_Ea return Coordinate_Types.Cartesian is
   begin
      return Wind_Gust.Get_Vel_Ea(Container.This_Subsystem.The_Wind_Gust);
   end Get_Wind_Gust_Vel_Ea;

   function Get_Wind_Gust_Direction return Angle_Types.Radians is
   begin
      return Wind_Gust.Get_Direction(Container.This_Subsystem.The_Wind_Gust);
   end Get_Wind_Gust_Direction;

   function Get_Wind_Training_Direction return Angle_Types.Radians is
   begin
      return Wind_Gust.Get_Wind_Training_Direction(Container.This_Subsystem.The_Wind_Gust);
   end Get_Wind_Training_Direction;

   --| Wind Shear
   function Get_Wind_Shear_Trigger return Boolean is
   begin
      return Wind_Shear.Trigger(Container.This_Subsystem.The_Wind_Shear);
   end Get_Wind_Shear_Trigger;

   function Get_Wind_Shear_Intensity return Float is
   begin
      return Wind_Shear.Get_Intensity(Container.This_Subsystem.The_Wind_Shear);
   end Get_Wind_Shear_Intensity;

   function Get_Wind_Shear_Wind_Factor return Float is
   begin
      return Wind_Shear.Get_Wind_Factor(Container.This_Subsystem.The_Wind_Shear);
   end Get_Wind_Shear_Wind_Factor;

   function Get_Wind_Shear_Magnitude return Float is
   begin
      return Wind_Shear.Get_Magnitude(Container.This_Subsystem.The_Wind_Shear);
   end Get_Wind_Shear_Magnitude;

   function Get_Aircraft_dist_into_ws return Length_Types.Feet is
   begin
      return Wind_Shear.Get_dist_into_ws(Container.This_Subsystem.The_Wind_Shear);
   end Get_Aircraft_dist_into_ws;

   function Get_Wind_Shear_Lagged_Wind_Velocity return Coordinate_Types.Cartesian is
   begin
      return Wind_Shear.Get_Lagged_Wind_Velocity(Container.This_Subsystem.The_Wind_Shear);
   end Get_Wind_Shear_Lagged_Wind_Velocity;

   function Get_Wind_Shear_Vel_Ea return Coordinate_Types.Cartesian is
   begin
      return Wind_Shear.Get_Vel_Ea(Container.This_Subsystem.The_Wind_Shear);
   end Get_Wind_Shear_Vel_Ea;

   function Get_Wind_Shear_Turbulence_Intensity return Float is
   begin
      return Wind_Shear.Get_Turbulence_Intensity(Container.This_Subsystem.The_Wind_Shear);
   end Get_Wind_Shear_Turbulence_Intensity;

   --| Winds
   function Get_Surface_Wind_Velocity return Length_Types.Feet_per_Sec is
   begin
      return Winds.Get_Surface_Wind_Velocity(Container.This_Subsystem.The_Winds);
   end Get_Surface_Wind_Velocity;

   function Get_Surface_Wind_Altitude return Length_Types.Feet is
   begin
      return Winds.Get_Surface_Wind_Altitude(Container.This_Subsystem.The_Winds);
   end Get_Surface_Wind_Altitude;

   function Get_Surface_Wind_Direction return Angle_Types.Radians is
   begin
      return Winds.Get_Surface_Wind_Direction(Container.This_Subsystem.The_Winds);
   end Get_Surface_Wind_Direction;

   function Get_Cruise_Wind_Velocity return Length_Types.Feet_per_Sec is
   begin
      return Winds.Get_Cruise_Wind_Velocity(Container.This_Subsystem.The_Winds);
   end Get_Cruise_Wind_Velocity;

   function Get_Cruise_Wind_Altitude return Length_Types.Feet is
   begin
      return Winds.Get_Cruise_Wind_Altitude(Container.This_Subsystem.The_Winds);
   end Get_Cruise_Wind_Altitude;

   function Get_Cruise_Wind_Direction return Angle_Types.Radians is
   begin
      return Winds.Get_Cruise_Wind_Direction(Container.This_Subsystem.The_Winds);
   end Get_Cruise_Wind_Direction;

   function Get_Cross_Wind_Velocity return Length_Types.Feet_per_Sec is
   begin
      return Winds.Get_Cross_Wind_Velocity(Container.This_Subsystem.The_Winds);
   end Get_Cross_Wind_Velocity;

   function Get_Cross_Wind_Altitude return Length_Types.Feet is
   begin
      return Winds.Get_Cross_Wind_Altitude(Container.This_Subsystem.The_Winds);
   end Get_Cross_Wind_Altitude;

   function Get_Cross_Wind_Direction return Angle_Types.Radians is
   begin
      return Winds.Get_Cross_Wind_Direction(Container.This_Subsystem.The_Winds);
   end Get_Cross_Wind_Direction;

   function Get_Winds_Velocity_Slope return Float is
   begin
      return Winds.Get_Velocity_Slope(Container.This_Subsystem.The_Winds);
   end Get_Winds_Velocity_Slope;

   function Get_Winds_Direction_Slope return Float is
   begin
      return Winds.Get_Direction_Slope(Container.This_Subsystem.The_Winds);
   end Get_Winds_Direction_Slope;

   function Get_Wind_Velocity return Length_Types.Feet_per_Sec is
   begin
      return Winds.Get_Wind_Velocity(Container.This_Subsystem.The_Winds);
   end Get_Wind_Velocity;

   function Get_Wind_Direction return Angle_Types.Radians is
   begin
      return Winds.Get_Wind_Direction(Container.This_Subsystem.The_Winds);
   end Get_Wind_Direction;

   --| This function will give the SUMMED wind velocities generated by the atmospheric phenomenon of
   --| 1. A_Steady_State_Wind
   --| 2. A_Steady_State_Winds_Increments
   --| 3. A_Wind_Gust
   --| 4. A_Microburst and
   --| 5. A_Wind_Shear
   function Get_Wind_Vel_Ea return Coordinate_Types.Cartesian is
   begin
      return Winds.Get_Wind_Vel_Ea(Container.This_Subsystem.The_Winds);
   end Get_Wind_Vel_Ea;

   function Get_Display_Head_Wind_Velocity return Length_Types.Feet_per_Sec is
   begin
      return Winds.Get_Display_Head_Wind_Velocity(Container.This_Subsystem.The_Winds);
   end Get_Display_Head_Wind_Velocity;

   function Get_Display_Cross_Wind_Velocity return Length_Types.Feet_per_Sec is
   begin
      return Winds.Get_Display_Cross_Wind_Velocity(Container.This_Subsystem.The_Winds);
   end Get_Display_Cross_Wind_Velocity;
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- free air
   function Temperature return Temperature_Types.Rankine is
      begin
      return Free_Air.oat(Container.This_Subsystem.The_Free_air);
   end Temperature;

   function Density return Mass_Types.Slugs_per_Cubic_Feet is
      begin
        return Free_Air.density(Container.This_Subsystem.The_Free_air);
   end Density;

   function Pressure_ratio return Normalized_Types.Normalize is
      begin
        return Free_Air.Pressure_Ratio(Container.This_Subsystem.The_Free_air);
      end Pressure_ratio;

   function Pressure return Force_Types.Inches_of_Hg is
   begin
      return Free_Air.Pressure(Container.This_Subsystem.The_Free_air);
   end Pressure;

    function Sl_Pressure return Force_Types.Inches_of_Hg is
   begin
      return Free_Air.Sl_Pressure(Container.This_Subsystem.The_Free_air);
   end Sl_Pressure;

   function temperature_ratio return Normalized_Types.Normalize is
      begin
        return Free_Air.temp_Ratio(Container.This_Subsystem.The_Free_air);
    end temperature_ratio;

-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   function Angle_of_Attack_Vane_Ice return Float is
   begin
      return 0.0;
   end Angle_Of_Attack_Vane_Ice;

   function Primary_Pitot_Ice return Float is
   begin
      return Aircraft_Ice.Primary_Pitot_ice(Container.This_Subsystem.The_Aircraft_ice);
   end Primary_Pitot_Ice;

   function standby_Pitot_Ice return Float is
   begin
      return Aircraft_Ice.Secondary_Pitot_ice(Container.This_Subsystem.The_Aircraft_ice);
   end Standby_Pitot_Ice;

   function Get_Ice_Acculmulation_Factor_Wing_Body_Plus return Float is
   begin
      return 0.0;
   end Get_Ice_Acculmulation_Factor_Wing_Body_Plus;

   function Flat_tire return Boolean is
   begin
      return Container.This_Ios_interface.Flat_tire;
   end Flat_tire;

   function midair return Boolean is
   begin
      return Container.This_Ios_interface.midair;
   end midair;

  function Shaker_malf return Boolean is
   begin
      return Container.This_Ios_interface.Shaker_malf;
   end Shaker_malf;

end JPATS_Atmosphere;
