-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer: Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Ada.Text_Io;
with Class_Test_Result_File;
with Hartzell_4_Blade_Propeller_Geometry;

with Angle_Types;
with Jpats_Propeller_Types;
with Vector_Types;
use  Vector_Types;
with Normalized_Types;
with Torque_Types;
with Force_Types;
with Mass_Types;
with Length_Types;

procedure Hartzell_4_Blade_Propeller_Geometry_Ctd is

begin

  Ada.Text_Io.Put_Line ("Hartzell_4_Blade_Propeller_Geometry_Ctd.exe is executing.");

Test_1 :
  -------------------------------------------
  -- Test Case 1
  -- Test the Initialized and Accessor functions
  -- Inputs           : A Valid Hartzell_4_Blade_Propeller_Geometry Class
  -- Expected Results : A query of all accessor functions should
  --                    show that all of the initialized instance
  --                    variables are set to the correct values
  --                    thus, testing the initialize and accessor
  --                    functions.
  -- Purpose          : Test the update and initialize functions
  -- Interface Tested : Hartzell_4_Blade_Propeller_Geometry.Initialize
  --                    Hartzell_4_Blade_Propeller_Geometry.Propeller_Inertia_Ipgyro
  --                    Hartzell_4_Blade_Propeller_Geometry.Propeller_Diameter
  --                    Hartzell_4_Blade_Propeller_Geometry.Wetted_Surface_Area
  --                    Hartzell_4_Blade_Propeller_Geometry.Low_Pitch_Stop
  --                    Hartzell_4_Blade_Propeller_Geometry.High_Pitch_Stop
  --
  --------------------------------------------

  declare
    The_Propeller_Geometry              : Hartzell_4_Blade_Propeller_Geometry.Instance;
    Test_Ipgyro                       : Mass_Types.Slugs_Feet_Sq;
    Test_Diameter                     : Length_Types.Feet;
    Test_Area                         : Length_Types.Sq_Feet;
    Test_Low_Pitch                    : Angle_Types.Degrees;
    Test_High_Pitch                   : Angle_Types.Degrees;
    Test_Number : Integer := 1;
    Test_Result : Boolean;
    Test_Init   : Boolean;
  begin

    Hartzell_4_Blade_Propeller_Geometry.Initialize
      (An_Instance => The_Propeller_Geometry);

    -- Use the accessor function to check the initialize function and the accessor functions

    -- Access Propeller_Inertia_Ipgyro
--  Test_Number := 1;
    Test_Ipgyro := Hartzell_4_Blade_Propeller_Geometry.Propeller_Inertia_Ipgyro
      (An_Instance => The_Propeller_Geometry);
    Test_Result :=  Test_Ipgyro = Mass_Types.Slugs_Feet_Sq(8.97);
--  Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
    Test_Init := Test_Result;

    -- Access Propeller_Diameter
--  Test_Number := 2;
    Test_Diameter := Hartzell_4_Blade_Propeller_Geometry.Propeller_Diameter
      (An_Instance => The_Propeller_Geometry);
    Test_Result := Test_Diameter = Length_Types.Feet(8.083);
--  Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
    Test_Init := Test_Init and Test_Result;

    -- Access Wetted_Surface_Area
--  Test_Number := 3;
    Test_Area := Hartzell_4_Blade_Propeller_Geometry.Wetted_Surface_Area
      (An_Instance => The_Propeller_Geometry);
    Test_Result := Test_Area = Length_Types.Sq_feet(173.5);
--  Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
    Test_Init := Test_Init and Test_Result;

    -- Access Low_Pitch_Stop
--  Test_Number := 4;
    Test_Low_Pitch := Hartzell_4_Blade_Propeller_Geometry.Low_Pitch_Stop
      (An_Instance => The_Propeller_Geometry);
    Test_Result := Test_Low_Pitch = Angle_Types.Degrees(9.9);
--  Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
    Test_Init := Test_Init and Test_Result;

    -- Access High_Pitch_Stop
--  Test_Number := 5;
    Test_High_Pitch := Hartzell_4_Blade_Propeller_Geometry.High_Pitch_Stop
      (An_Instance => The_Propeller_Geometry);
    Test_Result := Test_High_Pitch = Angle_Types.Degrees(84.0);
    Test_Init := Test_Init and Test_Result;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Init, Number => Test_Number);

  end Test_1;

Test_2 :
  -------------------------------------------
  -- Test Case 2
  -- Test the Set and Accessor functions
  -- Inputs           : A Valid Hartzell_4_Blade_Propeller_Geometry Class
  -- Expected Results : A set and query of the accessor functions should
  --                    show that the initialized instance variables are
  --                    set to the correct values.
  -- Purpose          : Test the set function for Low_Pitch_Stop
  -- Interface Tested : Hartzell_4_Blade_Propeller_Geometry.Set_Low_Pitch_Stop
  --
  --------------------------------------------

  -- Access Low_Pitch_Stop
  declare
    Test_Number : Integer := 2;
    Test_Result : Boolean;
    The_Propeller_Geometry            : Hartzell_4_Blade_Propeller_Geometry.Instance;
    Value_In                          : Angle_Types.Degrees;
    Value_Out                         : Angle_Types.Degrees;
  begin
    Value_In := Angle_Types.Degrees(82.45);
    Hartzell_4_Blade_Propeller_Geometry.Low_Pitch_Stop
      (An_Instance => The_Propeller_Geometry,
       Low_Pitch_Stop => Value_In);
    Value_Out := Hartzell_4_Blade_Propeller_Geometry.Low_Pitch_Stop
      (An_Instance => The_Propeller_Geometry);
    Test_Result :=  Value_Out = Value_In;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end Test_2;

Test_3 :
  -------------------------------------------
  -- Test Case 3
  -- Test the Set and Accessor functions
  -- Inputs           : A Valid Hartzell_4_Blade_Propeller_Geometry Class
  -- Expected Results : A set and query of the accessor functions should
  --                    show that the initialized instance variables are
  --                    set to the correct values.
  -- Purpose          : Test the set function for High_Pitch_Stop
  -- Interface Tested : Hartzell_4_Blade_Propeller_Geometry.Set_High_Pitch_Stop
  --
  --------------------------------------------
    -- Access High_Pitch_Stop
  declare
    Test_Number : Integer := 3;
    Test_Result : Boolean;
    The_Propeller_Geometry            : Hartzell_4_Blade_Propeller_Geometry.Instance;
    Value_In                          : Angle_Types.Degrees;
    Value_Out                         : Angle_Types.Degrees;
  begin
    Value_In := Angle_Types.Degrees(87.45);
    Hartzell_4_Blade_Propeller_Geometry.High_Pitch_Stop
      (An_Instance => The_Propeller_Geometry,
       High_Pitch_Stop => Value_In);
    Value_Out := Hartzell_4_Blade_Propeller_Geometry.High_Pitch_Stop
      (An_Instance => The_Propeller_Geometry);
    Test_Result :=  Value_Out = Value_In;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end Test_3;

Test_4 :
  -------------------------------------------
  -- Test Case 4
  -- Test the Set and Accessor functions
  -- Inputs           : A Valid Hartzell_4_Blade_Propeller_Geometry Class
  -- Expected Results : A set and query of the accessor functions should
  --                    show that the initialized instance variables are
  --                    set to the correct values.
  -- Purpose          : Test the set function for Wetted_Surface_Area
  -- Interface Tested : Hartzell_4_Blade_Propeller_Geometry.Set_Wetted_Surface_Area
  --
  --------------------------------------------
  -- Access Wetted_Surface_Area
  declare
    Test_Number : Integer := 4;
    Test_Result : Boolean;
    The_Propeller_Geometry            : Hartzell_4_Blade_Propeller_Geometry.Instance;
    Value_In                          : Length_Types.Sq_Feet;
    Value_Out                         : Length_Types.Sq_Feet;
  begin
    Value_In := Length_Types.Sq_Feet(42.45);
    Hartzell_4_Blade_Propeller_Geometry.Wetted_Surface_Area
      (An_Instance => The_Propeller_Geometry,
       Wetted_Surface_Area  => Value_In);
    Value_Out := Hartzell_4_Blade_Propeller_Geometry.Wetted_Surface_Area
      (An_Instance => The_Propeller_Geometry);
    Test_Result :=  Value_Out = Value_In;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end Test_4;

Test_5 :
  -------------------------------------------
  -- Test Case 5
  -- Test the Set and Accessor functions
  -- Inputs           : A Valid Hartzell_4_Blade_Propeller_Geometry Class
  -- Expected Results : A set and query of the accessor functions should
  --                    show that the initialized instance variables are
  --                    set to the correct values.
  -- Purpose          : Test the set function for Propeller_Diameter
  -- Interface Tested : Hartzell_4_Blade_Propeller_Geometry.Set_Propeller_Diameter
  --
  --------------------------------------------
    -- Access Propeller_Diameter
  declare
    Test_Number : Integer := 5;
    Test_Result : Boolean;
    The_Propeller_Geometry            : Hartzell_4_Blade_Propeller_Geometry.Instance;
    Value_In                          : Length_Types.Feet;
    Value_Out                         : Length_Types.Feet;
  begin
    Value_In := Length_Types.Feet(42.3335);
    Hartzell_4_Blade_Propeller_Geometry.Propeller_Diameter
      (An_Instance => The_Propeller_Geometry,
       Propeller_Diameter  => Value_In);
    Value_Out := Hartzell_4_Blade_Propeller_Geometry.Propeller_Diameter
      (An_Instance => The_Propeller_Geometry);
    Test_Result :=  Value_Out = Value_In;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end Test_5;

Test_6 :
  -------------------------------------------
  -- Test Case 6
  -- Test the Set and Accessor functions
  -- Inputs           : A Valid Hartzell_4_Blade_Propeller_Geometry Class
  -- Expected Results : A set and query of the accessor functions should
  --                    show that the initialized instance variables are
  --                    set to the correct values.
  -- Purpose          : Test the set function for Propeller_Inertia_Ipgyro
  -- Interface Tested : Hartzell_4_Blade_Propeller_Geometry.Set_Propeller_Inertia_Ipgyro
  --
  --------------------------------------------
  -- Access Propeller_Inertia_Ipgyro
  declare
    Test_Number : Integer := 6;
    Test_Result : Boolean;
    The_Propeller_Geometry            : Hartzell_4_Blade_Propeller_Geometry.Instance;
    Value_In                          : Mass_Types.Slugs_Feet_Sq;
    Value_Out                         : Mass_Types.Slugs_Feet_Sq;
  begin
    Value_In := Mass_Types.Slugs_Feet_Sq(432.3335);
    Hartzell_4_Blade_Propeller_Geometry.Propeller_Inertia_Ipgyro
      (An_Instance => The_Propeller_Geometry,
       Propeller_Inertia_Ipgyro  => Value_In);
    Value_Out := Hartzell_4_Blade_Propeller_Geometry.Propeller_Inertia_Ipgyro
      (An_Instance => The_Propeller_Geometry);
    Test_Result :=  Value_Out = Value_In;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end Test_6;

  Ada.Text_Io.Put_Line ("Hartzell_4_Blade_Propeller_Geometry_Ctd.exe is finished.");

end Hartzell_4_Blade_Propeller_Geometry_Ctd;







