-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer: Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Ada.Text_Io;
with Ada.Float_Text_Io;
with Class_Test_Result_File;
with Hartzell_4_Blade_Propeller;
with Jpats_Propeller_Types;
use  Jpats_Propeller_Types;
with Angle_Types;
with Jpats_Propeller_Types;
with Vector_Types;
use  Vector_Types;
with Normalized_Types;
with Torque_Types;
with Force_Types;
with Mass_Types;
with Length_Types;
with Electrical_Units_Types;

procedure Hartzell_4_Blade_Propeller_Ctd is
  use type Jpats_Propeller_Types.Force_Vector_Type.Instance;
  use type Jpats_Propeller_Types.Torque_Vector_Type.Instance;

  function "=" (A : in Jpats_Propeller_Types.Torque_Vector_Type.Instance;
                  B : in Jpats_Propeller_Types.Torque_Vector_Type.Instance) return Boolean is
    begin
      return A(X) = B(X) and A(Y)=B(Y) and A(Z)=B(Z) ;
    end "=";

    function "=" (A : in Jpats_Propeller_Types.Force_Vector_Type.Instance;
                  B : in Jpats_Propeller_Types.Force_Vector_Type.Instance) return Boolean is
    begin
      return A(X) = B(X) and A(Y)=B(Y) and A(Z)=B(Z) ;
    end "=";

    function "=" (A : in Jpats_Propeller_Types.Propeller_Angular_Rate_Vector_Type.Instance;
                  B : in Jpats_Propeller_Types.Propeller_Angular_Rate_Vector_Type.Instance) return Boolean is
    begin
      return A(X) = B(X) and A(Y)=B(Y) and A(Z)=B(Z) ;
    end "=";


begin

  Ada.Text_Io.Put_Line ("Hartzell_4_Blade_Propeller_Ctd.exe is executing.");

  -- Set up File path

  -- Test the initialize function
  declare
    Test_Result       : Boolean;
    Test_Number       : Integer := 1;
    The_Propeller     : Hartzell_4_Blade_Propeller.Instance;
    Axial_Thrust      : Jpats_Propeller_Types.Force_Vector_Type.Instance;
    Axial_Torque      : Jpats_Propeller_Types.Torque_Vector_Type.Instance;
    Axial_Coeff       : Normalized_Types.Normalize;
  begin
    Hartzell_4_Blade_Propeller.Read_Tables;

    Hartzell_4_Blade_Propeller.Initialize
      (An_Instance => The_Propeller);

    -- Use the accessor function to check the initialize function and the accessor functions

    -- Access Axial_Thrust
    Test_Number := 1;
    Axial_Thrust := Hartzell_4_Blade_Propeller.Axial_Thrust
      (An_Instance => The_Propeller);
    Test_Result :=  Axial_Thrust = (0.0,0.0,0.0);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);

    -- Access Axial_Thrust_Coefficient_Limited
    Test_Number := 2;
    Axial_Coeff := Hartzell_4_Blade_Propeller.Axial_Thrust_Coefficient_Limited
      (An_Instance => The_Propeller);
    Test_Result := Axial_Coeff = Normalized_Types.Normalize(0.0);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);

    -- Access Axial_Torque_Absorbed
    Test_Number := 3;
    Axial_Torque := Hartzell_4_Blade_Propeller.Axial_Torque_Absorbed
      (An_Instance => The_Propeller);
    Test_Result := Axial_Torque = (Torque_Types.Ft_Lbf(0.0),Torque_Types.Ft_Lbf(0.0),Torque_Types.Ft_Lbf(0.0));
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);

  end;

-- Test the propeller for Stopped, No-Rotation conditions on the ground.
  declare
    Test_Result               : Boolean;
    Test_Number               : Integer := 4;
    Next_Propeller            : Hartzell_4_Blade_Propeller.Instance;
    This_Propeller            : Hartzell_4_Blade_Propeller.Instance;
    Test_Prop_Rpm             : Jpats_Propeller_Types.Propeller_Angular_Rate_Vector_Type.Instance;
    Thrust                    : Jpats_Propeller_Types.Force_Vector_Type.Instance;
    Torque                    : Jpats_Propeller_Types.Torque_Vector_Type.Instance;
    Aircraft_Angular_Rate     : Jpats_Propeller_Types.Angular_Rate_Vector_Type.Instance;
    Iconst                    : Float;
    Air_Density               : Mass_Types.Slugs_Per_Cubic_Feet;
    Ambient_Temperature_Ratio : Normalized_Types.Normalize;
    Mach                      : Normalized_Types.Normalize;
    Delta_Blade_Angle         : Angle_Types.Degrees;
    Dynamic_Pressure          : Force_Types.Pounds_Per_Sq_Feet;
    Propeller_Angle_Of_Attack : Angle_Types.Degrees;
    Aircraft_Forward_Velocity : Length_Types.Feet_Per_Sec;

  begin
    Hartzell_4_Blade_Propeller.Read_Tables;

    Hartzell_4_Blade_Propeller.Initialize(An_Instance => This_Propeller);
    Hartzell_4_Blade_Propeller.Initialize(An_Instance => Next_Propeller);

-- Method Update
    Iconst := 1.0/15.0;
    Air_Density := 0.0023769;  -- slugs/ft cubed
    Ambient_Temperature_Ratio := 1.0;
    Mach := 0.0;
    Dynamic_Pressure := 0.00001;
    Aircraft_Angular_Rate := (0.0,0.0,0.0);
    Test_Prop_Rpm := (0.0,0.0,0.0);
    Delta_Blade_Angle := 0.0;
    Propeller_Angle_Of_Attack := Angle_Types.Degrees(2.50);
    Aircraft_Forward_Velocity := Length_Types.Feet_Per_Sec(0.0);

    Hartzell_4_Blade_Propeller.Update
      ( Next_Instance              => Next_Propeller,
        This_Instance              => This_Propeller,
        Iconst                     => Iconst,
        Air_Density                => Air_Density,
        Ambient_Temperature_Ratio  => Ambient_Temperature_Ratio,
        Mach                       => Mach,
        Dynamic_Pressure           => Dynamic_Pressure,
        Aircraft_Angular_Rate      => Aircraft_Angular_Rate,
        Prop_Rpm                   => Test_Prop_Rpm,
        Delta_Blade_Angle          => Delta_Blade_Angle,
        Propeller_Angle_Of_Attack  => Propeller_Angle_Of_Attack,
        Aircraft_Forward_Velocity  => Aircraft_Forward_Velocity);


    Thrust := Hartzell_4_Blade_Propeller.Axial_Thrust
      (An_Instance => Next_Propeller);
    Torque := Hartzell_4_Blade_Propeller.Axial_Torque_Absorbed
      (An_Instance => Next_Propeller);
    Test_Result := abs(Jpats_Propeller_Types.Force_Vector_Type.Magnitude(Thrust - (0.0,0.0,0.0))) < 0.001 and
                   abs(Jpats_Propeller_Types.Torque_Vector_Type.Magnitude(Torque - (0.0,0.0,0.0))) < 0.001;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;

Test_5:

    -- Test the propeller for Stopped, No-Rotation conditions on the ground.
    declare
      Test_Result           : Boolean;
      Test_Number           : Integer := 5;
      Next_Propeller        : Hartzell_4_Blade_Propeller.Instance;
      This_Propeller        : Hartzell_4_Blade_Propeller.Instance;
      Test_Prop_Rpm         : Jpats_Propeller_Types.Propeller_Angular_Rate_Vector_Type.Instance;
      Thrust                : Jpats_Propeller_Types.Force_Vector_Type.Instance;
      Torque                : Jpats_Propeller_Types.Torque_Vector_Type.Instance;
      Aircraft_Angular_Rate : Jpats_Propeller_Types.Angular_Rate_Vector_Type.Instance;

      Iconst                    : Float;
      Air_Density               : Mass_Types.Slugs_Per_Cubic_Feet;
      Ambient_Temperature_Ratio : Normalized_Types.Normalize;
      Mach                      : Normalized_Types.Normalize;
      Delta_Blade_Angle         : Angle_Types.Degrees;
      Dynamic_Pressure          : Force_Types.Pounds_Per_Sq_Feet;
      Propeller_Angle_Of_Attack : Angle_Types.Degrees;
      Aircraft_Forward_Velocity : Length_Types.Feet_Per_Sec;

--       function "-" ( Left : Jpats_Propeller_Types.Force_Vector_Type.Instance;
--                      Right: Jpats_Propeller_Types.Force_Vector_Type.Instance)
--       return
--       Jpats_Propeller_Types.Force_Vector_Type.Instance is
--
--       begin
--         return
--           (Left(X)-Right(X), Left(Y)-Right(Y), Left(Z)-Right(Z));
--       end "-";
--       function "-" ( Left : Jpats_Propeller_Types.Torque_Vector_Type.Instance;
--                      Right: Jpats_Propeller_Types.Torque_Vector_Type.Instance)
--       return      Jpats_Propeller_Types.Torque_Vector_Type.Instance is
--
--       begin
--         return
--           (Left(X)-Right(X), Left(Y)-Right(Y), Left(Z)-Right(Z));
--       end "-";

    begin
    Hartzell_4_Blade_Propeller.Read_Tables;

      Hartzell_4_Blade_Propeller.Initialize(An_Instance => This_Propeller);
      Hartzell_4_Blade_Propeller.Initialize(An_Instance => Next_Propeller);

      -- Method Update
      Iconst := 1.0/15.0;
      Air_Density := 0.0023769;  -- slugs/ft cubed
      Ambient_Temperature_Ratio := 1.0;
      Mach := 0.0;
      Dynamic_Pressure := 0.00001;
      Aircraft_Angular_Rate := (0.0,0.0,0.0);
      Test_Prop_Rpm := (2000.0,0.0,0.0);
      Delta_Blade_Angle := 0.0;
      Propeller_Angle_Of_Attack := Angle_Types.Degrees(0.0);
      Aircraft_Forward_Velocity := Length_Types.Feet_Per_Sec(0.0);

      Hartzell_4_Blade_Propeller.Update
        ( Next_Instance              => Next_Propeller,
          This_Instance              => This_Propeller,
          Iconst                     => Iconst,
          Air_Density                => Air_Density,
          Ambient_Temperature_Ratio  => Ambient_Temperature_Ratio,
          Mach                       => Mach,
          Dynamic_Pressure           => Dynamic_Pressure,
          Aircraft_Angular_Rate      => Aircraft_Angular_Rate,
          Prop_Rpm                   => Test_Prop_Rpm,
          Delta_Blade_Angle          => Delta_Blade_Angle,
          Propeller_Angle_Of_Attack  => Propeller_Angle_Of_Attack,
          Aircraft_Forward_Velocity  => Aircraft_Forward_Velocity);


      Thrust := Hartzell_4_Blade_Propeller.Axial_Thrust
        (An_Instance => Next_Propeller);
      Torque := Hartzell_4_Blade_Propeller.Axial_Torque_Absorbed
        (An_Instance => Next_Propeller);
--      Ada.Text_Io.Put (Float'Image(Thrust(X)));
--      Ada.Text_Io.Put (Float'Image(Thrust(Y)));
--      Ada.Text_Io.Put (Float'Image(Thrust(Z)));
--      Ada.Text_Io.New_line;
--      Ada.Text_Io.Put (float'Image(Torque(X)));
--      Ada.Text_Io.Put (float'Image(Torque(Y)));
--      Ada.Text_Io.Put (float'Image(Torque(Z)));
--      Ada.Text_Io.New_line;
      Test_Result :=
        abs(Jpats_Propeller_Types.Force_Vector_Type.Magnitude
         (Thrust - (Force_Types.Lbf(0.0),Force_Types.Lbf(0.0),Force_Types.Lbf(0.0)))) < 0.0001
      and
        abs(Jpats_Propeller_Types.Torque_Vector_Type.Magnitude
         (Torque - (Torque_Types.Ft_Lbf(9223.77),Torque_Types.Ft_Lbf(0.0),Torque_Types.Ft_Lbf(0.0))))/14502.8 < 0.0001;
      Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);

    end Test_5;


    Ada.Text_Io.Put_Line ("Hartzell_4_Blade_Propeller_Ctd.exe is finished.");

end Hartzell_4_Blade_Propeller_Ctd;











