-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Stepper_Motor;
with Ada.Text_Io;
with Ada.Float_Text_Io;
with Class_Test_Result_File;

procedure Stepper_Motor_Ctd is

  subtype Step_Type is Integer range 0 .. 338;


  package Discrete_Stepper_Motor is new Stepper_Motor
    ( Step_Type => Step_Type);

  Test_Number : Integer;
  Test_Result : Boolean;

begin
-- Test Number 1  Check Initialize and Accessor Functions
  declare
    Next_Stepper_Motor : Discrete_Stepper_Motor.Instance;
    This_Stepper_Motor : Discrete_Stepper_Motor.Instance;
    Time     : Float := 0.0;
    Iconst   : Float := 1.0/15.0;
    Smp_Req  : Step_Type := 0;
    This_Smp : Step_Type := 0;
    Next_Smp : Step_Type := 0;

  begin
    Test_Number := 1;
    Discrete_Stepper_Motor.Initialize
      (An_Instance => Next_Stepper_Motor);
    Discrete_Stepper_Motor.Initialize
       (An_Instance => This_Stepper_Motor);

    Test_Result := (Discrete_Stepper_Motor.Position
      (An_Instance => Next_Stepper_Motor) = Step_Type'First)
      and
      (Discrete_Stepper_Motor.Position
      (An_Instance => This_Stepper_Motor) = Step_Type'First);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);

  end;





  -- Dynamic Test Number 2  Test Normal Range of Smp input
  declare

    Next_Stepper_Motor : Discrete_Stepper_Motor.Instance;
    This_Stepper_Motor : Discrete_Stepper_Motor.Instance;
--  Swap_Stepper_Motor : Discrete_Stepper_Motor.Instance;
    Time     : Float := 0.0;
    Iconst   : Float := 1.0/15.0;
    Smp_Req  : Step_Type := 0;
    This_Smp : Step_Type := 0;
    Next_Smp : Step_Type := 0;
    Actual_Value : Step_Type;
  begin
    Test_Number := 2;
    Discrete_Stepper_Motor.Initialize
      (An_Instance => Next_Stepper_Motor);
    Discrete_Stepper_Motor.Initialize
       (An_Instance => This_Stepper_Motor);

--    Ada.Text_Io.Put_Line ("     Time     SMP_Req  This_SMP Next_Smp");

    while Time < 4.0 loop
      Time := Time + Iconst;
      Smp_Req := Smp_Req + Integer(400.0/5.0*Iconst);
      Discrete_Stepper_Motor.Update
        (Next_Instance => Next_Stepper_Motor,
         This_Instance => This_Stepper_Motor,
         Iconst        => Iconst,
         Position_Requested => Smp_Req);

      This_Smp := Discrete_Stepper_Motor.Position (An_Instance => This_Stepper_Motor);
      Next_Smp := Discrete_Stepper_Motor.Position (An_Instance => Next_Stepper_Motor);
--    Ada.Text_Io.Put_Line(Float'Image(Time) & ",   " & Integer'Image(Smp_Req) & ",      " & Integer'Image(This_Smp) & ",      " & Integer'Image(Next_Smp));

      Smp_Req := Smp_Req + Integer(400.0/5.0*Iconst);
      Time := Time + Iconst;
      Discrete_Stepper_Motor.Update
        (Next_Instance                    => This_Stepper_Motor,
         This_Instance                    => Next_Stepper_Motor,
         Iconst                           => Iconst,
         Position_Requested => Smp_Req);

      This_Smp := Discrete_Stepper_Motor.Position (An_Instance => Next_Stepper_Motor);
      Next_Smp := Discrete_Stepper_Motor.Position (An_Instance => This_Stepper_Motor);
--    Ada.Text_Io.Put_Line(Float'Image(Time) & ",   " & Integer'Image(Smp_Req) & ",      " & Integer'Image(This_Smp) & ",      " & Integer'Image(Next_Smp));

    end loop;
    Actual_Value :=  Integer(400.0/5.0*4.0);
    Test_Result := abs((Next_Smp - Actual_Value)/Actual_Value) < 1;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;

  -- Test 3  Any input beyond the limits of the step type causes compile error.
  declare

    Next_Stepper_Motor : Discrete_Stepper_Motor.Instance;
    This_Stepper_Motor : Discrete_Stepper_Motor.Instance;
--  Swap_Stepper_Motor : Discrete_Stepper_Motor.Instance;
    Time     : Float := 0.0;
    Iconst   : Float := 1.0/15.0;
    Smp_Req  : Step_Type := 0;
    This_Smp : Step_Type := 0;
    Next_Smp : Step_Type := 0;
    Actual_Value : Step_Type;
  begin
    Test_Number := 3;
    Discrete_Stepper_Motor.Initialize
      (An_Instance => Next_Stepper_Motor);
    Discrete_Stepper_Motor.Initialize
       (An_Instance => This_Stepper_Motor);

      Smp_Req := Step_Type'Last;
      Discrete_Stepper_Motor.Update
        (Next_Instance => Next_Stepper_Motor,
         This_Instance => This_Stepper_Motor,
         Iconst        => Iconst,
         Position_Requested => Smp_Req);

      This_Smp := Discrete_Stepper_Motor.Position (An_Instance => This_Stepper_Motor);
      Next_Smp := Discrete_Stepper_Motor.Position (An_Instance => Next_Stepper_Motor);

      Actual_Value := 338;
    Test_Result := abs((Next_Smp - Actual_Value)/Actual_Value) < 1;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;

  -- Test 4  Any input beyond the limits of the step type causes compile error.
  declare

    Next_Stepper_Motor : Discrete_Stepper_Motor.Instance;
    This_Stepper_Motor : Discrete_Stepper_Motor.Instance;
--  Swap_Stepper_Motor : Discrete_Stepper_Motor.Instance;
    Time     : Float := 0.0;
    Iconst   : Float := 1.0/15.0;
    Smp_Req  : Step_Type := 0;
    This_Smp : Step_Type := 0;
    Next_Smp : Step_Type := 0;
    Actual_Value : Step_Type;
  begin
    Test_Number := 4;
    Discrete_Stepper_Motor.Initialize
      (An_Instance => Next_Stepper_Motor);
    Discrete_Stepper_Motor.Initialize
       (An_Instance => This_Stepper_Motor);

      Smp_Req := Step_Type'First;
      Discrete_Stepper_Motor.Update
        (Next_Instance => Next_Stepper_Motor,
         This_Instance => This_Stepper_Motor,
         Iconst        => Iconst,
         Position_Requested => Smp_Req);

      This_Smp := Discrete_Stepper_Motor.Position (An_Instance => This_Stepper_Motor);
      Next_Smp := Discrete_Stepper_Motor.Position (An_Instance => Next_Stepper_Motor);

      Actual_Value := 0;
    Test_Result := abs(Next_Smp - Actual_Value) < 1;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;


end Stepper_Motor_Ctd;










