-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer: Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0
with Ada.Text_Io;
with Class_Test_Result_File;
with Metering_Valve;
with Angle_Types;
with Mass_Types;
with Normalized_Types;
with Jpats_Powerplant_Types;
with Force_Types;

procedure Metering_Valve_Ctd is


  package Fuel_Metering_Valve is new Metering_Valve
    ( Degrees_Type                         =>  Angle_Types.Degrees,
      Step_Type                            =>  Jpats_Powerplant_Types.Step_Type,
      High_Pressure_Relief_Valve_Set_Point =>  1175.0,
      Bypass_Valve_Set_Point               =>  50.0,
      Cam_Profile_Table_Name               =>  "FF3DCAM.ito",
      Gain_Table_Name                      =>  "KFMVDELT.ito");



begin

  Ada.Text_Io.Put_Line ("Metering_Valve_Ctd.exe is executing.");

  -- Testing of the Update and Initialize methods are black box methods.

  -- Test the initialize function
  declare
    Fmu_Metering_Valve                   : Fuel_Metering_Valve.Instance;
    Fuel_Output_Pressure                 : Force_Types.Psi;
    Fuel_Flow_Rate                       : Mass_Types.Pph;
    Fuel_Bypass_Flow_Rate                : Mass_Types.Pph;
    Min_Fuel_Flow_Rate                   : Mass_Types.Pph;
    Altitude_Gain                        : Normalized_Types.Normalize;
    Test_Result                          : Boolean;
    Test_Number                          : Integer;
    Init_Result                          : Boolean;
  begin
    Fuel_Metering_Valve.Read_Tables;
    Fuel_Metering_Valve.Initialize
        (An_Instance => Fmu_Metering_Valve);

    -- Use the accessor function to check the initialize function


    -- Access Fuel Output Pressure
    Test_Number := 1;
    Fuel_Output_Pressure := Fuel_Metering_Valve.Output_Pressure ( An_Instance => Fmu_Metering_Valve);
    Test_Result :=  Fuel_Output_Pressure = Force_Types.Psi(0.0);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
    Init_Result := Test_Result;

    -- Access Fuel_Flow_Rate
    Test_Number := 2;
    Fuel_Flow_Rate := Fuel_Metering_Valve.Flow_Rate (An_Instance => Fmu_Metering_Valve);
    Test_Result :=  Fuel_Flow_Rate = Mass_Types.pph(0.0);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
    Init_Result := Init_Result and Test_Result;

    -- Access Fuel_Bypass_Flow_Rate
    Test_Number := 3;
    Fuel_Bypass_Flow_Rate := Fuel_Metering_valve.Bypass_Flow_Rate (An_Instance => Fmu_Metering_Valve);
    Test_Result := Fuel_Bypass_Flow_Rate = Mass_Types.Pph(0.0);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
    Init_Result := Init_Result and Test_Result;

    -- Access Min_Fuel_Flow_Rate
    Test_Number := 4;
    Min_Fuel_Flow_Rate := Fuel_Metering_valve.Min_Flow_Rate (An_Instance => Fmu_Metering_Valve);
    Test_Result := Min_Fuel_Flow_Rate = Mass_Types.Pph(65.0);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
    Init_Result := Init_Result and Test_Result;

    -- Access Altitude_Gain
    Test_Number := 5;
    Altitude_Gain := Fuel_Metering_valve.Altitude_Gain (An_Instance => Fmu_Metering_Valve);
    Test_Result := Altitude_Gain = Normalized_Types.Normalize(1.0);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
    Init_Result := Init_Result and Test_Result;

    -- Results for Initialize function
    Test_Number := 6;
    Class_Test_Result_File.Report_Case_Status (Success => Init_Result, Number => Test_Number);


  end;

    -- Set and Access Fuel Output Pressure
  declare
    Fmu_Metering_Valve                   : Fuel_Metering_Valve.Instance;
    Fuel_Output_Pressure                 : Force_Types.Psi;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
  begin
    Fuel_Metering_Valve.Read_Tables;

    Fuel_Metering_Valve.Initialize
      (An_Instance => Fmu_Metering_Valve);

    Test_Number := 7;
    Fuel_Metering_Valve.Set_Output_Pressure
      (An_Instance     => Fmu_Metering_Valve,
       Output_Pressure => Force_Types.Psi(34.6));
    Fuel_Output_Pressure := Fuel_Metering_Valve.Output_Pressure ( An_Instance => Fmu_Metering_Valve);
    Test_Result :=  Fuel_Output_Pressure = Force_Types.Psi(34.6);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;

  -- Set and Access Fuel Flow Rate
  declare
    Fmu_Metering_Valve                   : Fuel_Metering_Valve.Instance;
    Fuel_Flow_Rate                       : Mass_Types.Pph;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
  begin
    Fuel_Metering_Valve.Read_Tables;

    Fuel_Metering_Valve.Initialize
      (An_Instance => Fmu_Metering_Valve);

    Test_Number := 8;
    Fuel_Metering_Valve.Set_Flow_Rate
      (An_Instance     => Fmu_Metering_Valve,
       Flow_Rate       => Mass_Types.Pph(34.6));
    Fuel_Flow_Rate := Fuel_Metering_Valve.Flow_Rate( An_Instance => Fmu_Metering_Valve);
    Test_Result :=  Fuel_Flow_Rate  = Mass_Types.Pph(34.6);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;

  -- Set and Access Fuel Bypass Flow Rate
  declare
    Fmu_Metering_Valve                   : Fuel_Metering_Valve.Instance;
    Fuel_Bypass_Flow_Rate                : Mass_Types.Pph;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
  begin
    Fuel_Metering_Valve.Read_Tables;

    Fuel_Metering_Valve.Initialize
      (An_Instance => Fmu_Metering_Valve);

    Test_Number := 9;
    Fuel_Metering_Valve.Set_Bypass_Flow_Rate
      (An_Instance      => Fmu_Metering_Valve,
       Bypass_Flow_Rate => Mass_Types.Pph(34.6));
    Fuel_Bypass_Flow_Rate := Fuel_Metering_Valve.Bypass_Flow_Rate ( An_Instance => Fmu_Metering_Valve);
    Test_Result :=  Fuel_Bypass_Flow_Rate = Mass_Types.Pph(34.6);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;

  -- Set and Access Min_Fuel_Flow_Rate
  declare
    Fmu_Metering_Valve                   : Fuel_Metering_Valve.Instance;
    Min_Fuel_Flow_Rate                   : Mass_Types.Pph;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
  begin

    Fuel_Metering_Valve.Read_Tables;
    Fuel_Metering_Valve.Initialize
      (An_Instance => Fmu_Metering_Valve);

    Test_Number := 10;
    Fuel_Metering_Valve.Set_Min_Flow_Rate
      (An_Instance     => Fmu_Metering_Valve,
       Min_Flow_Rate   => Mass_Types.Pph(34.6));
    Min_Fuel_Flow_Rate  := Fuel_Metering_Valve.Min_Flow_Rate ( An_Instance => Fmu_Metering_Valve);
    Test_Result :=  Min_Fuel_Flow_Rate  = Mass_types.Pph(34.6);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;

  -- Set and Access Altitude Gain
  declare
    Fmu_Metering_Valve                   : Fuel_Metering_Valve.Instance;
    Altitude_Gain                        : Normalized_Types.Normalize;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
  begin

    Fuel_Metering_Valve.Read_Tables;
    Fuel_Metering_Valve.Initialize
      (An_Instance => Fmu_Metering_Valve);

    Test_Number := 11;
    Fuel_Metering_Valve.Set_Altitude_Gain
      (An_Instance     => Fmu_Metering_Valve,
       Altitude_Gain   => Normalized_Types.Normalize(34.6));
    Altitude_Gain := Fuel_Metering_Valve.Altitude_Gain ( An_Instance => Fmu_Metering_Valve);
    Test_Result :=  Altitude_Gain = Normalized_Types.Normalize(34.6);
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;


  -- This test will compute the fuel flow for a pla of 80 degrees and
  -- Smp of 169 unit steps.

  declare
    Next_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    This_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
    Pla                                  : Angle_Types.Degrees;
    Smp                                  : Jpats_Powerplant_Types.Step_Type;
  begin
    Test_Number := 12;
    Fuel_Metering_Valve.Read_Tables;
    Fuel_Metering_Valve.Initialize (An_Instance => Next_Fmu_Metering_Valve);
    Fuel_Metering_Valve.Initialize (An_Instance => This_Fmu_Metering_Valve);


    Pla := Angle_Types.Degrees(80.0);
    Smp := Jpats_Powerplant_Types.Step_Type(169);

    Fuel_Metering_Valve.Update
      (Next_Instance                        => Next_Fmu_Metering_Valve,
       This_Instance                        => This_Fmu_Metering_Valve,
       Iconst                               => 1.0/15.0,
       Power_Lever_Angle                    => Pla,
       Stepper_Motor_Position               => Smp,
       Shutdown_Solenoid_Energized          => False,
       Ambient_Pressure_Ratio               => Normalized_Types.Normalize(1.0),
       Return_Line_Pressure                 => Force_Types.Psi(0.0),
       Inlet_Pressure                       => Force_Types.Psi(5.0),
       Inlet_Flow_Rate                      => Mass_Types.Pph(10.0));

--    Ada.Text_Io.Put_Line( Mass_Types.Pph'Image( Fuel_Metering_Valve.Flow_Rate(An_Instance => Next_Fmu_Metering_Valve)));
    Test_Result := abs((Fuel_Metering_Valve.Flow_Rate (An_Instance => Next_Fmu_Metering_Valve)
      - Mass_Types.Pph(65.0 + 623.0))/Mass_Types.Pph(65.0 + 623.0)) < 0.0001;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);

  end;

  -- This test will compute the fuel flow for a pla of 80 degrees and
  -- Smp of 169 unit steps.

  declare
    Next_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    This_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
    Pla                                  : Angle_Types.Degrees;
    Smp                                  : Jpats_Powerplant_Types.Step_Type;
  begin
    Test_Number := 12;
    Fuel_Metering_Valve.Read_Tables;
    Fuel_Metering_Valve.Initialize (An_Instance => Next_Fmu_Metering_Valve);
    Fuel_Metering_Valve.Initialize (An_Instance => This_Fmu_Metering_Valve);


    Pla := Angle_Types.Degrees(0.0);
    Smp := Jpats_Powerplant_Types.Step_Type(0);

    Fuel_Metering_Valve.Update
      (Next_Instance                        => Next_Fmu_Metering_Valve,
       This_Instance                        => This_Fmu_Metering_Valve,
       Iconst                               => 1.0/15.0,
       Power_Lever_Angle                    => Pla,
       Stepper_Motor_Position               => Smp,
       Shutdown_Solenoid_Energized          => False,
       Ambient_Pressure_Ratio               => Normalized_Types.Normalize(1.0),
       Return_Line_Pressure                 => Force_Types.Psi(0.0),
       Inlet_Pressure                       => Force_Types.Psi(5.0),
       Inlet_Flow_Rate                      => Mass_Types.Pph(10.0));

--    Ada.Text_Io.Put_Line( Mass_Types.Pph'Image( Fuel_Metering_Valve.Flow_Rate(An_Instance => Next_Fmu_Metering_Valve)));
    Test_Result := abs((Fuel_Metering_Valve.Flow_Rate (An_Instance => Next_Fmu_Metering_Valve)
      - Mass_Types.Pph(65.0))/Mass_Types.Pph(65.0)) < 0.0001;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);

  end;

  -- This test will compute the fuel flow for a pla of 80 degrees and
  -- Smp of 169 unit steps.

  declare
    Next_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    This_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
    Pla                                  : Angle_Types.Degrees;
    Smp                                  : Jpats_Powerplant_Types.Step_Type;
  begin
    Test_Number := 13;
    Fuel_Metering_Valve.Read_Tables;
    Fuel_Metering_Valve.Initialize (An_Instance => Next_Fmu_Metering_Valve);
    Fuel_Metering_Valve.Initialize (An_Instance => This_Fmu_Metering_Valve);


    Pla := Angle_Types.Degrees(80.0);
    Smp := Jpats_Powerplant_Types.Step_Type(169);

    Fuel_Metering_Valve.Update
      (Next_Instance                        => Next_Fmu_Metering_Valve,
       This_Instance                        => This_Fmu_Metering_Valve,
       Iconst                               => 1.0/15.0,
       Power_Lever_Angle                    => Pla,
       Stepper_Motor_Position               => Smp,
       Shutdown_Solenoid_Energized          => False,
       Ambient_Pressure_Ratio               => Normalized_Types.Normalize(1.0),
       Return_Line_Pressure                 => Force_Types.Psi(0.0),
       Inlet_Pressure                       => Force_Types.Psi(5.0),
       Inlet_Flow_Rate                      => Mass_Types.Pph(10.0));

--    Ada.Text_Io.Put_Line( Mass_Types.Pph'Image( Fuel_Metering_Valve.Flow_Rate(An_Instance => Next_Fmu_Metering_Valve)));
    Test_Result := abs((Fuel_Metering_Valve.Flow_Rate (An_Instance => Next_Fmu_Metering_Valve)
      - Mass_Types.Pph(65.0 + 623.0))/Mass_Types.Pph(65.0+623.0)) < 0.0001;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;

  -- This test will compute the fuel flow for a pla of 30 degrees and
  -- Smp of 169 unit steps.  This is an intermediate value in the table
  -- for pla.

  declare
    Next_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    This_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
    Pla                                  : Angle_Types.Degrees;
    Smp                                  : Jpats_Powerplant_Types.Step_Type;
  begin
    Test_Number := 14;
    Fuel_Metering_Valve.Read_Tables;
    Fuel_Metering_Valve.Initialize (An_Instance => Next_Fmu_Metering_Valve);
    Fuel_Metering_Valve.Initialize (An_Instance => This_Fmu_Metering_Valve);


    Pla := Angle_Types.Degrees(30.0);
    Smp := Jpats_Powerplant_Types.Step_Type(169);

    Fuel_Metering_Valve.Update
      (Next_Instance                        => Next_Fmu_Metering_Valve,
       This_Instance                        => This_Fmu_Metering_Valve,
       Iconst                               => 1.0/15.0,
       Power_Lever_Angle                    => Pla,
       Stepper_Motor_Position               => Smp,
       Shutdown_Solenoid_Energized          => False,
       Ambient_Pressure_Ratio               => Normalized_Types.Normalize(1.0),
       Return_Line_Pressure                 => Force_Types.Psi(0.0),
       Inlet_Pressure                       => Force_Types.Psi(5.0),
       Inlet_Flow_Rate                      => Mass_Types.Pph(10.0));

    Ada.Text_Io.Put_Line( Mass_Types.Pph'Image( Fuel_Metering_Valve.Flow_Rate(An_Instance => Next_Fmu_Metering_Valve)));
    Test_Result := abs((Fuel_Metering_Valve.Flow_Rate (An_Instance => Next_Fmu_Metering_Valve)
      - Mass_Types.Pph(65.0 + 135.0))/Mass_Types.Pph(65.0 + 135.0)) < 0.0001;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;

    -- This test will compute the fuel flow for a pla of 77 degrees and
  -- Smp of 169 unit steps.  This is an intermediate value in the table
  -- for smp.

  declare
    Next_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    This_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
    Pla                                  : Angle_Types.Degrees;
    Smp                                  : Jpats_Powerplant_Types.Step_Type;
  begin
    Test_Number := 15;
    Fuel_Metering_Valve.Read_Tables;
    Fuel_Metering_Valve.Initialize (An_Instance => Next_Fmu_Metering_Valve);
    Fuel_Metering_Valve.Initialize (An_Instance => This_Fmu_Metering_Valve);


    Pla := Angle_Types.Degrees(77.0);
    Smp := Jpats_Powerplant_Types.Step_Type(211.25);

    Fuel_Metering_Valve.Update
      (Next_Instance                        => Next_Fmu_Metering_Valve,
       This_Instance                        => This_Fmu_Metering_Valve,
       Iconst                               => 1.0/15.0,
       Power_Lever_Angle                    => Pla,
       Stepper_Motor_Position               => Smp,
       Shutdown_Solenoid_Energized          => False,
       Ambient_Pressure_Ratio               => Normalized_Types.Normalize(1.0),
       Return_Line_Pressure                 => Force_Types.Psi(0.0),
       Inlet_Pressure                       => Force_Types.Psi(5.0),
       Inlet_Flow_Rate                      => Mass_Types.Pph(10.0));

    Ada.Text_Io.Put_Line( Mass_Types.Pph'Image( Fuel_Metering_Valve.Flow_Rate(An_Instance => Next_Fmu_Metering_Valve)));
    Test_Result := abs((Fuel_Metering_Valve.Flow_Rate (An_Instance => Next_Fmu_Metering_Valve)
      - Mass_Types.Pph(65.0 + 744.4375))/Mass_Types.Pph(65.0+744.4375)) < 0.0001;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;

  -- This test will compute the fuel flow for a pla of 30 degrees and
  -- Smp of 169 unit steps.  This is an intermediate value in the table
  -- for pla.

  declare
    Next_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    This_Fmu_Metering_Valve              : Fuel_Metering_Valve.Instance;
    Test_Number                          : Integer;
    Test_Result                          : Boolean;
    Pla                                  : Angle_Types.Degrees;
    Smp                                  : Jpats_Powerplant_Types.Step_Type;
  begin
    Test_Number := 16;
    Fuel_Metering_Valve.Read_Tables;
    Fuel_Metering_Valve.Initialize (An_Instance => Next_Fmu_Metering_Valve);
    Fuel_Metering_Valve.Initialize (An_Instance => This_Fmu_Metering_Valve);


    Pla := Angle_Types.Degrees(30.0);
    Smp := Jpats_Powerplant_Types.Step_Type(169);

    Fuel_Metering_Valve.Update
      (Next_Instance                        => Next_Fmu_Metering_Valve,
       This_Instance                        => This_Fmu_Metering_Valve,
       Iconst                               => 1.0/15.0,
       Power_Lever_Angle                    => Pla,
       Stepper_Motor_Position               => Smp,
       Shutdown_Solenoid_Energized          => True,
       Ambient_Pressure_Ratio               => Normalized_Types.Normalize(1.0),
       Return_Line_Pressure                 => Force_Types.Psi(0.0),
       Inlet_Pressure                       => Force_Types.Psi(5.0),
       Inlet_Flow_Rate                      => Mass_Types.Pph(10.0));

    Ada.Text_Io.Put_Line( Mass_Types.Pph'Image( Fuel_Metering_Valve.Flow_Rate(An_Instance => Next_Fmu_Metering_Valve)));
    Test_Result := abs((Fuel_Metering_Valve.Flow_Rate (An_Instance => Next_Fmu_Metering_Valve)
      - Mass_Types.Pph(0.0))) < 0.0001;
    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
  end;




  Ada.Text_Io.Put_Line ("Metering_Valve_Ctd.exe is finished.");

end Metering_Valve_Ctd;







