-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Fuel_Metering_Unit;
with Angle_Types;
with Mass_Types;
with Force_Types;
with Class_Test_Result_File;

procedure Fuel_Metering_Unit_Ctd is

begin

  --| Test initialize function
  --| Check with the accessor functions
  --| Test Set functions
  --| Check with the accessor functions
  --| Test the update function for operation
  --| with pla angle, stepper motor position,
  --| reset solenoids activated.;

Test_1 :
    -------------------------------------------
    -- Test Case 1
    -- Test the Initialize function
    -- Inputs           : A Valid Fuel_Metering_Unit Class
    --                    A Valid Cam Generic Class
    --                    A Valid Stepper_Motor Generic Class
    --                    A Valid Solenoid Class
    --                    A Valid Fuel_Metering_Valve Class
    -- Expected Results : A query of all accessor functions should
    --                    show that all of the initialized instance
    --                    variables are set to the correct values
    --                    thus, testing the initialize and accessor
    --                    functions.
    -- Purpose          : Test the initialize and accessor functions.
    -- Interface Tested : Fuel_metering_unit.Initialize
    --                    Fuel_metering_unit.Power_Lever_Angle_In_Degrees
    --

    declare
      The_FMU               : Fuel_Metering_Unit.Instance;
      Pla                   : Angle_Types.Degrees;
      Fuel_Output_Pressure  : Force_Types.Psi;
      Fuel_Flow_Rate        : Mass_Types.Pph;
      Fuel_Bypass_Flow_Rate : Mass_Types.Pph;
      Test_Result           : Boolean;
      Init_Result           : Boolean;
      Test_Number           : Integer := 1;

    begin

      Fuel_Metering_Unit.Read_Tables;
      Fuel_Metering_Unit.Initialize
        (An_Instance => The_FMU);

      -- Use the accessor function to check the initialize function

      Pla := Fuel_Metering_Unit.Power_Lever_Angle
        (An_Instance => The_FMU);
        Test_Result := ((Pla - Angle_Types.Degrees(6.0))/Angle_Types.Degrees(0.0)) < 0.0001;
      Init_Result := Test_Result;

      -- Accessor Fuel_Output_Pressure
      Fuel_Output_Pressure := Fuel_Metering_Unit.Fuel_Output_Pressure
        (An_Instance => The_FMU);
      Test_Result :=  Fuel_Output_Pressure - Force_Types.Psi(0.0) < 0.0001;
--    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
      Init_Result := Init_Result and Test_Result;

      -- Access Fuel_Flow_Rate
      Fuel_Flow_Rate := Fuel_Metering_Unit.Fuel_Flow_Rate
        (An_Instance => The_FMU);
      Test_Result := (Pla - Mass_Types.Pph(0.0)) < 0.0001;
--    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
      Init_Result := Init_Result and Test_Result;

      -- Access Fuel_Bypass_Flow_Rate
      Fuel_Bypass_Flow_Rate := Fuel_Metering_Unit.Fuel_Bypass_Flow_Rate
        (An_Instance => The_FMU);
      Test_Result := (Pla - Mass_Types.Pph(0.0)) < 0.0001;
      Init_Result := Init_Result and Test_Result;
      Class_Test_Result_File.Report_Case_Status (Success => Init_Result, Number => Test_Number);

    end Test_1;

Test_2 :
    -------------------------------------------
    -- Test Case 2
    -- Test the Update function
    -- Inputs           : A Valid Fuel_Metering_Unit Class
    --                    A Valid Cam Generic Class
    --                    A Valid Stepper_Motor Generic Class
    --                    A Valid Solenoid Class
    --                    A Valid Fuel_Metering_Valve Class
    -- Expected Results : A query of all accessor functions should
    --                    show that all of the initialized instance
    --                    variables are set to the correct values
    --                    thus, testing the initialize and accessor
    --                    functions.
    -- Purpose          : Test the initialize and accessor functions.
    -- Interface Tested : Fuel_metering_unit.Initialize
    --                    Fuel_metering_unit.Power_Lever_Angle_In_Degrees
    --

    declare
      The_FMU               : Fuel_Metering_Unit.Instance;
      Pla                   : Angle_Types.Degrees;
      Fuel_Output_Pressure  : Force_Types.Psi;
      Fuel_Flow_Rate        : Mass_Types.Pph;
      Fuel_Bypass_Flow_Rate : Mass_Types.Pph;
      Test_Result           : Boolean;
      Init_Result           : Boolean;
      Test_Number           : Integer := 2;

    begin

      Fuel_Metering_Unit.Read_Tables;
      Fuel_Metering_Unit.Initialize
        (An_Instance => The_FMU);

      -- Use the accessor function to check the initialize function

      Pla := Fuel_Metering_Unit.Power_Lever_Angle
        (An_Instance => The_FMU);
        Test_Result := ((Pla - Angle_Types.Degrees(6.0))/Angle_Types.Degrees(0.0)) < 0.0001;
      Init_Result := Test_Result;

      -- Accessor Fuel_Output_Pressure
      Fuel_Output_Pressure := Fuel_Metering_Unit.Fuel_Output_Pressure
        (An_Instance => The_FMU);
      Test_Result :=  Fuel_Output_Pressure - Force_Types.Psi(0.0) < 0.0001;
--    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
      Init_Result := Init_Result and Test_Result;

      -- Access Fuel_Flow_Rate
      Fuel_Flow_Rate := Fuel_Metering_Unit.Fuel_Flow_Rate
        (An_Instance => The_FMU);
      Test_Result := (Pla - Mass_Types.Pph(0.0)) < 0.0001;
--    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
      Init_Result := Init_Result and Test_Result;

      -- Access Fuel_Bypass_Flow_Rate
      Fuel_Bypass_Flow_Rate := Fuel_Metering_Unit.Fuel_Bypass_Flow_Rate
        (An_Instance => The_FMU);
      Test_Result := (Pla - Mass_Types.Pph(0.0)) < 0.0001;
      Init_Result := Init_Result and Test_Result;
      Class_Test_Result_File.Report_Case_Status (Success => Init_Result, Number => Test_Number);

    end Test_2;

Test_3 :
    -------------------------------------------
    -- Test Case 3
    -- Test the Update function
    -- Inputs           : Test the reset function of the FMU
    --
    -- Expected Results : The fmu should yield the steady state value
    --
    -- Purpose          : Test the reset capabilities
    -- Interface Tested : Fuel_metering_unit.Initialize
    --                    Fuel_metering_unit.Power_Lever_Angle_In_Degrees
    --

    declare
      The_FMU               : Fuel_Metering_Unit.Instance;
      Pla                   : Angle_Types.Degrees;
      Fuel_Output_Pressure  : Force_Types.Psi;
      Fuel_Flow_Rate        : Mass_Types.Pph;
      Fuel_Bypass_Flow_Rate : Mass_Types.Pph;
      Test_Result           : Boolean;
      Init_Result           : Boolean;
      Test_Number           : Integer := 3;

    begin

      Fuel_Metering_Unit.Read_Tables;
      Fuel_Metering_Unit.Initialize
        (An_Instance => The_FMU);

      -- Use the accessor function to check the initialize function

      Pla := Fuel_Metering_Unit.Power_Lever_Angle
        (An_Instance => The_FMU);
        Test_Result := ((Pla - Angle_Types.Degrees(6.0))/Angle_Types.Degrees(0.0)) < 0.0001;
      Init_Result := Test_Result;

      -- Accessor Fuel_Output_Pressure
      Fuel_Output_Pressure := Fuel_Metering_Unit.Fuel_Output_Pressure
        (An_Instance => The_FMU);
      Test_Result :=  Fuel_Output_Pressure - Force_Types.Psi(0.0) < 0.0001;
--    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
      Init_Result := Init_Result and Test_Result;

      -- Access Fuel_Flow_Rate
      Fuel_Flow_Rate := Fuel_Metering_Unit.Fuel_Flow_Rate
        (An_Instance => The_FMU);
      Test_Result := (Pla - Mass_Types.Pph(0.0)) < 0.0001;
--    Class_Test_Result_File.Report_Case_Status (Success => Test_Result, Number => Test_Number);
      Init_Result := Init_Result and Test_Result;

      -- Access Fuel_Bypass_Flow_Rate
      Fuel_Bypass_Flow_Rate := Fuel_Metering_Unit.Fuel_Bypass_Flow_Rate
        (An_Instance => The_FMU);
      Test_Result := (Pla - Mass_Types.Pph(0.0)) < 0.0001;
      Init_Result := Init_Result and Test_Result;
      Class_Test_Result_File.Report_Case_Status (Success => Init_Result, Number => Test_Number);

    end Test_3;

end Fuel_Metering_Unit_Ctd;
