-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Standby_Attitude_Indicator;
with  Nav_Instruments_Types;
with Ada.Text_Io;
with Class_Test_Result_File;
use Ada.Text_Io;
use Standby_Attitude_Indicator;

procedure Stby_Att_Ind_Ct is

   package It renames Nav_Instruments_Types;

   Power              : Boolean;
   Cage               : Boolean;
   Aircraft_Attitude  : Nav_Instruments_Types.Attitude_Type;
   Output              : Nav_Instruments_Types.Attitude_Type;
   Stable : Boolean;
   Pass : Boolean;
   Pitch_N1 : Float;
   Roll_N1 : Float;
   Time : Float := 0.0;
   Iconst : Float := 1.0/30.0;
   The_Vg : Standby_Attitude_Indicator.Instance;


begin

   Power := True;
   Cage  := False;
   Aircraft_Attitude.Pitch := 30.0;
   Aircraft_Attitude.Roll := 45.0;

   Init(The_Vg);

   loop
      Time := Time + Iconst;

      Set_Power(The_Vg,Power);
      Set_Cage(The_Vg,Cage);
      Set_Aircraft_Attitude(The_Vg,Aircraft_Attitude);

      Update(Iconst => Iconst,
             An_Instance          => The_Vg);



      Output := Indicated_Attitude(The_Vg);

      Stable :=
        (abs(Output.Pitch - Pitch_N1) < 0.01 and
         abs(Output.Roll  - Roll_N1)  < 0.01) and
        Time >= 1.0;
      Pitch_N1 := Output.Pitch;
      Roll_N1  := Output.Roll;

      if Stable then
         Pass :=
           abs(Output.Pitch - Aircraft_Attitude.Pitch) < 0.5 and
           abs(Output.Roll  - Aircraft_Attitude.Roll ) < 0.5;

         Class_Test_Result_File.Report_Case_Status (Pass);

         if Pass then
            Put_Line("Pass");
         else
            Put_Line("Fail");
         end if;

         exit;

      end if;

   end loop;

end;

