-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Jim Reynolds
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Standby_Mag_Compass;
with  Nav_Instruments_Types;
with Ada.Text_Io;
with Class_Test_Result_File;

use Ada.Text_Io;
use Standby_Mag_Compass;

procedure Standby_Mag_Compass_Ct is

   package It renames Nav_Instruments_Types;

   Aircraft_Position          : It.Position_Type;
   Translational_Acceleration : It.Attitude_Accel_Type;
   Aircraft_Attitude          : It.Attitude_Type;
   Body_Axis_Velocity         : It.Attitude_Rate_Type;
   Turbulence_Level           : Float;
   Weight_On_Wheels           : Boolean;
   Magnetic_Heading           : It.Heading_Type;
   Stable : Boolean;
   Pass : Boolean;
   Heading_N1 : Float;
   Time : Float := 0.0;
   Iconst : Float := 1.0/30.0;
   The_Compass : Standby_Mag_Compass.Instance;

   type Cases is array (1 .. 8) of Integer;

   type Heading_Array is array (Cases'range) of It.Heading_Type;

   Heading : constant Heading_Array := (0.0,45.0,90.0,135.0,180.0,
                                        -135.0,-90.0,-45.0);
begin

   for I in Cases'Range loop

      Time := 0.0;
      Init(The_Compass);


      Aircraft_Position.Latitude := 45.0;
      Aircraft_Position.Longitude := -45.0;
      Aircraft_Position.Altitude := 20000.0;
      Translational_Acceleration.P := 0.0;
      Aircraft_Attitude.Roll := 0.0;
      Body_Axis_Velocity.P := 0.0;
      Turbulence_Level := 0.0;
      Weight_On_Wheels := False;
      Magnetic_Heading := 100.0;

      while Time < 20.0 loop
         Time := Time + Iconst;



         Set_Aircraft_Position(The_Compass,Aircraft_Position);
         Set_Translational_Acceleration(The_Compass,
                                        Translational_Acceleration);
         Set_Aircraft_Attitude(The_Compass,Aircraft_Attitude);
         Set_Body_Axis_Velocity(The_Compass,Body_Axis_Velocity);
         Set_Turbulence_Level(The_Compass,Turbulence_Level);
         Set_Weight_On_Wheels(The_Compass,Weight_On_Wheels);
         Set_Magnetic_Heading(The_Compass,Heading(I));

         Update(Integration_Constant => Iconst,
                An_Instance          => The_Compass);

         Stable := abs(Compass_Heading(The_Compass) - Heading_N1) < 0.0001 and
           Time > 5.0;
         Heading_N1 := Compass_Heading(The_Compass);

         if Stable then
            Pass := abs(Compass_Heading(The_Compass) - Heading(I)) < 0.5;

         Class_Test_Result_File.Report_Case_Status (Pass);

         if Pass then
            Put_Line("Pass");
         else
            Put_Line("Fail");
         end if;

         exit;

         end if;
      end loop;
   end loop;
end;

