-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Nav_Instruments.Container;
with Jpats_Nav_Instruments.Controller;
with Jpats_Nav_Instruments;
with Class_Test_Result_File;
with Jpats_Landing_Gear,
  Jpats_Electrical,
  Jpats_Simulated_Aircraft,
  Jpats_Atmosphere,
  Jpats_Radio;

with Ada.Text_Io;
use Ada.Text_Io;

procedure Jpats_Nav_Instruments.Ctd is

   Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;

   Time : Float := 0.0;
   Iconst : Float := 1.0/30.0;
   Pass : Boolean := False;
   Stable : Boolean;
   Sin_N1 : Float;
   Cos_N1 : Float;
   Pitch_N1 : Float;

begin

   -------------------------------------------------------
   -- Test Case 1--Standby Magnetic Compass
   --
   -- Inputs:
   --   magnetic heading : 45.0
   --   aircraft latitude: 45.0
   --   aircraft attitude : pitch : 30.0, roll : 30.0
   --   weight on wheels : off
   --
   -- Expected Results:
   --   compass heading drive : sin : 0.707, cos : 0.707
   --
   -- Purpose:
   --   To test the standby mag compass function.
   --
   JPATS_Nav_Instruments.Controller.Initialize;

   Time := 0.0;

   loop

      Time := Time + Iconst;

      JPATS_Nav_Instruments.Controller.Update(Iconst);

      Stable := abs(Io.The_Stby_Compass_Sin - Sin_N1) < 0.0001 and
        abs(Io.The_Stby_Compass_Cos - Cos_N1) < 0.01 and
        Time > 5.0;
      Sin_N1 := Io.The_Stby_Compass_Sin;
      Cos_N1 := Io.The_Stby_Compass_Cos;

      if Stable then
         Pass :=
           abs(Io.The_Stby_Compass_Sin - 0.363) < 0.1 and
           abs(Io.The_Stby_Compass_Cos - 0.932) < 0.1;

         if Pass then
            Put_Line("test case 1 pass");
         else
            Put_Line("test case 1 fail");
         end if;

         Class_Test_Result_File.Report_Case_Status(Pass);

         exit;
      end if;
   end loop;

   -------------------------------------------------------
   -- Test Case 1--Standby Attitude Indicator
   --
   -- Inputs:
   --   power : available
   --   aircraft attitude : pitch : 30.0, roll : 30.0
   --
   -- Expected Results:
   --   indicated pitch : 30.0
   --   indicated roll  : 30.0
   --
   -- Purpose:
   --   To test the standby attitude indicator
   --
   JPATS_Nav_Instruments.Controller.Initialize;

   Time := 0.0;

   loop

      Time := Time + Iconst;

      JPATS_Nav_Instruments.Controller.Update(Iconst);

      Stable :=
        abs(Io.The_Stby_Horizon_Roll_Sin - Sin_N1) < 0.0001   and
        abs(Io.The_Stby_Horizon_Roll_cos - Cos_N1) < 0.0001 and
        abs(Io.The_Stby_Horizon_Pitch - Pitch_n1) < 0.0001  and
        Time > 5.0;

      Sin_N1 := Io.The_Stby_Horizon_Roll_Sin;
      Cos_N1 := Io.The_Stby_Horizon_Roll_Cos;
      Pitch_N1 := Io.The_Stby_Horizon_Pitch;

      if Stable then

         Pass :=
           abs(Io.The_Stby_Horizon_Roll_Sin - 0.5) < 0.1 and
           abs(Io.The_Stby_Horizon_Roll_cos - 0.866) < 0.1 and
           abs(Io.The_Stby_Horizon_Pitch - 30.0) < 0.1;

         if Pass then
            Put_Line("test case 1 pass");
         else
            Put_Line("test case 1 fail");
         end if;

         Class_Test_Result_File.Report_Case_Status(Pass);

         exit;
      end if;
   end loop;





end;

