-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Light_G;
with Wing_Lights_G;

procedure Wing_Lights_G_Ctd is


begin



   -------------------------------------------------------------------------------
   -- Test_1
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :


   Test_1 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Lt is new Light_G (Float, 0.05);
      package Wing_Lts is new Wing_Lights_G
        (Current_Type       => Float,                --is digits <>;
         Light_Type         => Lt.Instance,          -- is private;
         Turn_On_A_Light    => Lt.Turn_On,           --(An_Instance : in out Light_Type);
         Turn_Off_A_Light   => Lt.Turn_Off,          -- (An_Instance : in out Light_Type);
         A_Lights_Load      => Lt.Load,              -- (A_Light : in Light_Type) return Current_Type;
         A_Light_Is_On      => Lt.Is_On,             -- (A_Light : in Light_Type) return Boolean;
         Initialize_A_Light => Lt.Initialize,        -- (A_Light : in out Light_Type);
         Update_A_Light     => Lt.Update);           -- (A_Light : in out Light_Type; Request : in Boolean);

      Some_Wing_Lts : Wing_Lts.Instance;
      Test_Case_1 :  Boolean;
      Flag : Integer := 0;

   begin

      Wing_Lts.Initialize (Some_Wing_Lts);

      Test_Case_1 := Wing_Lts.Load (Some_Wing_Lts) = 0.0;

      Class_Test_Result_File.Report_Case_Status (Success => Test_Case_1 , Number => 1);

   end Test_1;




   -------------------------------------------------------------------------------
   -- Test_2
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :


   Test_2 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Lt is new Light_G (Float, 0.5);
      package Wing_Lts is new Wing_Lights_G
        (Current_Type       => Float,                --is digits <>;
         Light_Type         => Lt.Instance,          -- is private;
         Turn_On_A_Light    => Lt.Turn_On,           --(An_Instance : in out Light_Type);
         Turn_Off_A_Light   => Lt.Turn_Off,          -- (An_Instance : in out Light_Type);
         A_Lights_Load      => Lt.Load,              -- (A_Light : in Light_Type) return Current_Type;
         A_Light_Is_On      => Lt.Is_On,             -- (A_Light : in Light_Type) return Boolean;
         Initialize_A_Light => Lt.Initialize,        -- (A_Light : in out Light_Type);
         Update_A_Light     => Lt.Update);           -- (A_Light : in out Light_Type; Request : in Boolean);

      Some_Wing_Lts : Wing_Lts.Instance;
      Test_Case_2 : array (1..4) of Boolean;
      Flag : Integer := 0;
      L_REQ, R_REQ : BOOLEAN := True;
   begin

      Wing_Lts.Initialize (Some_Wing_Lts);

      WING_LTS.Update
        (An_Instance   => Some_Wing_Lts, -- in out Instance;
         Left_Request  => L_REQ, -- in     Boolean;
         Right_Request => R_REQ);

      Test_Case_2(1) := Wing_Lts.Load (Some_Wing_Lts) = 1.0;



      L_Req := True; R_Req := False;

      WING_LTS.Update
        (An_Instance   => Some_Wing_Lts, -- in out Instance;
         Left_Request  => L_REQ, -- in     Boolean;
         Right_Request => R_REQ);

      Test_Case_2(2) := Wing_Lts.Load (Some_Wing_Lts) = 0.5;




      L_Req := False; R_Req := True;

      WING_LTS.Update
        (An_Instance   => Some_Wing_Lts, -- in out Instance;
         Left_Request  => L_REQ, -- in     Boolean;
         Right_Request => R_REQ);

      Test_Case_2(3) := Wing_Lts.Load (Some_Wing_Lts) = 0.5;



      L_Req := False; R_Req := False;

      WING_LTS.Update
        (An_Instance   => Some_Wing_Lts, -- in out Instance;
         Left_Request  => L_REQ, -- in     Boolean;
         Right_Request => R_REQ);

      Test_Case_2(4) := Wing_Lts.Load (Some_Wing_Lts) = 0.0;

      for I in 1..4
      loop
         exit when not Test_Case_2(I);
         Flag := I;
      end loop;

      Class_Test_Result_File.Report_Case_Status (Success => Flag = 4, Number => 2);

   end Test_2;






--     -------------------------------------------------------------------------------
--     -- Test_3
--     --
--     -- Inputs           :
--     -- Expected results :
--     -- Purpose          :


--     Test_3 : declare
--        -------------------------------------------------------------------------------
--        -------------------------------------------------------------------------------

--        Interval : Duration := 10.0;
--        Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

--        Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

--        One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
--        Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

--        One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
--        Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
--        Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

--        Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
--        Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

--        function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

--        Iconst : Float := 0.06666666;
--        I : Integer := 0;

--        In_First_Quarter  : Boolean := true;
--        In_Second_Quarter : Boolean := true;
--        In_Third_Quarter  : Boolean := true;
--        In_Fourth_Quarter : Boolean := true;

--        -------------------------------------------------------------------------------
--        -------------------------------------------------------------------------------

--        package Lt is new Light_G (Float, 0.05);
--        package Wing_Lts is new Wing_Lights_G
--          (Current_Type       => Float,                --is digits <>;
--           Light_Type         => Lt.Instance,          -- is private;
--           Turn_On_A_Light    => Lt.Turn_On,           --(An_Instance : in out Light_Type);
--           Turn_Off_A_Light   => Lt.Turn_Off,          -- (An_Instance : in out Light_Type);
--           A_Lights_Load      => Lt.Load,              -- (A_Light : in Light_Type) return Current_Type;
--           A_Light_Is_On      => Lt.Is_On,             -- (A_Light : in Light_Type) return Boolean;
--           Initialize_A_Light => Lt.Initialize,        -- (A_Light : in out Light_Type);
--           Update_A_Light     => Lt.Update);           -- (A_Light : in out Light_Type; Request : in Boolean);

--        Some_Wing_Lts : Wing_Lts.Instance;
--        Test_Case_3 : array () of Boolean;
--        Flag : Integer := 0;

--     begin

--        Wing_Lts.Initialize (Some_Wing_Lts);



--        Class_Test_Result_File.Report_Case_Status (Success => , Number => );

--     end Test_3;


end Wing_Lights_G_Ctd;
