-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Rheostat_Controlled_Lighting_G;

procedure Rheostat_Controlled_Lighting_G_Ctd is


begin

   -------------------------------------------------------------------------------
   -- Test_1
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

      Test_1 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Rheo_Lts is new Rheostat_Controlled_Lighting_G (Float);

      A_Rheo_Lt : Rheo_Lts.Instance;

      Test_Case_1 : array (1..2) of Boolean;
--      Flag : Integer;

   begin

      Rheo_Lts.Initialize (A_Rheo_Lt);

      Test_Case_1(1) := not Rheo_Lts.Is_Powered (A_Rheo_Lt);
      Test_Case_1(2) := Rheo_Lts.Voltage_Out (A_Rheo_Lt) = 0.0;

      Class_Test_Result_File.Report_Case_Status (Success => Test_Case_1(1) and Test_Case_1(2), Number => 1);

   end Test_1;



   -------------------------------------------------------------------------------
   -- Test_2
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_2 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      package Rheo_Lts is new Rheostat_Controlled_Lighting_G (Float);

      A_Rheo_Lt : Rheo_Lts.Instance;

      Test_Case_2 : array (1..8) of Boolean;
      Flag : Integer := 0;
      Pwr : Boolean := True; Rheo : Float := 1.0;

   begin

      Rheo_Lts.Initialize (A_Rheo_Lt);


      Pwr := true; Rheo := 1.0;

      Rheo_Lts.update
        (An_Instance   => A_Rheo_Lt,      -- in out Instance;
         Powered       => Pwr,      -- in     Boolean;
         Rheo_Position => Rheo);     -- in     Float) is

      Test_Case_2(1) := Rheo_Lts.Is_Powered (A_Rheo_Lt);
      Test_Case_2(2) := Rheo_Lts.Voltage_Out (A_Rheo_Lt) = 1.0;






      Pwr := false; Rheo := 2.0;

      Rheo_Lts.update
        (An_Instance   => A_Rheo_Lt,      -- in out Instance;
         Powered       => Pwr,      -- in     Boolean;
         Rheo_Position => Rheo);     -- in     Float) is


      Test_Case_2(3) := not Rheo_Lts.Is_Powered (A_Rheo_Lt);
      Test_Case_2(4) := Rheo_Lts.Voltage_Out (A_Rheo_Lt) = 2.0;






      Pwr := True; Rheo := 10.0;

      Rheo_Lts.update
        (An_Instance   => A_Rheo_Lt,      -- in out Instance;
         Powered       => Pwr,      -- in     Boolean;
         Rheo_Position => Rheo);     -- in     Float) is


      Test_Case_2(5) := Rheo_Lts.Is_Powered (A_Rheo_Lt);
      Test_Case_2(6) := Rheo_Lts.Voltage_Out (A_Rheo_Lt) = 10.0;








      Pwr := True; Rheo := -10.0;

      Rheo_Lts.update
        (An_Instance   => A_Rheo_Lt,      -- in out Instance;
         Powered       => Pwr,      -- in     Boolean;
         Rheo_Position => Rheo);     -- in     Float) is


      Test_Case_2(7) := Rheo_Lts.Is_Powered (A_Rheo_Lt);
      Test_Case_2(8) := Rheo_Lts.Voltage_Out (A_Rheo_Lt) = -10.0;



      for I in 1..8
      loop
         exit when not Test_Case_2(I);
         Flag := I;
      end loop;

      Class_Test_Result_File.Report_Case_Status (Success => Flag = 8, Number => 2);

   end Test_2;




   -------------------------------------------------------------------------------
   -- Test_3
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_3 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end Test_3;


end Rheostat_Controlled_Lighting_G_Ctd;
