-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Jpats_Lights.Controller;
with Jpats_Lights.Container;

with Jpats_Electrical;
with Jpats_Electrical_Types;
with Jpats_Landing_Gear;
with Jpats_Landing_Gear_Types;


procedure Jpats_Lights.Controller_Ctd is

   package Ctnr       renames Container;
   package Ele        renames Jpats_Electrical;
   package Ele_T      renames Jpats_Electrical_Types;
   package Ldg_Light  renames Ctnr.Landing_Light;
   package Taxi_Light renames Ctnr.Taxi_Light;
   package Util_Light renames Ctnr.Utility_Lighting;
   package Gear       renames Jpats_Landing_Gear;
   package Gear_T     renames Jpats_Landing_Gear_Types;
   package Pwr_Supply renames Ctnr.Wing_Light_Power_Supply;
   package Anti_Coll_Lights renames Ctnr.Anti_Collision_Lights;
   package Nav_Lights       renames Ctnr.Navigation_Lights;
   package Position_Lights  renames Ctnr.Position_Lights;
   package Flood_Lights     renames Ctnr.Flood_Lighting;
   package Console_Lights   renames Ctnr.Console_Lighting;
   package Instrument_Lights renames Ctnr.Instrument_Lighting;

   The_Ldg_Light : Ldg_Light.Instance renames Ctnr.This_Subsystem.The_Landing_Light;
   The_Taxi_Light : Taxi_Light.Instance renames Ctnr.This_Subsystem.The_Taxi_Light;
   The_Util_Light : Util_Light.Instance renames Ctnr.This_Subsystem.The_Utility_Light;
   The_Left_Wing_Pwr_Supply : Pwr_Supply.Instance renames Ctnr.This_Subsystem.The_Left_Wing_Power_Supply;
   The_Right_Wing_Pwr_Supply : Pwr_Supply.Instance renames Ctnr.This_Subsystem.The_Right_Wing_Power_Supply;
   The_Anti_Coll_Lights : Anti_Coll_Lights.Instance renames Ctnr.This_Subsystem.The_Anti_Collision_Lights;
   The_Nav_Lights : Nav_Lights.Instance renames Ctnr.This_Subsystem.The_Navigation_Lights;
   The_Position_Lights : Position_Lights.Instance renames Ctnr.This_Subsystem.The_Position_Lights;
   The_Flood_Lights : Flood_Lights.Instance renames Ctnr.This_Subsystem.The_Flood_Lights;
   The_Console_Lights : Console_Lights.Instance renames Ctnr.This_Subsystem.The_Console_Lights;
   The_Instrument_Lights : Instrument_Lights.Instance renames Ctnr.This_Subsystem.The_Instrument_Lights;

   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

begin
   -------------------------------------------------------------------------------
   -- Test_1
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

Test_1 : declare
   Test_Case_1 : array (1..13) of Boolean;
   Flag : Integer := 0;
begin

   Controller.Initialize;

   Test_Case_1 (1) := not Ldg_Light.Is_On (The_Ldg_Light);
   Test_Case_1 (2) := not Taxi_Light.Is_On (The_Taxi_Light);
   Test_Case_1 (3) := not Util_Light.Is_On (The_Util_Light);
   Test_Case_1 (4) := not Pwr_Supply.Nav_Out (The_Left_Wing_Pwr_Supply);
   Test_Case_1 (5) := not Pwr_Supply.Anti_Collision_Out (The_Left_Wing_Pwr_Supply);
   Test_Case_1 (6) := not Pwr_Supply.Nav_Out (The_Right_Wing_Pwr_Supply);
   Test_Case_1 (7) := not Pwr_Supply.Anti_Collision_Out (The_Right_Wing_Pwr_Supply);
   Test_Case_1 (8) := Anti_Coll_Lights.load (The_Anti_Coll_Lights) = 0.0;
   Test_Case_1 (9) := Nav_Lights.load (The_Nav_Lights) = 0.0;
   Test_Case_1 (10) := Position_Lights.load (The_Position_Lights) = 0.0;
   Test_Case_1 (11) := not Flood_Lights.Is_Powered (The_Flood_Lights);
   Test_Case_1 (12) := not Console_Lights.Is_Powered (The_Console_Lights);
   Test_Case_1 (13) := not Instrument_Lights.Is_Powered (The_Instrument_Lights);

   for I in 1..13
   loop
      exit when not Test_Case_1 (I);
      Flag := I;
   end loop;
   Class_Test_Result_File.Report_Case_Status (Success => Flag = 13, Number => 1);


end Test_1;



-------------------------------------------------------------------------------
-- Test_2
--
-- Inputs           :
-- Expected results :
-- Purpose          :


Test_2 : declare
   Test_Case_2 : array (1..13) of Boolean;
   Flag : Integer := 0;
   Iconst : constant Float := 0.066667;
begin


   Controller.Initialize;


   Io.Lamp_Test_Sw                := true;      -- Boolean;
   Io.Ldg_Lts_Sw                  := true;      -- Boolean;
   Io.Taxi_Lts_Sw                 := true;      -- Boolean;
   Io.Anti_Collision_Lts_Sw       := true;      -- Boolean;
   Io.Cont_Nav_Lts_Sw             := true;      -- Boolean;
   Io.Instrument_Pnl_On_Sw        := true;      -- Boolean;
   Io.Side_Pnl_On_Sw              := true;      -- Boolean;
   Io.Flood_Ltg_On_Sw             := true;      -- Boolean;


   Controller.Update (Iconst);

   Test_Case_2 (1) := Ldg_Light.Is_On (The_Ldg_Light);
   Test_Case_2 (2) := Taxi_Light.Is_On (The_Taxi_Light);
   Test_Case_2 (3) := Util_Light.Is_On (The_Util_Light);
   Test_Case_2 (4) := Pwr_Supply.Nav_Out (The_Left_Wing_Pwr_Supply);
   Test_Case_2 (5) := Pwr_Supply.Anti_Collision_Out (The_Left_Wing_Pwr_Supply);
   Test_Case_2 (6) := Pwr_Supply.Nav_Out (The_Right_Wing_Pwr_Supply);
   Test_Case_2 (7) := Pwr_Supply.Anti_Collision_Out (The_Right_Wing_Pwr_Supply);
   Test_Case_2 (8) := Anti_Coll_Lights.load (The_Anti_Coll_Lights) > 0.0;
   Test_Case_2 (9) := Nav_Lights.load (The_Nav_Lights) > 0.0;
   Test_Case_2 (10) := Position_Lights.load (The_Position_Lights) > 0.0;
   Test_Case_2 (11) := Flood_Lights.Is_Powered (The_Flood_Lights);
   Test_Case_2 (12) := Console_Lights.Is_Powered (The_Console_Lights);
   Test_Case_2 (13) := Instrument_Lights.Is_Powered (The_Instrument_Lights);

   for I in 1..13
   loop
      exit when not Test_Case_2 (I);
      Flag := I;
   end loop;
   Class_Test_Result_File.Report_Case_Status (Success => Flag = 13, Number => 1);
end Test_2;


null;
end Jpats_Lights.Controller_Ctd;
