-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Electrical.Container;
with Power_Supply.Generator;

package body Jpats_Electrical is


   -- circuit breakers
   function Is_Powered
     (Name : in Jpats_Electrical_Types.Circuit_Breaker_Name_Type)
     return Boolean
   is
      package Ctnr renames Container;
      package Cbs renames Ctnr.Circuit_Breaker_Collection;
   begin
      return true; --Cbs.Is_Powered (Ctnr.This_Subsystem.The_Circuit_Breakers, Name);
   end Is_Powered;

   procedure Trip
     (Name : in Jpats_Electrical_Types.Circuit_Breaker_Name_Type)
   is
      Host : Container.Host_Interface_Instance renames Container.This_Host_Interface;
      package Ele renames Jpats_Electrical_Types;
   begin
      case Name is
         when Ele.Ail_El_Trim_Cb                  => Host.Ail_El_Trim_Do     := True;
         when Ele.Rud_Trim_Cb                     => Host.Rud_Trim_Do        := True;
         when Ele.Ldg_Gr_Cont_Cb                  => Host.Ldg_Gr_Cont_Do     := True;
         when Ele.Flap_Cont_Cb                    => Host.Flap_Cont_Do       := True;
         when Ele.Util_Lt_Cb                      => Host.Util_Do            := True;
         when Ele.Coll_Lts_Cb                     => Host.Coll_Do            := True;
         when Ele.Inst_Lts_Cb                     => Host.Inst_Do            := True;
         when Ele.Ldg_Lts_Cb                      => Host.Ldg_Do             := True;
         when Ele.Cws_Cb_Fwd_Batt_Bus             => Host.Cws_Batt_Do        := True;
         when Ele.Fuel_Qty_Lo_Cb                  => Host.Fuel_Qty_Lo_Do     := True;
         when Ele.Pmu_Cb                          => Host.Pmu_Do             := True;
         when Ele.Boost_Pump_Cb                   => Host.Boost_Pump_Do      := True;
         when Ele.Ign_Cb                          => Host.Ign_Do             := True;
         when Ele.Start_Cb                        => Host.Start_Do           := True;
         when Ele.Oil_Trx_Cb                      => Host.Oil_Trx_Do         := True;
         when Ele.Batt_Sw_Cb                      => Host.Bat_Sw_Do          := True;
         when Ele.Avi_Mstr_Cb                     => Host.Avi_Mstr_Do        := True;
         when Ele.Fld_Lts_Cb                      => Host.Fldt_Do            := True;
         when Ele.Alt_Eng_Dis_Cb                  => Host.Alt_Eng_Dis_Do     := True;
         when Ele.Edm_Cb_Fwd_Batt_Bus             => Host.Edm_Batt_Do        := True;
         when Ele.Prop_Sys_Cb                     => Host.Prop_Sys_Do        := True;
         when Ele.Fdr_Cb                          => Host.Fdr_Do             := True;
         when Ele.Aoa_Cb                          => Host.Aoa_Do             := True;
         when Ele.Inflow_Sys_Cb                   => Host.Inflow_Sys_Do      := True;
         when Ele.Hyd_Sys_Cb                      => Host.Hyd_Sys_Do         := True;
         when Ele.Audio_Cb                        => Host.Audio_Do           := True;
         when Ele.Aft_Battery_Cb                  => Host.Aft_Bat_Do         := True;
         when Ele.Aux_Battery_Cb                  => Host.Aux_Bat_Do         := True;
         when Ele.Fwd_Avi_Cb_Fwd_Batt_Bus         => Host.Fwd_Avi_Batt_Do    := True;

         when Ele.Eadi_Cb                         => Host.Eadi_Do            := True;
         when Ele.Gps_Cb                          => Host.Gps_Do             := True;
         when Ele.Ahrs_Cb                         => Host.Ahrs_Do            := True;
         when Ele.Aft_Avi_Cb_Fwd_Avi_Batt_Bus     => Host.Aft_Avi_Batt_Do    := True;

         when Ele.Gyro_Cb                         => Host.Gyro_Do            := True;
         when Ele.Altm_Cb_Fwd_Aux_Batt_Bus        => Host.Altm_Batt_Do       := True;
         when Ele.Trn_Rt_Cb                       => Host.Turn_Rt_Do         := True;
         when Ele.Uhf_Comm_Cb                     => Host.Uhf_Comm_Do        := True;
         when Ele.Radio_Rlys_Cb_Fwd_Aux_Batt_Bus  => Host.Radio_Rlys_Batt_Do := True;
         when Ele.Fire_Detect_Cb_Fwd_Aux_Batt_Bus => Host.Fire_1_Do          := True;
         when Ele.Stby_Lts_Cb                     => Host.Stby_Do            := True;
         when Ele.Aft_Stby_Cb                     => Host.Aft_Inst_Do        := True;



         when Ele.Air_Cond_Cb                     => Host.Air_Cond_Do        := True;
         when Ele.Ckpt_Temp_Cb                    => Host.Ckpt_Temp_Do       := True;
         when Ele.Aural_Warn_Cb                   => Host.Aural_Warn_Do      := True;
         when Ele.Evap_Blower_Cb                  => Host.Evap_Blower_Do     := True;
         when Ele.Aoa_Ht_Cb                       => Host.Aoa_Ht_Do          := True;
         when Ele.Pitot_Ht_Cb                     => Host.Pitot_Ht_Do        := True;
         when Ele.Fuel_Bal_Cb                     => Host.Fuel_Bal_Do        := True;
         when Ele.Side_Lts_Cb                     => Host.Side_Do            := True;
         when Ele.Nav_Lts_Cb                      => Host.Nav_Do             := True;
         when Ele.Taxi_Lts_Cb                     => Host.Taxi_Do            := True;
         when Ele.Speedbrake_Cb                   => Host.Speed_Brake_Do     := True;
         when Ele.Nws_Cb                          => Host.Nws_Do             := True;
         when Ele.Test_Lts_Cb                     => Host.Test_Do            := True;
         when Ele.Trim_Ind_Cb                     => Host.Trim_Ind_Do        := True;
         when Ele.Edm_Cb_Fwd_Gen_Bus              => Host.Edm_Gen_Do         := True;
         when Ele.Gen_Sw_Cb                       => Host.Gen_Sw_Do          := True;
         when Ele.Fwd_Avi_Cb_Fwd_Gen_Bus          => Host.Fwd_Avi_Gen_Do     := True;
         when Ele.Fire_Detect_Cb_Fwd_Gen_Bus      => Host.Fire_2_Do          := True;
         when Ele.Eng_Sys_Dis_Cb                  => Host.Eng_Sys_Dis_Do     := True;
         when Ele.Pri_Eng_Dis_Cb                  => Host.Pri_Eng_Dis_Do     := True;
         when Ele.Tad_Cb                          => Host.Tad_Do             := True;
         when Ele.Seat_Adj_Cb                     => Host.Seat_Adj_Do        := True;
         when Ele.Cws_Cb_Fwd_Gen_Bus              => Host.Cws_Gen_Do         := True;
         when Ele.Aft_Gen_Cb                      => Host.Aft_Gen_Do         := True;

         when Ele.Adc_Cb                          => Host.Adc_Do             := True;
         when Ele.Ehsi_Cb                         => Host.Ehsi_Do            := True;
         when Ele.Xpdr_Cb                         => Host.Xpdr_Do            := True;
         when Ele.Nacws_Cb                        => Host.Nacws_Do           := True;
         when Ele.Vhf_Comm_Cb                     => Host.Vhf_Comm_Do        := True;
         when Ele.Asi_Cb                          => Host.Asi_Do             := True;
         when Ele.Altm_Cb_Fwd_Avi_Gen_Bus         => Host.Altm_Gen_Do        := True;
         when Ele.Vhf_Nav_Cb                      => Host.Vhf_Nav_Do         := True;
         when Ele.Dme_Cb                          => Host.Dme_Do             := True;
         when Ele.Radio_Rlys_Cb_Fwd_Avi_Gen_Bus   => Host.Radio_Rlys_Do      := True;
         when Ele.Vvi_Cb                          => Host.Vvi_Do             := True;
         when Ele.Rmu_Cb                          => Host.Rmu_Gen_Do         := True;
         when Ele.Aft_Avi_Cb_Fwd_Avi_Gen_Bus      => Host.Aft_Avi_Gen_Do     := True;

         when others => null;

      end case;
   end Trip;





   procedure Clear_Trip
     (Name : in Jpats_Electrical_Types.Circuit_Breaker_Name_Type)
   is
      Host : Container.Host_Interface_Instance renames Container.This_Host_Interface;
      package Ele renames Jpats_Electrical_Types;
   begin
      case Name is
         when Ele.Ail_El_Trim_Cb                  => Host.Ail_El_Trim_Do     := False;
         when Ele.Rud_Trim_Cb                     => Host.Rud_Trim_Do        := False;
         when Ele.Ldg_Gr_Cont_Cb                  => Host.Ldg_Gr_Cont_Do     := False;
         when Ele.Flap_Cont_Cb                    => Host.Flap_Cont_Do       := False;
         when Ele.Util_Lt_Cb                      => Host.Util_Do            := False;
         when Ele.Coll_Lts_Cb                     => Host.Coll_Do            := False;
         when Ele.Inst_Lts_Cb                     => Host.Inst_Do            := False;
         when Ele.Ldg_Lts_Cb                      => Host.Ldg_Do             := False;
         when Ele.Cws_Cb_Fwd_Batt_Bus             => Host.Cws_Batt_Do        := False;
         when Ele.Fuel_Qty_Lo_Cb                  => Host.Fuel_Qty_Lo_Do     := False;
         when Ele.Pmu_Cb                          => Host.Pmu_Do             := False;
         when Ele.Boost_Pump_Cb                   => Host.Boost_Pump_Do      := False;
         when Ele.Ign_Cb                          => Host.Ign_Do             := False;
         when Ele.Start_Cb                        => Host.Start_Do           := False;
         when Ele.Oil_Trx_Cb                      => Host.Oil_Trx_Do         := False;
         when Ele.Batt_Sw_Cb                      => Host.Bat_Sw_Do          := False;
         when Ele.Avi_Mstr_Cb                     => Host.Avi_Mstr_Do        := False;
         when Ele.Fld_Lts_Cb                      => Host.Fldt_Do            := False;
         when Ele.Alt_Eng_Dis_Cb                  => Host.Alt_Eng_Dis_Do     := False;
         when Ele.Edm_Cb_Fwd_Batt_Bus             => Host.Edm_Batt_Do        := False;
         when Ele.Prop_Sys_Cb                     => Host.Prop_Sys_Do        := False;
         when Ele.Fdr_Cb                          => Host.Fdr_Do             := False;
         when Ele.Aoa_Cb                          => Host.Aoa_Do             := False;
         when Ele.Inflow_Sys_Cb                   => Host.Inflow_Sys_Do      := False;
         when Ele.Hyd_Sys_Cb                      => Host.Hyd_Sys_Do         := False;
         when Ele.Audio_Cb                        => Host.Audio_Do           := False;
         when Ele.Aft_Battery_Cb                  => Host.Aft_Bat_Do         := False;
         when Ele.Aux_Battery_Cb                  => Host.Aux_Bat_Do         := False;
         when Ele.Fwd_Avi_Cb_Fwd_Batt_Bus         => Host.Fwd_Avi_Batt_Do    := False;

         when Ele.Eadi_Cb                         => Host.Eadi_Do            := False;
         when Ele.Gps_Cb                          => Host.Gps_Do             := False;
         when Ele.Ahrs_Cb                         => Host.Ahrs_Do            := False;
         when Ele.Aft_Avi_Cb_Fwd_Avi_Batt_Bus     => Host.Aft_Avi_Batt_Do    := False;

         when Ele.Gyro_Cb                         => Host.Gyro_Do            := False;
         when Ele.Altm_Cb_Fwd_Aux_Batt_Bus        => Host.Altm_Batt_Do       := False;
         when Ele.Trn_Rt_Cb                       => Host.Turn_Rt_Do         := False;
         when Ele.Uhf_Comm_Cb                     => Host.Uhf_Comm_Do        := False;
         when Ele.Radio_Rlys_Cb_Fwd_Aux_Batt_Bus  => Host.Radio_Rlys_Batt_Do := False;
         when Ele.Fire_Detect_Cb_Fwd_Aux_Batt_Bus => Host.Fire_1_Do          := False;
         when Ele.Stby_Lts_Cb                     => Host.Stby_Do            := False;
         when Ele.Aft_Stby_Cb                     => Host.Aft_Inst_Do        := False;



         when Ele.Air_Cond_Cb                     => Host.Air_Cond_Do        := False;
         when Ele.Ckpt_Temp_Cb                    => Host.Ckpt_Temp_Do       := False;
         when Ele.Aural_Warn_Cb                   => Host.Aural_Warn_Do      := False;
         when Ele.Evap_Blower_Cb                  => Host.Evap_Blower_Do     := False;
         when Ele.Aoa_Ht_Cb                       => Host.Aoa_Ht_Do          := False;
         when Ele.Pitot_Ht_Cb                     => Host.Pitot_Ht_Do        := False;
         when Ele.Fuel_Bal_Cb                     => Host.Fuel_Bal_Do        := False;
         when Ele.Side_Lts_Cb                     => Host.Side_Do            := False;
         when Ele.Nav_Lts_Cb                      => Host.Nav_Do             := False;
         when Ele.Taxi_Lts_Cb                     => Host.Taxi_Do            := False;
         when Ele.Speedbrake_Cb                   => Host.Speed_Brake_Do     := False;
         when Ele.Nws_Cb                          => Host.Nws_Do             := False;
         when Ele.Test_Lts_Cb                     => Host.Test_Do            := False;
         when Ele.Trim_Ind_Cb                     => Host.Trim_Ind_Do        := False;
         when Ele.Edm_Cb_Fwd_Gen_Bus              => Host.Edm_Gen_Do         := False;
         when Ele.Gen_Sw_Cb                       => Host.Gen_Sw_Do          := False;
         when Ele.Fwd_Avi_Cb_Fwd_Gen_Bus          => Host.Fwd_Avi_Gen_Do     := False;
         when Ele.Fire_Detect_Cb_Fwd_Gen_Bus      => Host.Fire_2_Do          := False;
         when Ele.Eng_Sys_Dis_Cb                  => Host.Eng_Sys_Dis_Do     := False;
         when Ele.Pri_Eng_Dis_Cb                  => Host.Pri_Eng_Dis_Do     := False;
         when Ele.Tad_Cb                          => Host.Tad_Do             := False;
         when Ele.Seat_Adj_Cb                     => Host.Seat_Adj_Do        := False;
         when Ele.Cws_Cb_Fwd_Gen_Bus              => Host.Cws_Gen_Do         := False;
         when Ele.Aft_Gen_Cb                      => Host.Aft_Gen_Do         := False;

         when Ele.Adc_Cb                          => Host.Adc_Do             := False;
         when Ele.Ehsi_Cb                         => Host.Ehsi_Do            := False;
         when Ele.Xpdr_Cb                         => Host.Xpdr_Do            := False;
         when Ele.Nacws_Cb                        => Host.Nacws_Do           := False;
         when Ele.Vhf_Comm_Cb                     => Host.Vhf_Comm_Do        := False;
         when Ele.Asi_Cb                          => Host.Asi_Do             := False;
         when Ele.Altm_Cb_Fwd_Avi_Gen_Bus         => Host.Altm_Gen_Do        := False;
         when Ele.Vhf_Nav_Cb                      => Host.Vhf_Nav_Do         := False;
         when Ele.Dme_Cb                          => Host.Dme_Do             := False;
         when Ele.Radio_Rlys_Cb_Fwd_Avi_Gen_Bus   => Host.Radio_Rlys_Do      := False;
         when Ele.Vvi_Cb                          => Host.Vvi_Do             := False;
         when Ele.Rmu_Cb                          => Host.Rmu_Gen_Do         := False;
         when Ele.Aft_Avi_Cb_Fwd_Avi_Gen_Bus      => Host.Aft_Avi_Gen_Do     := False;

         when others => null;

      end case;

   end Clear_Trip;

   procedure Clear_All_Trip
   is
      Host : Container.Host_Interface_Instance renames Container.This_Host_Interface;
   begin
      Host.Ail_El_Trim_Do     := False;
      Host.Rud_Trim_Do        := False;
      Host.Ldg_Gr_Cont_Do     := False;
      Host.Flap_Cont_Do       := False;
      Host.Util_Do            := False;
      Host.Coll_Do            := False;
      Host.Inst_Do            := False;
      Host.Ldg_Do             := False;
      Host.Cws_Batt_Do        := False;
      Host.Fuel_Qty_Lo_Do     := False;
      Host.Pmu_Do             := False;
      Host.Boost_Pump_Do      := False;
      Host.Ign_Do             := False;
      Host.Start_Do           := False;
      Host.Oil_Trx_Do         := False;
      Host.Bat_Sw_Do          := False;
      Host.Avi_Mstr_Do        := False;
      Host.Fldt_Do            := False;
      Host.Alt_Eng_Dis_Do     := False;
      Host.Edm_Batt_Do        := False;
      Host.Prop_Sys_Do        := False;
      Host.Fdr_Do             := False;
      Host.Aoa_Do             := False;
      Host.Inflow_Sys_Do      := False;
      Host.Hyd_Sys_Do         := False;
      Host.Audio_Do           := False;
      Host.Aft_Bat_Do         := False;
      Host.Aux_Bat_Do         := False;
      Host.Fwd_Avi_Batt_Do    := False;

      Host.Eadi_Do            := False;
      Host.Gps_Do             := False;
      Host.Ahrs_Do            := False;
      Host.Aft_Avi_Batt_Do    := False;

      Host.Gyro_Do            := False;
      Host.Altm_Batt_Do       := False;
      Host.Turn_Rt_Do         := False;
      Host.Uhf_Comm_Do        := False;
      Host.Radio_Rlys_Batt_Do := False;
      Host.Fire_1_Do          := False;
      Host.Stby_Do            := False;
      Host.Aft_Inst_Do        := False;



      Host.Air_Cond_Do        := False;
      Host.Ckpt_Temp_Do       := False;
      Host.Aural_Warn_Do      := False;
      Host.Evap_Blower_Do     := False;
      Host.Aoa_Ht_Do          := False;
      Host.Pitot_Ht_Do        := False;
      Host.Fuel_Bal_Do        := False;
      Host.Side_Do            := False;
      Host.Nav_Do             := False;
      Host.Taxi_Do            := False;
      Host.Speed_Brake_Do     := False;
      Host.Nws_Do             := False;
      Host.Test_Do            := False;
      Host.Trim_Ind_Do        := False;
      Host.Edm_Gen_Do         := False;
      Host.Gen_Sw_Do          := False;
      Host.Fwd_Avi_Gen_Do     := False;
      Host.Fire_2_Do          := False;
      Host.Eng_Sys_Dis_Do     := False;
      Host.Pri_Eng_Dis_Do     := False;
      Host.Tad_Do             := False;
      Host.Seat_Adj_Do        := False;
      Host.Cws_Gen_Do         := False;
      Host.Aft_Gen_Do         := False;

      Host.Adc_Do             := False;
      Host.Ehsi_Do            := False;
      Host.Xpdr_Do            := False;
      Host.Nacws_Do           := False;
      Host.Vhf_Comm_Do        := False;
      Host.Asi_Do             := False;
      Host.Altm_Gen_Do        := False;
      Host.Vhf_Nav_Do         := False;
      Host.Dme_Do             := False;
      Host.Radio_Rlys_Do      := False;
      Host.Vvi_Do             := False;
      Host.Rmu_Gen_Do         := False;
      Host.Aft_Avi_Gen_Do     := False;
   end Clear_All_Trip;



   -- relays
   function Is_Closed
     (Name : in Jpats_Electrical_Types.Relay_Name_Type)
     return Boolean
   is
      package Ctnr renames Container;
      package Relays renames Ctnr.Coil_Relay_Collection;
   begin
      return Relays.Is_Closed (Ctnr.This_Subsystem.The_Relays, Name);
   end Is_Closed;

   -- master caution panel light requests
   function Bat_Bus_Annunciator_Request return Boolean
   is
      package Ele renames Jpats_Electrical_Types;
   begin
      return not Is_Powered (Ele.Cws_Cb_Fwd_Batt_Bus);
   end Bat_Bus_Annunciator_Request;

   function Gen_Bus_Annunciator_Request return Boolean
   is
      package Ele renames Jpats_Electrical_Types;
   begin
      return not Is_Powered (Ele.Cws_Cb_Fwd_Gen_Bus);
   end Gen_Bus_Annunciator_Request;

   function Gen_Annunciator_Request return Boolean
   is
      package Ctnr renames Container;
      package Gcu  renames Ctnr.Generator_Control_Unit;
   begin
      return not Gcu.Line_Control (Ctnr.This_Subsystem.The_Generator_Control_Unit);
   end Gen_Annunciator_Request;

   function Bus_Tie_Annunciator_Request return Boolean
   is
      package Ele    renames Jpats_Electrical_Types;
      package Ctnr   renames Container;
      package Relays renames Ctnr.Coil_Relay_Collection;
   begin
      return Relays.Is_Open (Ctnr.This_Subsystem.The_Relays, Ele.Bus_Tie_Relay) and Is_Powered (Ele.Bus_Tie_Control_Cb);
   end Bus_Tie_Annunciator_Request;

   function Starter_Torque return Float
   is
      package Ctnr renames Container;
   begin
      return Power_Supply.Generator.Torque (Ctnr.This_Subsystem.The_Generator);
   end Starter_Torque;

   function Emergency_Lights return Boolean
   is
   begin
      return Container.Auxiliary_Battery_Mount.Lights_Out (Container.This_Subsystem.The_Auxiliary_Battery_Mount);
   end Emergency_Lights;


end Jpats_electrical;



