-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Landing_Gear_Door_G;

procedure Landing_Gear_Door_G_Ctd is



begin

   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter_Latch  : Boolean := true;
      In_Second_Quarter_Latch : Boolean := true;
      In_Third_Quarter_Latch  : Boolean := true;
      In_Fourth_Quarter_Latch : Boolean := true;

      In_First_Quarter_Timer  : Float := 0.0;
      In_Second_Quarter_Timer : Float := 0.0;
      In_Third_Quarter_Timer  : Float := 0.0;
      In_Fourth_Quarter_Timer : Float := 0.0;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      subtype Pos_Type is Float range 0.0..1.0;
      subtype Hyd_Fcn_Type is Float range 0.0..1.0;

      package Ldg_Gr_Door is new Landing_Gear_Door_G
        (Position_Type  => Pos_Type,
         Hyd_Load_Type  => Float,
         Hyd_Fcn_Type   => Hyd_Fcn_Type);

      A_Door : Ldg_Gr_Door.Instance;
      K_Hyd : Hyd_Fcn_Type := 1.0;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;
      Test_16 : Boolean;
      Test_17 : Boolean;
      Test_18 : Boolean;
      Test_19 : Boolean;
      Test_20 : Boolean;
      Test_21 : Boolean;
      Test_22 : Boolean;
      Test_23 : Boolean;
      Test_24 : Boolean;
      Test_25 : Boolean;

   begin

      Ldg_Gr_Door.Initialize (A_Door);

      Test_1 := Ldg_Gr_Door.Position (A_Door) = 0.0;
      Test_2 := Ldg_Gr_Door.Up_Locked (A_Door);
      Test_3 := not Ldg_Gr_Door.Open (A_Door);
      Test_4 := not Ldg_Gr_Door.In_Transit (A_Door);
      Test_5 := Ldg_Gr_Door.Hydraulic_Load (A_Door) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
      Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
      Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Ldg_Gr_Door.Extend
              (An_Instance => A_Door,
               Iconst      => Iconst,
               Hyd_Fcn     => K_Hyd);

            if In_First_Quarter_Latch and In_First_Quarter_Timer > 1.5 then
               Test_6  := Ldg_Gr_Door.Position (A_Door) = 1.0;
               Test_7  := not Ldg_Gr_Door.Up_Locked (A_Door);
               Test_8  := Ldg_Gr_Door.Open (A_Door);
               Test_9  := not Ldg_Gr_Door.In_Transit (A_Door);
               Test_10 := Ldg_Gr_Door.Hydraulic_Load (A_Door) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
               Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
               Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
               Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               In_First_Quarter_Latch := False;
            end if;
            In_First_Quarter_Timer := In_First_Quarter_Timer + Iconst;

         elsif Now < Two_Quarter_Time then


            Ldg_Gr_Door.Retract
              (An_Instance => A_Door,
               Iconst      => Iconst,
               Hyd_Fcn     => K_Hyd);

            if In_Second_Quarter_Latch and In_Second_Quarter_Timer > 1.5 then
               Test_11 := Ldg_Gr_Door.Position (A_Door) = 0.0;
               Test_12 := Ldg_Gr_Door.Up_Locked (A_Door);
               Test_13 := not Ldg_Gr_Door.Open (A_Door);
               Test_14 := not Ldg_Gr_Door.In_Transit (A_Door);
               Test_15 := Ldg_Gr_Door.Hydraulic_Load (A_Door) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               In_Second_Quarter_Latch := False;
            end if;
            In_Second_Quarter_Timer := In_Second_Quarter_Timer + Iconst;
         elsif Now < Three_Quarter_Time then


            Ldg_Gr_Door.Extend
              (An_Instance => A_Door,
               Iconst      => Iconst,
               Hyd_Fcn     => K_Hyd);

            if In_Third_Quarter_Latch and In_Third_Quarter_Timer > 1.5 then
               Test_16 := Ldg_Gr_Door.Position (A_Door) = 1.0;
               Test_17 := not Ldg_Gr_Door.Up_Locked (A_Door);
               Test_18 := Ldg_Gr_Door.Open (A_Door);
               Test_19 := not Ldg_Gr_Door.In_Transit (A_Door);
               Test_20 := Ldg_Gr_Door.Hydraulic_Load (A_Door) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);
               In_Third_Quarter_Latch := False;
            end if;
            In_Third_Quarter_Timer := In_Third_Quarter_Timer + Iconst;
         else


            Ldg_Gr_Door.Retract
              (An_Instance => A_Door,
               Iconst      => Iconst,
               Hyd_Fcn     => K_Hyd);

            if In_Fourth_Quarter_Latch and In_Fourth_Quarter_Timer > 1.5 then
               Test_21 := Ldg_Gr_Door.Position (A_Door) = 0.0;
               Test_22 := Ldg_Gr_Door.Up_Locked (A_Door);
               Test_23 := not Ldg_Gr_Door.Open (A_Door);
               Test_24 := not Ldg_Gr_Door.In_Transit (A_Door);
               Test_25 := Ldg_Gr_Door.Hydraulic_Load (A_Door) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_21, Number => 21);
               Class_Test_Result_File.Report_Case_Status (Success => Test_22, Number => 22);
               Class_Test_Result_File.Report_Case_Status (Success => Test_23, Number => 23);
               Class_Test_Result_File.Report_Case_Status (Success => Test_24, Number => 24);
               Class_Test_Result_File.Report_Case_Status (Success => Test_25, Number => 25);
               In_Fourth_Quarter_Latch := False;
            end if;
            In_Fourth_Quarter_Timer := In_Fourth_Quarter_Timer + Iconst;
         end if;

      end loop;


   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;


end Landing_Gear_Door_G_Ctd;
