-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Landing_Gear.Controller;
with Jpats_Landing_Gear.Container;

with Jpats_Electrical;
with Jpats_Electrical_Types;
with Electrical_Units_Types;
with Jpats_Landing_Gear_Types;
with Jpats_Hydraulics;
with Jpats_Hydraulics_Types;
with Jpats_Auto_Test;
with Jpats_Secondary_Flight_Controls;
with Jpats_Secondary_Flight_Controls_Types;

procedure Jpats_Landing_Gear.Controller_Ctd is
   package Ctnr       renames Container;
   package Ele        renames Jpats_Electrical;
   package Ele_T      renames Jpats_Electrical_Types;
   package Ele_U      renames Electrical_Units_Types;
   package Main_Gear  renames Ctnr.Main_Gear;
   package Nose_Gear  renames Ctnr.Nose_Gear;
   package Gear_T     renames Jpats_Landing_Gear_Types;
   package Gear_Door  renames Ctnr.Gear_Door;
   package Hyd        renames Jpats_Hydraulics;
   package Hyd_T      renames Jpats_Hydraulics_Types;
   package Switches   renames Ctnr.Position_Switches;
   package Relays     renames Ctnr.Relays;
   package Brake      renames Ctnr.Brake;
   package Indicators renames Ctnr.Gear_Position_Indicators;
   package Auto_Test  renames Jpats_Auto_Test;
   package Sfc        renames Jpats_Secondary_Flight_Controls;
   package Sfc_T      renames Jpats_Secondary_Flight_Controls_Types;

   The_Left_Gear       : Main_Gear.Instance renames Ctnr.This_Subsystem.The_Left_Main_Landing_Gear;
   The_Right_Gear      : Main_Gear.Instance renames Ctnr.This_Subsystem.The_Right_Main_Landing_Gear;
   The_Nose_Gear       : Nose_Gear.Instance renames Ctnr.This_Subsystem.The_Nose_Landing_Gear;
   The_Left_Gear_Door  : Gear_Door.Instance renames Ctnr.This_Subsystem.The_Left_Main_Gear_Door;
   The_Right_Gear_Door : Gear_Door.Instance renames Ctnr.This_Subsystem.The_Right_Main_Gear_Door;
   The_Switches        : Switches.Instance  renames Ctnr.This_Subsystem.The_Gear_Position_Switches;
   The_Relays          : Relays.Instance    renames Ctnr.This_Subsystem.The_Gear_Position_Relays;
   The_Left_Brake      : Brake.Instance     renames Ctnr.This_Subsystem.The_Left_Brake;
   The_Right_Brake     : Brake.Instance     renames Ctnr.This_Subsystem.The_Right_Brake;
   The_Indicators      : Indicators.Instance renames Ctnr.This_Subsystem.The_Position_Indicators;


   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

begin

Test_1 : declare
   Test_Case_1 : array (1..53) of Boolean;
   Flag : Integer := 0;
begin

   Controller.Initialize;

   Test_Case_1 (1) := Main_Gear.Position (The_Left_Gear) = 1.0;
   Test_Case_1 (2) := Main_Gear.Position (The_Right_Gear) = 1.0;
   Test_Case_1 (3) := nose_Gear.Position (The_Nose_Gear) =1.0;
   Test_Case_1 (4) := not Main_Gear.Up_Locked (The_Left_Gear);
   Test_Case_1 (5) := not Main_Gear.Up_Locked (The_Right_Gear);
   Test_Case_1 (6) := not Nose_Gear.Up_Locked (The_Nose_Gear);
   Test_Case_1 (7) := Main_Gear.Down_Locked (The_Left_Gear);
   Test_Case_1 (8) := Main_Gear.Down_Locked (The_Right_Gear);
   Test_Case_1 (9) := Nose_Gear.Down_Locked (The_Nose_Gear);
   Test_Case_1 (10) := not Main_Gear.In_Transit (The_Left_Gear);
   Test_Case_1 (11) := not Main_Gear.In_Transit (The_Right_Gear);
   Test_Case_1 (12) := not Nose_Gear.In_Transit (The_Nose_Gear);
   Test_Case_1 (13) := Main_Gear.Hydraulic_Load (The_Left_Gear) = 0.0;
   Test_Case_1 (14) := Main_Gear.Hydraulic_Load (The_Right_Gear) = 0.0;
   Test_Case_1 (15) := Nose_Gear.Hydraulic_Load (The_Nose_Gear) = 0.0;
   Test_Case_1 (16) := Gear_Door.Position (The_Left_Gear_Door) = 0.0;
   Test_Case_1 (17) := Gear_Door.Position (The_Right_Gear_Door) = 0.0;
   Test_Case_1 (18) := Gear_Door.Up_Locked (The_Left_Gear_Door);
   Test_Case_1 (19) := Gear_Door.Up_Locked (The_Right_Gear_Door);
   Test_Case_1 (20) := not Gear_Door.Open (The_Left_Gear_Door);
   Test_Case_1 (21) := not Gear_Door.Open (The_Right_Gear_Door);
   Test_Case_1 (22) := not Gear_Door.In_Transit (The_Left_Gear_Door);
   Test_Case_1 (23) := not Gear_Door.In_Transit (The_Right_Gear_Door);
   Test_Case_1 (24) := Gear_Door.Hydraulic_Load (The_Left_Gear_Door) = 0.0;
   Test_Case_1 (25) := Gear_Door.Hydraulic_Load (The_Right_Gear_Door) = 0.0;
   Test_Case_1 (26) := Switches.Is_Open (The_Switches, Gear_T.Left_Door_Lock_Switch);
   Test_Case_1 (27) := Switches.Is_Open (The_Switches, Gear_T.Left_Main_Gear_Switch);
   Test_Case_1 (28) := Switches.Is_Open (The_Switches, Gear_T.Left_Gear_Up_And_Locked_Switch);
   Test_Case_1 (29) := Switches.Is_Open (The_Switches, Gear_T.Left_Gear_Down_And_Locked_Switch);
   Test_Case_1 (30) := Switches.Is_Open (The_Switches, Gear_T.Left_Gear_WOW_Switch);
   Test_Case_1 (31) := Switches.Is_Open (The_Switches, Gear_T.Nose_Gear_Down_And_Locked_Switch);
   Test_Case_1 (32) := Switches.Is_Open (The_Switches, Gear_T.Nose_Gear_Up_And_Locked_Switch);
   Test_Case_1 (33) := Switches.Is_Open (The_Switches, Gear_T.Right_Door_Lock_Switch);
   Test_Case_1 (34) := Switches.Is_Open (The_Switches, Gear_T.Right_Main_Gear_Switch);
   Test_Case_1 (35) := Switches.Is_Open (The_Switches, Gear_T.Right_Gear_Up_And_Locked_Switch);
   Test_Case_1 (36) := Switches.Is_Open (The_Switches, Gear_T.Right_Gear_Down_And_Locked_Switch);
   Test_Case_1 (37) := Switches.Is_Open (The_Switches, Gear_T.Right_Gear_WOW_Switch);
   Test_Case_1 (38) := Relays.Is_Open (The_Relays, Gear_T.Left_Landing_Gear_A1_WOW_Relay);
   Test_Case_1 (39) := Relays.Is_Open (The_Relays, Gear_T.Right_Landing_Gear_A1_WOW_Relay);
   Test_Case_1 (40) := Relays.Is_Open (The_Relays, Gear_T.Left_Landing_Gear_A2_WOW_Relay);
   Test_Case_1 (41) := Relays.Is_Open (The_Relays, Gear_T.Right_Landing_Gear_A2_WOW_Relay);
   Test_Case_1 (42) := Relays.Is_Open (The_Relays, Gear_T.Q_Switch_Control_Relay);
   Test_Case_1 (43) := Relays.Is_Open (The_Relays, Gear_T.Landing_Gear_Down_And_Locked);
   Test_Case_1 (44) := Brake.Pressure (The_Left_Brake) = 0.0;
   Test_Case_1 (45) := Brake.Pressure (The_Right_Brake) = 0.0;
   Test_Case_1 (46) := Brake.Force (The_Left_Brake) = 0.0;
   Test_Case_1 (47) := Brake.Force (The_Right_Brake) = 0.0;
   Test_Case_1 (48) := not Indicators.Is_On (The_Indicators, Ctnr.Left_Main_Gear_Down_And_Locked_Indicator);
   Test_Case_1 (49) := not Indicators.Is_On (The_Indicators, Ctnr.Right_Main_Gear_Down_And_Locked_Indicator);
   Test_Case_1 (50) := not Indicators.Is_On (The_Indicators, Ctnr.Nose_Gear_Down_And_Locked_Indicator);
   Test_Case_1 (51) := not Indicators.Is_On (The_Indicators, Ctnr.Left_Main_Gear_In_Transit_Indicator);
   Test_Case_1 (52) := not Indicators.Is_On (The_Indicators, Ctnr.Right_Main_Gear_In_Transit_Indicator);
   Test_Case_1 (53) := not Indicators.Is_On (The_Indicators, Ctnr.Nose_Gear_In_Transit_Indicator);

   for I in 1..53
   loop
      exit when not Test_Case_1 (I);
      Flag := I;
   end loop;
   Class_Test_Result_File.Report_Case_Status (Success => Flag = 53, Number => 1);
end Test_1;


Test_2 : declare
   Test_Case_2 : array (1..10) of Boolean;
   Flag : Integer := 0;
   Iconst : constant Float := 0.066667;
begin
   Controller.Initialize;

   Io.Emer_Landing_Gear_Sw := False;
   Io.Landing_Gear_Down_Sw := true;

   for J in 1..100
   loop
      Controller.Update (Iconst);
   end loop;
   Io.Emer_Landing_Gear_Sw := False;
   Io.Landing_Gear_Down_Sw := False;

   for J in 1..100
   loop
      Controller.Update (Iconst);
   end loop;

   Test_Case_2 (1) := Gear_Door.Position (The_Left_Gear_Door) > 0.0;
   Test_Case_2 (2) := Gear_Door.Position (The_Right_Gear_Door) > 0.0;
   Test_Case_2 (3) := Main_Gear.Up_Locked (The_Left_Gear);
   Test_Case_2 (4) := Main_Gear.Up_Locked (The_Right_Gear);
   Test_Case_2 (5) := Nose_Gear.Up_Locked (The_Nose_Gear);
   Test_Case_2 (6) := true;
   Test_Case_2 (7) := true;
   Test_Case_2 (8) := true;
   Test_Case_2 (9) := true;
   Test_Case_2 (10) := true;

   for I in 1..10
   loop
      exit when not Test_Case_2 (I);
      Flag := I;
   end loop;
   Class_Test_Result_File.Report_Case_Status (Success => Flag = 10, Number => 2);
end Test_2;

end Jpats_Landing_Gear.Controller_Ctd;
