-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Hydraulics.Container;

package body Jpats_Hydraulics is

   function Primary_System_Pressure_Function
     return Jpats_Hydraulics_Types.Normalized_Pressure_Type is
   begin
      return 1.0;
   end Primary_System_Pressure_Function;

   function Emergency_System_Pressure_Function
     return Jpats_Hydraulics_Types.Normalized_Pressure_Type is
   begin
      return Jpats_Hydraulics_Types.Normalized_Pressure_Type'First;
   end Emergency_System_Pressure_Function;

   function HYDR_FL_LO_Annunciator_Request
     return Boolean is
   begin
      return False;
   end HYDR_FL_LO_Annunciator_Request;

   function HYDR_PX_LO_Annunciator_Request
     return Boolean is
   begin
      return False;
   end HYDR_PX_LO_Annunciator_Request;

   function EMERG_HYDR_PX_LO_Annunciator_Request
     return Boolean is
   begin
      return False;
   end EMERG_HYDR_PX_LO_Annunciator_Request;

end Jpats_Hydraulics;
