-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Brake_G;

procedure Brake_G_Ctd is



begin



   -------------------------------------------------------------------------------
   -- Test_1
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_1 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Brake is new Brake_G
        (Pedal_Angle_Type => Float,   -- is digits <>;
         Pressure_Type    => Float,    --i s digits <>;
         Force_Type       => Float);   --is digits <>;

      A_Brake : Brake.Instance;
      Test_Case_1 : Boolean;

   begin

      Brake.Initialize (A_Brake);

      Test_Case_1 := Brake.Pressure (A_Brake) = 0.0;

      Class_Test_Result_File.Report_Case_Status (Success => Test_Case_1, Number => 1);

   end Test_1;







   -------------------------------------------------------------------------------
   -- Test_2
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_2 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      package Brake is new Brake_G
        (Pedal_Angle_Type => Float,   -- is digits <>;
         Pressure_Type    => Float,    --i s digits <>;
         Force_Type       => Float);   --is digits <>;

      A_Brake : Brake.Instance;
      Test_Case_2 : array (1..4) of Boolean;
      Flag : Integer;
      Ped_Angle : Float := 0.0;

   begin

      Brake.Initialize (A_Brake);

      Ped_Angle := 1.0;
      Brake.Update (A_Brake, Ped_Angle);
      Test_Case_2(1) := Brake.Pressure (A_Brake) = 0.5;

      Ped_Angle := 2.0;
      Brake.Update (A_Brake, Ped_Angle);
      Test_Case_2(2) := Brake.Pressure (A_Brake) = 1.0;

      Ped_Angle := 1.0;
      Brake.Update (A_Brake, Ped_Angle);
      Test_Case_2(3) := Brake.Pressure (A_Brake) = 0.5;

      Ped_Angle := 0.0;
      Brake.Update (A_Brake, Ped_Angle);
      Test_Case_2(4) := Brake.Pressure (A_Brake) = 0.0;

      for I in 1..4
      loop
         exit when not Test_Case_2(I);
         Flag := I;
      end loop;

      Class_Test_Result_File.Report_Case_Status (Success => Flag = 4, Number => 1);

   end Test_2;


end Brake_G_Ctd;
