-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Hydraulics.Controller;
with Jpats_Hydraulics.Container;
with Jpats_Fuel;
with Jpats_Landing_Gear;
with Jpats_Secondary_Flight_Controls;
with Jpats_Aircraft_Body;



procedure Jpats_Hydraulics.Controller_Ctd is

   package Ctnr    renames Container;
   package Sov     renames Ctnr.Hydraulic_Shutoff_Valve;
   package Fuel    renames Jpats_Fuel;
   package Gear    renames Jpats_Landing_Gear;
   package Sfc     renames Jpats_Secondary_Flight_Controls;

   package Ac_Body renames Jpats_Aircraft_Body;
   package Hyd_Sys renames Ctnr.System;
   package Accum   renames Ctnr.Hydraulic_Accumulator;
   package Reservoir renames Ctnr.Hydraulic_Reservoir;

   package Low_Level_Sw renames Ctnr.Hydraulic_Fluid_Low_Level_Switch;
   package Low_Press_Sw renames Ctnr.Hydraulic_Pressure_Low_Level_Switch;

   The_Primary_Sys : Hyd_Sys.Instance renames Ctnr.This_Subsystem.The_Primary_System;
   The_Emerg_Sys   : Hyd_Sys.Instance renames Ctnr.This_Subsystem.The_Emergency_System;
   The_Accum       : Accum.Instance   renames Ctnr.This_Subsystem.The_Accumulator;
   The_Reservoir   : Reservoir.Instance renames Ctnr.This_Subsystem.The_Reservoir;

   The_Low_Level_Sw : Low_Level_Sw.Instance renames Ctnr.This_Subsystem.The_Reservoir_Fluid_Low_Level_Switch;
   The_Low_Press_Sw : Low_Press_Sw.Instance renames Ctnr.This_Subsystem.The_Low_Pressure_Switch;

   The_Hyd_Sov : Sov.Instance renames Ctnr.This_Subsystem.The_Shutoff_Valve;

   type Test_Case is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case;
      N : in Integer)
      return boolean;

   function passed
     (A : in Test_Case;
      N : in Integer)
      return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;


begin

Test_1 : declare
   Test_Case_1 : Test_Case (1..12):= (others => false);-- of Boolean;

begin
   Controller.Initialize;

   Test_Case_1 (1) := Hyd_Sys.Quantity (The_Primary_Sys) = 0.0;
   Test_Case_1 (2) := Hyd_Sys.Pressure (The_Primary_Sys) = 0.0;
   Test_Case_1 (3) := Hyd_Sys.Normalized_Quantity (The_Primary_Sys) = 0.0;
   Test_Case_1 (4) := Hyd_Sys.Normalized_Pressure (The_Primary_Sys) = 0.0;

   Test_Case_1 (5) := Hyd_Sys.Quantity (The_Emerg_Sys) = 0.0;
   Test_Case_1 (6) := Hyd_Sys.Pressure (The_Emerg_Sys) = 0.0;
   Test_Case_1 (7) := Hyd_Sys.Normalized_Quantity (The_Emerg_Sys) = 0.0;
   Test_Case_1 (8) := Hyd_Sys.Normalized_Pressure (The_Emerg_Sys) = 0.0;

   Test_Case_1 (9) := Reservoir.Quantity (The_Reservoir) = 0.0;

   Test_Case_1 (10) := not Low_Level_Sw.Is_Open (The_Low_Level_Sw);

   Test_Case_1 (11) := not Low_Press_Sw.Is_Open (The_Low_Press_Sw);

   Test_Case_1 (12) := Accum.Quantity (The_Accum) = 0.0;

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);
end Test_1;

Test_2 : declare
   Test_Case_2 : Test_case (1..2) := (others => false); -- of Boolean;
   Iconst : constant Float := 0.0666667;
begin
   Controller.Initialize;


   for I in 1..1000 loop
      Controller.Update (Iconst);
   end loop;

   Test_Case_2 (1) := Reservoir.Quantity (The_Reservoir) = 0.6;
   Test_Case_2 (2) := Accum.Quantity (The_Accum) = 0.21;
--   Test_Case_2 (3) := true;

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;

end Jpats_Hydraulics.Controller_Ctd;
