-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Hydraulic_System_G;

procedure Hydraulic_System_G_Ctd is

begin

   -------------------------------------------------------------------------------
   -- Test_1
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :


   Test_1 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      subtype Norm is Float range 0.0..1.0;
      package Sys is new Hydraulic_System_G (Float, Float, Norm, Norm);
      A_Sys : Sys.Instance;

      Test_Case_1 : array (1..4) of Boolean;
      Flag : Integer := 0;

   begin
      Sys.Initialize (A_Sys);

      Test_Case_1(1) := Sys.Quantity (A_Sys) = 0.0;
      Test_Case_1(2) := Sys.Pressure (A_Sys) = 0.0;
      Test_Case_1(3) := Sys.Normalized_Quantity (A_Sys) = 0.0;
      Test_Case_1(4) := Sys.Normalized_Pressure (A_Sys) = 0.0;

      for I in 1..4
      loop
         exit when not Test_Case_1(I);
         Flag := I;
      end loop;

      Class_Test_Result_File.Report_Case_Status (Success => Flag = 4, Number => 1);

   end Test_1;


   -------------------------------------------------------------------------------
   -- Test_2
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_2 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      subtype Norm is Float range 0.0..1.0;
      package Sys is new Hydraulic_System_G (Float, Float, Norm, Norm);
      A_Sys : Sys.Instance;

      Test_Case_2 : array (1..8) of Boolean;
      Flag : Integer := 0;


      A_Quantity : Float := 0.5;
      A_Pressure : Float := 0.5;
      A_Quantity_Norm : Norm := 0.01;
      A_Pressure_Norm : Norm := 0.01;

   begin

      Sys.Initialize (A_Sys);
      Sys.Update
        (An_Instance         => A_Sys,              -- in out Instance;
         Quantity            => A_Quantity,         -- in     Quantity_Type;
         Pressure            => A_Pressure,         -- in     Pressure_Type;
         Normalized_Quantity => A_Quantity_Norm,    -- in     Normalized_Quantity_Type;
         Normalized_Pressure => A_Pressure_Norm);   -- in     Normalized_Pressure_Type);

      Test_Case_2(1) := Sys.Quantity (A_Sys) = 0.5;
      Test_Case_2(2) := Sys.Pressure (A_Sys) = 0.5;
      Test_Case_2(3) := Sys.Normalized_Quantity (A_Sys) = 0.01;
      Test_Case_2(4) := Sys.Normalized_Pressure (A_Sys) = 0.01;


      A_Quantity := 0.2;
      A_Pressure := 0.3;
      A_Quantity_Norm := 0.5;
      A_Pressure_Norm := 0.05;

      Sys.Update
        (An_Instance         => A_Sys,              -- in out Instance;
         Quantity            => A_Quantity,         -- in     Quantity_Type;
         Pressure            => A_Pressure,         -- in     Pressure_Type;
         Normalized_Quantity => A_Quantity_Norm,    -- in     Normalized_Quantity_Type;
         Normalized_Pressure => A_Pressure_Norm);   -- in     Normalized_Pressure_Type);

      Test_Case_2(5) := Sys.Quantity (A_Sys) = 0.2;
      Test_Case_2(6) := Sys.Pressure (A_Sys) = 0.3;
      Test_Case_2(7) := Sys.Normalized_Quantity (A_Sys) = 0.5;
      Test_Case_2(8) := Sys.Normalized_Pressure (A_Sys) = 0.05;


      for I in 1..8
      loop
         exit when not Test_Case_2(I);
         Flag := I;
      end loop;

      Class_Test_Result_File.Report_Case_Status (Success => Flag = 8, Number => 2);


   end Test_2;

end Hydraulic_System_G_Ctd;
