-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Tank.Wing;
with Mass_Types;

procedure Tank.Wing_Ctd is


begin


   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      package W_Tank renames Tank.Wing;

      A_W_Tank : W_Tank.Instance;

      Test_1  : Boolean; Test_21 : Boolean;
      Test_2  : Boolean; Test_22 : Boolean;
      Test_3  : Boolean; Test_23 : Boolean;
      Test_4  : Boolean; Test_24 : Boolean;
      Test_5  : Boolean; Test_25 : Boolean;
      Test_6  : Boolean; Test_26 : Boolean;
      Test_7  : Boolean; Test_27 : Boolean;
      Test_8  : Boolean; Test_28 : Boolean;
      Test_9  : Boolean; Test_29 : Boolean;
      Test_10 : Boolean; Test_30 : Boolean;
      Test_11 : Boolean; Test_31 : Boolean;
      Test_12 : Boolean; Test_32 : Boolean;
      Test_13 : Boolean; Test_33 : Boolean;
      Test_14 : Boolean; Test_34 : Boolean;
      Test_15 : Boolean; Test_35 : Boolean;
      Test_16 : Boolean; Test_36 : Boolean;
      Test_17 : Boolean; Test_37 : Boolean;
      Test_18 : Boolean; Test_38 : Boolean;
      Test_19 : Boolean; Test_39 : Boolean;
      Test_20 : Boolean; Test_40 : Boolean;


   begin
      W_Tank.Initialize (A_W_Tank,40.0);

      Test_1 := W_Tank.Motive_Rate_In (An_Instance => A_W_Tank) = 0.0; --return Mass_Types.Pph;
      Test_2 := W_Tank.Motive_Rate_Out (An_Instance => A_W_Tank) = 0.0;
      Test_3 := W_Tank.Gravity_Rate_In (An_Instance => A_W_Tank) = 0.0;
      Test_4 := W_Tank.Gravity_Rate_Out (An_Instance => A_W_Tank) = 0.0;
      Test_5 := not W_Tank.Motive_Flow_In (An_Instance => A_W_Tank); --return Boolean;
      Test_6 := not W_Tank.Motive_Flow_Out (An_Instance => A_W_Tank);
      Test_7 := not W_Tank.Gravity_Flow_In (An_Instance => A_W_Tank);
      Test_8 := not W_Tank.Gravity_Flow_Out (An_Instance => A_W_Tank);

      Class_Test_Result_File.Report_Case_Status (Success => Test_1 , Number => 1 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_2 , Number => 2 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_3 , Number => 3 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_4 , Number => 4 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_5 , Number => 5 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_6 , Number => 6 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_7 , Number => 7 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_8 , Number => 8 );

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

               W_Tank.Set_Motive_Rate_In (An_Instance => A_W_Tank, Value => 10.0); --return Mass_Types.Pph;
               W_Tank.Set_Motive_Rate_Out (An_Instance => A_W_Tank, Value => 10.0);
               W_Tank.Set_Gravity_Rate_In (An_Instance => A_W_Tank, Value => 10.0);
               W_Tank.Set_Gravity_Rate_Out (An_Instance => A_W_Tank, Value => 10.0);
               W_Tank.Set_Motive_Flow_In (An_Instance => A_W_Tank, Value => True); --return Boolean;
               W_Tank.Set_Motive_Flow_Out (An_Instance => A_W_Tank, Value => True);
               W_Tank.Set_Gravity_Flow_In (An_Instance => A_W_Tank, Value => True);
               W_Tank.Set_Gravity_Flow_Out (An_Instance => A_W_Tank, Value => True);


            if In_First_Quarter then

               Test_9  := W_Tank.Motive_Rate_In (An_Instance => A_W_Tank) = 10.0; --return Mass_Types.Pph;
               Test_10 := W_Tank.Motive_Rate_Out (An_Instance => A_W_Tank) = 10.0;
               Test_11 := W_Tank.Gravity_Rate_In (An_Instance => A_W_Tank) = 10.0;
               Test_12 := W_Tank.Gravity_Rate_Out (An_Instance => A_W_Tank) = 10.0;
               Test_13 := W_Tank.Motive_Flow_In (An_Instance => A_W_Tank); --return Boolean;
               Test_14 := W_Tank.Motive_Flow_Out (An_Instance => A_W_Tank);
               Test_15 := W_Tank.Gravity_Flow_In (An_Instance => A_W_Tank);
               Test_16 := W_Tank.Gravity_Flow_Out (An_Instance => A_W_Tank);

               Class_Test_Result_File.Report_Case_Status (Success => Test_9 , Number => 9 );
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);

            end if;
            In_First_Quarter := False;

         elsif Now < Two_Quarter_Time then

               W_Tank.Set_Motive_Rate_In (An_Instance => A_W_Tank, Value => 15.0); --return Mass_Types.Pph;
               W_Tank.Set_Motive_Rate_Out (An_Instance => A_W_Tank, Value => 1.0);
               W_Tank.Set_Gravity_Rate_In (An_Instance => A_W_Tank, Value => 15.0);
               W_Tank.Set_Gravity_Rate_Out (An_Instance => A_W_Tank, Value => 1.0);
               W_Tank.Set_Motive_Flow_In (An_Instance => A_W_Tank, Value => True); --return Boolean;
               W_Tank.Set_Motive_Flow_Out (An_Instance => A_W_Tank, Value => False);
               W_Tank.Set_Gravity_Flow_In (An_Instance => A_W_Tank, Value => True);
               W_Tank.Set_Gravity_Flow_Out (An_Instance => A_W_Tank, Value => False);

            if In_Second_Quarter then

               Test_17 := W_Tank.Motive_Rate_In (An_Instance => A_W_Tank) = 15.0; --return Mass_Types.Pph;
               Test_18 := W_Tank.Motive_Rate_Out (An_Instance => A_W_Tank) = 1.0;
               Test_19 := W_Tank.Gravity_Rate_In (An_Instance => A_W_Tank) = 15.0;
               Test_20 := W_Tank.Gravity_Rate_Out (An_Instance => A_W_Tank) = 1.0;
               Test_21 := W_Tank.Motive_Flow_In (An_Instance => A_W_Tank); --return Boolean;
               Test_22 := not W_Tank.Motive_Flow_Out (An_Instance => A_W_Tank);
               Test_23 :=     W_Tank.Gravity_Flow_In (An_Instance => A_W_Tank);
               Test_24 := not W_Tank.Gravity_Flow_Out (An_Instance => A_W_Tank);

               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);
               Class_Test_Result_File.Report_Case_Status (Success => Test_21, Number => 21);
               Class_Test_Result_File.Report_Case_Status (Success => Test_22, Number => 22);
               Class_Test_Result_File.Report_Case_Status (Success => Test_23, Number => 23);
               Class_Test_Result_File.Report_Case_Status (Success => Test_24, Number => 24);

            end if;
            In_Second_Quarter := False;

         elsif Now < Three_Quarter_Time then

               W_Tank.Set_Motive_Rate_In (An_Instance => A_W_Tank, Value => 100.0); --return Mass_Types.Pph;
               W_Tank.Set_Motive_Rate_Out (An_Instance => A_W_Tank, Value => 10.2);
               W_Tank.Set_Gravity_Rate_In (An_Instance => A_W_Tank, Value => 100.0);
               W_Tank.Set_Gravity_Rate_Out (An_Instance => A_W_Tank, Value => 10.2);
               W_Tank.Set_Motive_Flow_In (An_Instance => A_W_Tank, Value => False); --return Boolean;
               W_Tank.Set_Motive_Flow_Out (An_Instance => A_W_Tank, Value => True);
               W_Tank.Set_Gravity_Flow_In (An_Instance => A_W_Tank, Value => False);
               W_Tank.Set_Gravity_Flow_Out (An_Instance => A_W_Tank, Value => True);

            if In_Third_Quarter then

               Test_25 := W_Tank.Motive_Rate_In (An_Instance => A_W_Tank) = 100.0; --return Mass_Types.Pph;
               Test_26 := W_Tank.Motive_Rate_Out (An_Instance => A_W_Tank) = 10.2;
               Test_27 := W_Tank.Gravity_Rate_In (An_Instance => A_W_Tank) = 100.0;
               Test_28 := W_Tank.Gravity_Rate_Out (An_Instance => A_W_Tank) = 10.2;
               Test_29 := not W_Tank.Motive_Flow_In (An_Instance => A_W_Tank); --return Boolean;
               Test_30 :=     W_Tank.Motive_Flow_Out (An_Instance => A_W_Tank);
               Test_31 := not W_Tank.Gravity_Flow_In (An_Instance => A_W_Tank);
               Test_32 :=     W_Tank.Gravity_Flow_Out (An_Instance => A_W_Tank);

               Class_Test_Result_File.Report_Case_Status (Success => Test_25, Number => 25);
               Class_Test_Result_File.Report_Case_Status (Success => Test_26, Number => 26);
               Class_Test_Result_File.Report_Case_Status (Success => Test_27, Number => 27);
               Class_Test_Result_File.Report_Case_Status (Success => Test_28, Number => 28);
               Class_Test_Result_File.Report_Case_Status (Success => Test_29, Number => 29);
               Class_Test_Result_File.Report_Case_Status (Success => Test_30, Number => 30);
               Class_Test_Result_File.Report_Case_Status (Success => Test_31, Number => 31);
               Class_Test_Result_File.Report_Case_Status (Success => Test_32, Number => 32);

            end if;
            In_Third_Quarter := False;

         else

               W_Tank.Set_Motive_Rate_In (An_Instance => A_W_Tank, Value => 0.03); --return Mass_Types.Pph;
               W_Tank.Set_Motive_Rate_Out (An_Instance => A_W_Tank, Value => 0.03);
               W_Tank.Set_Gravity_Rate_In (An_Instance => A_W_Tank, Value => 0.03);
               W_Tank.Set_Gravity_Rate_Out (An_Instance => A_W_Tank, Value => 0.03);
               W_Tank.Set_Motive_Flow_In (An_Instance => A_W_Tank, Value => True); --return Boolean;
               W_Tank.Set_Motive_Flow_Out (An_Instance => A_W_Tank, Value => True);
               W_Tank.Set_Gravity_Flow_In (An_Instance => A_W_Tank, Value => True);
               W_Tank.Set_Gravity_Flow_Out (An_Instance => A_W_Tank, Value => True);

            if In_Fourth_Quarter then

               Test_33 := W_Tank.Motive_Rate_In (An_Instance => A_W_Tank) = 0.03; --return Mass_Types.Pph;
               Test_34 := W_Tank.Motive_Rate_Out (An_Instance => A_W_Tank) = 0.03;
               Test_35 := W_Tank.Gravity_Rate_In (An_Instance => A_W_Tank) = 0.03;
               Test_36 := W_Tank.Gravity_Rate_Out (An_Instance => A_W_Tank) = 0.03;
               Test_37 :=     W_Tank.Motive_Flow_In (An_Instance => A_W_Tank); --return Boolean;
               Test_38 :=     W_Tank.Motive_Flow_Out (An_Instance => A_W_Tank);
               Test_39 :=     W_Tank.Gravity_Flow_In (An_Instance => A_W_Tank);
               Test_40 :=     W_Tank.Gravity_Flow_Out (An_Instance => A_W_Tank);

               Class_Test_Result_File.Report_Case_Status (Success => Test_33, Number => 33);
               Class_Test_Result_File.Report_Case_Status (Success => Test_34, Number => 34);
               Class_Test_Result_File.Report_Case_Status (Success => Test_35, Number => 35);
               Class_Test_Result_File.Report_Case_Status (Success => Test_36, Number => 36);
               Class_Test_Result_File.Report_Case_Status (Success => Test_37, Number => 37);
               Class_Test_Result_File.Report_Case_Status (Success => Test_38, Number => 38);
               Class_Test_Result_File.Report_Case_Status (Success => Test_39, Number => 39);
               Class_Test_Result_File.Report_Case_Status (Success => Test_40, Number => 40);

            end if;
            In_Fourth_Quarter := False;

         end if;

      end loop;


   end;





   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;

end Tank.Wing_Ctd;
