-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Jpats_Fuel.Controller;
with Jpats_Fuel.Container;


with Jpats_Electrical;
with Jpats_Electrical_Types;
with Jpats_Powerplant;
with Tank.Wing;
with Tank.Collector;
with Tank;

procedure Jpats_Fuel.Controller_Ctd is

   type Test_Case is array (Integer range <>) of Boolean;

   function passed
     (A : in Test_Case;
      N : in Integer)
     return boolean;

   function passed
     (A : in Test_Case;
      N : in Integer)
     return boolean
   is
   begin
      if N = A'First then return A(N); end if;
      return A(N) and Passed (A,N-1);
   end Passed;

   package Ctnr                renames Container;
   package Ele                 renames Jpats_Electrical;
   package Ele_T               renames Jpats_Electrical_Types;
   package Boost               renames Ctnr.Boost_Pump;
   package Low_Pressure_Switch renames Ctnr.Low_Pressure_Switch;
   package Sov                 renames Ctnr.Shutoff_Valve;
   package Xfer_Valve          renames Ctnr.Transfer_Valve;
   package Pwrplant            renames Jpats_Powerplant;
   package Fuel_Probe          renames Ctnr.Fuel_Probe;


   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;

   The_Left_Wing_Tank      : Tank.Wing.Instance           renames Ctnr.This_Subsystem.The_Left_Wing_Tank;
   The_Right_Wing_Tank     : Tank.Wing.Instance           renames Ctnr.This_Subsystem.The_Right_Wing_Tank;
   The_Collector_Tank      : Tank.Collector.Instance      renames Ctnr.This_Subsystem.The_Collector_Tank;
   The_Boost_Pump          : Boost.Instance               renames Ctnr.This_Subsystem.The_Fuel_Boost_Pump;
   The_Firewall_Sov        : Ctnr.Shutoff_Valve.Instance  renames Ctnr.This_Subsystem.The_Firewall_Fuel_Shutoff_Valve;
   The_Low_Pressure_Switch : Low_Pressure_Switch.Instance renames Ctnr.This_Subsystem.The_Low_Pressure_Switch;
   The_Left_Xfer_Valve     : Xfer_Valve.Instance          renames Ctnr.This_Subsystem.The_Left_Wing_Transfer_Valve;
   The_Right_Xfer_Valve    : Xfer_Valve.Instance          renames Ctnr.This_Subsystem.The_Right_Wing_Transfer_Valve;


   Left_Wing_Tank_Low_Level_Sensor  : Ctnr.Fuel_Low_Level_Sensor.Instance renames
     Ctnr.This_Subsystem.The_Left_Wing_Tank_Low_Level_Sensor;
   Right_Wing_Tank_Low_Level_Sensor : Ctnr.Fuel_Low_Level_Sensor.Instance renames
     Ctnr.This_Subsystem.The_Right_Wing_Tank_Low_Level_Sensor;

begin


Test_1 : declare
   Test_Case_1 : Test_Case (1..8) := (others => false);
begin

   Controller.Initialize;

   Test_Case_1 (1) := Tank.Quantity (The_Left_Wing_Tank) = 530.0;
   Test_Case_1 (2) := Tank.Volume (The_Left_Wing_Tank) = 530.0/6.7;
   Test_Case_1 (3) := Tank.Quantity (The_Right_Wing_Tank) = 530.0;
   Test_Case_1 (4) := Tank.Volume (The_Right_Wing_Tank) = 530.0/6.7;
   Test_Case_1 (5) := Tank.Quantity (The_Collector_Tank) = 40.0;
   Test_Case_1 (6) := Tank.Volume (The_Collector_Tank) < 40.0/6.6 and Tank.Volume (The_Collector_Tank) > 40.0/6.8;
   Test_Case_1 (7) := not Boost.Is_On (The_Boost_Pump);
   Test_Case_1 (8) := Boost.Load (The_Boost_Pump) = 0.0;

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_1,Test_Case_1'Last), Number => 1);

end Test_1;




Test_2 : declare
   Test_Case_2 : Test_Case (1..4) := (others => false);
   Iconst : constant Float := 0.066667;
begin

   Controller.Initialize;
   Io.Boost_Pump_Below_Idle_Sw := False;
   Io.Boost_Pump_On_Sw := True;
   for I in 1..100 loop
      Controller.Update (Iconst);
   end loop;
   Test_Case_2 (1) := Boost.Is_On (The_Boost_Pump);
   Test_Case_2 (2) := Boost.Load (The_Boost_Pump) = 10.5;

   Io.Boost_Pump_Below_Idle_Sw := True;
   Io.Boost_Pump_On_Sw := false;
   for I in 1..100 loop
      Controller.Update (Iconst);
   end loop;
   Test_Case_2 (3) := not Boost.Is_On (The_Boost_Pump);
   Test_Case_2 (4) := Boost.Load (The_Boost_Pump) = 0.0;

   Class_Test_Result_File.Report_Case_Status (Success => Passed (Test_Case_2,Test_Case_2'Last), Number => 2);
end Test_2;


end Jpats_Fuel.Controller_Ctd;
