-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Fuel_Flow.Gravity;

procedure Fuel_Flow.Gravity_Ctd is


begin

   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Ffg renames Fuel_Flow.Gravity;

      A_Ffg : Fuel_Flow.Gravity.Instance;


      Test_1  : Boolean;  Test_11  : Boolean;
      Test_2  : Boolean;  Test_12  : Boolean;
      Test_3  : Boolean;  Test_13  : Boolean;
      Test_4  : Boolean;  Test_14  : Boolean;
      Test_5  : Boolean;  Test_15  : Boolean;
      Test_6  : Boolean;  Test_16  : Boolean;
      Test_7  : Boolean;  Test_17  : Boolean;
      Test_8  : Boolean;  Test_18  : Boolean;
      Test_9  : Boolean;  Test_19  : Boolean;
      Test_10 : Boolean;  Test_20  : Boolean;


   begin

      Ffg.Initialize (A_Ffg);

      Test_1 := Ffg.Rate_In (A_Ffg) = 0.0;
      Test_2 := Ffg.Rate_Out (A_Ffg) = 0.0;
      Test_3 := not Ffg.Gravity_Flow_In (A_Ffg);
      Test_4 := not Ffg.Gravity_Flow_Out (A_Ffg);
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
      Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);


      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Ffg.Set_Rate_In (A_Ffg,10.0);
            Ffg.Set_Rate_Out (A_Ffg,15.0);
            Ffg.Set_Gravity_Flow_In (A_Ffg,True);
            Ffg.Set_Gravity_Flow_Out (A_Ffg,True);

            if In_First_Quarter then
               Test_5 := Ffg.Rate_In (A_Ffg) = 10.0;
               Test_6 := Ffg.Rate_Out (A_Ffg) = 15.0;
               Test_7 := Ffg.Gravity_Flow_In (A_Ffg);
               Test_8 := Ffg.Gravity_Flow_Out (A_Ffg);
               Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
               Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
               Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then


            Ffg.Set_Rate_In (A_Ffg,100.0);
            Ffg.Set_Rate_Out (A_Ffg,1.0);
            Ffg.Set_Gravity_Flow_In (A_Ffg,False);
            Ffg.Set_Gravity_Flow_Out (A_Ffg,True);

            if In_Second_Quarter then
               Test_9  := Ffg.Rate_In (A_Ffg) = 100.0;
               Test_10 := Ffg.Rate_Out (A_Ffg) = 1.0;
               Test_11 := not Ffg.Gravity_Flow_In (A_Ffg);
               Test_12 := Ffg.Gravity_Flow_Out (A_Ffg);
               Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
               Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then


            Ffg.Set_Rate_In (A_Ffg,1.0);
            Ffg.Set_Rate_Out (A_Ffg,5.0);
            Ffg.Set_Gravity_Flow_In (A_Ffg,True);
            Ffg.Set_Gravity_Flow_Out (A_Ffg,False);

            if In_Third_Quarter then
               Test_13 := Ffg.Rate_In (A_Ffg) = 1.0;
               Test_14 := Ffg.Rate_Out (A_Ffg) = 5.0;
               Test_15 := Ffg.Gravity_Flow_In (A_Ffg);
               Test_16 := not Ffg.Gravity_Flow_Out (A_Ffg);
               Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
               Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
            end if;
            In_Third_Quarter := False;
         else


            Ffg.Set_Rate_In (A_Ffg,0.05);
            Ffg.Set_Rate_Out (A_Ffg,0.05);
            Ffg.Set_Gravity_Flow_In (A_Ffg,False);
            Ffg.Set_Gravity_Flow_Out (A_Ffg,False);

            if In_Fourth_Quarter then
               Test_17 := Ffg.Rate_In (A_Ffg) = 0.05;
               Test_18 := Ffg.Rate_Out (A_Ffg) = 0.05;
               Test_19 := not Ffg.Gravity_Flow_In (A_Ffg);
               Test_20 := not Ffg.Gravity_Flow_Out (A_Ffg);
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;


   end;

   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;


end Fuel_Flow.Gravity_Ctd;
