-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Turn_Indicator;
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Force_Types;
with Mass_Types;
with Torque_Types;
with Normalized_Types;
with Temperature_Types;
with Flight_Instruments_Types;

with JPATS_Flight_Instruments_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Multiply_Indexed;
with Class_Test_Result_File;


procedure EXECUTE_Turn is

   An_Integration_Constant : Float := 1.0/60.0;

   An_Instance : Turn_Indicator.Instance;

   A_Roll_Angle :Angle_Types.Radians;
   A_Pitch_Rate :Float;
   A_Yaw_Rate   :Float;
   A_Predefined_Turn_Rate  :Float;

   A_File_Path : string := JPATS_Flight_Instruments_Types.A_File_Path;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin

   A_Roll_Angle   := -2.32e-2*3.142/180.0;
   A_Pitch_Rate   := -0.71268*3.142/180.0;
   A_Yaw_Rate     := -0.31443*3.142/180.0;
   Turn_Indicator.Set_Turn_Rate(A_Roll_Angle           ,
                                A_Pitch_Rate    ,
                                A_Yaw_Rate     ,
                                An_Instance            );

   --| This procedure will set the Rate_of_Turn calculated during initalization,
   --| autotesting or when Rate_of_Turn is defined by an approved other method.
   --Turn_Indicator.Assign_Turn_Rate(A_Predefined_Turn_Rate ,
   --                           An_Instance           );

   put(Turn_Indicator.Get_Turn_Rate(An_Instance )); put_line(" Turn rate ");

   Pass:= abs(Turn_Indicator.Get_Turn_Rate(An_Instance )- (-0.00548351) ) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put_line("-------------------- CONSTRAINT -----------------------");

   A_Roll_Angle   := 1000.0;
   A_Pitch_Rate   := 1000.0;
   A_Yaw_Rate     := 1000.0;
   Turn_Indicator.Set_Turn_Rate(A_Roll_Angle           ,
                                A_Pitch_Rate    ,
                                A_Yaw_Rate     ,
                                An_Instance            );

   --| This procedure will set the Rate_of_Turn calculated during initalization,
   --| autotesting or when Rate_of_Turn is defined by an approved other method.
   --Turn_Indicator.Assign_Turn_Rate(A_Predefined_Turn_Rate ,
   --                           An_Instance           );

   put(Turn_Indicator.Get_Turn_Rate(An_Instance )); put_line(" Turn rate ");

   Pass:= abs(Turn_Indicator.Get_Turn_Rate(An_Instance ))>= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);


   put_line("-------------------- END -----------------------");

   A_Roll_Angle   := 0.0;
   A_Pitch_Rate   := 0.0;
   A_Yaw_Rate     := 0.0;
   Turn_Indicator.Set_Turn_Rate(A_Roll_Angle           ,
                                A_Pitch_Rate    ,
                                A_Yaw_Rate     ,
                                An_Instance            );

   --| This procedure will set the Rate_of_Turn calculated during initalization,
   --| autotesting or when Rate_of_Turn is defined by an approved other method.
   --Turn_Indicator.Assign_Turn_Rate(A_Predefined_Turn_Rate ,
   --                           An_Instance           );

   put(Turn_Indicator.Get_Turn_Rate(An_Instance )); put_line(" Turn rate ");

   Pass:= abs(Turn_Indicator.Get_Turn_Rate(An_Instance ))>= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);



end EXECUTE_Turn;

