-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Static_Probe;
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Force_Types;
with Mass_Types;
with Torque_Types;
with Normalized_Types;
with Temperature_Types;
with Flight_Instruments_Types;

with JPATS_Flight_Instruments_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Multiply_Indexed;
with Class_Test_Result_File;


procedure EXECUTE_SP is

   An_Integration_Constant : Float := 1.0/60.0;

   An_Instance : Static_Probe.Instance;

   An_Ambient_Pressure_from_Free_Air        :Force_Types.Pounds_per_Sq_Feet;
   A_Pressure_Altitude_from_Free_Air        :Length_Types.Feet;
   An_Air_Density_at_Altitude_from_Free_Air :Mass_Types.Slugs_per_Cubic_Feet;
   A_Predefined_Ambient_Pressure            :Force_Types.Pounds_per_Sq_Feet;
   A_Predefined_Pressure_Altitude           :Length_Types.Feet;
   A_Predefined_Air_Density_at_Altitude     :Mass_Types.Slugs_per_Cubic_Feet;

   A_File_Path : string := JPATS_Flight_Instruments_Types.A_File_Path;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin
   An_Ambient_Pressure_from_Free_Air         := 2116.22*0.8298051;
   A_Pressure_Altitude_from_Free_Air         := 5071.902;
   An_Air_Density_at_Altitude_from_Free_Air  := 0.8617*0.002376;

   Static_Probe.Set_Attributes_for_Malfunctions
     (An_Ambient_Pressure_from_Free_Air        ,
      A_Pressure_Altitude_from_Free_Air        ,
      An_Air_Density_at_Altitude_from_Free_Air ,
      An_Instance                              );

   put(Static_Probe.Get_Static_Pressure (An_Instance)); put_line(" Static Pressure ");
   put(Static_Probe.Get_Pressure_Altitude (An_Instance ));  put_line(" Pressure_Altitude ");
   put(Static_Probe.Get_Last_Pass_Pressure_Altitude (An_Instance ));  put_line(" Last_Pass_Pressure_Altitude ");
   put(Static_Probe.Get_Air_Density (An_Instance));  put_line(" Air_Density ");

   if (abs(Static_Probe.Get_Static_Pressure (An_Instance)) > 1756.05 - 100.0 or
       abs(Static_Probe.Get_Static_Pressure (An_Instance)) < 1756.05 + 100.0) and
     (abs(Static_Probe.Get_Pressure_Altitude (An_Instance)) > 5071.902 - 100.0 or
      abs(Static_Probe.Get_Pressure_Altitude (An_Instance)) < 5071.902 + 100.0) and
     (abs(Static_Probe.Get_Air_Density (An_Instance)) > 0.0020474 - 0.001 or
      abs(Static_Probe.Get_Air_Density (An_Instance)) < 0.0020474 + 0.001) then
      Pass:= True;
   end if;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;


   --| Here An_Ambient_Pressure, A_Pressure_Altitude and An_Air_Density_at_Altitude is from
   --| Free_Air or during initailization are assigned appropriate Initialization values.
   A_Predefined_Ambient_Pressure         := 1.0;
   A_Predefined_Pressure_Altitude        := 2.0;
   A_Predefined_Air_Density_at_Altitude  := 3.0;

   Static_Probe.Assign_Attributes
     (A_Predefined_Ambient_Pressure        ,
      A_Predefined_Pressure_Altitude       ,
      A_Predefined_Air_Density_at_Altitude ,
      An_Instance                          );

   put(Static_Probe.Get_Static_Pressure (An_Instance)); put_line(" Static Pressure ");
   put(Static_Probe.Get_Pressure_Altitude (An_Instance ));  put_line(" Pressure_Altitude ");
   put(Static_Probe.Get_Last_Pass_Pressure_Altitude (An_Instance ));  put_line(" Last_Pass_Pressure_Altitude ");
   put(Static_Probe.Get_Air_Density (An_Instance));  put_line(" Air_Density ");

   put_line("-------------------- CONSTRAINT ----------------------");
   An_Ambient_Pressure_from_Free_Air         := 10000.0;
   A_Pressure_Altitude_from_Free_Air         := 10000.0;
   An_Air_Density_at_Altitude_from_Free_Air  := 1.0;

   Static_Probe.Set_Attributes_for_Malfunctions
     (An_Ambient_Pressure_from_Free_Air        ,
      A_Pressure_Altitude_from_Free_Air        ,
      An_Air_Density_at_Altitude_from_Free_Air ,
      An_Instance                              );

   put(Static_Probe.Get_Static_Pressure (An_Instance)); put_line(" Static Pressure ");
   put(Static_Probe.Get_Pressure_Altitude (An_Instance ));  put_line(" Pressure_Altitude ");
   put(Static_Probe.Get_Last_Pass_Pressure_Altitude (An_Instance ));  put_line(" Last_Pass_Pressure_Altitude ");
   put(Static_Probe.Get_Air_Density (An_Instance));  put_line(" Air_Density ");

   if abs(Static_Probe.Get_Static_Pressure (An_Instance)) >= 0.0 and
     abs(Static_Probe.Get_Pressure_Altitude (An_Instance)) >= 0.0 and
     abs(Static_Probe.Get_Air_Density (An_Instance)) >= 0.0 then
      Pass:= True;
   end if;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   put_line("-------------------- END ----------------------");
   An_Ambient_Pressure_from_Free_Air         := 0.0;
   A_Pressure_Altitude_from_Free_Air         := 0.0;
   An_Air_Density_at_Altitude_from_Free_Air  := 0.0;

   Static_Probe.Set_Attributes_for_Malfunctions
     (An_Ambient_Pressure_from_Free_Air        ,
      A_Pressure_Altitude_from_Free_Air        ,
      An_Air_Density_at_Altitude_from_Free_Air ,
      An_Instance                              );

   put(Static_Probe.Get_Static_Pressure (An_Instance)); put_line(" Static Pressure ");
   put(Static_Probe.Get_Pressure_Altitude (An_Instance ));  put_line(" Pressure_Altitude ");
   put(Static_Probe.Get_Last_Pass_Pressure_Altitude (An_Instance ));  put_line(" Last_Pass_Pressure_Altitude ");
   put(Static_Probe.Get_Air_Density (An_Instance));  put_line(" Air_Density ");

   if abs(Static_Probe.Get_Static_Pressure (An_Instance)) >= 0.0 and
     abs(Static_Probe.Get_Pressure_Altitude (An_Instance)) >= 0.0 and
     abs(Static_Probe.Get_Air_Density (An_Instance)) >= 0.0 then
      Pass:= True;
   end if;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;



end EXECUTE_SP;

