-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Slip_Indicator;
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Force_Types;
with Mass_Types;
with Torque_Types;
with Normalized_Types;
with Temperature_Types;
with Flight_Instruments_Types;

with JPATS_Flight_Instruments_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Multiply_Indexed;
with Class_Test_Result_File;


procedure EXECUTE_slip is

   An_Integration_Constant : Float := 1.0/60.0;

   An_Instance : Slip_Indicator.Instance;

   A_y_Acceleration_Body_Axis                      :Float;
   A_z_Acceleration_Body_Axis                      :Float;
   A_Yaw_Acceleration                              :Angle_Types.Radians_per_Sq_Sec;
   A_Fuselage_Station_of_Current_Center_of_Gravity :Length_Types.Feet;
   A_Panel_Dist_from_CG_Ref_Datum                  :Length_Types.Feet;
   A_Predefined_Ball_Displacement                  :Flight_Instruments_Types.Slip_Indicator_Type;

   A_File_Path : string := JPATS_Flight_Instruments_Types.A_File_Path;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin
   A_Predefined_Ball_Displacement := 0.125;
   Slip_Indicator.Assign_Ball_Displacement
     (A_Predefined_Ball_Displacement,
      An_Instance                   );

   A_y_Acceleration_Body_Axis                      := 0.150;
   A_z_Acceleration_Body_Axis                      := -90.999110;
   A_Yaw_Acceleration                              := -0.9184675;
   A_Fuselage_Station_of_Current_Center_of_Gravity := 13.7775;
   A_Panel_Dist_from_CG_Ref_Datum                  := 7.0;

   Slip_Indicator.Set_Ball_Displacement(A_y_Acceleration_Body_Axis                   ,
                                        A_z_Acceleration_Body_Axis                      ,
                                        A_Yaw_Acceleration                              ,
                                        A_Fuselage_Station_of_Current_Center_of_Gravity ,
                                        A_Panel_Dist_from_CG_Ref_Datum                  ,
                                        --This is the fuselage station position of the nose gear.
                                        --The Slip_Indicator is assumed to be mounted on top of the nose gear.
                                        --Value to be obtained from UNCOMPRESSED TIRE LOCATION in the TIRE GEOMETRY Class.
                                        An_Integration_Constant                          ,
                                        An_Instance                                     );

   put(Slip_Indicator.Get_Ball_Displacement(An_Instance)); put_line(" Ball displacement ");

   Pass := abs(Slip_Indicator.Get_Ball_Displacement(An_Instance) - 0.24495531) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("------------- CONSTRAINT ---------------------");

   A_y_Acceleration_Body_Axis                      := 1000.0;
   A_z_Acceleration_Body_Axis                      := 1000.0;
   A_Yaw_Acceleration                              :=1000.0;
   A_Fuselage_Station_of_Current_Center_of_Gravity :=1000.0;
   A_Panel_Dist_from_CG_Ref_Datum                  := 1000.0;

   Slip_Indicator.Set_Ball_Displacement(A_y_Acceleration_Body_Axis                   ,
                                        A_z_Acceleration_Body_Axis                      ,
                                        A_Yaw_Acceleration                              ,
                                        A_Fuselage_Station_of_Current_Center_of_Gravity ,
                                        A_Panel_Dist_from_CG_Ref_Datum                  ,
                                        --This is the fuselage station position of the nose gear.
                                        --The Slip_Indicator is assumed to be mounted on top of the nose gear.
                                        --Value to be obtained from UNCOMPRESSED TIRE LOCATION in the TIRE GEOMETRY Class.
                                        An_Integration_Constant                          ,
                                        An_Instance                                     );

   put(Slip_Indicator.Get_Ball_Displacement(An_Instance)); put_line(" Ball displacement ");

   Pass := abs(Slip_Indicator.Get_Ball_Displacement(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("------------- END ---------------------");

   A_y_Acceleration_Body_Axis                      := 0.0;
   A_z_Acceleration_Body_Axis                      := 0.0;
   A_Yaw_Acceleration                              := 0.0;
   A_Fuselage_Station_of_Current_Center_of_Gravity := 0.0;
   A_Panel_Dist_from_CG_Ref_Datum                  := 0.0;

   Slip_Indicator.Set_Ball_Displacement(A_y_Acceleration_Body_Axis                   ,
                                        A_z_Acceleration_Body_Axis                      ,
                                        A_Yaw_Acceleration                              ,
                                        A_Fuselage_Station_of_Current_Center_of_Gravity ,
                                        A_Panel_Dist_from_CG_Ref_Datum                  ,
                                        --This is the fuselage station position of the nose gear.
                                        --The Slip_Indicator is assumed to be mounted on top of the nose gear.
                                        --Value to be obtained from UNCOMPRESSED TIRE LOCATION in the TIRE GEOMETRY Class.
                                        An_Integration_Constant                          ,
                                        An_Instance                                     );

   put(Slip_Indicator.Get_Ball_Displacement(An_Instance)); put_line(" Ball displacement ");

   Pass := abs(Slip_Indicator.Get_Ball_Displacement(An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

end EXECUTE_Slip;

