-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Pitot_Probe;
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Force_Types;
with Mass_Types;
with Torque_Types;
with Normalized_Types;
with Temperature_Types;
with Flight_Instruments_Types;

with JPATS_Flight_Instruments_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Multiply_Indexed;
with Class_Test_Result_File;



procedure EXECUTE_PP is

   An_Integration_Constant : Float := 1.0/60.0;

   An_Instance : Pitot_Probe.Instance;


   An_Ambient_Pressure_from_Free_Air          :Force_Types.Pounds_per_Sq_Feet;
   A_Dynamic_Pressure_from_Simulated_Aircraft :Force_Types.Pounds_per_Sq_Feet;
   An_Ambient_Pressure_from_Static_Probe      :Force_Types.Pounds_per_Sq_Feet;
   A_Predefined_Total_Pressure                :Force_Types.Pounds_per_Sq_Feet;

   A_File_Path : string := JPATS_Flight_Instruments_Types.A_File_Path;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_5;

begin


   An_Ambient_Pressure_from_Free_Air          := 0.8298051*2116.22;
   A_Dynamic_Pressure_from_Simulated_Aircraft := 70.92708;
   Pitot_Probe.Set_Total_Pressure
     (An_Ambient_Pressure_from_Free_Air        ,
      A_Dynamic_Pressure_from_Simulated_Aircraft,
      An_Instance                               );
   put(abs(Pitot_Probe.Get_Total_Pressure (An_Instance) - 1826.977228)); put( " total Pressure ");

   Pass := abs(Pitot_Probe.Get_Total_Pressure (An_Instance) - 1826.977228) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   --| In the event of Damaged or Leaked Malfunction use Set_Total_Pressure_for_Malfunction Method.

   --| IF ICED OR BLOCKED MALFUNCTION DO NOT UPDATE THE PITOT PROBE (i.e. DONOT CALL EITHER
   --| Set_Total_Pressure OR Set_Total_Pressure_for_Malfunction METHOD.)  DO NOTHING.
   An_Ambient_Pressure_from_Static_Probe := An_Ambient_Pressure_from_Free_Air;
   Pitot_Probe.Set_Total_Pressure_for_Malfunction
     (An_Ambient_Pressure_from_Static_Probe,
      An_Integration_Constant              ,
      An_Instance                          );

   -- Pitot_Probe.Assign_Total_Pressure (A_Predefined_Total_Pressure ,
   --                                  An_Instance                );

   put(Pitot_Probe.Get_Total_Pressure (An_Instance)); put( " total Pressure ");

   Pass := abs(Pitot_Probe.Get_Total_Pressure (An_Instance) - 1826.977228) <= 1.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   put_line(" ----------------- CONSTRAINT -----------------");

   An_Ambient_Pressure_from_Free_Air          := 1000.0;
   A_Dynamic_Pressure_from_Simulated_Aircraft := 1000.0;
   Pitot_Probe.Set_Total_Pressure
     (An_Ambient_Pressure_from_Free_Air        ,
      A_Dynamic_Pressure_from_Simulated_Aircraft,
      An_Instance                               );
   put(Pitot_Probe.Get_Total_Pressure (An_Instance)); put( " total Pressure ");

   Pass := abs(Pitot_Probe.Get_Total_Pressure (An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   --| In the event of Damaged or Leaked Malfunction use Set_Total_Pressure_for_Malfunction Method.

   --| IF ICED OR BLOCKED MALFUNCTION DO NOT UPDATE THE PITOT PROBE (i.e. DONOT CALL EITHER
   --| Set_Total_Pressure OR Set_Total_Pressure_for_Malfunction METHOD.)  DO NOTHING.
   An_Ambient_Pressure_from_Static_Probe := An_Ambient_Pressure_from_Free_Air;
   Pitot_Probe.Set_Total_Pressure_for_Malfunction
     (An_Ambient_Pressure_from_Static_Probe,
      An_Integration_Constant              ,
      An_Instance                          );

   -- Pitot_Probe.Assign_Total_Pressure (A_Predefined_Total_Pressure ,
   --                                  An_Instance                );

   put(Pitot_Probe.Get_Total_Pressure (An_Instance)); put( " total Pressure ");

   Pass := abs(Pitot_Probe.Get_Total_Pressure (An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   put_line(" ----------------- END -----------------");

   An_Ambient_Pressure_from_Free_Air          := 0.0;
   A_Dynamic_Pressure_from_Simulated_Aircraft := 0.0;
   Pitot_Probe.Set_Total_Pressure
     (An_Ambient_Pressure_from_Free_Air        ,
      A_Dynamic_Pressure_from_Simulated_Aircraft,
      An_Instance                               );
   put(Pitot_Probe.Get_Total_Pressure (An_Instance)); put( " total Pressure ");

   Pass := abs(Pitot_Probe.Get_Total_Pressure (An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   --| In the event of Damaged or Leaked Malfunction use Set_Total_Pressure_for_Malfunction Method.

   --| IF ICED OR BLOCKED MALFUNCTION DO NOT UPDATE THE PITOT PROBE (i.e. DONOT CALL EITHER
   --| Set_Total_Pressure OR Set_Total_Pressure_for_Malfunction METHOD.)  DO NOTHING.
   An_Ambient_Pressure_from_Static_Probe := An_Ambient_Pressure_from_Free_Air;
   Pitot_Probe.Set_Total_Pressure_for_Malfunction
     (An_Ambient_Pressure_from_Static_Probe,
      An_Integration_Constant              ,
      An_Instance                          );

   -- Pitot_Probe.Assign_Total_Pressure (A_Predefined_Total_Pressure ,
   --                                  An_Instance                );

   put(Pitot_Probe.Get_Total_Pressure (An_Instance)); put( " total Pressure ");

   Pass := abs(Pitot_Probe.Get_Total_Pressure (An_Instance)) >= 0.0;
   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;





end EXECUTE_PP;

