-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Angle_of_Attack_System;
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Force_Types;
with Mass_Types;
with Torque_Types;
with Normalized_Types;
with Temperature_Types;
with Flight_Instruments_Types;
with Class_Test_Result_File;

with JPATS_Flight_Instruments_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Multiply_Indexed;


procedure EXECUTE_AoA is

   An_Integration_Constant : Float := 1.0/60.0;

   An_Instance : Angle_of_Attack_System.Instance;

   A_Flap_Position                          :Angle_Types.Degrees;
   An_Angle_of_Attack                       :Angle_Types.Degrees;
   AOACAL_Table                             :Interpolation_Table.Doubly_Indexed.Instance;
   A_Predefined_Indicated_Angle_of_Attack   :Angle_Types.Degrees;
   A_Predefined_Prefiltered_Angle_of_Attack :Angle_Types.Degrees;
   A_Predefined_Angle_of_Attack_Indexer     :Flight_Instruments_Types.Color;
   A_Predefined_Stick_Shaker_Active         :Boolean;

   A_File_Path : string := JPATS_Flight_Instruments_Types.A_File_Path;

   Pass : Boolean := False;
   A_Tolerance: Float := 0.000_1;

begin

   Interpolation_Table.Doubly_Indexed.Read_Ascii(A_File_Path & "AOACAL.csv",AOACAL_Table);

   A_Predefined_Indicated_Angle_of_Attack := 4.854438;
   Angle_of_Attack_System.Assign_Angle_of_Attack
     (A_Predefined_Indicated_Angle_of_Attack ,
      An_Instance                           );
   A_Predefined_Prefiltered_Angle_of_Attack := 0.2330131;
   Angle_of_Attack_System.Assign_Prefiltered_Angle_of_Attack
     (A_Predefined_Prefiltered_Angle_of_Attack,
      An_Instance                             );


   A_Flap_Position    := 0.0;
   An_Angle_of_Attack := -1.757778;

   Angle_of_Attack_System.Set_Angle_of_Attack
     (A_Flap_Position         ,
      An_Angle_of_Attack     ,
      AOACAL_Table           ,
      An_Integration_Constant,
      An_Instance            );

   put(Angle_of_Attack_System.Get_Angle_of_Attack(An_Instance)); put_line(" AOA ");
   put(Angle_of_Attack_System.Get_Prefiltered_Angle_of_Attack(An_Instance)); put_line(" Prefiltered AOA ");

   Pass := abs(Angle_of_Attack_System.Get_Angle_of_Attack(An_Instance) - 4.777399) <= A_Tolerance and
     abs(Angle_of_Attack_System.Get_Prefiltered_Angle_of_Attack(An_Instance) - 0.0) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   A_Predefined_Angle_of_Attack_Indexer := Flight_Instruments_Types.Amber;
   Angle_of_Attack_System.Assign_Angle_of_Attack_Indexer
     (A_Predefined_Angle_of_Attack_Indexer,
      An_Instance                         );

   case Angle_of_Attack_System.Get_Angle_of_Attack_Indexer (An_Instance) is
      when  Flight_Instruments_Types.Amber
        => put_line("  Amber ");
      when Flight_Instruments_Types.Green
        => put_line("  Green ");
      when Flight_Instruments_Types.Blank
        => put_line("  Blank ");
      when others
        => put_line("  Other ");
   end case;


   A_Predefined_Stick_Shaker_Active := false;
   Angle_of_Attack_System.Assign_Stick_Shaker (A_Predefined_Stick_Shaker_Active,
                                               An_Instance                     );


   if (Angle_of_Attack_System.Get_Stick_Shaker (An_Instance )) then
      put_line(" Stick Shaker ON ");
   else
      put_line(" Stick Shaker OFF ");
   end if;


   put_line("--------------------- CONSTRAINT --------------------");

   A_Predefined_Indicated_Angle_of_Attack := 1000.0;
   Angle_of_Attack_System.Assign_Angle_of_Attack
     (A_Predefined_Indicated_Angle_of_Attack ,
      An_Instance                           );
   A_Predefined_Prefiltered_Angle_of_Attack := 1000.0;
   Angle_of_Attack_System.Assign_Prefiltered_Angle_of_Attack
     (A_Predefined_Prefiltered_Angle_of_Attack,
      An_Instance                             );


   A_Flap_Position    := 1000.0;
   An_Angle_of_Attack := 1000.0;

   Angle_of_Attack_System.Set_Angle_of_Attack
     (A_Flap_Position         ,
      An_Angle_of_Attack     ,
      AOACAL_Table           ,
      An_Integration_Constant,
      An_Instance            );

   put(Angle_of_Attack_System.Get_Angle_of_Attack(An_Instance)); put_line(" AOA ");
   put(Angle_of_Attack_System.Get_Prefiltered_Angle_of_Attack(An_Instance)); put_line(" Prefiltered AOA ");

   Pass := abs(Angle_of_Attack_System.Get_Angle_of_Attack(An_Instance)) >= 0.0 and
     abs(Angle_of_Attack_System.Get_Prefiltered_Angle_of_Attack(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("--------------------- END --------------------");


   A_Predefined_Indicated_Angle_of_Attack := 0.0;
   Angle_of_Attack_System.Assign_Angle_of_Attack
     (A_Predefined_Indicated_Angle_of_Attack ,
      An_Instance                           );
   A_Predefined_Prefiltered_Angle_of_Attack := 0.0;
   Angle_of_Attack_System.Assign_Prefiltered_Angle_of_Attack
     (A_Predefined_Prefiltered_Angle_of_Attack,
      An_Instance                             );

   A_Flap_Position    := 0.0;
   An_Angle_of_Attack := 0.0;

   Angle_of_Attack_System.Set_Angle_of_Attack
     (A_Flap_Position         ,
      An_Angle_of_Attack     ,
      AOACAL_Table           ,
      An_Integration_Constant,
      An_Instance            );

   put(Angle_of_Attack_System.Get_Angle_of_Attack(An_Instance)); put_line(" AOA ");
   put(Angle_of_Attack_System.Get_Prefiltered_Angle_of_Attack(An_Instance)); put_line(" Prefiltered AOA ");

   Pass := abs(Angle_of_Attack_System.Get_Angle_of_Attack(An_Instance)) >= 0.0 and
     abs(Angle_of_Attack_System.Get_Prefiltered_Angle_of_Attack(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;




end EXECUTE_AoA;

