-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Air_Data_Computer;
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Force_Types;
with Mass_Types;
with Torque_Types;
with Normalized_Types;
with Temperature_Types;
with Class_Test_Result_File;

with JPATS_Flight_Instruments_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Multiply_Indexed;


procedure EXECUTE_ADC is

   An_Integration_Constant : Float := 1.0/60.0;

   An_Instance : Air_Data_Computer.Instance;

   A_Baro_Pressure_Set_from_Cockpit                :Force_Types.Inches_of_Hg;
   A_Predefined_Baro_Correction                    :Length_Types.Feet;
   A_Flap_Position                                 :Angle_Types.Degrees;
   A_Pressure_Altitude_from_Static_Port            :Length_Types.Feet;
   DHPADC_Table                                    :Interpolation_Table.Multiply_Indexed.Instance;
   A_Pressure_Altitude_of_Aircraft                 :Length_Types.Feet;
   IAS_H_at_Flap_for_Standby_Altimeter_Table       :Interpolation_Table.Multiply_Indexed.Instance;
   A_Predefined_Baro_Corrected_Altitude_Value      :Length_Types.Feet;
   A_Last_Pass_Pressure_Altitude_from_Static_Probe :Length_Types.Feet;
   A_Predefined_Vertical_Velocity                  :Length_Types.Feet_Per_Min;
   A_Total_Pressure_from_Pitot_Probe               :Force_Types.Pounds_per_Sq_Feet;
   A_Static_Pressure_from_Static_Probe             :Force_Types.Pounds_per_Sq_Feet;
   An_Air_Density_from_Static_Probe                :Mass_Types.Slugs_per_Cubic_Feet;
   A_Pressure_Altitude_from_Static_Probe           :Length_Types.Feet;
   An_Ambient_Temperature                          :Temperature_Types.Rankine; --| From Free_Air (doesn't matter if it is from
   VKIASADC_Table                                  :Interpolation_Table.Doubly_Indexed.Instance;
   A_Side_Slip_Angle                               :Angle_Types.Radians;
   CAS_Correction_Airspeed_Indicator_Table         :Interpolation_Table.Doubly_Indexed.Instance;
   True_Mach_Calibrated_Airspeed_Indicator_Table   :Interpolation_Table.Doubly_Indexed.Instance;
   A_Predefined_Indicated_Airspeed                 :Length_Types.Knots;
   A_Predefined_True_Mach_Number                   :Length_Types.Mach;
   A_Predefined_Indicated_Mach_Number              :Length_Types.Mach;
   A_Predefined_Maximum_Operating_Airspeed         :Length_Types.Knots;
   A_Predefined_Overspeed_Aural_Warning            :Boolean;
   A_Predefined_Ambient_Temperature                :Temperature_Types.Celsius;

   A_File_Path : string := JPATS_Flight_Instruments_Types.A_File_Path;

   Pass : Boolean := False;
   A_Tolerance : float := 0.000_1;

begin

   Interpolation_Table.Multiply_Indexed.Read_Ascii(A_File_Path & "DHPADC.csv", DHPADC_Table);
   Interpolation_Table.Multiply_Indexed.Read_Ascii(A_File_Path & "IAS_H_at_Flap_for_Standby_Altimeter.csv",
                                                   IAS_H_at_Flap_for_Standby_Altimeter_Table);
   Interpolation_Table.Doubly_Indexed.Read_Ascii(A_File_Path & "VKIASADC.csv",VKIASADC_Table);
   Interpolation_Table.Doubly_Indexed.Read_Ascii(A_File_Path & "CAS_Correction_Airspeed_Indicator.csv",
                                                 CAS_Correction_Airspeed_Indicator_Table);
   Interpolation_Table.Doubly_Indexed.Read_Ascii(A_File_Path & "True_Mach_Calibrated_Airspeed_Indicator.csv",
                                                 True_Mach_Calibrated_Airspeed_Indicator_Table);

   A_Predefined_Indicated_Airspeed     := 141.8761;
   A_Predefined_True_Mach_Number       := 0.2351802;
   A_Predefined_Indicated_Mach_Number  := 0.2351802;

   Air_Data_Computer.Assign_Airspeed (A_Predefined_Indicated_Airspeed   ,
                                      A_Predefined_True_Mach_Number     ,
                                      A_Predefined_Indicated_Mach_Number,
                                      An_Instance                       );

   A_Baro_Pressure_Set_from_Cockpit := 29.92;
   Air_Data_Computer.Set_Baro_Correction
     (A_Baro_Pressure_Set_from_Cockpit,
      An_Instance                     );

   --| If Set_Baro_Corrected_Altitude method is invoked then The_Indicated_Altitude_Valid BOOLEAN is
   --| automatically set to TRUE
   --| Set_Baro_Corrected_Altitude_Method_1, method to be used for regular flight instruments.  This
   --| model based on Raytheon's math model.
   A_Flap_Position                      := 0.0;
   A_Pressure_Altitude_from_Static_Port := 5071.824;

   Air_Data_Computer.Set_Baro_Corrected_Altitude_Method_1
     (A_Flap_Position                      ,
      A_Pressure_Altitude_from_Static_Port,
      DHPADC_Table                        ,
      An_Instance                         );

   Put(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance));Put_line(" altitude ");

   Pass:= abs(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance) - 5025.276) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   --| If Set_Baro_Corrected_Altitude method is invoked then The_Indicated_Altitude_Valid BOOLEAN is
   --| automatically set to TRUE.  Set_Baro_Corrected_Altitude_Method_2, method to be used for standby
   --| flight instruments.  This model based on FSI's math model.
   A_Pressure_Altitude_of_Aircraft := 5071.824;
   Air_Data_Computer.Set_Baro_Corrected_Altitude_Method_2
     (A_Flap_Position                           ,
      A_Pressure_Altitude_of_Aircraft          ,
      A_Pressure_Altitude_from_Static_Port     ,
      IAS_H_at_Flap_for_Standby_Altimeter_Table,
      An_Instance                              );


   Put(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance));Put_line(" altitude ");

   Pass:= abs(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance) - 5013.0428) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   --| Indicated Vertical Velocity
   A_Last_Pass_Pressure_Altitude_from_Static_Probe := 5071.9020;
   Air_Data_Computer.Set_Indicated_Vertical_Velocity
     (A_Pressure_Altitude_from_Static_Port          ,
      A_Last_Pass_Pressure_Altitude_from_Static_Probe,
      An_Integration_Constant                        ,
      An_Instance                                     );

   --| Set_Airspeed_Method_1, to be used for calculating Mach, Indicated Airspeed, A_Maximum_Operating_Airspeed
   --| based on Raytheon's Math model for Regular Flight Instruments
   A_Total_Pressure_from_Pitot_Probe   := 1826.9868;
   A_Static_Pressure_from_Static_Probe := 1756.0552;
   An_Air_Density_from_Static_Probe    := 2.06775e-3;
   An_Ambient_Temperature              := 494.74494;--| From Free_Air (doesn't matter if it is from

   Air_Data_Computer.Set_Airspeed_Method_1
     (A_Flap_Position                       ,
      A_Total_Pressure_from_Pitot_Probe     ,
      A_Static_Pressure_from_Static_Probe   ,
      An_Air_Density_from_Static_Probe      ,
      A_Pressure_Altitude_from_Static_Probe,
      An_Ambient_Temperature               , --| From Free_Air (doesn't matter if it is from
      --| free air or from ADC, since the one calculated in ADC is nothing but setting the ADC Outside_Air_Temperature := Free_Air
      --| Ambient_Temperature.
      VKIASADC_Table                      ,
      An_Instance                          );


   Put(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance));Put_line(" Vias ");
   Put(Air_Data_Computer.Get_Maximum_Operating_Airspeed(An_Instance));Put_line(" VMO ");
   Put(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance));Put_line(" Mach ");

   Pass:= abs(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance) - 141.8761) <= 0.05 and
     abs(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance) - 0.2351802) <= 0.01;


   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;


   A_Predefined_Indicated_Airspeed    := 141.8761;
   A_Predefined_True_Mach_Number      := 0.2402265;
   A_Predefined_Indicated_Mach_Number := 0.2351802;

   Air_Data_Computer.Assign_Airspeed (A_Predefined_Indicated_Airspeed     ,
                                      A_Predefined_True_Mach_Number        ,
                                      A_Predefined_Indicated_Mach_Number  ,
                                      An_Instance                            );

   --| Set_Airspeed_Method_2, to be used for calculating Mach, Indicated Airspeed, A_Maximum_Operating_Airspeed
   --| based on FSI's Math model for Standby Flight Instruments
   A_Side_Slip_Angle := 0.0;
   A_Flap_Position:= 0.0;
   A_Total_Pressure_from_Pitot_Probe    := 1826.9868;
   A_Static_Pressure_from_Static_Probe  := 1756.0552;
   An_Air_Density_from_Static_Probe     := 2.06775e-3;
   A_Pressure_Altitude_from_Static_Probe := 5071.824;

   Air_Data_Computer.Set_Airspeed_Method_2
     (A_Flap_Position,
      A_Total_Pressure_from_Pitot_Probe       ,
      A_Static_Pressure_from_Static_Probe     ,
      A_Side_Slip_Angle                       ,
      An_Air_Density_from_Static_Probe        ,
      A_Pressure_Altitude_from_Static_Probe  ,
      CAS_Correction_Airspeed_Indicator_Table ,
      True_Mach_Calibrated_Airspeed_Indicator_Table,
      An_Instance                            );

   Put(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance));Put_line(" Vias ");
   Put(Air_Data_Computer.Get_Maximum_Operating_Airspeed(An_Instance));Put_line(" VMO ");
   Put(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance));Put_line(" Mach ");

   Pass:= abs(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance) - 141.09) <= 0.1 and
     abs(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance) - 0.2351802) <= 0.5;


   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   put_line(" -------------------- CONSTRAINT --------------------");

   A_Predefined_Indicated_Airspeed     := 1000.0;
   A_Predefined_True_Mach_Number       := 10.0;
   A_Predefined_Indicated_Mach_Number  := 10.0;

   Air_Data_Computer.Assign_Airspeed (A_Predefined_Indicated_Airspeed   ,
                                      A_Predefined_True_Mach_Number     ,
                                      A_Predefined_Indicated_Mach_Number,
                                      An_Instance                       );

   A_Baro_Pressure_Set_from_Cockpit := 29.92;
   Air_Data_Computer.Set_Baro_Correction
     (A_Baro_Pressure_Set_from_Cockpit,
      An_Instance                     );

   --| If Set_Baro_Corrected_Altitude method is invoked then The_Indicated_Altitude_Valid BOOLEAN is
   --| automatically set to TRUE
   --| Set_Baro_Corrected_Altitude_Method_1, method to be used for regular flight instruments.  This
   --| model based on Raytheon's math model.
   A_Flap_Position                      := 1000.0;
   A_Pressure_Altitude_from_Static_Port := 100000.0;

   Air_Data_Computer.Set_Baro_Corrected_Altitude_Method_1
     (A_Flap_Position                      ,
      A_Pressure_Altitude_from_Static_Port,
      DHPADC_Table                        ,
      An_Instance                         );

   Put(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance));Put_line(" altitude ");

   Pass:= abs(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance) ) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   --| If Set_Baro_Corrected_Altitude method is invoked then The_Indicated_Altitude_Valid BOOLEAN is
   --| automatically set to TRUE.  Set_Baro_Corrected_Altitude_Method_2, method to be used for standby
   --| flight instruments.  This model based on FSI's math model.
   A_Pressure_Altitude_of_Aircraft := 100000.0;
   Air_Data_Computer.Set_Baro_Corrected_Altitude_Method_2
     (A_Flap_Position                           ,
      A_Pressure_Altitude_of_Aircraft          ,
      A_Pressure_Altitude_from_Static_Port     ,
      IAS_H_at_Flap_for_Standby_Altimeter_Table,
      An_Instance                              );


   Put(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance));Put_line(" altitude ");

   Pass:= abs(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   --| Indicated Vertical Velocity
   A_Last_Pass_Pressure_Altitude_from_Static_Probe := 100000.0;
   Air_Data_Computer.Set_Indicated_Vertical_Velocity
     (A_Pressure_Altitude_from_Static_Port          ,
      A_Last_Pass_Pressure_Altitude_from_Static_Probe,
      An_Integration_Constant                        ,
      An_Instance                                     );

   --| Set_Airspeed_Method_1, to be used for calculating Mach, Indicated Airspeed, A_Maximum_Operating_Airspeed
   --| based on Raytheon's Math model for Regular Flight Instruments
   A_Total_Pressure_from_Pitot_Probe   := 10000.0;
   A_Static_Pressure_from_Static_Probe := 10000.0;
   An_Air_Density_from_Static_Probe    := 1.0;
   An_Ambient_Temperature              := 1000.0;--| From Free_Air (doesn't matter if it is from

   Air_Data_Computer.Set_Airspeed_Method_1
     (A_Flap_Position                       ,
      A_Total_Pressure_from_Pitot_Probe     ,
      A_Static_Pressure_from_Static_Probe   ,
      An_Air_Density_from_Static_Probe      ,
      A_Pressure_Altitude_from_Static_Probe,
      An_Ambient_Temperature               , --| From Free_Air (doesn't matter if it is from
      --| free air or from ADC, since the one calculated in ADC is nothing but setting the ADC Outside_Air_Temperature := Free_Air
      --| Ambient_Temperature.
      VKIASADC_Table                      ,
      An_Instance                          );


   Put(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance));Put_line(" Vias ");
   Put(Air_Data_Computer.Get_Maximum_Operating_Airspeed(An_Instance));Put_line(" VMO ");
   Put(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance));Put_line(" Mach ");

   Pass:= abs(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance)) >= 0.0 and
     abs(Air_Data_Computer.Get_Maximum_Operating_Airspeed(An_Instance)) >= 0.0 and
     abs(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance)) >= 0.0;


   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;


   A_Predefined_Indicated_Airspeed    := 1000.0;
   A_Predefined_True_Mach_Number      := 10.0;
   A_Predefined_Indicated_Mach_Number := 10.0;

   Air_Data_Computer.Assign_Airspeed (A_Predefined_Indicated_Airspeed     ,
                                      A_Predefined_True_Mach_Number        ,
                                      A_Predefined_Indicated_Mach_Number  ,
                                      An_Instance                            );

   --| Set_Airspeed_Method_2, to be used for calculating Mach, Indicated Airspeed, A_Maximum_Operating_Airspeed
   --| based on FSI's Math model for Standby Flight Instruments
   A_Side_Slip_Angle := 1000.0;
   A_Flap_Position:= 1000.0;
   A_Total_Pressure_from_Pitot_Probe    := 10000.0;
   A_Static_Pressure_from_Static_Probe  := 10000.0;
   An_Air_Density_from_Static_Probe     := 1.0;
   A_Pressure_Altitude_from_Static_Probe := 100000.0;

   Air_Data_Computer.Set_Airspeed_Method_2
     (A_Flap_Position,
      A_Total_Pressure_from_Pitot_Probe       ,
      A_Static_Pressure_from_Static_Probe     ,
      A_Side_Slip_Angle                       ,
      An_Air_Density_from_Static_Probe        ,
      A_Pressure_Altitude_from_Static_Probe  ,
      CAS_Correction_Airspeed_Indicator_Table ,
      True_Mach_Calibrated_Airspeed_Indicator_Table,
      An_Instance                            );

   Put(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance));Put_line(" Vias ");
   Put(Air_Data_Computer.Get_Maximum_Operating_Airspeed(An_Instance));Put_line(" VMO ");
   Put(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance));Put_line(" Mach ");

   Pass:= abs(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance)) >= 0.0 and
     abs(Air_Data_Computer.Get_Maximum_Operating_Airspeed(An_Instance)) >= 0.0 and
     abs(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance)) >= 0.0;


   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   put_line(" -------------------- END --------------------");


   A_Predefined_Indicated_Airspeed     := 0.0;
   A_Predefined_True_Mach_Number       := 0.0;
   A_Predefined_Indicated_Mach_Number  := 0.0;

   Air_Data_Computer.Assign_Airspeed (A_Predefined_Indicated_Airspeed   ,
                                      A_Predefined_True_Mach_Number     ,
                                      A_Predefined_Indicated_Mach_Number,
                                      An_Instance                       );

   A_Baro_Pressure_Set_from_Cockpit := 29.92;
   Air_Data_Computer.Set_Baro_Correction
     (A_Baro_Pressure_Set_from_Cockpit,
      An_Instance                     );

   --| If Set_Baro_Corrected_Altitude method is invoked then The_Indicated_Altitude_Valid BOOLEAN is
   --| automatically set to TRUE
   --| Set_Baro_Corrected_Altitude_Method_1, method to be used for regular flight instruments.  This
   --| model based on Raytheon's math model.
   A_Flap_Position                      := 10.0;
   A_Pressure_Altitude_from_Static_Port := 0.0;

   Air_Data_Computer.Set_Baro_Corrected_Altitude_Method_1
     (A_Flap_Position                      ,
      A_Pressure_Altitude_from_Static_Port,
      DHPADC_Table                        ,
      An_Instance                         );

   Put(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance));Put_line(" altitude ");

   Pass:= abs(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance) ) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   --| If Set_Baro_Corrected_Altitude method is invoked then The_Indicated_Altitude_Valid BOOLEAN is
   --| automatically set to TRUE.  Set_Baro_Corrected_Altitude_Method_2, method to be used for standby
   --| flight instruments.  This model based on FSI's math model.
   A_Pressure_Altitude_of_Aircraft := 100000.0;
   Air_Data_Computer.Set_Baro_Corrected_Altitude_Method_2
     (A_Flap_Position                           ,
      A_Pressure_Altitude_of_Aircraft          ,
      A_Pressure_Altitude_from_Static_Port     ,
      IAS_H_at_Flap_for_Standby_Altimeter_Table,
      An_Instance                              );


   Put(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance));Put_line(" altitude ");

   Pass:= abs(Air_Data_Computer.Get_Baro_Corrected_Altitude_Value(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;

   --| Indicated Vertical Velocity
   A_Last_Pass_Pressure_Altitude_from_Static_Probe := 0.0;
   Air_Data_Computer.Set_Indicated_Vertical_Velocity
     (A_Pressure_Altitude_from_Static_Port          ,
      A_Last_Pass_Pressure_Altitude_from_Static_Probe,
      An_Integration_Constant                        ,
      An_Instance                                     );

   --| Set_Airspeed_Method_1, to be used for calculating Mach, Indicated Airspeed, A_Maximum_Operating_Airspeed
   --| based on Raytheon's Math model for Regular Flight Instruments
   A_Total_Pressure_from_Pitot_Probe   := 0.0;
   A_Static_Pressure_from_Static_Probe := 0.0;
   An_Air_Density_from_Static_Probe    := 0.0;
   An_Ambient_Temperature              := 0.0;--| From Free_Air (doesn't matter if it is from

   Air_Data_Computer.Set_Airspeed_Method_1
     (A_Flap_Position                       ,
      A_Total_Pressure_from_Pitot_Probe     ,
      A_Static_Pressure_from_Static_Probe   ,
      An_Air_Density_from_Static_Probe      ,
      A_Pressure_Altitude_from_Static_Probe,
      An_Ambient_Temperature               , --| From Free_Air (doesn't matter if it is from
      --| free air or from ADC, since the one calculated in ADC is nothing but setting the ADC Outside_Air_Temperature := Free_Air
      --| Ambient_Temperature.
      VKIASADC_Table                      ,
      An_Instance                          );


   Put(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance));Put_line(" Vias ");
   Put(Air_Data_Computer.Get_Maximum_Operating_Airspeed(An_Instance));Put_line(" VMO ");
   Put(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance));Put_line(" Mach ");

   Pass:= abs(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance)) >= 0.0 and
     abs(Air_Data_Computer.Get_Maximum_Operating_Airspeed(An_Instance)) >= 0.0 and
     abs(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance)) >= 0.0;


   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;


   A_Predefined_Indicated_Airspeed    := 1000.0;
   A_Predefined_True_Mach_Number      := 10.0;
   A_Predefined_Indicated_Mach_Number := 10.0;

   Air_Data_Computer.Assign_Airspeed (A_Predefined_Indicated_Airspeed     ,
                                      A_Predefined_True_Mach_Number        ,
                                      A_Predefined_Indicated_Mach_Number  ,
                                      An_Instance                            );

   --| Set_Airspeed_Method_2, to be used for calculating Mach, Indicated Airspeed, A_Maximum_Operating_Airspeed
   --| based on FSI's Math model for Standby Flight Instruments
   A_Side_Slip_Angle := 0.0;
   A_Flap_Position:= 0.0;
   A_Total_Pressure_from_Pitot_Probe    := 0.0;
   A_Static_Pressure_from_Static_Probe  := 0.0;
   An_Air_Density_from_Static_Probe     := 0.0;
   A_Pressure_Altitude_from_Static_Probe := 0.0;

   Air_Data_Computer.Set_Airspeed_Method_2
     (A_Flap_Position,
      A_Total_Pressure_from_Pitot_Probe       ,
      A_Static_Pressure_from_Static_Probe     ,
      A_Side_Slip_Angle                       ,
      An_Air_Density_from_Static_Probe        ,
      A_Pressure_Altitude_from_Static_Probe  ,
      CAS_Correction_Airspeed_Indicator_Table ,
      True_Mach_Calibrated_Airspeed_Indicator_Table,
      An_Instance                            );

   Put(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance));Put_line(" Vias ");
   Put(Air_Data_Computer.Get_Maximum_Operating_Airspeed(An_Instance));Put_line(" VMO ");
   Put(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance));Put_line(" Mach ");

   Pass:= abs(Air_Data_Computer.Get_Indicated_Airspeed(An_Instance)) >= 0.0 and
     abs(Air_Data_Computer.Get_Maximum_Operating_Airspeed(An_Instance)) >= 0.0 and
     abs(Air_Data_Computer.Get_Indicated_Mach_Number(An_Instance)) >= 0.0;


   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:= False;




end EXECUTE_ADC;

