-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Obogs_Regulator_G;

procedure Obogs_Regulator_G_Ctd is


begin


   -------------------------------------------------------------------------------
   -- Test_1
   --
   -- Inputs           :
   -- Expected results : Attribute accessors = initialization default values.
   -- Purpose          : Test initialize()

Test_1 : declare

   package Regulator is new Obogs_Regulator_G (Float, Float);
   A_Regulator : Regulator.Instance;
   Ith_Case : Integer := 0;

   Test_Battery_1 : array (1..6) of Boolean;

begin

   Regulator.Initialize (A_Regulator);

   Test_Battery_1(1) := Regulator.Pressure (A_Regulator) = 0.0;
   Test_Battery_1(2) := not Regulator.Power_Out (A_Regulator);
   Test_Battery_1(3) := not Regulator.Bit_Out (A_Regulator);
   Test_Battery_1(4) := not Regulator.O2_Sel_Out (A_Regulator);
   Test_Battery_1(5) := not Regulator.Max_Light (A_Regulator);
   Test_Battery_1(6) := Regulator.Load (A_Regulator) = 0.0;

   for I in 1..6
   loop
      exit when not Test_Battery_1(I);
      Ith_Case := I;
   end loop;


   Class_Test_Result_File.Report_Case_Status (Success => Ith_Case = 6, Number => 1);

end Test_1;


   -------------------------------------------------------------------------------
   -- Test_2
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

Test_2 : declare

   -------------------------------------------------------------------------------
   -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Regulator is new Obogs_Regulator_G (Float, Float);
      A_Regulator : Regulator.Instance;
      Ith_Case : Integer := 0;
      Test_Case_2 : array (1..4) of Boolean;

   begin

      Regulator.Initialize (A_Regulator);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Regulator.Update
              (An_Instance               => A_Regulator,  -- in out Instance;
               Pressure_In               => 0.0,          -- in     Pressure_Type;
               Power_In                  => false,        -- in     Boolean;
               Supply_Sw_On              => false,        -- in     Boolean;
               Pressure_Cntrl_Sw_Normal  => false,        -- in     Boolean;
               Pressure_Cntrl_Sw_Emerg   => false,  -- in     Boolean;
               Concentration_Sw_Normal   => false,  -- in     Boolean;
               Bit_Sw_In                 => false,  -- in     Boolean;
               Bit_In                    => false,  -- in     Boolean;
               O2_Sel_In                 => false,  -- in     Boolean;
               Max_Light_In              => false); -- in     Boolean);

            if In_First_Quarter then
               Test_Case_2(1) := not Regulator.Power_Out (A_Regulator);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then

            Regulator.Update
              (An_Instance               => A_Regulator,  -- in out Instance;
               Pressure_In               => 0.0,          -- in     Pressure_Type;
               Power_In                  => true,        -- in     Boolean;
               Supply_Sw_On              => false,        -- in     Boolean;
               Pressure_Cntrl_Sw_Normal  => false,        -- in     Boolean;
               Pressure_Cntrl_Sw_Emerg   => false,  -- in     Boolean;
               Concentration_Sw_Normal   => false,  -- in     Boolean;
               Bit_Sw_In                 => false,  -- in     Boolean;
               Bit_In                    => false,  -- in     Boolean;
               O2_Sel_In                 => false,  -- in     Boolean;
               Max_Light_In              => false); -- in     Boolean);

            if In_Second_Quarter then
               Test_Case_2(2) := not Regulator.Power_Out (A_Regulator);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then

            Regulator.Update
              (An_Instance               => A_Regulator,  -- in out Instance;
               Pressure_In               => 0.0,          -- in     Pressure_Type;
               Power_In                  => true,        -- in     Boolean;
               Supply_Sw_On              => True,        -- in     Boolean;
               Pressure_Cntrl_Sw_Normal  => false,        -- in     Boolean;
               Pressure_Cntrl_Sw_Emerg   => false,  -- in     Boolean;
               Concentration_Sw_Normal   => false,  -- in     Boolean;
               Bit_Sw_In                 => false,  -- in     Boolean;
               Bit_In                    => false,  -- in     Boolean;
               O2_Sel_In                 => false,  -- in     Boolean;
               Max_Light_In              => false); -- in     Boolean);

            if In_Third_Quarter then
               Test_Case_2(3) := Regulator.Power_Out (A_Regulator);
            end if;
            In_Third_Quarter := False;
         else

            Regulator.Update
              (An_Instance               => A_Regulator,  -- in out Instance;
               Pressure_In               => 0.0,          -- in     Pressure_Type;
               Power_In                  => false,        -- in     Boolean;
               Supply_Sw_On              => true,        -- in     Boolean;
               Pressure_Cntrl_Sw_Normal  => false,        -- in     Boolean;
               Pressure_Cntrl_Sw_Emerg   => false,  -- in     Boolean;
               Concentration_Sw_Normal   => false,  -- in     Boolean;
               Bit_Sw_In                 => false,  -- in     Boolean;
               Bit_In                    => false,  -- in     Boolean;
               O2_Sel_In                 => false,  -- in     Boolean;
               Max_Light_In              => false); -- in     Boolean);

            if In_Fourth_Quarter then
               Test_Case_2(4) := not Regulator.Power_Out (A_Regulator);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;


      for I in 1..4
      loop
         exit when not Test_Case_2(I);
         Ith_Case := I;
      end loop;


      Class_Test_Result_File.Report_Case_Status (Success => Ith_Case = 4, Number => 2);



   end Test_2;


   -------------------------------------------------------------------------------
   -- Test_3
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

Test_3 : declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------


      package Regulator is new Obogs_Regulator_G (Float, Float);
      A_Regulator : Regulator.Instance;
      Ith_Case : Integer := 0;
      Test_Case_3 : array (1..4) of Boolean;



   begin


      Regulator.Initialize (A_Regulator);


      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then


            Regulator.Update
              (An_Instance               => A_Regulator,  -- in out Instance;
               Pressure_In               => 0.0,          -- in     Pressure_Type;
               Power_In                  => true,        -- in     Boolean;
               Supply_Sw_On              => true,        -- in     Boolean;
               Pressure_Cntrl_Sw_Normal  => false,        -- in     Boolean;
               Pressure_Cntrl_Sw_Emerg   => false,  -- in     Boolean;
               Concentration_Sw_Normal   => false,  -- in     Boolean;
               Bit_Sw_In                 => false,  -- in     Boolean;
               Bit_In                    => true,  -- in     Boolean;
               O2_Sel_In                 => false,  -- in     Boolean;
               Max_Light_In              => false); -- in     Boolean);

            if In_First_Quarter then
               Test_Case_3(1) := not Regulator.Bit_Out (A_Regulator);
            end if;
            In_First_Quarter := False;



         elsif Now < Two_Quarter_Time then

            Regulator.Update
              (An_Instance               => A_Regulator,  -- in out Instance;
               Pressure_In               => 0.0,          -- in     Pressure_Type;
               Power_In                  => true,        -- in     Boolean;
               Supply_Sw_On              => true,        -- in     Boolean;
               Pressure_Cntrl_Sw_Normal  => false,        -- in     Boolean;
               Pressure_Cntrl_Sw_Emerg   => false,  -- in     Boolean;
               Concentration_Sw_Normal   => false,  -- in     Boolean;
               Bit_Sw_In                 => true,  -- in     Boolean;
               Bit_In                    => true,  -- in     Boolean;
               O2_Sel_In                 => false,  -- in     Boolean;
               Max_Light_In              => false); -- in     Boolean);

            if In_Second_Quarter then
               Test_Case_3(2) := Regulator.Bit_Out (A_Regulator);
            end if;
            In_Second_Quarter := False;



         elsif Now < Three_Quarter_Time then




            Regulator.Update
              (An_Instance               => A_Regulator,  -- in out Instance;
               Pressure_In               => 0.0,          -- in     Pressure_Type;
               Power_In                  => true,        -- in     Boolean;
               Supply_Sw_On              => True,        -- in     Boolean;
               Pressure_Cntrl_Sw_Normal  => false,        -- in     Boolean;
               Pressure_Cntrl_Sw_Emerg   => false,  -- in     Boolean;
               Concentration_Sw_Normal   => false,  -- in     Boolean;
               Bit_Sw_In                 => true,  -- in     Boolean;
               Bit_In                    => false,  -- in     Boolean;
               O2_Sel_In                 => false,  -- in     Boolean;
               Max_Light_In              => false); -- in     Boolean);

            if In_Third_Quarter then
               Test_Case_3(3) := not Regulator.Bit_Out (A_Regulator);
            end if;
            In_Third_Quarter := False;




         else



            Regulator.Update
              (An_Instance               => A_Regulator,  -- in out Instance;
               Pressure_In               => 0.0,          -- in     Pressure_Type;
               Power_In                  => true,        -- in     Boolean;
               Supply_Sw_On              => true,        -- in     Boolean;
               Pressure_Cntrl_Sw_Normal  => false,        -- in     Boolean;
               Pressure_Cntrl_Sw_Emerg   => false,  -- in     Boolean;
               Concentration_Sw_Normal   => false,  -- in     Boolean;
               Bit_Sw_In                 => false,  -- in     Boolean;
               Bit_In                    => false,  -- in     Boolean;
               O2_Sel_In                 => false,  -- in     Boolean;
               Max_Light_In              => false); -- in     Boolean);

            if In_Fourth_Quarter then
               Test_Case_3(4) := not Regulator.Bit_Out (A_Regulator);
            end if;
            In_Fourth_Quarter := False;
         end if;




      end loop;


      for I in 1..4
      loop
         exit when not Test_Case_3(I);
         Ith_Case := I;
      end loop;


      Class_Test_Result_File.Report_Case_Status (Success => Ith_Case = 4, Number => 3);

   end Test_3;


end Obogs_Regulator_G_Ctd;

